<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
*   Obtenir les tapes d'un parcours sous forme d'un tableau javascript, avec leurs themes.
*	Le tableau javascript est nomm tab_etapes_parcours.
*   @param integer : le numro de parcours
*   @return string : une chaine contenant la declaration javascript d'un tableau contenant tous les id des tapes d'un parcours.
*/
function get_media_themes_tableau_javascript($accept_extensions) {
	$current_theme=null;
	$res_medias=get_medias_scenarios_themes();
	$tableau_javascript="\nvar tab_medias= new Array();\n";
	$nb_medias=pg_num_rows($res_medias);
	for($i=0;$i<$nb_medias;$i++){
		$row=pg_fetch_row($res_medias,$i);
		if(is_fichier_type_mime_type_valid($row[1], $accept_extensions)){
			if($current_theme!=$row[3]){
				$current_theme=$row[3];
				$tableau_javascript.="tab_medias[$current_theme]=new Array();\n";
				$j=0;
			}
			$tableau_javascript.="tab_medias[$current_theme][$j]=new Array();\n";
			$tableau_javascript.="tab_medias[$current_theme][$j][0]=$row[0];\n";
			$tableau_javascript.="tab_medias[$current_theme][$j][1]='".addslashes($row[1])."';\n";
			$tableau_javascript.="tab_medias[$current_theme][$j][2]=$row[2];\n";
			$tableau_javascript.="tab_medias[$current_theme][$j][3]=$row[3];\n";
			$tableau_javascript.="tab_medias[$current_theme][$j][4]='".addslashes($row[4])."';\n";
			$j++;
		}
	}
	return $tableau_javascript;
}
?>