<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Fichier de dfinition de la classe MediaEvaluation
* 
* 
* @package media_evaluation
*/

/**
* Cette classe dcrit un mdia utilis par des valuations de srie (et non pas par un exercice  tlcharger > classe  faire)
*/
class MediaEvaluation extends Media {

	/**
	* Constructeur de la classe MediaEvaluation
	* @param integer : identifiant en base de donnes
	* @param integer : longueur
	* @param integer : largeur
	* @param integer : identifiant du thme
	* @param String : Nom du fichier media
	*/
	function MediaEvaluation($id = "", $longueur = "", $largeur = "", $numTheme = "", $nom = "") {

		// SI l'identifiant est connu, on construit  partir d'une ligne de base de donnes
		if (!empty ($id)) {
			$result = get_fichier_medias_evaluations($id);
			if (pg_num_rows($result) == 0 || pg_fetch_result($result, 0, 0)==null ) {
				$id = null;
				$numTheme = null;
			} else {
				$media = pg_fetch_result($result, 0, 0);
				$numTheme = pg_fetch_result(get_fichier_medias_evaluations_theme($id), 0, 0);
			}
		}
		parent :: Media($id, $nom, $longueur, $largeur);
	}

	/**
	* Fonction qui insre un enregistrement en table
	* On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
	* @return integer : identifiant de l'enregistrement cr (ou rcupr)
	*/
	function insertToDB() {

		if ($this->nom_media && $this->num_theme) {

			/*  $insert = "INSERT INTO $nom_table (nom_fic, num_themedir) VALUES ('".addslashes($this->nom_media)."', $this->num_theme)" ;
			  $result = pg_query($insert) ;
			  $oid = pg_last_oid($result) ;
			  return pg_result(pg_query("SELECT num_fic FROM $nom_table WHERE oid=$oid"),0,0) ;*/
			return set_fichier_media_evaluation(addslashes($this->nom_media), $this->num_theme);

		} else {
			echo "Insertion Media_exo impossible : mauvais attributs d'objet<br>";
			return false;
		}

	}

	/**
	* Fonction qui met  jour un enregistrement en table
	*/
	function updateToDB() {
		global $nom_table;

		if ($this->num_media && $this->nom_media && $this->num_theme) {
			/* $update = "UPDATE $nom_table SET nom_fic='".addslashes($this->nom_media)."' WHERE num_fic=$this->num_media, $this->num_theme" ;
			 $result = pg_query($update) ;*/
			return maj_media_evaluation($this->num_media,addslashes($this->nom_media), $this->num_theme);
		} else {
			echo "Mise  jour Media_exo impossible : mauvais attributs d'objet<br>";
		}

	}

}
?>