<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Fichier de dfinition de la classe MediaEvaluation
* 
* 
* @package media_question_reponse_element
*/

/**
* Cette classe dcrit un mdia utilis par des valuations de srie (et non pas par un exercice  tlcharger > classe  faire)
*/
class MediaQuestionReponseElement extends Media {

	var $question_reponse;
	var $question_reponse_element;
	/**
	* Constructeur de la classe MediaEvaluation
	* @param integer : identifiant en base de donnes
	* @param integer : longueur
	* @param integer : largeur
	* @param integer : identifiant du thme
	* @param String : Nom du fichier media
	*/
	function MediaQuestionReponseElement($question_reponse,$question_reponse_element,$id=0 , $hauteur = 0, $largeur = 0, $libelle = "") {
			
		// SI l'identifiant est connu, on construit  partir d'une ligne de base de donnes
		if (func_num_args()==2) {
			$result = get_question_reponse_element_media($question_reponse,$question_reponse_element);
			if ($result&&pg_num_rows($result) ==1) {
				$row=pg_fetch_row($result);
				$id = $row[2];
				$libelle= $row[3];
				$hauteur = $row[4];
				$largeur = $row[5];
			}else {
				die("MediaQuestionReponseElement::MediaQuestionReponseElement($question_reponse,$question_reponse_element,$id=0 , $longueur = 0, $largeur = 0, $libelle = \"\") Il n'y a pas de mdia associ  ce QuestionReponseElement.");				
			}
		}
		else{
			
		}
		if(empty($id)){
			die("MediaQuestionReponseElement::MediaQuestionReponseElement() Ne peut crer d'objet sans identifiant (\$id=$id).");
		}
		$this->initMediaQuestionReponseElement($question_reponse,$question_reponse_element);
		parent :: Media($id, $hauteur, $largeur,$libelle);
	}

	function initMediaQuestionReponseElement($question_reponse,$question_reponse_element){
		$this->question_reponse=$question_reponse;
		$this->question_reponse_element=$question_reponse_element;
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		//$res_parent=parent::verifyInsert($message);
		$res_parent=true;
		$verif=MediaQuestionReponseElement::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		//$res_parent=parent::verifyUpdate($message);
		$res_parent=true;
		$verif=MediaQuestionReponseElement::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Vrifie qu'un question_reponse et qu'un question_reponse_element sont bien spcifies.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes , false si non .
	 */
	function verify(&$message){
		$attributs_ok=true;
		if((!(is_numeric($this->question_reponse))||empty($this->question_reponse))){
			$message.="[question_reponse]";
			$attributs_ok=false;	
		}
		if((!(is_numeric($this->question_reponse_element))||empty($this->question_reponse_element))){
			$message.="[question_reponse_element]";
			$attributs_ok=false;	
		}
		return $attributs_ok;
	}
		
	/**
	* Fonction qui insre un enregistrement en table.
	* @return bool true si l'insertion a t correctement effectue, false sinon.
	*/
	function insertToDB(&$message) {
		if(MediaQuestionReponseElement::verifyInsert(&$message)){
			return set_question_reponse_element_media($this->question_reponse, $this->question_reponse_element, $this->id, int2Sql($this->hauteur), int2Sql($this->largeur));
		}
		else{
			return false;
		}	
	}

	/**
	* Fonction qui met  jour un enregistrement en table
	* @return bool true si la mise  jour  t correctement effectue, false sinon.
	*/
	function updateToDB(&$message) {
		if(MediaQuestionReponseElement::verifyUpdate(&$message)){
			return maj_question_reponse_element_media($this->question_reponse, $this->question_reponse_element, $this->id, int2Sql($this->hauteur), int2Sql($this->largeur));
		}
		else{
			return false;
		}	

	}

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	function setQuestionReponse($question_reponse){
		$this->question_reponse=$question_reponse;
	}
}
?>