<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions pour obtenir les entits de la plate-forme.
	
       @package modalite
       @modulegroup plpgsql
       @module plpgsql_modalite
*/

/**
	Obtenir une modalite (OLD)
	@param integer : numero modalite
	@return integer : resultat requete (id,libelle,code)
*/
function get_modalite_old($modalite){
	$sql="select * from typeform where num_typeform=$modalite";
	return pg_query($sql);
}
/**
	Obtenir une modalite 
	@param integer : numero modalite
	@return integer : resultat requete (id,libelle,code)
*/
function get_modalite($modalite){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_modalite($modalite) as (id int4,libelle varchar,code varchar)";
		$res=pg_query($sql);
	}
	else
		$res=get_modalite_old($modalite);
	return $res;
}
?>