<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de d�finition d'un module fonctionnel Astairs.
 * Un Module est compos� d'un ensemble d'attributs qui lui sont propres (id, code, version, ...)
 * Il est compos� de Pages (Page) et de sous modules (Module).
 * Un ensemble de m�thode permettent de les obtenir.
 */
class Module{
	
	/**
	 * @var integer Identifiant en base de donn�es. 
	 * Cet identifiant est propre � chaque plate-forme Astairs.
	 */
	var $id;
	
	/**
	 * @var string Identifiant unique de module.
	 * Cet identifiant est commun � toutes les plate-formes.
	 */
	var $code;
	
	/**
	 * @var string Version du module. 
	 * @todo A impl�menter
	 */
	var $version;
	
	/**
	 * @var string Libell� du r�pertoire contenant les scripts du Module.
	 */
	var $directory;
	
	/**
	 * @var string Lib�ll� du Module. Pour affichage.
	 */
	var $libelle;
	
	/**
	 * @var string Description des fonctionnalit�s du Module. Pour affichage d'une aide.
	 */
	var $description;
	
	/**
	 * @var string Type du Module. Permet de gerer des ensembles de Modules, pour affichage d'un menu par exemple.
	 */
	var $type;

	/**
	 * @var object[] Page Tableau de l'ensemble des Pages constituant le Module. 
	 */
	var $pages;

	/**
	 * @var object[] Module Tableau de l'ensemble des sous Modules constituant le Module. 
	 */

	var $subModules;
	
	/**
	 * @var string[] Tableau ind�x� par des cl�s contenant les �l�ments n�cessaires � l'installation de ce Module.
	 * Ces cl�s peuvent �tre : MODULE,STYLE, ou JAVASCRIPT
	 */
	var $required;
	
	/**
	 * @var string[] Tableau ind�x� par des cl�s contenant les �l�ments de base de donn�es n�cessaires � l'installation de ce Module.
	 * Ces cl�s peuvent �tre : TABLE,DATA, ou FUNCTIONS
	 */
	var $db;
	
	/**
	 * @var integer Indique si le module est actif ou non
	 */
	var $active;
	
	var $returnPageStack;
	
	/**
	 * @var mixed array tableau d'objet de sessions propres au module.
	 */
	var $session_objects;
	 
	/**
	 * @var mixed array Tableau indéxé par les profils ayant des droits sur le module, et dont les valeurs sont les droits du module pour le profile
	 */
	var $permissions;

	var $mainModule;

	/**
	 * Constructeur.
	 * 
	 * @param integer $id Identifiant en base de donn�es. Cet identifiant est propre � chaque plate-forme Astairs.
	 * @param string $code Identifiant unique de module. Cet identifiant est commun � toutes les plate-formes.
	 * @param string $version Version du module. 
	 * @param string $directory Description des fonctionnalit�s du Module. Pour affichage d'une aide.
	 * @param string $libelle Libell� du r�pertoire contenant les scripts du Module.
	 * @param string $type Type du Module. Permet de gerer des ensembles de Modules, pour affichage d'un menu par exemple.
	 * @param string $description Description des fonctionnalit�s du Module. Pour affichage d'une aide.
	 * @param boolean $active Indique si le module est actif ou non
	 */
	function Module($id,$code,$version,$directory, $libelle="",$type="",$description="",$active=false){
		$this->id=$id;
		$this->code=$code;
		$this->version=$version;
		$this->directory=$directory;
		$this->libelle=$libelle;
		$this->description=$description;
		$this->active=$active;
		$this->type=$type;
		$this->pages=array();
		$this->returnPageStack=array();
		$this->subModules=array();
		$this->required=array("MODULE"=>array(), "STYLE"=>array(), "JAVASCRIPT"=>array());
		$this->db=array("TABLE"=>array(), "DATA"=>array(), "FUNCTIONS"=>array());
		$this->permissions=new AstairsModulePerm($this->id);
	}
	
	/**
	 * Associer une Page � ce Module.
	 * @param integer $indice Indice de la Page
	 * @param object Page $page La Page � associer
	 */
	function setPage($indice,$page){
		$this->pages[$indice]=$page;
	}

	/**
	 * Associer un sous Module � ce Module.
	 * @param integer $indice Indice du sous Module
	 * @param objetc Module $module Le Module � associer
	 */
	function &setSubModule($indice,$module){
		$this->subModules[$indice]=$module;
	}
	
	/**
	 * Supprimer l'association d'un sous Module � ce Module.
	 * @param integer $indice Indice du sous Module � supprimer
	 */
	function &delSubModule($indice){
		unset($this->subModules[$indice]);
	}
	
	/**
	 * Obtenir une Page de ce Module
	 * @param integer $indice Indice de la Page
	 * @return object Page La Page � l'indice $indice
	 */	
	function &getPage($indice){
		return $this->pages[$indice];
	}
	
	/**
	 * Obtenir les pages du module.
	 * @return object[] Page Les Pages associ�es au Module
	 */
	function &getPages(){
		return $this->pages;
	}	

	/**
	 * Charger les Pages du Module.
	 * Obtient et associe les Pages � partir de la base de donn�es.
	 */
	function &loadPages(){
		
		//TODO � supprimer
		if(!count($this->pages)!=0){
			$res_pages=get_module_pages_by_code(string2Sql($this->code));
			$this->pages=array();
			while($row=pg_fetch_row($res_pages)){
				$this->pages[]=new Page($row[2],$row[3],$row[4],$row[5]);
			}
		}
	}
	
	/**
	 * Obtenir les pages du module d'un type donn�.
	 * @param string $type Le type de Pages d�sir�.
	 * @return object[] Page Les Pages associ�es au Module de type $type.
	 */	
	function &getPagesByType($type){
		$tmp_array=$this->getPages();
		foreach($tmp_array as $k => $v){
			if($v->getType()!=$type){
				unset($tmp_array[$k]);
			}
		}
		return $tmp_array;
	}
	/**
	 * Otenir les types d�finis par les Pages du Module.
	 * @return array Constantes de types.
	 */
	function getPagesTypes(){
		$tmp_array=$this->getPages();
		$types=array();
		foreach($tmp_array as $k => $v){
			if(!in_array($v->getType(),$types)){
				$types[]=$v->getType();
			}
		}
		return $types;
	}
	
	/**
	 * Obtenir les sous-modules du module tri�s.
	 * Les sous-modules sont tri�s par type puis par lib�ll� si les types sont identiques.
	 */
	function &getSubModules(){
		return $this->subModules;
	}	
	
	
	/**
	 * Charger les sous Modules du Module.
	 * Obtient et associe les sous Modules � partir de la base de donn�es.
	 * Si les sous Modules ont déjà été afféctés auparavent, cette méthode ne provoque pas d'erreur,
	 * et re calcule les sous modules.
	 */
	function &loadSubModules(){
		if(!$this->id)die("Module::loadSubModules(): Les sous modules ne peuvent etre charg�s car le module n'est pas installl�.");	
	
		$this->subModules=array();
		$res_sub_modules=get_module_submodules($this->id); 
		while($row=pg_fetch_row($res_sub_modules)){ 
//			print_rr($row);
			$this->subModules[]=new Module($row[0],$row[2],$row[4],$row[5],$row[1],$row[3],$row[8],sql2Bool($row[6]));
		}
	}
	
	function unloadSubModules(){
		unset($this->subModules);
	}
	
	function unloadPages(){
		unset($this->pages);
	}
	
	
	/**
	 * Obtenir les sous Modules du module d'un type donn�.
	 * @param string $type Le type de Modules d�sir�.
	 * @return object[] Module Les Module associ�es au Module de type $type.
	 */	
	function &getSubModulesByType($type){
		$tmp_array=$this->getSubModules();
		foreach($tmp_array as $k => $v){
			
			if($v->getType()!=$type){
				unset($tmp_array[$k]);
			}
		}
		return $tmp_array;
	}
	
	/**
	 * Affectation du lib�ll� du Module.
	 * Pour affichage.
	 * @param string $libelle Le lib�ll� du Module
	 */
	function setLibelle($libelle){
		$this->libelle=$libelle;
	}

	/**
	 * @todo A impl�menter
	 */	
	function setRequired($type,$entity){
		
		if(empty($type)||empty($entity))die("Module::setRequired() Parametres manquants ($type,$entity)".$this->getCode());
		$this->required[$type][]=$entity;
	}
	
	function getRequired($type=null){
		if(func_num_args()==0)		
			return $this->required;
		else
			return $this->required[$type];
	}
	
	/**
	 * @todo A impl�menter
	 */		
	function setDb($type,$entity){
		$this->db[$type][]=$entity;
	}
	
	function setUDb($type,$entity){
		$this->db[$type][]=$entity;
	}
	
	/**
	 * Obtenir le lib�ll� du Module.
	 * Pour affichage.
	 * @return string Le lib�ll� du Module
	 */	
	function getLibelle(){
		if(substr($this->libelle,0,5)=='MENU_'){
			return eval('return '.$this->libelle.';');
		}
		else{
			return $this->libelle;
		}
	}
	
	function getLibelleCode(){
		return $this->libelle;
	}
	
	/**
	 * Obtenir le type du Module.
	 * @return string Le type du Module.
	 */		
	function getType(){
		return $this->type;
	}
	
	/**
	 * Obtenir la version du Module.
	 * @return string La version du Module.
	 */	
	function getVersion(){
		return $this->version;
	}
	
	/**
	 * Obtenir le code unique du Module.
	 * Le code est commun � toutes les plate-formes.
	 * @return string Le code du Module
	 */	
	function getCode(){
		return $this->code;
	}
	
	/**
	 * Obtenir l'identifiant en bases de donn�es du Module.
	 * Cet identifiant est propre � chaque plate-forme Astairs.
	 * @return string Le code du Module
	 */	
	function getId(){
		return $this->id;
	}

	/**
	 * Affecter l'identifiant en bases de donn�es du Module.
	 * Cet identifiant est propre � chaque plate-forme Astairs.
	 * @param integer $id Identifiant du module
	 * @return string Le code du Module
	 */	
	function setId($id){
		$this->id=$id;
		$this->permissions=new AstairsModulePerm($this->id);
		
	}	

	/**
	 * @return string Libell� du r�pertoire contenant les scripts du Module.
	 */
	function getDirectory(){
		return $this->directory;
	}
	
	/**
	 * Verifie la validite du repertoire du modude.
	 * Le repertoire est valide s'ils'agit du meme repertoire que le repertoire courrant.
	 * @return boolean;
	 */
	function isDirectoryValid(){
		$cur_dir=dirname($_SERVER["PHP_SELF"]);
		$cur_dir=explode('/',$cur_dir);
		$cur_dir=$cur_dir[count($cur_dir)-1];
		$dirs_to_ignore=array('module_menu');
		
		if(!in_array($cur_dir,$dirs_to_ignore)){
//			echo "$cur_dir==$this->directory <br/>";
			return $cur_dir==$this->directory;
		}else
			return true;
	}
	/**
	 * @return string Description des fonctionnalit�s du Module. Pour affichage d'une aide.
	 */
	function getDescription(){
//		echo $this->description;
		return $this->description;
	}
	
	function isDeployed(){
		if(empty($this->id))return false;
		return true;
	}
	
	
	function isInstalled(){
		global $chemin_bo;
		if(file_exists($chemin_bo.'/'.$this->getDirectory().'/install.lock')){
			return true;
		}else{
			return false;
		}
	}
	
	function isActive(){
		return $this->active;
	}
	
	function setActive($active){
		$this->active=$active;
	}
	function install(){
		if(!$this->isInstalled()){
			return true;
			
		}else{
			return false;
		}
	}

	/**
	 * Affecter un lien retour pour les pages.
	 * Le script php pass� en argument est ajout�e � une pile de lien retour.
	 * @param string $script_php Le nom d'un script php et son repertoire � partir d'un repertoire de public_html. Il est possible de passer des parametes GET � la suite du nom du script.
	 * @example Syntaxes correctes: setReturnPage('/individu/individu.php'), setReturnPage('/individu/individu.php?id=$id&toto=toto')
	 */
	function setReturnPage($script_php){
		array_push($this->returnPageStack,$script_php);
	}
	
	/**
	 * Obtenir le chemin (relatif) pour l'affichage d'un lien retour dans une page.
	 * Le chemin est d�pil� et le prochain appel retourne donc une valeur diff�rente. 
	 * @param string $path Le chemin relatif pour atteindre un repertoire de public_html (le $dbpath)
	 */
	function getReturnPage($path){
		if(count($this->returnPageStack)>0){
			return $path."/bo".array_pop($this->returnPageStack);
		}else{
			return $path;
		}
	}
	
	function readReturnPage($path){
		if(count($this->returnPageStack)>0){
			return $path."/bo".$this->returnPageStack[count($this->returnPageStack)-1];
		}else{
			return $path;
		}
	}
	
	function have_perm($code=""){
		global $auth;
		
		if($auth->is_root())return true;
		
		$auth_perms=explode(',',$auth->auth["perm"]);

		if(empty($code)){
	        foreach($auth_perms as $profile){
	        	if(count($this->permissions->permissions[$profile])>0){
	          		return true;
	          	}
	        }
        }else{
        	
        	foreach($auth_perms as $profile){
        		if($profile=='root')return true;
	        	if(is_array($this->permissions->permissions[$profile])&&array_key_exists($code,$this->permissions->permissions[$profile])){
	          		return true;
	          	}
	        }
        }
        return false;
	}
	function have_perm_user($code=""){
		global $auth;
		
		if($auth->auth['uname']=='root')return true;
		
		$user=$auth->getUserId();
//		$this->loadPerms();
		$auth_perms=explode(',',$auth->auth["perm"]);

		if(empty($code)){
	        foreach($auth_perms as $profile){
	        	if(count($this->permissions->permissions[$profile])>0){
	          		return true;
	          	}
	        }
        }else{
        	
        	foreach($auth_perms as $profile){
        		if($profile=='root')return true;
	        	if(is_array($this->permissions->permissions[$profile])&&array_key_exists($code,$this->permissions->permissions[$profile])){
	          		return true;
	          	}
	        }
        }
        return false;
	}
	
	
	
	function &loadPerms(){
        return $this->permissions->loadPerms();
	}
	
	function setMainModule($main_module){
		$this->mainModule=$main_module;
	}
	
	function getMainModule(){
		return $this->mainModule;
	}
	
}
?>