<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on 7 déc. 07
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
class ModuleInstaller{
	
	function install($module){
		global $chemin_bo;
		$ok=true;
//		print_rr($module);
//		$ok=ModuleBuilder::saveModule($module);
		$log=fopen($chemin_bo.'/'.$module->getDirectory().'/log/install.log','a');
		if(!$log){
			die("Erreur: le fichier ".$chemin_bo.'/'.$module->getDirectory().'/log/install.log'." ne peut pas etre ouvert.");
		}
		if(!file_exists($chemin_bo.'/'.$module->getDirectory().'/install.lock')){
//			if(!file_exists($chemin_bo.'/'.$module->getDirectory().'/log/install.log')){
				
				fwrite($log,"--------------------------------------\n\n");
				fwrite($log,"Installation module:".date("d-m-Y H:i")."\n");
				fwrite($log,"infos:".$module->getLibelle()." (".$module->getCode().") ".$module->getVersion()."\n");
				
				$dependances=ModuleInstaller::checkRequireds($module,$log);
				if(count($dependances)==0){
					fwrite($log,"\n[OK]Dépendances vérifiées\n");
					ModuleInstaller::registerRequireds($module);
				}
				else{
					fwrite($log,"\n[ERREUR]Dépendances non vérifiées:\n");
					foreach($dependances as $miss){
						fwrite($log,"$miss est manquant\n");
					}
					$ok=false;
				}
				
		}else{
			$ok=false;
			fwrite($log,"\n[ERREUR]Module déjà installé (install.lock présent)\n");
		}
		fclose($log);
		if($ok==true)touch($chemin_bo.'/'.$module->getDirectory().'/install.lock');
		return $ok;
	}
	
	function uninstall($module){
		global $chemin_bo;
//		print_rr($module);
		$ok=true;
		$log=fopen($chemin_bo.'/'.$module->getDirectory().'/log/install.log','a');
		if(!$log){
			die("Erreur: le fichier ".$chemin_bo.'/'.$module->getDirectory().'/log/install.log'." ne peut pas etre ouvert.");
		}
		fwrite($log,"--------------------------------------\n\n");
		fwrite($log,"Desinstallation module:".date("d-m-Y H:i")."\n");
		fwrite($log,"infos:".$module->getLibelle()." (".$module->getCode().") ".$module->getVersion()."\n");
		if(file_exists($chemin_bo.'/'.$module->getDirectory().'/install.lock')){
			if(!ModuleInstaller::is_required($module,$log)){
				fwrite($log,"\n[OK]Dépendances vers ce module nulles.\n");
				ModuleInstaller::unregisterRequireds($module);
				fwrite($log,"\n[OK]Dépendances supprimées\n");
				unlink($chemin_bo.'/'.$module->getDirectory().'/install.lock');
			}else{
				$ok=false;
			}
		}else{
			fwrite($log,"\n[ERREUR]Module non installé (install.lock absent)\n");
			fwrite($log,"\n$chemin_bo/".$module->getDirectory()."/install.lock est manquant\n");
			$ok=false;
		}
		fclose($log);		
//		$ok=ModuleBuilder::unsaveModule($module);
		return $ok;
	}
	
	function deploy($module,$id_pere){
		global $chemin_bo;
		$db=connecteDB();
		$log=fopen($chemin_bo.'/'.$module->getDirectory().'/log/deploy.log','a');
		if(!$log){
			die("Erreur: le fichier ".$chemin_bo.'/'.$module->getDirectory().'/log/install.log'." ne peut pas etre ouvert.");
		}
		fwrite($log,"--------------------------------------\n\n");
		fwrite($log,"Deploiement module:".date("d-m-Y H:i")."\n");
		fwrite($log,"infos:".$module->getLibelle()." (".$module->getCode().") ".$module->getVersion()."\n");
		$ok=true;
//		print_rr($module);
		$ok=ModuleInstaller::deploySql($module,$db,$log);
		$ok=ModuleBuilder::saveModule($module);
		if(!empty($id_pere))$ok=set_module_submodule($id_pere,$module->getId(),$module->getCode(),$module->getVersion());
		fclose($log);
		return $ok;
	}
	
	function undeploy($module){
		global $chemin_bo;
		$db=connecteDB();
		$log=fopen($chemin_bo.'/'.$module->getDirectory().'/log/deploy.log','a');
		if(!$log){
			die("Erreur: le fichier ".$chemin_bo.'/'.$module->getDirectory().'/log/deploy.log'." ne peut pas etre ouvert.");
		}
		fwrite($log,"--------------------------------------\n\n");
		fwrite($log,"Retrait module:".date("d-m-Y H:i")."\n");
		fwrite($log,"infos:".$module->getLibelle()." (".$module->getCode().") ".$module->getVersion()."\n");
		$ok=true;
		if(!ModuleInstaller::is_required($module,$log)){
			fwrite($log,"\n[OK]Dépendances vers ce module nulles.\n");
			$ok=ModuleBuilder::unsaveModule($module);
			if($ok)$ok=ModuleInstaller::undeploySql($module,$db,$log);
		}else{
			fwrite($log,"\n[ERREUR]Suppression du module impossible, il y a des dépendances vers ce module:\n");
			$ok=false;
		}
		fclose($log);
		return $ok;
	}
	
	function deploySql($module,$db,$log){
		global $chemin_bo;
		$erreur="";
		foreach($module->db['TABLE'] as $sql_tables_file){
			$erreur=ModuleInstaller::launchSqlFile($chemin_bo.'/'.$module->getDirectory(),$sql_tables_file,$db,$log);
			if(!empty($erreur))return false; 
		}
		foreach($module->db['FUNCTIONS'] as $sql_functions_file){
			$erreur=ModuleInstaller::launchSqlFile($chemin_bo.'/'.$module->getDirectory(),$sql_functions_file,$db,$log);
			if(!empty($erreur))return false; 
		}
		foreach($module->db['DATA'] as $sql_data_file){
			$erreur=ModuleInstaller::launchSqlFile($chemin_bo.'/'.$module->getDirectory(),$sql_data_file,$db,$log);
			if(!empty($erreur))return false; 
		}
		return true;
	}
	
	function undeploySql($module,$db,$log){
		global $chemin_bo;
		$erreur="";
		if(is_array($module->db['DROP'])){
			foreach($module->db['DROP'] as $sql_tables_file){
				$erreur=ModuleInstaller::launchSqlFile($chemin_bo.'/'.$module->getDirectory(),$sql_tables_file,$db,$log);
				if(!empty($erreur))return false; 
			}
		}
		return true;
	}
	
	function launchSqlFile($path_sql,$fichier_sql,$db,$log){
		$requetes="";
		$erreur="";
		pg_query($db,"begin");
		$sql=file($path_sql.'/sql/'.$fichier_sql); // on charge le fichier SQL
//		$log=fopen($path_sql.'/log/sql.log','a');
//		if(!$log){
//			die("Erreur: le fichier ".$path_sql.'/log/sql.log'." ne peut pas etre ouvert.");
//		}
		if(!$sql){
			fwrite($log,"Erreur: le fichier $fichier_sql n'existe pas.");
		}
		foreach($sql as $l){ // on le lit
			if (substr(trim($l),0,2)!="--"){ // suppression des commentaires
				$requetes .= $l;
			}
		}
		 
		$reqs = split(";",$requetes);// on sépare les requêtes
		$fonction_search=false;
		foreach($reqs as $req){	// et on les éxécute
		
			//debut fonction
			if(strstr($req,'$BODY$')&&!$fonction_search){
//				echo "trouve $req<br>";
				$fonction_search=true;				
				$tmp=$req.';';
				continue;
			}
			//corps fonction
			if($fonction_search &&!strstr($req,'$BODY$')){
//				echo "lit $req<br>";
				$tmp.=$req.';';
				continue;
			}
			//fin fonction
			if($fonction_search &&strstr($req,'$BODY$')){
//				echo "fin $req<br>";
				$tmp.=$req.';';
				$fonction_search=false;
				$req=$tmp;
//				echo "<br>$req<br>";
			}
			
			if((trim($req)=="")){
				continue;
			}
			if (!pg_query($db,$req)){
				fwrite($log,$req);
				fwrite($log,"\n[ERROR]".pg_last_error($db)."\n"); 
				continue;
			}else{
				fwrite($log,"\n[OK]".trim($req,"\n"));
			}
		}
		if(empty($erreur)){
			pg_query($db,"commit");
		}else{
			pg_query($db,"rollback");
		}
		return $erreur;
	}
	
	function checkRequireds($module,$log){
		$req_miss=array();
		$required_modules=$module->getRequired('MODULE');
		foreach($required_modules as $i => $req){
			$res=get_module($req);
			$row=pg_fetch_row($res);
			$id=$row[0];
			$repertoire=$row[5];
			if($id){
				fwrite($log,"\n[OK]Dépendance module $req ($id)");
			}
			else{
				$req_miss[]=$req;	
				fwrite($log,"\n[ERREUR] dépendance module $req");
			}
		}
		return $req_miss;
	}
	function registerRequireds($module){
		global $chemin_bo;
		$req_miss=array();
		foreach($module->getRequired('MODULE') as $i => $req){
			$res=get_module($req);
			$row=pg_fetch_row($res);
			$repertoire=$row[5];
			$tab_content=file($chemin_bo.'/'.$repertoire.'/install.lock');
			if(!in_array($module->getCode(),$tab_content)){
//				print_rr($tab_content);
				$tab_content[]=$module->getCode();
				$content=implode("\n",$tab_content);
//				print_rr($tab_content);
//				die($content);
				 if (!$handle = fopen($chemin_bo.'/'.$repertoire.'/install.lock', 'w')) {
				         echo "Impossible d'ouvrir le fichier ($chemin_bo.'/'.$repertoire.'/install.lock',$content)";
				         exit;
				   }
				//file_put_contents($chemin_bo.'/'.$repertoire.'/install.lock',$content);
				fwrite($handle,$content);
				fclose($handle);
			}
		}
		return $req_miss;
	}
	
	function unregisterRequireds($module){
		global $chemin_bo;
		$req_miss=array();
		foreach($module->getRequired('MODULE') as $i => $req){
			$res=get_module($req);
			$row=pg_fetch_row($res);
//			print_rr($row);
			$repertoire=$row[5];
			$content=file_get_contents($chemin_bo.'/'.$repertoire.'/install.lock');
			$tab_content=explode("\n",$content);
			if(in_array($module->getCode(),$tab_content)){
				$cle=array_search($module->getCode(),$tab_content);			
//				print_rr($tab_content);
				unset($tab_content[$cle]);
				$content=implode("\n",$tab_content);
//				print_rr($tab_content);
//				die($content);
//				file_put_contents($chemin_bo.'/'.$repertoire.'/install.lock',$content);
 				if (!$handle = fopen($chemin_bo.'/'.$repertoire.'/install.lock', 'w')) {
				         echo "Impossible d'ouvrir le fichier ($chemin_bo.'/'.$repertoire.'/install.lock',$content)";
				         exit;
				   }
				//file_put_contents($chemin_bo.'/'.$repertoire.'/install.lock',$content);
				fwrite($handle,$content);
				fclose($handle);
			}
		}
		return $req_miss;
	}
	
	function is_required($module,$log){
		global $chemin_bo;
		$requis=false;
		$tmp="";
		$tab_content=file($chemin_bo.'/'.$module->getDirectory().'/install.lock');
		foreach($tab_content as $i => $req){
			$txt=trim($req);
			if(!empty($txt)){
				$requis=true;
				$tmp.="requis par le module $req\n";
			}
		}
		if($requis){
			$tmp="[ERREUR]Suppression du module impossible, il y a des dépendances vers ce module:\n".$tmp;
			fwrite($log,$tmp);
		}
		return $requis;
	}
	
	function getInstallLog($module){
		global $chemin_bo;
		$content=file_get_contents($chemin_bo.'/'.$module->getDirectory().'/log/install.log');
		return $content;
	}
	function getDeployLog($module){
		global $chemin_bo;
		$content=file_get_contents($chemin_bo.'/'.$module->getDirectory().'/log/deploy.log');
		return $content;
	}
}
?>
