<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de dfinition d'un menu de module.
 * Cet objet est compos d'un code (identifiant compos de lettres) qui doit etre unique,
 * d'un libll, ainsi que d'un style facultatif.
 */
class ModuleMenu{
	
	/**
	 * @var string Idendifiant unique du menu
	 */
	var $code;
	
	/**
	 * var string Libll du menu
	 */
	var $libelle;
	
	/**
	 * var string Style associ au menu
	 */
	var $style_class;
	
	/**
	 * Constructeur.
	 * Initialisation des parametres
	 * @param string $code Idendifiant unique du menu
	 * @param string $libelle Libll du menu
	 * @param string $style_class Style associ au menu
	 */
	function ModuleMenu($code, $libelle,$style_class=""){
		$this->code=$code;
		$this->libelle=$libelle;
		$this->style_class=$style_class;
	}
	
	/**
	 * Obtenir le libll.
	 */
	function getLibelle(){
		return $this->libelle;
	}
		
	/**
	 * Obtenir l'identifiant
	 */
	function getCode(){
		return $this->code;
	}
	
	/**
	 * Obtenir le style
	 */
	function getStyleClass(){
		return $this->style_class;
	}
	
	/**
	 * Obtenir les Modules parmis ceux passs en parametre dont le type correspond au code du ModuleMenu.
	 * @param object[] Module $modules Tableau de modules parmis lesquels on veut extraire ceux correspondant au code
	 * @return object[] Module $modules Les modules dont le type correspond au code
	 */
	function getModules($modules){
		$tmp_array=array();
		foreach($modules as $i => $module){
		
			if(strtolower($this->code)==strtolower($module->getType())){
				$tmp_array[]=$module;
			}
		}
		return $tmp_array;
	}
	
	function perm_check($individu){
		global $auth;	
		if($auth->is_root())return true;
		else return check_individu_modules_access_by_type($individu,$this->code);
	}
}	
?>
