<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe abstraites charge de la dfinition d'une structure de menus.
 */
class ModuleMenuStruct{
	
	/**
	 * @var ModuleMenu Menus composant la structure
	 */
	var $module_menus;
	
	/**
	 * Constructeur.
	 * Initialisation de l'attribut.
	 */
	function ModuleMenuStruct(){
		$this->module_menus=array();
	}
	
	/**
	 * Obtenir les ModuleMenu de la structure.
	 */
	function getModuleMenus(){
		return $this->module_menus;
	}
	

	/**
	 * Obtenir les identifiannts des menus composant la structure
	 */
	function getCodes(){
		$tmp_array=array();
		foreach($this->module_menus as $i => $menu){
			if(!in_array($menu,$tmp_array)){
				$tmp_array[]=$menu;
			}
		}	
		return $tmp_array;
	}
}
?>
