<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
* Obtenir les modules de la plate-forme.
*
* @param boolean Indique s'il s'agit des modules install� ou activ�s que l'on souhaite obtenir. 
* @return integer le resultat de la requete (id integer,libelle character varying,code character varying ,type character varying,version character varying, directory text, active boolean,description character varying)
*/
function get_modules($active=null){
	if(is_null($active))
		$sql="SELECT * FROM contraintes.FW_get_modules() AS (id integer,libelle character varying,code character varying , type character varying,version character varying, directory text,active boolean,description character varying)";
	else												
		$sql="SELECT * FROM contraintes.FW_get_modules($active) AS (id integer,libelle character varying,code character varying , type character varying,version character varying, directory text,active boolean,description character varying)";
	return pg_query($sql);    	
}

/**
* Obtenir un module de la plate-forme � partir de son code. (identifiant unique du module sur l'ensemble des plate-formes, ind�pendant de l'identifiant BDD)
*
* @param string $code Identifiant unique du module, ind�pendant de l'identifiant BDD
* @return integer le resultat de la requete (id integer,libelle character varying,code character varying ,type character varying,version character varying, directory text, active boolean,description character varying)
*/
function get_module($code){
	$sql="SELECT * FROM contraintes.FW_get_module('$code') AS (id integer,libelle character varying,code character varying , type character varying,version character varying, directory text,active boolean,description character varying)";
	return pg_query($sql);    	
}

/**
 * Enregistrement d'un Module en base de donn�es.
 * @param string $libelle Le lib�ll� du Module.
 * @param string $code Le code du Module
 * @param string $type Le type du Module
 * @param string $version La version du Module
 * @param string $directory Le repertoire correspondant au Module
 * @param boolean $active Indique si le repertoire doit etre actif ou non.
 * @param string $description Description de la fonctionnalit� du module.
 * 
 * @return integer Identifiant du Module ainsi cr��.
 */
function set_module($libelle,$code,$type,$version,$directory,$active,$description){
	$sql="SELECT * FROM contraintes.FW_set_module('$libelle','$code','$type','$version','$directory',$active,'$description')";
//	echo "$sql<br/>";
	$res=pg_query($sql);
	if(!$res){
		die("plpgsql_module::set_module($libelle,$code,$type,$version,$directory,$active): Erreur cr�ation Module, pas de resultat BDD");	
	}
	return pg_fetch_result($res,0,0);    	
}

/**
 * Enregistrement d'une Page de Module.
 * @param integer $module Identifiant du Module associ� � la Page.
 * @param string $libelle Le lib�ll� de la Page
 * @param string $type Le type de la Page
 * @param string $type L'URL de la Page
 * @param string $description Description de la fonctionnalit� de la Page
 * 
 * @return integer Identifiant de la Page ainsi cr��e.
 */
function set_module_page($module,$libelle,$type,$url,$description){
	$sql="SELECT * FROM contraintes.FW_set_module_page($module,'$libelle','$type','$url','$description')";
//	echo "$sql<br/>";
	return pg_fetch_result(pg_query($sql),0,0);    		
}

/**
 * Enregistrement d'un sous Module de Module.
 * @param integer $module Identifiant du Module associ� au sous Module 
 * @param string $submodule Identifiant du sous Module 
 * @param string $code Identifiant unique du module, ind�pendant de l'identifiant BDD
 * @param string $version A impl�menter
 * 
 * @return boolean true si l'affectaion a r�ussie,false sinon.
 */
function set_module_submodule($module,$submodule,$code,$version){
	$sql="SELECT * FROM contraintes.FW_set_module_submodule($module,$submodule,'$code','$version')";
//	echo "$sql<br/>";
	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));    		
}

/**
 * Obtenir les sous Modules d'un Module.
 * @return integer R�sultat de la requete: id integer,libelle character varying,code character varying ,type character varying,version character varying, directory text,active boolean,submodule integer,description character varying)
 */
function get_module_submodules($module){
	$sql="SELECT * FROM contraintes.FW_get_module_submodules($module)AS (id integer,libelle character varying,code character varying ,type character varying,version character varying, directory text,active boolean,description character varying)";
//	$sql="SELECT * FROM contraintes.FW_get_module_submodules($module)AS (id integer,libelle character varying,code character varying ,type character varying,version character varying, directory text,active boolean,submodule integer,description character varying)";
//	echo "$sql<br/>";
	return pg_query($sql);    		
}

/**
 * Obtenir types d'individus associés à un Module.
 * @return integer R�sultat de la requete: (id integer,libelle character varying,code character varying ,module integer)
 */
function get_module_individus_types($module){
	$sql="SELECT * FROM contraintes.FW_get_module_individus_types($module)AS (id integer,libelle character varying,code character varying ,module integer)";
//	echo "$sql<br/>";
	return pg_query($sql);    		
}

/**
 * Associer des types d'individus à un Module.
 * @return integer true ou fasle selon le resultat de la requete.
 */
function set_module_individus_types($module, $types){
	$sql="SELECT * FROM contraintes.FW_set_module_individus_types($module,".int_array_to_plpgsql_array($types).")";
//	echo "$sql<br/>";
//	exit;
	$res=pg_query($sql);	
	return (bool)($res && sql2Bool(pg_fetch_result($res,0,0))==true);    		
}

/**
 * Supprimer l'Association de types d'individus à un Module.
 * @return integer true ou fasle selon le resultat de la requete.
 */
function del_module_individus_types($module, $types){
	$sql="SELECT * FROM contraintes.FW_del_module_individus_types($module,".int_array_to_plpgsql_array($types).")";
	$res=pg_query($sql);	
	return (bool)($res && sql2Bool(pg_fetch_result($res,0,0))==true);     		
}

/**
 * Supprimer un enregistrement de Module.
 * @param integer identifiant du module
 */
function del_module($module){
	$sql="SELECT * FROM contraintes.FW_del_module($module)";
//	echo $res;
	$res=pg_query($sql);	
	return (bool)($res && sql2Bool(pg_fetch_result($res,0,0))==true);     		
}

/**
 * Obtenir les Pages d'un Module.
 * @return integer R�sultat de la requete: id integer,module integer,libelle character varying ,type character varying,url character varying,description character varying
 */
function get_module_pages($module){
	$sql="SELECT * FROM contraintes.FW_get_module_pages($module)AS (id integer,module integer,libelle character varying ,type character varying,url character varying,description character varying)";
//	echo "$sql<br/>";
	return pg_query($sql);    		
}

function maj_module_activation($module,$active,$recursif){
	$sql="SELECT * FROM contraintes.fw_maj_module_activation($module,$active,$recursif)";
//	echo "$sql<br/>";
	return (sql2Bool(pg_fetch_result(pg_query($sql),0,0))); 
}

function check_module_requireds($modules){
	$sql="SELECT * FROM contraintes.FW_check_module_requireds($modules)";
//	echo "$sql<br/>";
	return (sql2Bool(pg_fetch_result(pg_query($sql),0,0))==true);
}

function get_module_pages_by_code($code){
	$sql="SELECT * FROM contraintes.FW_get_module_pages($code)AS (id integer,module integer,libelle character varying ,type character varying,url character varying,description character varying)";
	//echo "$sql<br/>";
	return pg_query($sql);    		
}

/**
 * 
 * @return integer R�sultat de la requete:  (module integer,individu_type integer,droit integer)
 */
function get_modules_individus_types_droits(){
	$sql="SELECT * FROM contraintes.fw_get_modules_individus_types_droits()as (module integer,individu_type integer,droit integer)";
//	echo $sql;
//	echo "$sql<br/>";
	return pg_query($sql);    		
}

/**
 * 
 * @return integer R�sultat de la requete:  (module integer,individu_type integer,droit integer)
 */
function get_module_individus_types_droits($module){
	$sql="SELECT * FROM contraintes.fw_get_module_individus_types_droits($module)as (module integer,individu_type integer,droit integer)";
//	echo $sql;
//	echo "$sql<br/>";
	return pg_query($sql);    		
}
?>