<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoNode.
 * Un DoNode est l'objet de base servant  gerer l'avancement d'un parcours des entits
 * au sein de liste chaines.
 * Ainsi, chaque objet d'avancement dont doit hriter de cette classe, tel que les DoEtape ou les DoEvaluation.
 * 
 * @package node
 */
class DoNode extends DoElement{
	
	/**
	 * @var integer Identifiant du Node.
	 */
	var $node;
	
	/**
	 * @var integer Type du Node.
	 */
	var $node_type;
	
	/**
	 * @var object Node Objet correspondant au Node.
	 */
	var $obj_node;
	
	/**
	 * @var object Resultat Objet Resultat associ au Node
	 */
	var $obj_resultat;

	/**
	 * @var integer Identifiant du resultat en base de donnes
	 * Cet identifiant est correspond  une combinaison unique
	 * d'identifiants de Formation, Parcours, Individu et Etape.
	 */
	var $resultat;
		
	/**
	 * @var sql timestamp: date de dbut du Node
	 */	
	var $debut;
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * @param integer $element L'lment dont on gre l'avancement
	 * @param integer $individu l'individu qui effectue l'lment.
	 */
	function DoNode( $element,$individu){
		parent::DoElement($element,$individu);
	}
	
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * @param integer $entity Idendifiant de la liste chaine dans laquelle s'intgre le Node.
	 * @param integer $node Identifiant du node courant.
	 * @param integer $node_type Identifiant du type du node courant.
	 */
	function initDoNode($entity,$node, $node_type){
		messageDebug("DoNode::initDoNode($entity,$node, $node_type)");
		if(!empty($entity)&&!empty($node)&&!empty($node_type)){
			$this->entity=$entity;
			$this->node=$node;
			$this->node_type=$node_type;
			parent::initDoElement();
		}else{
			die("Erreur initDoNode(): L'objet ne peut etre initialis.");
		}
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * Commence le DoNode.
	 * Ne fait rien.
	 */
	function begin(){
		messageDebug("DoNode::begin()");
	}

	/**
	 * Construit le DoNode.
	 * Ne fait rien.
	 */
	function perform(){
		messageDebug("DoNode::perform()");
		return null;
	}

	/**
	 * Termine le DoNode.
	 * Dsaffecte les attributs de l'objet.
	 *  @return boolean true ou false suivant le succs ou non de la mthode.
	 */
	function end(){
		messageDebug("DoNode::end()");
		$res_parent=parent::end();
//		unset($this->entity);
//		unset($this->node);
//		unset($this->node_type);
//		unset($this->obj_node);
//		unset($this->obj_resultat);
		return $res_parent;
		
	}
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Obtenir l'identifiant de l'Entity associe au DoNode
	 * @return integer L'identifiant de l'Entity associe au DoNode
	 */
	function getEntity(){
		return $this->entity;
	}

	/**
	 * Obtenir l'objet Node associe au DoNode
	 * @return object Node L'objet Node associe au DoNode
	 */	
	function getNode(){
		return $this->node;
	}

	/**
	 * Obtenir l'identifiant du Node associe au DoNode
	 * @return integer L'identifiant ddu Node associe au DoNode
	 */		
	function &getObjNode(){
		return $this->obj_node;
	}

	/**
	 * Obtenir le type de Node
	 * @return integer le type de Node
	 */		
	function getNodeType(){
		return $this->node_type;
	}

	/**
	 * Obtenir l'objet Resultat correspondant au Node en cours.
	 * @return object Resultat l'identifiant resultat en base de donnes.
	 */		
	function &getCurrentResultat(){
		return $this->obj_resultat;
	}
	
	function getDebut(){
		return $this->debut;
	}
	
	function getDebutFormate(){
		return sql2StringTimestamp($this->debut);
	}
}
?>
