<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets d'avancement pour les Nodes.
 * Cette classe est une interface permettant d'indiquer les mthodes que
 * doivent implment des fabriques drives.
 * 
 * La fabrique doit tre initialise avec des identifiants de Formation, d'Individu ainsi qu'avec une
 * fabrique permettant de crer les objets associs aux objets d'avancement.
 * 
 * Cet objet permet ensuite d'obtenir, par la mthode createDoNode(), un objet d'avancement pour le rsultat et l'Evaluation spcifie (identifiant et type).
 * 
 * @package node
 */
class DoNodeFactory{
	
	/**
	 * @var integer Identifiant de la Formation concern par l'avancement.
	 */
	var $formation;

	/**
	 * @var integer Identifiant de l'Individu concern par l'avancement.
	 */	
	var $individu;
	
	/**
	 * @var object NodeFactory Fabrique pour les objets Node.
	 */	
	var $obj_NodeFactory;
	
	/**
	 * Constructeur de la fabrique.
	 * @param integer $formation Identifiant de la formation.
	 * @param integer $individu Identifiant de l'individu.
	 * @param object NodeFactory &$obj_NodeFactory Fabrique des objets associs aux objets d'avancement. 
	 */
	function DoNodeFactory($formation,$individu,&$obj_NodeFactory){
		$this->formation=$formation;
		$this->individu=$individu;
		$this->obj_NodeFactory=&$obj_NodeFactory;
	}
	
	/**
	 * Cre un objet d'avancement pour une Node.
	 * @param integer $entity identifiant de l'entit permettant d'identifier le Node
	 * @param integer $node identifiant du Node.
	 * @param integer $node_type identifiant du type de Node.
	 * 
	 * @return object DoNode : l'objet d'avancement dsir
	 */
	function &createDoNode($entity,$node,$node_type){
		
	}
	
	/**
	 * Obtenir la fabrique des objets associs (Nodes).
	 * @return object NodeFactory la fabrique des objets associs aux objets d'avancement de cette fabrique.
	 */
	function &getNodeFactory(){
		return $this->obj_NodeFactory;
	}
}
?>
