<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Node.
 *	Une Node est un objet driv de Element.
 *	Les Nodes sont utiliss dans les Listes.
 *
 *	@package node
 */
class Node extends Element{
	
	/**
	 * @var integer Type du Node
	 */
	var $type;
	
	/**
	 * @var string Date de cration du Node.
	 */	
	var $date_creation;
	
	/**
	 * Construit une Node.
	 * La Node peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de la Node
	 * @param string $libelle Libell
	 * @param integer $type Type de Node
	 * @param string $date_creation date de cration (format SQL)
	 */			
	function Node($id, $libelle, $type, $date_creation){
		messageDebug("Node::Node($id, $libelle, $type, $date_creation)");
		parent::Element($id, $libelle);
		//echo "typ=$type<br>";
		$this->initNode($type, $date_creation);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initialise les attributs propres au Node.
	 * 
	 * @param integer $type Type de Node
	 * @param string $date_creation date de cration (format SQL)
	 */		
	function initNode($type, $date_creation){
		messageDebug("Node::initNode($type, $date_creation)");
		if(!empty($type)){
			$this->type=$type;
			$this->date_creation=$date_creation;
		}else{
			die("Erreur initNode($type, $date_creation): L'objet ne peut etre initialis.");
		}
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$attributs_ok=true;
		if(!empty($this->date_creation)){
			$message.="[date_creation]";
			$attributs_ok=false;	
		}
		$res_parent=parent::verifyInsert(&$message);
		$verif=Node::verify(&$message);
		return $res_parent && $verif && $attributs_ok;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=Node::verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * La date de cration doit tre nulle et le type non null.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		
		$attributs_ok=true;
		if(empty($this->type)){
			$message.="[type]";
			$attributs_ok=false;	
		}
		return $attributs_ok;
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
		
	/**
	 * Obtenir le type de Node
	 * @return integer Le type de Node
	 */
	function getType(){
		return $this->type;
	}
	
	/**
	 * Obtenir la date de cration du Node
	 * @return string La date de cration au format SQL 
	 */
	function getDateCreation(){
		return $this->date_creation;
	}
}
?>
