<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
     Fichier de gestion des inclusions de classes

     Ces fichiers obj_nomClasses.php sont  inclure pour pouvoir utiliser les classes.
     On charge les fichiers de dfinitions de la classe et de ses fonctions.
     Les classes annexes ncssaires au bon fonctionnement sont par ailleurs aussi gres.

     @package lib
*/

//COMMUNS
require_once("$root/lib/element/Element.php");
require_once("$root/lib/element/DoElement.php");
require_once("$root/lib/node/Node.php");
require_once("$root/lib/node/DoNode.php");
require_once("$root/lib/node/NodeFactory.php");
require_once("$root/lib/node/DoNodeFactory.php");
require_once("$root/lib/element/DoElementEntity.php");
require_once("$root/lib/resultat/Resultat.php");
require_once("$root/lib/resultat/ResultatFactory.php");




//EVALUATIONS
require_once("$root/lib/evaluation/Evaluation.php");
require_once("$root/lib/ftb/Ftb.php");
require_once("$root/lib/question_reponse/QuestionReponse.php");
require_once("$root/lib/qcm/Qcm.php");
require_once("$root/lib/sondage/Sondage.php");
require_once("$root/lib/qsrc/Qsrc.php");
require_once("$root/lib/qrc/Qrc.php");
require_once("$root/lib/src/Src.php");
require_once("$root/lib/evaluation/EvaluationFactory.php");

//RESULTATS ETAPES
require_once("$root/lib/etape/ResultatEtape.php");
require_once("$root/lib/exotlc/ResultatExotlcPlateforme.php");
require_once("$root/lib/etape/ResultatEtapeFactory.php");

//RESULTATS EVALUATIONS
require_once("$root/lib/evaluation/ResultatEvaluation.php");
require_once("$root/lib/serie/ResultatSerie.php");
require_once("$root/lib/ftb/ResultatFtb.php");
require_once("$root/lib/question_reponse/ResultatQuestionReponse.php");
require_once("$root/lib/qcm/ResultatQcm.php");
require_once("$root/lib/sondage/ResultatSondage.php");
require_once("$root/lib/qsrc/ResultatQsrc.php");
require_once("$root/lib/qrc/ResultatQrc.php");
require_once("$root/lib/src/ResultatSrc.php");
require_once("$root/lib/evaluation/ResultatEvaluationFactory.php");


//ETAPES
require_once("$root/lib/etape/Etape.php");
require_once("$root/lib/etape_ressource/EtapeRessource.php");
require_once("$root/lib/exotlc/Exotlc.php");
require_once("$root/lib/exotlc/ExotlcMail.php");
require_once("$root/lib/exotlc/ExotlcPlateforme.php");
require_once("$root/lib/exotlc/ExotlcFactory.php");
require_once("$root/lib/scenario/Scenario.php");
require_once("$root/lib/etape_titre/EtapeTitre.php");
require_once("$root/lib/etape_forum/EtapeForum.php");
require_once("$root/lib/etape_chat/EtapeChat.php");
require_once("$root/lib/parcours/Parcours.php");
require_once("$root/lib/parcours_attache/ParcoursAttache.php");
require_once("$root/lib/parcours_oriente/ParcoursOriente.php");
require_once("$root/lib/etape/EtapeFactory.php");
require_once("$root/lib/liste/Liste.php");
require_once("$root/lib/serie/Serie.php");
require_once("$root/lib/serie_aleatoire/SerieAleatoire.php");
require_once("$root/lib/serie_aleatoire/SerieAleatoireMultiserie.php");
require_once("$root/lib/serie_aleatoire/SerieAleatoireMultitheme.php");
require_once("$root/lib/serie_aleatoire/SerieAleatoireMelangee.php");

//DO EVALUATIONS
require_once("$root/lib/evaluation/DoEvaluation.php");
require_once("$root/lib/ftb/DoFtb.php");
require_once("$root/lib/qsrc/DoQsrc.php");
require_once("$root/lib/qrc/DoQrc.php");
require_once("$root/lib/src/DoSrc.php");
require_once("$root/lib/question_reponse/DoQuestionReponse.php");
require_once("$root/lib/sondage/DoSondage.php");
require_once("$root/lib/qcm/DoQcm.php");
require_once("$root/lib/evaluation/DoEvaluationFactory.php");

//DO ETAPES
require_once("$root/lib/etape/DoEtape.php");
require_once("$root/lib/etape/DoEtapeRenewable.php");
require_once("$root/lib/etape/DoEtapeDynamique.php");
require_once("$root/lib/parcours/DoParcours.php");
require_once("$root/lib/exotlc/DoExotlc.php");
require_once("$root/lib/exotlc/DoExotlcMail.php");
require_once("$root/lib/exotlc/DoExotlcPlateforme.php");
require_once("$root/lib/exotlc/DoExotlcFactory.php");
require_once("$root/lib/etape_chat/DoEtapeChat.php");
require_once("$root/lib/etape_forum/DoEtapeForum.php");
require_once("$root/lib/etape_ressource/DoEtapeRessource.php");
require_once("$root/lib/liste/DoListe.php");
require_once("$root/lib/serie/DoSerie.php");
require_once("$root/lib/serie_aleatoire/DoSerieAleatoire.php");
require_once("$root/lib/serie_aleatoire/DoSerieAleatoireMultiserie.php");
require_once("$root/lib/serie_aleatoire/DoSerieAleatoireMultitheme.php");
require_once("$root/lib/serie_aleatoire/DoSerieAleatoireMelangee.php");
require_once("$root/lib/test/DoTest.php");
require_once("$root/lib/scenario/DoScenario.php");
require_once("$root/lib/etape_titre/DoEtapeTitre.php");
require_once("$root/lib/parcours/DoParcoursDynamique.php");
require_once("$root/lib/parcours_attache/DoParcoursAttache.php");
require_once("$root/lib/parcours_oriente/DoParcoursOriente.php");
require_once("$root/lib/etape/DoEtapeFactory.php");
require_once("$root/lib/formation/DoFormation.php");

//CORRECTIONS
require_once("$root/lib/etape/EtapeCorrectionFactory.php");
require_once("$root/lib/etape/EtapeCorrection.php");
require_once("$root/lib/etape/EtapeCorrectionTentative.php");
require_once("$root/lib/exotlc/ExotlcCorrection.php");
require_once("$root/lib/liste/ListeCorrection.php");
require_once("$root/lib/liste/ListeCorrectionTentative.php");
require_once("$root/lib/serie/SerieCorrection.php");
require_once("$root/lib/serie/SerieCorrectionTentative.php");
require_once("$root/lib/serie_aleatoire/SerieAleatoireCorrection.php");
require_once("$root/lib/evaluation/EvaluationCorrection.php");
require_once("$root/lib/evaluation/EvaluationCorrectionAleatoire.php");

require_once("$root/lib/question_reponse/QuestionReponseCorrection.php");
require_once("$root/lib/qcm/QcmCorrection.php");
require_once("$root/lib/sondage/SondageCorrection.php");
require_once("$root/lib/qsrc/QsrcCorrection.php");
require_once("$root/lib/qrc/QrcCorrection.php");
require_once("$root/lib/src/SrcCorrection.php");
require_once("$root/lib/ftb/FtbCorrection.php");
require_once("$root/lib/evaluation/EvaluationCorrectionFactory.php");

require_once("$root/lib/question_reponse/QuestionReponseCorrectionAleatoire.php");
require_once("$root/lib/qcm/QcmCorrectionAleatoire.php");
require_once("$root/lib/sondage/SondageCorrectionAleatoire.php");
require_once("$root/lib/qsrc/QsrcCorrectionAleatoire.php");
require_once("$root/lib/qrc/QrcCorrectionAleatoire.php");
require_once("$root/lib/src/SrcCorrectionAleatoire.php");
require_once("$root/lib/ftb/FtbCorrectionAleatoire.php");
require_once("$root/lib/evaluation/EvaluationCorrectionFactoryAleatoire.php");
?>