<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
     Fichier de gestion des inclusions de classes

     Ces fichiers obj_nomClasses.php sont  inclure pour pouvoir utiliser les classes.
     On charge les fichiers de dfinitions de la classe et de ses fonctions.
     Les classes annexes ncssaires au bon fonctionnement sont par ailleurs aussi gres.

     @package lib
*/

//-----------------------------------
//		INTERFACES
//-----------------------------------
require_once("$root/lib/import_export/ImportFile.php");
require_once("$root/lib/import_export/ExportFile.php");
require_once("$root/lib/import_export/ExportFileFactory.php");
require_once("$root/lib/import_export/ImportStruct.php");
require_once("$root/lib/import_export/ExportStruct.php");

//-----------------------------------
//		ASTAIRS
//-----------------------------------

//IMPORT

require_once("$root/lib/import_export/ImportAstairsQcm.php");
require_once("$root/lib/import_export/ImportAstairsSondage.php");
require_once("$root/lib/import_export/ImportAstairsQrc.php");
require_once("$root/lib/import_export/ImportAstairsSrc.php");
require_once("$root/lib/import_export/ImportAstairsFtb.php");
//require_once("$root/lib/import_export/ImportAstairsRessource.php");

//EXPORT
require_once("$root/lib/import_export/export/astairs/ExportAstairs.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsQcm.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsSondage.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsQrc.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsSrc.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsFtb.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsRessource.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsFactory.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsEtapeFactory.php");
require_once("$root/lib/import_export/export/astairs/ExportAstairsGlossaire.php");

//STRUCTURES
require_once("$root/lib/import_export/export/astairs/ExportStructAstairs.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsQuestion.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsReponse.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsReponseQcm.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsQcm.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsSondage.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsQrc.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsSrc.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsFtb.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsRessource.php");
require_once("$root/lib/import_export/export/astairs/ExportStructAstairsGlossaire.php");

//-----------------------------------
//		CSV
//-----------------------------------

//IMPORT
require_once("$root/lib/import_export/import/csv/ImportCsv.php");
require_once("$root/lib/import_export/import/csv/ImportCsvQcm.php");
require_once("$root/lib/import_export/import/csv/ImportCsvSondage.php");
require_once("$root/lib/import_export/import/csv/ImportCsvQrc.php");
require_once("$root/lib/import_export/import/csv/ImportCsvSrc.php");
require_once("$root/lib/import_export/import/csv/ImportCsvFtb.php");
require_once("$root/lib/import_export/import/csv/ImportCsvRessource.php");
require_once("$root/lib/import_export/import/csv/ImportFileCsvFactory.php");
require_once("$root/lib/import_export/import/csv/ImportFileCsvEtapeFactory.php");
require_once("$root/lib/import_export/import/csv/ImportCsvGlossaire.php");

//EXPORT
require_once("$root/lib/import_export/ExportCsvQcm.php");
require_once("$root/lib/import_export/ExportCsvSondage.php");
require_once("$root/lib/import_export/ExportCsvQrc.php");
require_once("$root/lib/import_export/ExportCsvSrc.php");
require_once("$root/lib/import_export/ExportCsvFtb.php");
require_once("$root/lib/import_export/ExportCsvQcm.php");
require_once("$root/lib/import_export/ExportCsvFactory.php");

//STRUCTURES
require_once("$root/lib/import_export/import/csv/ImportStructCsv.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvQcm.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvSondage.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvQrc.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvSrc.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvFtb.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvRessource.php");
require_once("$root/lib/import_export/import/csv/ImportStructCsvGlossaire.php");


//-----------------------------------
//		CORRELATIONS
//-----------------------------------
require_once("$root/lib/import_export/CorrelationStruct.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsQcm.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsSondage.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsQrc.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsSrc.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsFtb.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsRessource.php");
require_once("$root/lib/import_export/CorrelationStructCsvAstairsGlossaire.php");

//-----------------------------------
//		TRANSFERT BUILDER
//-----------------------------------
require_once("$root/lib/import_export/TransfertBuilder.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsQcm.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsSondage.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsQrc.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsSrc.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsFtb.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsRessource.php");
require_once("$root/lib/import_export/TransfertBuilderCsvAstairsGlossaire.php");
?>