<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Dfinition de la classe organisme
Cette classe dcrit un organisme (num, libelle).
@author CHABOISSIER Jonathan <jc@afide.fr>
@since 19/05/2004

@package organisme
*/
class Organisme
{
        /**
        * @var integer : Identifiant en base de donnes
        */
        var $num_org ;

        /**
        * @var string : Libelle de l'organisme
        */
        var $libelle_org ;

        /**
        * Constructeur
        * Ce constructeur permet de crer un objet Organisme de deux faon diffrentes. Soit il va chercher un libell dans
        * la base de donnes et dans ce cas il faut lui donner l'identifiant. Autrement, on lui passe une chane de caractre
        * qui sera affecte au libell.
        * @param string $num_ou_lib Peut-tre ou bien un identifiant de ligne en base de donnes (c'est donc un entier), ou une chane soit un
        * nouvel organisme
        */
        function Organisme($num_ou_lib)
        {

                // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine){
					$this->num_org = $num_ou_lib ;
					// Organisme multi-organisme
					if($num_ou_lib==0)
						$this->libelle_org = "Multi-organisme" ;
					// Organisme en base de donnes
					else{
						// echo "Class Organisme : constructeur avec identifiant<br>" ;
						/*
						$requete="SELECT * FROM organisme WHERE num_org=$num_ou_lib" ;
						$result=pg_query($requete) ;
						*/
						$result=get_organisme($num_ou_lib);
						$row=pg_fetch_row($result,0) ;
						//$this->libelle_org = $row["libelle_org"] ;
						$this->libelle_org = $row[1] ;
					}
                }
                // Construction  partir d'un libell
                else{
					if($num_ou_lib=="Multi-organisme")
						$this->num_org= "NULL" ;
					else
						$this->num_org="NULL" ; // Ce n'est pas un cas normal... Un organisme doit toujours avoir un identifiant si il est lment d'individu
					$this->libelle_org = $num_ou_lib ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Organisme($num_ou_lib)


        /**
        * Fonction qui insre un enregistrement en table organisme et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'organisme n'existe pas dj
                if($this->libelle_org=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        $lib=addslashes($this->libelle_org) ;
						//echo "lib=$lib<br>";
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_org FROM organisme WHERE libelle_org='$lib'"))>0)
                        if(check_organisme($lib))
                        {
                                return (-111);  // organisme existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO organisme (libelle_org) VALUES ('$lib')" ;
                                $insertion=set_organisme($lib);

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_org FROM organisme WHERE libelle_org='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table organisme
        *
        * Fonction qui met  jour l'enregistrement en table organisme
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->num_org != 0)
                {
                        //$update = "UPDATE organisme SET libelle_org = '".addslashes($this->libelle_org)."' WHERE num_org=$this->num_org" ;
                        $lib=addslashes($this->libelle_org) ;
                        $update=maj_organisme($this->num_org,$lib);

                        // echo "Class Organisme : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
        * Si on ne passe aucun paramtre, la chane retourne contient le libell de l'organisme. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        *
        * @param string : le paramtre determine ce qu'on retourne.
        * [num_org] - [libelle_org]
        * @return string : On retourne la chane de caractres cre  partir du format
        */

        function toString($format="")
        {
                // Aucun paramtre, on retourne le libell
                if($format=="")
                        return $this->libelle_org ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[num_org\]"=>$this->num_org,"\[libelle_org\]"=>$this->libelle_org) ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

        /**
        * Retourne la liste des individus appartenant  l'organisme
        *
        * On obtient les num_user, nom, prenom et catgorie des individus de l'oganisme. On peut classer
        * dans l'ordre croissant ou dcroissant salon le second paramtre.
        *
        * @param string : ASC ou DESC
        * @return interger : num_user, nom, prenom, categorie
        */
        function getIndividus($classement="ASC")
        {
                //return get_individus_organisme($this->num_org, $classement,0,0) ;
				return get_organisme_individus($this->num_org, $classement,0,'false') ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getIndividus($classement)

        /**
        * Retourne la liste des stagiaires appartenant  l'organisme
        *
        * On obtient les num_user, nom, prenom et catgorie des stagiaires de l'oganisme. On peut classer
        * dans l'ordre croissant ou dcroissant salon le second paramtre.
        *
        * @param string $classement ASC ou DESC
        * @param string $exclusif si VRAI alors on ne prend que les 'u' et aucun 'fu'
        * @return interger : num_user, nom, prenom, categorie
        */
        function getStagiaires($classement="ASC", $exclusif='false')
        {
                // echo "Class organisme : getStagiaires($classement, $exclusif)<br>";
                //return get_individus_organisme($this->num_org, $classement,2,$exclusif) ;
				return get_organisme_individus($this->num_org, $classement,2,$exclusif) ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getStagiaires($classement, $exclusif)

        /**
        * Retourne la liste des formateurs appartenant  l'organisme
        *
        * On obtient les num_user, nom, prenom et catgorie des formateurs de l'oganisme. On peut classer
        * dans l'ordre croissant ou dcroissant salon le second paramtre.
        *
        * @param string $classement ASC ou DESC
        * @param string $exclusif si VRAI alors on ne prend que les 'f' et aucun 'fu'
        * @return interger : num_user, nom, prenom, categorie
        */
        function getFormateurs($classement="ASC", $exclusif='false')
        {
                // echo "Class organisme : getFormateurs($classement, $exclusif)<br>";
                //return get_individus_organisme($this->num_org, $classement,1,$exclusif) ;
				return get_organisme_individus($this->num_org, $classement,1,$exclusif) ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getFormateurs($classement, $exclusif)
        
        /**
         * Retourne le libelle de l'organisme
         * @return string retourne une chaine de caractere contenant le libelle de l'organisme.
         */
         function getLibelle(){
         	return $this->libelle_org;
         }
         
         
         function setLibelle($libelle){
         	$this->libelle_org=$libelle;
         }
         
         /**
          * Retourne l'identifiant en base de donne de l'organisme
          * @return integer retourne l'identifiant en base de donne de l'organisme.
          */
         function getId(){
         	return $this->num_org;
         }
}

?>