<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package organisme
       @modulegroup plpgsql
       @module plpgsql_organisme
*/



/**
*   Supprimer un organisme.  (OLD)
*
*   Supprime l'organisme

*
*   @param integer : numero de l'organisme  supprimer
*   @return integer : 1
*/
function del_organisme_old($organisme){

    //suppression
    $del=pg_query("delete from organisme where num_org=$organisme;");

    return 1;
}

/**
*   Supprimer un organisme.
*
*   Supprime l'organisme

*
*   @param integer : numero de l'organisme  supprimer
*   @return integer : 1
*/
function del_organisme($organisme){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_organisme($organisme)";
		$res=pg_query($sql);
	}
	else
		$res=del_organisme_old( $organisme);
	return ($res);
}

/**
    Obtenir le libelle d'un organisme (OLD)
*   @param integer : numero de l'organisme
*   @return integer : le resultat de la requete
*/
function get_organisme_old($organisme){
    $sql="select * from organisme where num_org=$organisme";
    return (pg_query($sql));
}
/**
    Obtenir le libelle d'un organisme
*   @param integer : numero de l'organisme
*   @return integer : le resultat de la requete
*/
function get_organisme($organisme){
    if(VERSION_BASE>VERSION){
		
        $sql="select * from contraintes.af_get_organisme($organisme) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        $res=get_organisme_old( $organisme);
    return ($res);
}



/**
    Verifie si un nom d'organisme existe deja (OLD)

    @param string : nom de l'organisme
*   @return bool : true si existe,sinon false
*/
function check_organisme_old($libelle){
    $sql="SELECT num_org FROM organisme WHERE libelle_org='$libelle'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    return true;
}
/**
    Verifie si un nom d'organisme existe deja

    @param string : nom de l'organisme
*   @return bool : true si existe,sinon false
*/
function check_organisme($libelle){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=check_organisme_old($libelle);
    return ($res);
}

/**
    Enregistre un organisme (OLD)

    @param string : nom de l'organisme
    @return integer : le numro de l'organisme, 0 si erreur
*/
function set_organisme_old($libelle){
    $sql = "INSERT INTO organisme (libelle_org) VALUES ('$libelle')" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_org from organisme where oid=$oid;");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre un organisme

    @param string : nom de l'organisme
    @return integer : le numro de l'organisme, 0 si erreur
*/
function set_organisme($libelle){
	echo "coucou<br>";
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_organisme('$libelle')";
		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=set_organisme_old($libelle);
    return ($res);
}

/**
    Mettre  jour un organisme (OLD)

    @param integer : le numero de l'organisme
    @param string : le nom de l'organisme
    @return integer : le resultat de la requete
*/
function maj_organisme_old($organisme,$libelle){
    $sql="update organisme set libelle_org='$libelle' where num_org=$organisme";
    return pg_query($sql);
}
/**
    Mettre  jour un organisme

    @param integer : le numero de l'organisme
    @param string : le nom de l'organisme
    @return integer : le resultat de la requete
*/
function maj_organisme($organisme,$libelle){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_organisme($organisme,'$libelle')";
		$res=pg_query($sql);
    }
    else
        $res=maj_organisme_old($organisme,$libelle);
    return ($res);
}

/**
* Retourne la listes des individus de l'organisme dont l'id est pass en paramtre OLD
* On ne donne que les nom et les prnoms des individus
* @param integer : Identifiant de l'organisme dont on souhaite la liste des individus
* @param string : Ordre croissant ou dcroissant
* @param integer : Catgorie d'individus  slectionner : 0= tout les individus, 1=les formateurs & 2=les stagiaires
* @param integer : Si VRAI alors on ne garde que les 'f' ou 'u' selon la categorie
* @return integer : num_user, nom, prenom, categorie
*/
function get_organisme_individus_old($organisme, $classement="ASC", $categorie=0, $exclusif='false'){
	$req="select num_user, nom, prenom,login,password, categorie
                FROM utilisateurs
                WHERE num_org=$organisme " ;

    // On veut les formateurs
	if($categorie==1){
		// Les 'f' seulement
		if($exclusif=='true')
			$req .= " AND categorie LIKE 'f' " ;
		 // Les 'f' et les 'fu'
		 else
			$req .= " AND categorie LIKE '%f%' " ;
	}
	else{
		// On veut les stagiaires
		if($categorie==2){
			// les 'u' seulement
			if($exclusif=='true')
				$req .= " AND categorie LIKE 'u' " ;
			// Les 'u' et les 'fu'
			else
				$req .= " AND categorie LIKE '%u%' " ;
		}
	}
	$req .= " ORDER BY nom $classement;";
	//echo "$req<br>";
	$individus=pg_query($req);
	return $individus;
}

/**
* Retourne la listes des individus de l'organisme dont l'id est pass en paramtre
* On ne donne que les nom et les prnoms des individus. Si celui qui utilise cette fonction ne veut afficher que les
* formateurs ou que les stagiaires, il devra faire lui-mme un test sur le champ catgorie. En effet, j'ai estim
* que cette fonction ne serait pas assez utilise dans la plate forme pour faire les tests au niveau BD...
* @param integer : Identifiant de l'organisme dont on souhaite la liste des individus
* @param string : Ordre croissant ou dcroissant
* @param integer : Catgorie d'individus  slectionner : 0= tout les individus, 1=les formateurs & 2=les stagiaires
* @param integer : Si VRAI alors on ne garde que les 'f' ou 'u' selon la categorie
* @return integer : num_user, nom, prenom, categorie
*/
function get_organisme_individus($organisme, $classement='ASC', $categorie=0, $exclusif='false')
{
        if(VERSION_BASE>VERSION)
        {
		if($organisme==0)
			$organisme='NULL';
                $req="SELECT * FROM  contraintes.af_get_organisme_individus($organisme, '$classement', $categorie, $exclusif)
                AS (num_user integer, nom varchar, prenom varchar,login varchar,password varchar,type integer) ;" ;
				//echo "req=$req<br>";
                $individus=pg_query($req);
        }
         // Fonction de substitution
         else
                $individus=get_organisme_individus_old($organisme, $classement, $categorie, $exclusif) ;

        return $individus;
}

//function get_organisme_individus_autres($organisme, $classement='ASC', $categories)
//{
//        if(VERSION_BASE>VERSION)
//        {
//        	
//        	
//                $req="SELECT * FROM  contraintes.af_get_organisme_individus_autres($organisme, '$classement', '$categories')
//                AS (num_user integer, nom varchar, prenom varchar,login varchar,password varchar,type integer) ;" ;
//				echo "req=$req<br>";
//                $individus=pg_query($req);
//        }
//         // Fonction de substitution
//
//        return $individus;
//}

?>