<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de d�finition d'une Page Astairs.
 * Une Page est principalent un lien.
 * Elle � pour propri�t� un lib�ll�, utilis� pour le lien, un type, utilis� pour faire des ensembles de Pages,
 * une url et une description pour l'affichage d'une aide.
 */
 class Page{
 	/**
	 * @var string Lib�ll� de la Page. Pour affichage.
	 */
	var $libelle;
	
	/**
	 * @var string Description des fonctionnalit�s de la Page. Pour affichage d'une aide.
	 */
	var $description;
	
	/**
	 * @var string Type de la Page. Permet de gerer des ensembles de Pages, pour affichage d'un menu par exemple.
	 */	
	var $type;
	
	/**
	 * @var string L'URL de la Page.
	 */
	var $url;

	/**
	 * Constucteur.
	 * @param string $libelle Lib�ll� de la Page. Pour affichage.
	 * @param string $type Type de la Page. Permet de gerer des ensembles de Pages, pour affichage d'un menu par exemple.
	 * @param string $url L'URL de la Page.
	 * @param string $description Description des fonctionnalit�s de la Page. Pour affichage d'une aide.
	 */
	function Page($libelle,$type,$url="", $description=""){
		$this->libelle=$libelle;
		$this->description=$description;
		$this->type=$type;
		$this->url=$url;
	}
	
	/**
	 * Affectation de l'URL de la Page.
	 * @param string $url L'URL de la Page.
	 */
	function &setURL($url){
		$this->url=$url;
	}
	
	/**
	 * Obtenir le lib�ll� de la Page.
	 * @return string Lib�ll� de la Page. Pour affichage.
	 */
	function getLibelle(){

//NON: il ne faut pas interpr�ter le lib�ll� car sinon stock� de meme dans les taples de modules/pages		
//		if(substr($this->libelle,0,5)=='MENU_'||substr($this->libelle,0,4)=='MSG_'){
//			return eval('return '.$this->libelle.';');
//		}
//		else{
			return $this->libelle;
//		}
	}
	
	/**
	 * Obtenir la description des fonctionnalit�s de la Page. Pour affichage d'une aide.
	 * @return string Description des fonctionnalit�s de la Page. Pour affichage d'une aide.
	 */
	function getDescription(){
//		echo $this->description;
		return $this->description;
	}
	
	/**
	 * Obtenir l'URL de la Page.
	 * @return string L'URL de la Page.
	 */	
	function getURL(){
		return $this->url;
	}
	
	/**
	 * Obtenir le Type de la Page. Permet de gerer des ensembles de Pages, pour affichage d'un menu par exemple.
	 * @return string Type de la Page. Permet de gerer des ensembles de Pages, pour affichage d'un menu par exemple.
	 */
	function getType(){
		return $this->type;
	}
}
?>