<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions pourpage
	@package page
	@modulegroup fonctions
*/

/**
	Fonctions de conversion de numero de pages
	concerne les pages annuaire,ressource et score general (page unique dans leur type= 
*/
function get_numero_page_annuaire(){
	if(VERSION_BASE > VERSION)
		return 1;
	return 4;
}
function get_numero_page_ressource(){
	if(VERSION_BASE > VERSION)
		return 2;
	return 11;
}
function get_numero_page_score_general(){
	if(VERSION_BASE > VERSION)
		return 3;
	return 7;
}

/**
	Fonction qui retourne les diff�rents types d'individu pour la page d'annuaire
*/
function get_page_annuaire_type_individu(){
	if(VERSION_BASE > VERSION)
		$tab=array(1,2);
	else
		$tab=array('u','f');
	return $tab;
}

/**
	retourne les elements d'une page sous forme de tableau
	@param integer : page
*/
function get_page_tableau_elements($page){
	if(VERSION_BASE > VERSION){
		$res=get_page_elements($page);
		$nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			$tab[$row[0]]=$row[1];
		}
	}
	else{
		$sql="select * from formatpage where num_page=$page";
		$res=pg_query($sql);
		$row=pg_fetch_row($res,0);
		$nb=sizeof($row);
		for($i=1;$i<$nb;$i++){
			if($row[$i]=='t'){
				$libelle=pg_field_name($res,$i);
				$tab[$i]=$libelle;
			}
		}
	}
	return $tab;
}

/**
	retourne la configuration d'une page d'annuaire sous forme de tableau
	@param integer : le numero de formation
	@param integer : le numero de page
	@param interger/char : le type d'individu
*/
function get_page_tableau_annuaire_configuration($formation,$page,$type){
	$tab=array();
	$res=get_page_annuaire_configuration($formation,$page,$type);
	if(VERSION_BASE > VERSION){
		$nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			$tab[]=$row[0];
		}
	}
	else{
		if(pg_num_rows($res)==1){
			$row=pg_fetch_row($res,0);
			$t=explode(",",$row[0]);
			while(list($cle,$val)=each($t)){
				$tab[]=$val;
			}
		}
		
	
	}
	return $tab;
}

/**
	retourne la configuration d'une page de liste (serie ou test) sous forme de tableau
	@param integer : le numero de formation
	@param integer : le numero de parcours
	@param integer : le numero de liste
	@param integer : le numero de page
*/
function get_page_tableau_liste_configuration($formation,$parcours,$liste,$page){
	$tab=array();
	$res=get_page_liste_configuration($formation,$parcours,$liste,$page);
	if(VERSION_BASE > VERSION){
		$nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			$tab[]=$row[0];
		}
	}
	else{
		// a suivre
		//echo "coucou";
		$row=pg_fetch_row($res);
		//print_r($row);
		$tab=explode(",",$row[0]);
	}
	return $tab;
}

/**
	Retourne un tableau de parcours avec type d'etape
	@param integer : le numero de formation
	@param varchar : le type d'etape
	
*/
function get_page_parcourss_etape_type($formation,$type){
	$tab=array();
	if(VERSION_BASE > VERSION){
		// recup des etapes ressources de la formation pour en tirer les parcours
		$res=get_formation_etapes_type($formation,$type);
		$nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			if(!in_array($row[6],$tab))
				$tab[]=$row[6];
		}
	}
	else{
		// ancien type
		//$type=get_etape_type_new_old($type);
		switch($type){
			 case 1 :$old_type= "T";break;
			case 2 :$old_type= "F"; break;
			case 3 :$old_type=	 "Z"; break;
			case '4_1' : $old_type= "B"; break;
			case '4_3' : $old_type="L";break;
			case 5 :$old_type=	 "E"; break;
			case 6 :$old_type=	 "S"; break;
			case 7 :$old_type=	 "R"; break;
			case 8 :$old_type=	 "P"; break;
			case 9 :$old_type=	 "I"; break;
			case 10 : $old_type ="O"; break;
		}
		// recup parcours de la formation
		$sql="select distinct g_num_parcours from gestionnaire where g_num_cal=$formation";
		$res=pg_query($sql);
		$parcours=pg_fetch_result($res,0,0); 
		// NOTE : On ne gere que le parcours principal
		// Test si etape ressource
		$sql="select * from gestparcours where g_num_parcours=$parcours and type_etape='$old_type'";
		//echo 
		$res=pg_query($sql);
		if(pg_num_rows($res)>0)
			$tab[]=$parcours;
	}
	return $tab;
}

/**
 * Obtenir la langue à utiliser pour l'affichage d'une page.
 * 
 * La langue retournée est calculée ainsi:
 * On prend la langue de l'individu connecté si elle fait parti de celles de la formation,
 * sinon on prend la langue par défaut de la formation.
 * S'il n'y a pas de formation, on prend la langue par défault de la plateforme.
 * 
 * @param integer $individu L'identifiant de l'individu connecté
 * @param integer $formation L'identifiant de la plate-forme
 * @return integer L'identifiant de la langue à utiliser pour la page.
 */
function get_page_langue($individu=null,$formation=null){
	global $langue_par_defaut,$NIVEAU_DEBUG;
//	$NIVEAU_DEBUG=1;
	//initialisation de la variable
	$page_langue=null;

	//par d�faut, on prend la langue par d�faut de la plate_forme
	$page_langue=pg_fetch_result(get_langue($langue_par_defaut),0,0);
	messageDebug("Langue par d�fault de la plateforme:$page_langue");
	
	if(!empty($individu)){
		
		//recup de la langue de l'individu 
		$individu_langue=pg_fetch_result(get_individu($individu),0,12);
		messageDebug("Langue de l'individu connect�:$individu_langue");
		
		//si il y a  une formation, on prend la langue de l'individu 
		//si elle est dans les langues de la formation.
		if(!empty($formation)){
			//recup des langues de la formation
			$res_formation_langues=get_formation_langues($formation);
			$nb_formation_langues=pg_num_rows($res_formation_langues);
			messageDebug("Nombre de langues detect�es pour la formation $nb_formation_langues :");
			for($i=0;$i<$nb_formation_langues;$i++){
				$formation_langue=pg_fetch_result($res_formation_langues,$i,0);
				messageDebug("Numero :$formation_langue");
				//si la langue de l'individu est dans les langues de la formation, on la conserve
				if($formation_langue==$individu_langue){
					$page_langue_individu=$individu_langue;
					break;
				}
			}
	
			//on prend la langue pr�c�dement trouv�e si elle existe
			if(!empty($page_langue_individu)){
				$page_langue=$page_langue_individu;	
				messageDebug("La langue de l'individu connect� ($page_langue)est bien disponible dans la formation $formation.");
			//sinon on prend la langue par d�faut de la formation	
			}else{
				$page_langue=pg_fetch_result(get_formation($formation),0,5);
				messageDebug("Langue par d�fault de la formation:$page_langue");
				AstairsTemplate::setPageMessage('Votre langue est indisponible',MSG_WARNING);
			}
		}
		//sinon on prends la langue de l'individu
		else{
			$page_langue=$individu_langue;
		}
	}
	
	messageDebug("<b>LANGUE TROUVEE=$page_langue</b>");
	return $page_langue;
}

function get_page_encoding(){
	return CHARSET;
}
?>