<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package page
 * @modulegroup plpgsql
 * @module plpgsql_page
 */

/**
	Obtenir un numero de categoriepage en fonction du code (OLD)
	
	@param char : le code de la categorie de page
	@return integer : le resultat de la requete
*/
function get_page_categorie_old($code){
	$sql="select id from categoriepage where code = '$code';";
    return pg_query($sql);
}
/**
	Obtenir un numero de categoriepage en fonction du code 
	
	@param char : le code de la categorie de page
	@return integer : le resultat de la requete
*/
function get_page_categorie($code){
	if(VERSION_BASE > VERSION){
	
	}
	else
		$res=get_page_categorie_old($code);
	return $res;
}

/**
	Obtenir la configuration d'une page (OLD)
	
	@param integer : le numero de formation
	@param integer : le numero de page
	@param char : le type d'individu
	@return integer :  le resultat de la requete
*/
function get_page_configuration_old($formation,$page,$type){
	 $sql="select * from configpage where num_cal=$formation and num_page=$page and type_user='$type'";
	 //echo "sql=$sql<br>";
	 return pg_query($sql);
}
/**
	Obtenir la configuration d'une page 
	
	@param integer : le numero de formation
	@param integer : le numero de page
	@param char : le type d'individu
	@return integer :  le resultat de la requete
*/
function get_page_configuration($formation,$page,$type){
	if(VERSION_BASE > VERSION){
	
	}
	else
		$res=get_page_configuration_old($formation,$page,$type);
	return $res;
}

/**
--------------------------------------------------------------------------------------------------------------------
23/11/2006
*/

/**
	Obtenir la configuration d'une page d'annuaire (old)
	@param integer : le numero de formation
	@param integer : le numero de page
	@param char : le type d'individu
	@return integer :  le resultat de la requete
*/
function get_page_annuaire_configuration_old($formation,$page,$type){
	$sql="select configuration,num_cal,num_page,type_user  from configpage where num_cal=$formation and num_page=$page and type_user='$type'";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir la configuration d'une page d'annuaire
	@param integer : le numero de formation
	@param integer : le numero de page
	@param integer : le type d'individu
	@return integer :  le resultat de la requete
*/
function get_page_annuaire_configuration($formation,$page,$type){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_annuaire_configuration($formation,$page,$type) 
		as (page_element int4,formation int4,page int4,individu_type int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_page_annuaire_configuration_old($formation,$page,$type);
	return $res;
}

/**
	Obtenir les elements d'une page (old)
	@param integer : le numero de page
	@return integer :  le resultat de la requete
*/
/*
function get_page_elements_old($page){
	$sql="select * from formatpage where num_page=$page";
	$res=pg_query(
}
*/
/**
	Obtenir les elements d'une page 
	@param integer : le numero de page
	@return integer :  le resultat de la requete
*/
function get_page_elements($page){
	 if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_elements($page) as (id int4,libelle varchar,page int4)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_page_elements_old($page);
	 return $res;
}


/**
	Enregistre la configuration de la page d'annuaire  (OLD)
	@param integer : formation
	@param integer : le numero de page
	@param char : type d'individu
	@param array : tableau des elements de la page
	@return integer :  le resultat de la requete
*/
function set_page_annuaire_configuration_old($formation,$page,$type,$tab){
	// tranforme le contenu du tableau en chaine
	$liste_check=implode(",",$tab);
	// test si prsence en base
	$sql="select * from configpage where num_cal=$formation and num_page=$page and type_user='$type'";
	$res=pg_query($sql);
	$num_qcm='NULL';
	if(pg_num_rows($res)==1)
		$sql="update configpage set configuration='$liste_check' where num_cal=$formation and num_page=$page and type_user='$type'";
	else
		$sql="insert into configpage values($formation,$page,'$liste_check',$num_qcm,'$type')";
	// execute la requete
	return pg_query($sql);
	
	
}
/**
	Enregistre la configuration de la page d'annuaire 
	@param integer : formation
	@param integer : le numero de page
	@param char : type d'individu
	@param array : tableau des elements de la page
	@return integer :  le resultat de la requete
*/
function set_page_annuaire_configuration($formation,$page,$type,$tab){
	if(VERSION_BASE > VERSION){
		// on supprime l'ancienne configuration
		del_page_annuaire_configuration($formation,$page,$type);
		if(sizeof($tab)>0){
			$tabpl=int_array_to_plpgsql_array($tab);
			$sql="select * from contraintes.af_set_page_annuaire_configuration($formation,$page,'$type',$tabpl)";
			$res=pg_query($sql);
		}
		else
			$res=0;
	}
	else
		$res=set_page_annuaire_configuration_old($formation,$page,$type,$tab);
	return $res;
}

/**
	Supprime la configuration de la page d'annuaire
	@param integer : formation
	@param integer : page
	@param type : type
	@return integer : le resultat de la requete
*/
function del_page_annuaire_configuration($formation,$page,$type){
	$sql="select * from contraintes.af_del_page_annuaire_configuration($formation,$page,$type)";
	return pg_query($sql);
}

/**
	Obtenir les pages pour un type de page (old)
	@param integer : type de page
	@return integer : le resultat de la requete
*/
function get_page_type_pages_old($type){
	
	$sql="select * from page where categorie=$type";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les pages pour un type de page 
	@param integer : type de page
	@return integer : le resultat de la requete
*/
function get_page_type_pages($type){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_type_pages($type) as (id int4,libelle varchar,type int4,script varchar)";
		$res=pg_query($sql);
	}
	else
		$res=get_page_type_pages_old($type);
	return $res;
}

/**
	Obtenir la configuration d'une page de ressource (old)
	@param integer : formation
	@param integer : page
	@param integer : parcours
	@param integer : etape ressource
	@return integer : le resultat de la requete
*/
function get_page_ressource_configuration_old($formation,$page,$parcours,$etape_ressource){
	$sql="select num_cal,num_page,$parcours,num_qcm,commentaire from commentairepage 
			where num_cal=$formation and num_page=$page and num_qcm=$etape_ressource";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir la configuration d'une page de ressource
	@param integer : formation
	@param integer : page
	@param integer : parcours
	@param integer : etape ressource
	@return integer : le resultat de la requete
*/
function get_page_ressource_configuration($formation,$page,$parcours,$etape_ressource){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_ressource_configuration($formation,$page,$parcours,$etape_ressource) 
				as (formation int4,page int4,parcours int4,etape_ressource int4,commentaire text)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_page_ressource_configuration_old($formation,$page,$parcours,$etape_ressource);
	return $res;
}

/**
	Enregistre la configuration d'une page de ressource (old)
	@param integer : formation
	@param integer : page
	@param integer : parcours
	@param integer : etape ressource
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_ressource_configuration_old($formation,$page,$parcours,$etape_ressource,$commentaire){
	// test si update ou insert
	$sql="select * from commentairepage where num_cal=$formation and num_page=$page and num_qcm=$etape_ressource";
	$res=pg_query($sql);
	if(pg_num_rows($res)==0)
		$sql="insert into commentairepage values($formation,$page,'$commentaire',$etape_ressource,0)";
	else
		$sql="update commentairepage set commentaire='$commentaire' where  num_cal=$formation and num_page=$page and num_qcm=$etape_ressource";
	return pg_query($sql);
}
/**
	Enregistre la configuration d'une page de ressource
	@param integer : formation
	@param integer : page
	@param integer : parcours
	@param integer : etape ressource
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_ressource_configuration($formation,$page,$parcours,$etape_ressource,$commentaire){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_set_page_ressource_configuration($formation,$page,$parcours,$etape_ressource,'$commentaire')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=set_page_ressource_configuration_old($formation,$page,$parcours,$etape_ressource,$commentaire);
	return $res;
}

/**
	Obtenir le commentaire pour une page  (old)
	@param integer : page
	@param integer : formation
	@param integer : stagiaire
	@return integer : le resultat de la requete
*/
function get_page_commentaire_old($page,$formation,$stagiaire){
	$sql="select num_page,num_cal,num_user,commentaire from commentairepage 
			where num_cal=$formation and num_page=$page and num_user=$stagiaire";
	return pg_query($sql);
}
/**
	Obtenir le commentaire pour une page  
	@param integer : page
	@param integer : formation
	@param integer : stagiaire
	@return integer : le resultat de la requete
*/
function get_page_commentaire($page,$formation,$stagiaire){
	 if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_commentaire($page,$formation,$stagiaire) 
				as (page int4,formation int4,stagiaire int4, commentaire text)";
		$res=pg_query($sql);
	 }
	 else
		$res= get_page_commentaire_old($page,$formation,$stagiaire);
	 return $res;
}

/**
	Enregistre le commentaire pour une page (old)
	@param integer : page
	@param integer : formation
	@param integer : stagiaire
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_commentaire_old($page,$formation,$stagiaire,$commentaire){
	$sql="insert into commentairepage (num_cal,num_page,commentaire,num_user) 
			values($formation,$page,'$commentaire',$stagiaire)";
	return pg_query($sql);
}
/**
	Enregistre le commentaire pour une page 
	@param integer : page
	@param integer : formation
	@param integer : stagiaire
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_commentaire($page,$formation,$stagiaire,$commentaire){
	 if(VERSION_BASE > VERSION){
		 $sql="select * from contraintes.af_set_page_commentaire($page,$formation,$stagiaire,'$commentaire')";
		 $res=pg_query($sql);
	 }
	 else
		$res=set_page_commentaire_old($page,$formation,$stagiaire,$commentaire);
	 return $res;
}

/**
	Obtenir la configuration d'une page de liste (old)
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function get_page_liste_configuration_old($formation,$parcours,$liste,$page){
	$sql="select configuration,num_cal,$parcours,num_qcm,num_page from configpage
			where num_cal=$formation and num_page=$page and num_qcm=$liste";
	return pg_query($sql);
}
/**
	Obtenir la configuration d'une page de liste 
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function get_page_liste_configuration($formation,$parcours,$liste,$page){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_liste_configuration($formation,$parcours,$liste,$page) 
				as (page_element int4,formation int4,parcours int4,liste int4,page int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_page_liste_configuration_old($formation,$parcours,$liste,$page);
	return $res;
}

/**
	Obtenir le titre et commentaire pour une page de liste  (old)
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function get_page_liste_old($formation,$parcours,$liste,$page){
	$sql="select t.titre,c.commentaire,$formation,$parcours,$liste,$page from titrepage t,commentairepage c 
			where t.num_cal=$formation and t.num_cal=c.num_cal
			and t.num_page=$page  and t.num_page=c.num_page
			and t.num_qcm=$liste and t.num_qcm=c.num_qcm";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir le titre et commentaire pour une page de liste  
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function get_page_liste($formation,$parcours,$liste,$page){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_page_liste($formation,$parcours,$liste,$page) 
				as (titre varchar,commentaire text,formation int4,parcours int4,liste int4,page int4)";
//				echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_page_liste_old($formation,$parcours,$liste,$page);
	return $res;
}

/**
	Enregistre la configuration d'une page de liste (old)
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@param array : tableau des elements
	@param string : titre
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_liste_configuration_old($formation,$parcours,$liste,$page,$tab,$titre,$commentaire){
	if(sizeof($tab)>0){
		if(!empty($titre)){
			$sql="insert into titrepage (num_cal,num_page,titre,num_qcm) values($formation,$page,'$titre',$liste)";
			$ins=pg_query($sql);
		}
		if(!empty($commentaire)){
			$sql="insert into commentairepage (num_cal,num_page,commentaire,num_qcm) values($formation,$page,'$commentaire',$liste)";
			$ins=pg_query($sql);
		}
		// mise en forme configuration
		$chaine=implode(",",$tab);
		$sql="insert into configpage (num_cal,num_page,configuration,num_qcm) values($formation,$page,'$chaine',$liste)";
		return pg_query($sql);
		
	
	}
	
}
/**
	Enregistre la configuration d'une page de liste 
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@param array : tableau des elements
	@param string : titre
	@param text : commentaire
	@return integer : le resultat de la requete
*/
function set_page_liste_configuration($formation,$parcours,$liste,$page,$tab,$titre,$commentaire){
	 // on supprime l'ancienne configuration
	 del_page_liste_configuration($formation,$parcours,$liste,$page);
	 if(VERSION_BASE > VERSION){
		
		$tabpl=int_array_to_plpgsql_array($tab);
		if(empty($titre))
			$titre="NULL";
		else
			$titre="'$titre'";
		if(empty($commentaire))
			$commentaire="NULL";
		else
			$commentaire="'$commentaire'";
		$sql="select * from contraintes.af_set_page_liste_configuration($formation,$parcours,$liste,$page,$tabpl,$titre,$commentaire)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		$res=set_page_liste_configuration_old($formation,$parcours,$liste,$page,$tab,$titre,$commentaire);
	 return $res;
}

/**
	Supprime la configuration d'une page de liste (old)
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function del_page_liste_configuration_old($formation,$parcours,$liste,$page){
	$sql="delete from configpage where num_cal=$formation and num_page=$page and num_qcm=$liste";
	//echo "sql=$sql<br>";
	$del=pg_query($sql);
	$sql="delete from titrepage where num_cal=$formation and num_page=$page and num_qcm=$liste";
	$del=pg_query($sql);
	$sql="delete from commentairepage where num_cal=$formation and num_page=$page and num_qcm=$liste";
	return pg_query($sql);
}
/**
	Supprime la configuration d'une page de liste
	@param integer : formation
	@param integer : parcours
	@param integer : liste
	@param integer : page
	@return integer : le resultat de la requete
*/
function del_page_liste_configuration($formation,$parcours,$liste,$page){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_del_page_liste_configuration($formation,$parcours,$liste,$page)";
		$res=pg_query($sql);
	}
	else
		$res=del_page_liste_configuration_old($formation,$parcours,$liste,$page);
	return $res;
}
										
?>