<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoParcours.
 * Un DoParcours est l'objet servant  gerer l'avancement des
 * Etapes de type Parcours d'une Formation
 * 
 * @package parcours
 */
class DoParcours extends DoEtape{ //DoElementEntity

	/**
	 * @var object DoNodeFactory Fabrique des objets d'avancement des tapes du parcours
	 */
	var $obj_DoNodeFactory;
	
	var $obj_DoNode;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 */
	function DoParcours($formation, $individu){
		messageDebug("DoParcours::DoParcours($formation, $individu)");
		parent::DoEtape($formation, $individu);
	}
	
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param integer $type Identifiant du type de l'tape courante.
	 * @param object DoEtapeFactory &$obj_DoEtapeFactory Fabrique des objets d'avancement des tapes du parcours
	 */
	function initDoParcours($parcours,$etape, $type,&$obj_DoEtapeFactory){
		messageDebug("DoParcours::initDoParcours($current_parcours,$current_etape, $current_etape_type,&$obj_DoEtapeFactory)");
		if(is_object($obj_DoEtapeFactory)){
			parent::initDoEtape($parcours,$etape, $type);
			$this->obj_DoEtapeFactory=&$obj_DoEtapeFactory;
		}else{
			die("Erreur initDoParcours($parcours,$current_etape, $current_etape_type,$obj_DoEtapeFactory): L'objet ne peut etre initialis.<br>");
		}
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * Charge et commence le parcours et son tape courante.
	 * Cration de l'identifiant rsultat et enregistrement de la date de dbut du parcours et de son tape courante.
	 * @return integer idenfiant rsultat en base de donnes
	 */	
	function beginCurrentEtape(){
		messageDebug("DoParcours::beginCurrentEtape()");
		//if(is_object($this->obj_DoNode)){
			$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
			if(pg_num_rows($res_resultat)==1){
				$row_resultat=pg_fetch_row($res_resultat);
				$id_resultat=$row_resultat[0];
				$fin_resultat=$row_resultat[6];
//				print_rr($row_resultat);
			}
			if(!empty($id_resultat)){
				if(!empty($fin_resultat)){
					die("Erreur DoEtape::beginCurrentEtape(): l'tape a dj t commence et est dj termine.<br/>");
				}else{
					messageDebug("Commence l'etape");
					return $this->obj_DoNode->beginCurrentEtape();
				}
			}else{
				messageDebug("Commence le parcours");			
				$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
				$this->nextEtape();
				return $this->resultat;
				//$this->obj_DoNode->beginCurrentEtape()
			}
			return $this->resultat;
//		}else{
//			 die("Pas d'etape courante pour le parcours.");
//		}
	}

	/**
	 * Construction de l'objet associ  l'tape courante.
	 * La mthode beginCurrentEtape() doit avoir t appelle auparavent.
	 * @return object Etape L'objet correspondant  l'avancement de l'tape 
	 */
	function &performCurrentEtape(){
		messageDebug("DoParcours::performCurrentEtape()");
		return $this->obj_DoNode->performCurrentEtape($this->obj_DoEtapeFactory->getNodeFactory());
	}
	
	/**
	 * Termine l'tape courante et charge l'tape suivante et termine le Parcours si besoin. 
	 * Le parcours est termin s'il n'y a pas d'tape suivante. S'il y en a une, elle est charge.
	 * Enregistre la date de fin de l'tape et detruit les attributs de l'objet inutiles (resultat et obj_node).
	 * @param object ResultatParcours $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succs ou non de la mthode.
	 */
	function endCurrentEtape($obj_resultat=null){
		messageDebug(" DoParcours::endCurrentEtape()");
		
		//si l'tape du parcours est commence
		if($this->obj_DoNode->isBegin()){
			
			//et qu'elle est termine
			if($this->obj_DoNode->isEnd()){
				
				//on passe a l'tape suivante
				$this->nextEtape();
				
			//Si est est pas termine
			}else{
				
				//on la termine
				$res_node=$this->obj_DoNode->endCurrentEtape($obj_resultat);
				if($res_node){
//					unset($this->obj_DoNode);
					//et on passe a l'tape suivante
					$this->nextEtape();
				}
			}
		}else{
			die("DoParcours::endCurrentEtape(): L'tape courante ne peut etre termine car elle n'a pas t commence.</b><br/>");
			return false;
		}
		
		//si le parcours ne contient plus d'tape courante
		if(!is_object($this->obj_DoNode)){
			
			//on termine le parcours
			return parent::endCurrentEtape($obj_resultat);	
		}else{
			messageDebug("DoParcours::endCurrentEtape(): Le parcours ne peut etre termine: Il y a une tape suivante.");
			return false;
		}
	}
	
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Passage  l'tape suivante du parcours.
	 * Initalise l'objet d'avancement de l'tape suivante ou le met  null si pas d'tape suivante.
	 * @return boolean TRUE si il y a une tape suivante, FALSE sinon.
	 */
	function nextEtape(){
		messageDebug("DoParcours::nextEtape()");
		$row_avancement=$this->getAvancement();
		//print_rr( $row_avancement);
		
		//si il y a une etape suivante
		if(!empty($row_avancement[0])){
			
			//et qu'elle est du meme parcours
			if(($row_avancement[0]==$this->node)){
				
				//on la cre.
				$this->obj_DoNode=&$this->obj_DoEtapeFactory->createDoEtape($row_avancement[0],$row_avancement[1],$row_avancement[2]);
				return true;
			}
			/*
			else{
				die ("DoParcours::nextEtape():Changement de parcours dtect.");
				return false;	
			}
			*/
		}
		//si pas d'tape suivante
		else{
			//on nttoie
			unset($this->obj_DoNode);
			return false;
		}
	}
	
	/**
	 * Obtenir l'avancement courant.
	 * L'avancement est calcul pour la formation et l'individu courant, donc l'identifiant du parcours peut changer.
	 * @return array la ligne resultat de requete : (parcours int4, etape int4,type int4, formation int4,individu int4, date_debut timestamp)
	 */
	function getAvancement(){
		messageDebug("DoParcours::getAvancement()");
		$res_avancement=get_resultat_formation($this->getFormation(),$this->getIndividu());
		
		return pg_fetch_row($res_avancement);
	}
			
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir la fabrique permettant la cration des objets d'avancement du Parcours.
	 * @return object DoEtapeFactory La fabrique d'objet d'avancement des Etapes du Parcours.
	 */
	function &getDoEtapeFactory(){
		return $this->obj_DoEtapeFactory;
	}
	
	/**
	 * Obtenir l'objet d'avancement de l'tape courante du Parcours.
	 * @return object DoEtape L'objet d'avancement de l'tape courante du Parcours.
	 */
	function &getCurrentDoEtape(){
		return $this->obj_DoNode;
	}
}
?>
