<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoParcoursDynamique.
 * Un DoParcoursDynamique est un DoParcours possedant une mthode, perform(), qui est appele automatiquement pour commencer le DoParcoursDynamique,
 * et donc effectuer des traitements spcifiques (Dbut d'un ss parcours, calcul d'orientation d'un parcours,etc..)
 * 
 * CLASSE ABSTRAITE
 * 
 * @package parcours
 */
class DoParcoursDynamique extends DoParcours{ 

	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 */
	function DoParcoursDynamique($formation, $individu){
		messageDebug("DoParcoursDynamique::DoParcoursDynamique($formation, $individu)");
		parent::DoParcours($formation, $individu);
	}
	
	function initDoParcoursDynamique($parcours,$etape, $type, &$obj_DoEtapeFactory){
		messageDebug("DoParcoursDynamique::initDoParcoursDynamique($parcours,$etape, $type, &$obj_DoEtapeFactory)");
		parent::initDoParcours($parcours,$etape, $type,$obj_DoEtapeFactory);
	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * METHODE ABSTRAITE
	 * Appele automatiquement par l'objet d'avancement, cette mthode permet d'effectuer des traitements spcifiques 
	 * (Dbut d'un ss parcours, calcul d'orientation d'un parcours,etc..).
	 * Cette mthode doit etre surcharge.
	 * @param object &$obj_elementEntity DoElementEntity L'objet d'avancement 
	 */
	function perform(&$obj_elementEntity){
		messageDebug("DoParcoursDynamique::perform()");
		die("Erreur: Mthode abstraite a surcharger.");
	}
}
?>
