<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de dfinition de la class Parcours
 * @package parcours
*/
class Parcours extends Etape{
	
	
	/**
	 * @var integer Identifiant de la Filire du Parcours.
	 */
	var $filiere;


   /**
   	* @var object Filiere Filiere de la formation
    */
    var $obj_filiere ;
        
	/**
	 * @var integer Dure du Parcours en secondes.
	 */
	var $duree;
	
	/**
	 * Construit un Parcours.
	 * Le Parcours peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Etape
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param integer $type Type d'Etape
	 * @param integer $filiere Identifiant de la Filire du Parcours.
	 * @param integer $duree Dure du Parcours en secondes.
	 */
	function Parcours($id, $libelle="Parcours", $date_creation="27.11.2006",$type=0,$filiere=0, $duree=0){
		messageDebug("Parcours::Parcours($id, $libelle, $date_creation,$type,$filiere, $duree)");
		messageDebug("Parcours::Parcours::func_num_args()=".func_num_args());
		if(func_num_args()==1){
			$res_etape=get_parcours($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[4];
			$filiere=$row_etape[2];
			$duree=$row_etape[3];
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_PARCOURS_ATTACHE);
		$this->initParcours($filiere,$duree);
	}
	
	/**
	 * Initialise les attributs propres au Parcours
	 * @param integer $filiere Identifiant de la Filire du Parcours.
	 * @param integer $duree Dure du Parcours en secondes.
	 */		
	function initParcours($filiere, $duree){
		messageDebug("Parcours::initParcours($filiere, $duree)");
		parent::initEtape();
		if(!empty($filiere)){
			$this->filiere=$filiere;
			$this->duree=$duree;
		}else{
			die("Erreur initParcours(): L'objet ne peut etre initialis.");
		}
	}
	
	/**
	 * Obtenir les Etapes du Parcours.
	 * @return integer le rsultat de la requte (id int4, libelle_alias varchar, libelle_etape varchar, libelle_type_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)
	 */
	function getDuree(){
		return $this->duree;
	}
	
	/**
	 * fonction qui est cense retourner le nom de la filiere du parcours 
	 * @return integer A COMPLETER
	 */
	function getFiliere(){
		return $this->filiere;
	}
	
	
	/**
	 * Fonction qui retourne, en le construisant si besoin, l'objet du Filiere de la Formation
	 * @return object Filiere  Filiere de la Formation
	 */
	 //TODO AJOUTE POUR LES STATS, FAIRE DE MEME AVEC LES AUTRES OBJETS DE STATS A ADAPTER
	function getObjFiliere(){
		if(!is_object($this->obj_filiere)){
			$this->obj_filiere= new Filiere($this->filiere);
		}
		return $this->obj_filiere;
	}
		
	
	/**
	 *Fonction qui retourne les numeros de formation d'un parcours
	 *@param string $ordre: "ASC" ou "DESC" ordre Ascendant ou Descendant
	 *@param string $order_by:  Libelle ou Date_debut
	 *@return string retourne une chaine de caractere contenant la liste des formations d'un parcours.
	 */
	function getFormations($ordre="ASC",$order_by="libelle"){
		return get_parcours_formations($this->id,$ordre,$order_by);
	}
	
	/**
	 * Fonction qui retourne toutee les etapes d'un parcours
	 * @return integer retourne l'identifiant base de donne de l'tape d'un parcours.  (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)
	 */
	function getEtapes(){
		return get_parcours_etapes($this->id);
	}
	
}
?>