<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier de fonctions PHP pour le parcours

	Ce fichier contient les fonctions php utiles au parcours.
	
	@package parcours
	@modulegroup fonctions
*/

/**
 * Fonction qui retourne le temps d'une �valuation
 * @param integer $type 
 * @param integer $numeval
 * @param integer $type_chrono
 */
function tempseval($type, $numeval, $type_chrono = -1) {
	//global $obj_liste;
	// init
	$duree = 0;
	switch ($type) {
		case 'Q' :
			// recup du chrono questionnaire s'il existe
			$req = "select chrono_qstaire from questionnaire where num_qstaire='$numeval' and chrono_qstaire > 0";
			$res = pg_exec($req);
			if (pg_numrows($res) == 1) {
				// recup de la valeur du chrono
				$row = pg_fetch_row($res, 0);
				// debug
				//echo "chrono=$row[0]<br>";
				$req = "select temps from chrono where num_chrono='$row[0]'";
				$res = pg_exec($req);
				$row = pg_fetch_row($res, 0);
				$type_chrono = 1;
				$duree = $row[0];
			} else {
				// debug
				//echo "pas de chono qstaire<br>";
				//recup de la somme des chronos par question
				$req = "select * from elaborqstn where eq_num_qstaire='$numeval'";
				$res = pg_exec($req);
				$nb = pg_numrows($res);
				for ($c = 0; $c < $nb; $c++) {
					$row = pg_fetch_row($res, $c);
					if ($row[2] > 0) {
						$req = "select temps from chrono where num_chrono='$row[2]'";
						$reschrono = pg_exec($req);
						$rowchrono = pg_fetch_row($reschrono, 0);
						$duree += $rowchrono[0];
					} else
						$duree += 60; // 60 secondes par defaut
					$type_chrono = 0;
				}

			}
			break;
		case 'B' :
		case 'C' :
			// debug
			//echo "numeval=$numeval<br>";
			// recup de la valeur du chrono si existe
			$req = "select chrono from serie_exo where id='$numeval'";
			$res = pg_exec($req);
			//$res=get_serie_infos($numeval);
			$row = pg_fetch_row($res, 0);

			// 3 cas possibles >0 =0 et <0
			if ($row[0] == -1) {
				$duree = 0;
				$type_chrono = -1;
			} else
				if ($row[0] > 0) {
					$duree = $row[0];
					$type_chrono = 1;
				} else {
					// recup de la somme des chronos ds asso_exo_serie
					$req = "select sum(chrono) from asso_exo_serie where id_serie='$numeval'";
					$res = pg_exec($req);
					//$res=get_serie_somme_chrono($numeval);
					$row = pg_fetch_row($res, 0);
					$duree = $row[0];
					$type_chrono = 0;
				}

			break;

		case 'L' :
			$obj_liste = new Liste_test($numeval);
			$duree = $obj_liste->getChronoTotal();
			break;
	}
	return $duree;
}

//stockage des etapes dans un tableau (gere les parcours attaches)
function stockage(& $tab, $parc) {
	static $val = 0;
	$tabtype = array ();
	$tabtype[] = 'Q';
	$tabtype[] = 'B';
	//recup des etapes du parcours parc
	$resetape = pg_query("select * from gestparcours where g_num_parcours='$parc' order by num_etape;");
	$nbetape = pg_numrows($resetape);
	for ($i = 0; $i < $nbetape; $i++) {
		$rowetape = pg_fetch_row($resetape, $i);
		// mise � jour des temps d'�tapes �valuation (qcm,remplir les blanc,demoflash)
		if (in_array("$rowetape[2]", $tabtype)) {
			$temps_eval = tempseval($rowetape[2], $rowetape[4]);
			if ($temps_eval == "")
				$temps_eval = 0;
			$req = "update gestparcours set temps_etape='$temps_eval' where g_num_parcours='$parc' and num_etape='$rowetape[1]'";
			//echo "req=$req<br>";
			$maj = pg_exec($req);
		}
		if ($rowetape[7] != 0 && $rowetape[2] == 'T')
			stockage($tab, $rowetape[7], $db);
		//appel recursif
		else {
			for ($j = 0; $j < 11; $j++) {
				if ($j == 0)
					$tab[$val][$j] = $val;
				else {
					$k = $j -1;
					$tab[$val][$j] = $rowetape[$k];
				}
			}
			$tab[$val][11] = $rowetape[8]; //les etapes fin de page
			$tab[$val][12] = $rowetape[10]; // nom_etape
			$tab[$val][13] = $rowetape[11]; // temps de l'�tape
			$val++;
		}
	}
}
// stockage etape suivante et fin page
function gest_etape_suivante(& $tab, & $tab_avance, & $tab_finpage, & $tab_libre) {
	reset($tab);
	$sz = sizeof($tab);
	$first = 1;
	$prev = 0;
	$tab_finpage[] = -1; //init du tableau
	while (list ($cle, $val) = each($tab)) {
		//test si etape fin de page
		end($tab["$cle"]);
		// modif (nom etape) + (temps etape)
		prev($tab["$cle"]);
		prev($tab["$cle"]);
		list ($cl, $vl) = each($tab["$cle"]);
		//debug
		//echo "vl=$vl<br>";
		if ($vl == 1)
			if ($prev == 0)
				$tab_finpage[] = $tab["$cle"][0];
		//recup de l'obligation
		end($tab["$cle"]);
		prev($tab["$cle"]);
		// modif (nom etape + temps etape)
		prev($tab["$cle"]);
		prev($tab["$cle"]);
		list ($cle2, $val2) = each($tab["$cle"]);
		//$num_etape_suivante=$tab["$cle"][1] + 1;
		//test si etape obligatoire
		if ($val2 == 'o') {
			if ($first == 1) {
				$tab_avance[] = $tab["$cle"][0];
				$first = 0;
			}
			$lastcle = $cle;
			// Initialisation de l'�tape suivante
			$num_etape_suivante = $tab["$cle"][0] + 1;
			// Recherche de la prochaine �tape obligatoire
			while (list ($cle3, $val3) = each($tab)) {
				$fincle = $cle3;
				//debug
				//echo "cle3=$cle3<br>";
				end($tab["$cle3"]);
				// modif (nom etape + temps etape)
				prev($tab["$cle3"]);
				prev($tab["$cle3"]);
				list ($cl, $vl) = each($tab["$cle3"]);
				if ($vl == 1)
					$tab_finpage[] = $tab["$cle3"][0];
				end($tab["$cle3"]);
				prev($tab["$cle3"]);
				// modif (nom etape + temps etape)
				prev($tab["$cle3"]);
				prev($tab["$cle3"]);
				list ($cle4, $val4) = each($tab["$cle3"]);
				if ($val4 == 'o') {
					prev($tab);
					$prev = 1;
					$lastcle = $cle3;
					break;
				} else {
					$num_etape_suivante++;
					if ($tab["$cle3"][3] != 'I')
						$tab_libre[] = $tab["$cle3"][0];
				}
			}
			$tab["$cle"][9] = $num_etape_suivante;
			if ($num_etape_suivante < $sz)
				$tab_avance[] = $num_etape_suivante;
		} else {
			$prev = 0;
			if ($tab["$cle"][3] != 'I')
				$tab_libre[] = $tab["$cle"][0];
		}
		//else
		//$tab["$cle"][8]=$num_etape_suivante;
	}
	// Mise � 0 du N� etape suivante de la derni�re etape obligatoire
	$tab["$lastcle"][9] = 0;
	$sz = sizeof($tab_avance);
	$tab_avance[$sz] = 0;
	$sz = sizeof($tab_finpage);
	$fin = $sz -1;
	//debug
	//echo "cle3=$cle3 et cle=$cle lastcle=$lastcle et fincle=$fincle;<br>";
	if ($tab["$fincle"][0] > $tab_finpage[$fin])
		$tab_finpage[] = $tab["$fincle"][0];
}
//stockage des etapes titre
function gest_etape_titre(& $tab, & $tab_titre) {
	reset($tab);
	$first = 1;
	$tab_titre[] = 0;
	while (list ($cle, $val) = each($tab)) {
		if ($tab["$cle"][3] == 'I')
			if ($cle > 0)
				$tab_titre[] = $cle;
	}
}

/******************************************
FONCTION TRAITEMENT PARCOURS
******************************************/
// fonction qui retourne le parcours + ses parcours attach�s (r�cursif) ds un tableau
// param�tres : $parcours $tab
function stock_parc($parcours, & $tab) {
	//balayage des �tapes du parcours
	$req = "select attach_parcours,type_etape from gestparcours where g_num_parcours='$parcours' order by num_etape";
	$res = pg_query($req);
	$nbetape = pg_numrows($res);
	for ($i = 0; $i < $nbetape; $i++) {
		$row = pg_fetch_row($res, $i);
		if ($row[0] > 0 && $row[1] == 'T') {
			$tab[] = $row[0];
			stock_parc($row[0], $tab);
		}
	}

}

// fonction qui calcul le nb de points d'un user pour le parcours courant
// param�tres : $parcours,$num_user,$num_cal
// Note : Pour le moment on ne tient que des QCM
// Plus tard on prendra en compte "Remplir les blancs" "Compr�hension �crite et orale" ...
function calcul_point($parcours, $num_user, $num_cal) {
	// recup des parcours (cas des parcours attach�s)
	$stock_parc = array ();
	$stock_parc[] = $parcours;
	stock_parc($parcours, $stock_parc);
	//debug
	/*
	$sz=sizeof($stock_parc);
	for($p=0;$p<$sz;$p++){
	    echo "$stock_parc[$p] - ";
	}
	echo "<br>";
	*/
	$total_point = 0;
	$nbparc = sizeof($stock_parc);

	for ($p = 0; $p < $nbparc; $p++) {
		//recup ds etapes
		$req = "select result_qstn from gestionqstn where gqstn_num_qstaire in
				        (select num_c_q_e_d from gestparcours where g_num_parcours='$stock_parc[$p]' and type_etape='Q')
				        and gqstn_num_user='$num_user' and num_cal='$num_cal'";
		$res = pg_exec($req);
		$nb = pg_numrows($res);
		//echo "nb=$nb<br>";
		for ($i = 0; $i < $nb; $i++) {
			$row = pg_fetch_row($res, $i);
			$total_point += $row[0];

		}
	}
	// debug
	//if($num_user==110)
	//echo "total_point=$total_point<br>";
	return $total_point;
}
// fonction moyennesur20($score,$max)
// retourne la moyenne sur 20
// donn�es : $score,$max
function moyennesur20($score, $max) {
	if ($max > 0) {
		$moy = ($score * (20 / $max));
		$moy *= 100;
		$moy = round($moy);
		$moy /= 100;
	} else
		$moy = 0;
	return $moy;
}

// fonction calcul moyenne($type)
// calcul la moyenne / 20 pour un type d'�valuation
// donn�e : $type $parcours
function calcul_moyenne($type, $parcours) {
	global $s_numstag, $s_numcal;
	switch ($type) {
		case 'Q' :
			/*
			// recup des qcm du parcours
			$req="select num_c_q_e_d from gestparcours where g_num_parcours='$parcours' and type_etape='Q'";
			$res=pg_exec($req);
			$nbexo=pg_numrows($res);
			*/
			$req = "select sum(result_qstn) as point,sum(total) as pointtotal from gestionqstn where
						            gqstn_num_user='$s_numstag' and num_cal='$s_numcal' and gqstn_num_qstaire in
						            (select num_c_q_e_d from gestparcours where g_num_parcours='$parcours' and type_etape='Q')";
			$res = pg_exec($req);
			$row = pg_fetch_row($res, 0);
			$score = $row[0];
			$max = $row[1];
			$notesur20 = moyennesur20($score, $max);
			// debug
			//echo "notesur20=$notesur20<br>";
			break;
		case 'E' :
			$req = "select sum(score),sum(surtotal) from resexouser where
						            num_user='$s_numstag' and num_cal='$s_numcal' and num_exo in
						            (select num_c_q_e_d from gestparcours where g_num_parcours='$parcours' and type_etape='E')";
			$res = pg_exec($req);
			$row = pg_fetch_row($res, 0);
			$score = $row[0];
			$max = $row[1];
			$notesur20 = moyennesur20($score, $max);
			// debug
			//echo "notesur20=$notesur20<br>";
			break;
		case 'B' :
		case 'C' :
			$req = "select score from res_serie where id_stag=$s_numstag and id_formation=$s_numcal and id_serie in
						                                   (select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and (type_etape='B' or type_etape='C'))";
			$res = pg_query($req);
			$nb = pg_numrows($res);
			$somme = 0;
			for ($i = 0; $i < $nb; $i++) {
				$row = pg_fetch_row($res, $i);
				$somme += $row[0];
			}
			$max = $nb * 20;
			$notesur20 = moyennesur20($somme, $max);

			break;
		case 'D' :
			break;
	}
	return $notesur20;
}

// fonction listeseuil($seuil)
// construit la liste des moyennes par type
// donn�e : seuil (pour les types d'�valuation), parcours
function listeseuil($seuil, $parcours) {
	global $s_numstag, $s_numcal;
	$liste = "";
	// recup des types
	$valseuil = explode(":", $seuil);
	$sz = sizeof($valseuil);
	for ($s = 0; $s < $sz; $s++) {
		$type = substr("$valseuil[$s]", 0, 1);
		$val = calcul_moyenne($type, $parcours);
		if ($s == $sz -1)
			$liste .= $type . $val;
		else
			$liste .= $type . $val . ":";

	}
	return $liste;
}
// fonction superieur(listeseuil,$seuil)
// compare et retourne vrai si listeseuil > seuil
// donn�es : $listeseuil,$seuil
function superieur($listeseuil, $seuil) {
	$sup = true;
	$tabliste = explode(":", $listeseuil);
	$tabseuil = explode(":", $seuil);
	$sz = sizeof($tabliste);
	for ($i = 0; $i < $sz; $i++) {
		if (substr("$tabliste[$i]", 1) > substr("$tabseuil[$i]", 1))
			continue;
		else {
			$sup = false;
			break;
		}

	}
	return $sup;
}

// fonction choix_parcours($parcours)
// retourne le parcours qui sera stock� en fonction du seuil et du score
// donn�es : $tab (contient ts les parcours fini
function choix_parcours($tab) {
	global $s_numstag, $s_numcal;
	// recup des points pour le dernier parcours fini
	$sz = sizeof($tab);
	//echo "sz=$sz<br>";
	$indice = $sz -1;
	$parcours = $tab[$indice];
	//echo "p=$parcours<br>";
	// recup des points du stagiaire
	//$point_user=calcul_point($parcours,$s_numstag,$s_numcal);
	/*----------------------------------------------------------------------------------------*/
	// NOTE du 22-04-2003
	// Il faudra calculer la moyenne sur 20 car le seuil sera ramen� sur 20
	// A SUIVRE ....
	/*----------------------------------------------------------------------------------------*/

	// recup des exo + calcul
	// pour les qcm ( la suite plus tard)
	/*
	$total_point=0;
	$req="select result_qstn from gestionqstn where gqstn_num_qstaire in
	(select num_c_q_e_d from gestparcours where g_num_parcours='$parcours' and type_etape='Q')
	and gqstn_num_user='$s_numstag' and num_cal='$s_numcal'";
	$res=pg_exec($req);
	$nb=pg_numrows($res);
	for($i=0;$i<$nb;$i++){
	   $row=pg_fetch_row($res,$i);
	   $total_point +=$row[0];
	
	}
	*/
	// recup des seuils et sousparcours
	$req = "select * from config_orientation where num_parcours='$parcours'";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	//mise en tableau des seuil et des sous parcours
	$tabseuil = explode(",", $row[1]);
	$tabsousparcours = explode(",", $row[2]);
	//echo "sp0=$tabsousparcours[0] et total=$total_point<br>";
	$nbseuil = sizeof($tabseuil);
	//echo "nbseuil=$nbseuil<br>";
	for ($i = 0; $i < $nbseuil; $i++) {
		// recup du seuil
		$seuil = $tabseuil[$i];
		if (strlen($seuil) > 2) {
			// seuil par type
			// contruction de la liste des moyennes par type du stagiaire
			$listeseuil = listeseuil($seuil, $parcours);
			// debug
			//echo "seuil=$seuil et listeseuil=$listeseuil<br>";
			// si listeseuil > seuil on continue
			if (superieur($listeseuil, $seuil)) {
				// debug
				//echo "superieur<br>";
				continue;
			} else {
				// debug
				//echo "inferieur<br>";
				break;
			}

		} else {
			// seuil global
			// les types
			$tabtype = array ();
			$tabtype[] = 'Q';
			$tabtype[] = 'E';
			$tabtype[] = 'B';
			$tabtype[] = 'C';
			$tabtype[] = 'A';
			$tabtype[] = 'D';
			// recup des types d'�valuation du parcours
			$req = "select distinct type_etape from gestparcours where g_num_parcours='$parcours'";
			$restype = pg_exec($req);
			$nbtype = pg_numrows($restype);
			// calcul de la moyenne globale du stagiaire
			$maxval = 0;
			$compteur = 0;
			for ($t = 0; $t < $nbtype; $t++) {
				$rowtype = pg_fetch_row($restype, $t);
				if (in_array("$rowtype[0]", $tabtype)) {
					$compteur++;
					$val = calcul_moyenne($rowtype[0], $parcours);
					// debug
					//echo "type=$rowtype[0] et val=$val<br>";
					$maxval += $val;
				}
			}
			$moyenne_globale = $maxval / $compteur;
			// debug
			//echo "moyenne globale=$moyenne_globale<br>";
			if ($moyenne_globale > $tabseuil[$i])
				continue;
			else
				break;

		}

	}
	//echo "i=$i<br>";
	//echo "sp=$tabsousparcours[$i]<br>";
	return $tabsousparcours[$i];

}

// fonction qui teste si un parcours est fini
// donn�es recues : $parcours $tab
// $tab contient les parcours
function parcours_fini($tab) {
	global $s_numstag, $s_numcal;
	$fini = 0;
	//echo "stag=$s_numstag et cal=$s_numcal<br>";
	// somme des nb d'etape des parcours
	$nbparc = sizeof($tab);
	$parcours_principal = $tab[0];
	$somme_etape = 0;
	$somme_etape_libre = 0;
	for ($i = 0; $i < $nbparc; $i++) {
		$req = "select * from gestparcours where g_num_parcours='$tab[$i]';";
		$res = pg_exec($req);
		$somme_etape += pg_numrows($res);
		// somme etape libre autre que etape titre
		$req = "select * from gestparcours where g_num_parcours='$tab[$i]' and obligation <>'o' and type_etape <>'I'";
		$res = pg_exec($req);
		$somme_etape_libre += pg_numrows($res);
	}
	//$somme_etape -=$somme_etape_libre;
	//echo "somme_etape=$somme_etape<br>";
	//recup de l'avancement du stagiaire
	$req = "select avancement,etape_libre from gestionparcours where gp_num_user='$s_numstag' and num_cal='$s_numcal';";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	// recup des etapes libres

	$stock = explode(",", $row[1]);
	$nbetape_libre = sizeof($stock) - 1;
	//echo "nbetape_libre=$nbetape_libre et row[0]=$row[0]<br>";
	$avancement = $row[0] + $nbetape_libre;
	//$avancement=$row[0];
	//echo "avancement=$avancement<br>";
	if ($avancement >= $somme_etape) {
		// il faudra tester si les �valuations Exotlc (s'il y en a) ont �t� corrig�es A Suivre ....
		// recup des �tapes exotlc du parcours courant
		$indice = $nbparc -1;
		$parcours_courant = $tab[$indice];
		$req = "select * from gestparcours where g_num_parcours='$parcours_courant' and type_etape='E'";
		$resexo = pg_exec($req);
		$nbexo = pg_num_rows($resexo);
		if ($nbexo == 0)
			$fini = 1;

		else {
			// boucle sur ls exos
			$fini = 1;
			for ($e = 0; $e < $nbexo; $e++) {
				$rowexo = pg_fetch_row($resexo, $e);
				// debug
				//echo "rowexo[4]=$rowexo[4]<br>";
				// test si corrig�
				$req = "select * from resexouser where num_exo='$rowexo[4]' and num_user='$s_numstag' and num_cal='$s_numcal'";
				$restest = pg_exec($req);
				if (pg_numrows($restest) == 0) {
					$fini = 0;
					//echo "break<br>";
					break;
				}
			}
		}
	}
	return $fini;

}

// Fonction stockage_des_parcours($parcours,$num_user,$num_cal)
// Fonction qui renvoie un tableau de parcours
// en fonction de l'�tat d'avancement
// test si le parcours est fini et configur� (orientation)
// donn�es : $parcours $num_user $num_cal
function stockage_des_parcours($parcours, & $tab) {
	global $s_numstag, $s_numcal;
	reset($tab);
	//echo "tab[0]=$tab[0]<br>";

	// test si configuration (orientation)
	$req = "select * from config_orientation where num_parcours='$parcours';";
	$res = pg_exec($req);
	if (pg_numrows($res) == 1) {
		// test si le parcours courant est fini
		// note : le parcours courant est le dernier stock� ds $tab
		if (parcours_fini($tab)) {
			//echo "fini<br>";
			// recup seuil et sousparcours
			$row = pg_fetch_row($res, 0);
			// choix du sousparcours en fonction du score
			$sousparcours = choix_parcours($tab);
			//echo "sousparcours=$sousparcours<br>";
			$tab[] = $sousparcours;
			//debug
			/*
			$sz=sizeof($tab);
			for($i=0;$i<$sz;$i++)
			    //echo "$tab[$i] - ";
			echo "<br>";
			*/
			stockage_des_parcours($sousparcours, $tab);

		} else {
			// parcours configur� mais pas fini ou pas fait
			//echo "pas fini<br>";

		}

	} else {
		// le parcours n'est pas configur�
	}
}

function stockage_tous_parcours($parcours, & $tab) {
	global $s_numcal;
	//reset($tab);
	//echo "tab[0]=$tab[0]<br>";

	// test si configuration (orientation)
	$req = "select * from config_orientation where num_parcours='$parcours';";
	$res = pg_exec($req);
	if (pg_numrows($res) == 1) {
		// recup seuil et sousparcours
		$row = pg_fetch_row($res, 0);
		//recup du nombre de sous parcours
		$sousparcours = explode(",", $row[2]);
		$nbsousparcours = sizeof($sousparcours);
		for ($i = 0; $i < $nbsousparcours; $i++) {
			$tab[] = $sousparcours[$i];
			//echo "sousparcpurs[$i]=$sousparcours[$i]";
			stockage_tous_parcours($sousparcours[$i], $tab);

		}

		//debug
		/*
		$sz=sizeof($tab);
		for($i=0;$i<$sz;$i++)
		    //echo "$tab[$i] - ";
		echo "<br>";
		*/

	} else {
		// le parcours n'est pas configur�
	}
}

// fonction qui retourne le n� de parcours courant en fonction du n� d'etape
// Donn�es re�ues : $stock_parcours $num_etape
function parcours_courant($tab, $numetape) {

	$sz = sizeof($tab);
	$somme_etape = 0;
	for ($i = 0; $i < $sz; $i++) {
		$req = "select * from gestparcours where g_num_parcours='$tab[$i]'";
		$res = pg_exec($req);
		$somme_etape += pg_numrows($res);
		if ($numetape <= $somme_etape)
			break;
	}
	return $tab[$i];

}

// fonction qui retourne un tableau de heure minute et seconde
// donn�e re�ue : $nbseconde
function conversion($nbseconde, $tab) {
	print("La fonction conversion($nbseconde, $tab) est d�pr�ci�e.<br> utiliser function get_hms($nb_seconde) ");
	// nb heure
	$h = floor($nbseconde / 3600);
	// les minute
	$m = floor(($nbseconde - ($h * 3600)) / 60);
	// les seconde
	$s = $nbseconde - ($h * 3600) - ($m * 60);
	$tab[] = $h;
	$tab[] = $m;
	$tab[] = $s;
	return $tab;
}

// fonction qui retourne la dur�e d'un parcours
// donn�e re�ue : $parcours (n� de parcours)
/*------------------------------------------// NOTE : Prendre en compte les parcours attach�s !!!! */
// A SUIVRE ....
function dureeparcours($parcours, $duree = 0) {
	global $obj_liste;
	//init
	//$duree=0;
	$tabeval = array ();
	$tabeval[] = 'Q';
	$tabeval[] = 'B';
	$tabeval[] = 'D';
	$tabeval[] = 'L';
	$tabeval[] = 'C';
	// balayage des �tapes du parcours
	$req = "select * from gestparcours where g_num_parcours='$parcours' order by num_etape";
	$res = pg_exec($req);
	// pour plus tard
	//$res=get_parcours_etapes($parcours);
	$nbetape = pg_numrows($res);
	for ($e = 0; $e < $nbetape; $e++) {
		$temps_eval = 0;
		$row = pg_fetch_row($res, $e);
		if ($row[2] != 'I') {
			if ($row[7] != 0 && $row[2] == 'T')
				$duree = dureeparcours($row[7], $duree);
			else {
				if (in_array("$row[2]", $tabeval)) {
					// on regarde si l'evaluation est chronom�tr�e
					$temps_eval = tempseval($row[2], $row[4]);
					if ($temps_eval > 0)
						$duree += $temps_eval;
					else
						$duree += $row[11];
				} else
					$duree += $row[11];

			}
		}
	}

	return $duree;

}

// fonction qui retourne l'avancement total (etapes obligatoires + libres)
function avancement_total() {
	global $s_numstag, $s_numcal;
	$req = "select avancement,etape_libre from gestionparcours where gp_num_user='$s_numstag' and num_cal='$s_numcal';";
	$res = pg_exec($req);
	$row = pg_fetch_row($res, 0);
	// recup des etapes libres

	$stock = explode(",", $row[1]);
	$nbetape_libre = sizeof($stock) - 1;
	//echo "nbetape_libre=$nbetape_libre et row[0]=$row[0]<br>";
	$avancement = $row[0] + $nbetape_libre;
	return $avancement;
}

// fonction qui retourne la page ou se trouve le stagiaire
function page_stagiaire($num_stag, $typ) {
	global $chemin_bo;
	$page = "";
	switch ($typ) {
		case 'B' :
		case 'C' :
			$chaine = "do_serie_test.php";
			break;
		case 'Q' :
		case 'A' :
			$chaine = "testext.php3";
			break;
	}
	// M�thode : ouverture du fichier session du stagiaire et lecture du nom de la page courante
	// recup identifiant de session du stagiaire
	$sql = "select session from session where num_user=$num_stag";
	$res = pg_query($sql);
	if (pg_numrows($res) == 1) {
		$row = pg_fetch_row($res, 0);
		$id_session = $row[0];
		$fich_session = "sess_$id_session";
		$session_svg = session_save_path();
		// ouverture du fichier et recherche de la chaine "s_page"

		$fp = fopen("$session_svg/$fich_session", "r+");
		while (!feof($fp)) {
			$buffer = fgets($fp, 4096);
			if (strstr($buffer, $chaine)) {
				$page = $chaine;
			}

		}

	}
	return $page;

}
/*------------------------------------------------------------------*/
// fonction qui retourne le nombre d'�tape effectu�es
function etape_effectue($tab, $tps = 0) {
	global $s_numstag, $s_num_premiere_etape, $s_numcal, $s_groupe, $s_numparc, $s_liste_avance;
	// recup de l'avancement + etapes libres
	$req = "select avancement,etape_libre from gestionparcours
		                where gp_num_parcours='$s_numparc'
		                and gp_num_groupe='$s_groupe'
		                and gp_num_user=$s_numstag
		                and num_cal='$s_numcal';";
	$res = pg_query($req);
	$row = pg_fetch_row($res, 0);
	$avancement = $row[0];
	// on recup�re les etapes obligatoire
	$etape_obligatoire = 0;
	for ($i = 0; $i < $avancement; $i++) {
		if ($tab[$i][10] == 'o')
			$etape_obligatoire++;
	}
	/*
	if($s_num_premiere_etape==0){
	    //echo "coucou<br>";
	    $avancement =$avancement -1;
	}
	*/
	//echo "row[1]=$row[1]<br>";
	if (strlen($row[1]) == 1) {
		//echo "coucou<br>";
		$nb_etape_libre = 0;
	} else {
		$tab_libre = explode(",", $row[1]);
		$nb_etape_libre = sizeof($tab_libre) - 1;

		//echo "nb_etape_libre= $nb_etape_libre<br>";
		// temps effectue pour les etapes libre
		$tps = 0;
		for ($i = 1; $i <= $nb_etape_libre; $i++) {
			$numero_etape = substr("$tab_libre[$i]", 1);
			//echo "num=$numero_etape<br>";
			$tps += $tab[$numero_etape][13];
		}
	}
	// temps effectue pour les etape obligatoires

	return ($etape_obligatoire + $nb_etape_libre);

}

// fonction qui met a jour l'avancement en cas de blocage (prend en compte les �tapes titres juste apr�s l'�tape courante)
function maj_avancement($avance) {
	global $s_numuser, $s_numcal;
	global $stock_avance;
	reset($stock_avance);
	$cpt = 1;
	$i = $avance;

	while (!in_array(++ $i, $stock_avance))
		//while(!in_array($i++ , $stock_avance))
		{
		$cpt++;
	}

	// $req="update gestionparcours set avancement=avancement + 1 where gp_num_user=$s_numuser and num_cal=$s_numcal";
	$req = "update gestionparcours set avancement=avancement + $cpt where gp_num_user=$s_numuser and num_cal=$s_numcal";
	$maj = pg_query($req);

	/*
	// Traitement r�cursif si �tape suivante est une �tape titre
	if(in_array($avance+1,$stock_etape_titre))
	    $avance += maj_avancement($avance) ;
	*/

	return ($avance + $cpt);

}

// fonction qui retourne le n� du test correspondant � une serie
function numero_test($serie, $parcours, $liste) {

	print ("Fonction d�pr�ci�e: utiliser get_positionnement_serie_numero_positionnement_parcours_old($serie,$liste,$parcours)<br>");
	// les numero de serie dans un tableau
	//echo "liste=$liste et parc=$parcours<br>";
	$sql = "select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and attach_parcours=$liste order by num_etape";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_serie = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_serie[] = $row[0];
	}
	// les n� de test dans un tableau
	$sql = "select id_test from asso_liste_test where id_liste_test=$liste order by ordre";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_test = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_test[] = $row[0];
	}
	// debug
	// recup index de la serie
	reset($tab_serie);
	while (list ($cle, $val) = each($tab_serie)) {
		// debug
		//echo "cle=$cle et val=$val et serie=$serie<br>";
		if ($val == $serie)
			break;
	}
	return $tab_test[$cle];

}

// fonction qui retourne le n� d'une serie  correspondant � un test
function numero_serie($test, $parcours, $liste) {

	print ("Fonction d�pr�ci�e: utiliser get_positionnement_numero_serie_parcours_old($positionnnement,$liste,$parcours)<br>");
	// les numero de serie dans un tableau
	//echo "liste=$liste et parc=$parcours<br>";
	$sql = "select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and attach_parcours=$liste order by num_etape";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_serie = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_serie[] = $row[0];
	}
	// les n� de test dans un tableau
	$sql = "select id_test from asso_liste_test where id_liste_test=$liste order by ordre";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_test = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_test[] = $row[0];
	}
	// debug
	// recup index du test
	reset($tab_test);
	while (list ($cle, $val) = each($tab_test)) {
		// debug
		//echo "cle=$cle et val=$val et serie=$serie<br>";
		if ($val == $test)
			break;
	}
	return $tab_serie[$cle];

}

/******************************************
FONCTIONS AFFICHAGE
******************************************/

// tableau des couleurs des lignes du parcours
// lignes paires
$tab_couleur[0] = "#E7E7E7";
$tab_couleur[1] = "#CECFCE";

//*****************************************
//ICONE POUR AFFICHAGE LIBRE OU OBLIGATOIRE
function afflibre($couleur, $texte) {
	global $MSG_127;

	print ("
		<TR bgcolor=$couleur>
		<TD>
		<IMG  class=\"etape_libre\" src=\"data/images/icoaster.gif\" ALT=\"$MSG_127\" TITLE=\"$MSG_127\" /></TD>
		");
}

function affoblige($couleur, $texte) {
	global $MSG_126;

	print ("
		<TR bgcolor=$couleur>
		<TD>
		<IMG class=\"etape_obligatoire\" src=\"data/images/icoblige.gif\" ALT=\"$MSG_126\" TITLE=\"$MSG_126\" /></TD>
		");
}

//***********************************
//AFFICHAGE DU THEME / ICONE + TEXTE
function afftheme($couleur) {
	global $MSG_115;
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icotheme.gif\" ALT=\"$MSG_115\" TITLE=\"$MSG_115\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$MSG_115</DIV></TD>
		");
}

function affcours($couleur) {
	global $MSG_541;
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icocours.gif\" ALT=\"$MSG_541\" TITLE=\"$MSG_541\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$MSG_541</DIV></TD>
		");
}

function affchapitre($couleur) {
	global $MSG_920;
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icochap.gif\" ALT=\" $MSG_920\" TITLE=\"$MSG_920\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\"> $MSG_920</DIV></TD>
		");
}

function affmodule($couleur) {
	global $MSG_921;
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icomodule.gif\" ALT=\" $MSG_921\" TITLE=\"$MSG_921\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\"> $MSG_921</DIV></TD>
		");
}

function affscenario($couleur, $texte) {
	global $MSG_922;
	if ($texte == "")
		$texte = $MSG_922;

	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icoscenar.gif\" ALT=\"$texte_alt\"  TITLE=\"$texte_alt\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");

}

function affqcm($couleur, $texte) {
	global $MSG_288, $MSG_547;
	if ($texte == "")
		$texte = $MSG_547;

	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icoqcm.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");
}

function affblanc($couleur, $texte, $exo, $attache) {
	global $MSG_288, $MSG_1201, $MSG_547, $MSG_1483, $MSG_1267;
	//global $obj_liste;
	global $val0;
	global $s_numstag, $s_numcal;

	// note sur l'icone � afficher pour la s�rie
	// 1 - si la serie est monoexo alors icone de l'exo
	// 2 - si la serie est multiexo alors icone serie
	// debug
	//echo "texte=$texte<br>";
	// recup type_exo en fonction de l'al�atoire

	if ($attache == 0)
		$aleatoire = test_serie_aleatoire($exo, $mode_aleatoire);
	else
		$aleatoire = 0;

	if ($aleatoire == 1 && $mode_aleatoire > 0 && $mode_aleatoire != 3) {
		$sql = "SELECT DISTINCT nbexo_par_type, num_serie FROM serie_aleatoire WHERE num_serie=$exo";
		$res = pg_query($sql);

		// Ceci est faux il peut y avoir plusieurs lignes du type f:5 f:3 f:5 > type = remplir les blancs et non pas s�rie multitype
		/*
		if(pg_numrows($res)>1)
		        $type_serie=2;
		else
		{
		        $row=pg_fetch_row($res,0);  //ex : f:4,q:3,s2 ou q4 ...
		        $tab=explode(",",$row[0]);
		        if(count($tab)>1)
		                $type_serie=2;
		        else
		        {
		                $type_serie=1;
		                $type_icone=substr($tab[0],0,1);
		        }
		}
		*/

		$continue = 1;
		$temp = "";

		// $debug = "serie=$exo<br>";

		// On parcours les lignes d'enregistrement
		while (($row = pg_fetch_array($res)) && $continue) {
			// On scinde le tableau
			$tab = explode(",", $row['nbexo_par_type']);

			// S'il y a plus d'un type on arr�te
			if (count($tab) > 1) {
				$continue = 0;
			}
			// Autrement on compare avec le type pr�c�dent
			else {
				// Si temp n'est pas valu�, il n'y a pas de type pr�c�dent
				if ($temp == "")
					$temp = substr($tab[0], 0, 1);
				else
					// On continue la boucle si le caract�re de type est le m�me que le pr�c�dent
					if ($continue = ($temp == substr($tab[0], 0, 1)))
						$temp = substr($tab[0], 0, 1);
			}
		}

		// On sait maintenant s'il n'y avait qu'un seul type ou plusieurs
		if (!$continue)
			$type_serie = 2;
		else {
			$type_serie = 1;
			$type_icone = substr($tab[0], 0, 1);
		}

		// $debug .= "continue=$continue & $type_serie & $type_icone" ;
	} else {

		if ($attache == 0 || $attache == "")
			$sql = "select distinct type_exo from asso_exo_serie where id_serie=$exo";
		else
			$sql = "select distinct type_exo from asso_exo_serie_aleatoire where id_serie=$exo and num_user=$s_numstag and num_cal=$s_numcal";
		$res = pg_query($sql);
		$nb = pg_numrows($res);
		if ($nb > 1 || $nb == 0) {
			$type_serie = 2;
			if ($nb == 2) {
				// il faut verifier que les deux types ne sont pas de la m�me famille
				// (q,m) =>qcm et (s,o) =>sondage
				$res1 = pg_result($res, 0, 0);
				$res2 = pg_result($res, 1, 0);
				if (($res1 == 'q' && ($res2 == 'm' || $res2 == 's' || $res2 == 'o')) || ($res1 == 'm' && ($res2 == 'q' || $res2 == 's' || $res2 == 'o'))) {

					$type_serie = 1;
					$type_icone = 'q';
				} else
					if ((pg_result($res, 0, 0) == 's' && pg_result($res, 1, 0) == 'o') || (pg_result($res, 0, 0) == 'o' && pg_result($res, 1, 0) == 's')) {
						$type_serie = 1;
						$type_icone = 's';
					} else
						$type_serie = 2;
			}

		} else {
			$type_serie = 1;

			$row = pg_fetch_row($res, 0);
			$type_icone = $row[0];

		}
		/*
		else {
		    // La serie d�pend de l'�tape L (liste) et du test
		    // recup des type d'exo de la serie
		    // debug
		    //echo "exo=$exo et parc=$val0 et attache=$attache<br>";
		    //$exo=950;
		    // n� exo du test correspondant � la serie
		    $exo=numero_test($exo,$val0,$attache);
		     //echo "exo=$exo<br>";
		    $sql="select distinct type_exercice from test_rep_nbexogen where id_test=$exo";
		    $res=pg_query($sql);
		     if(pg_numrows($res)>1)
		            $type_serie=2;
		     else {
		        $type_serie=1;
		        $row=pg_fetch_row($res,0);
		        $type_icone=$row[0];
		     }
		
		
		}
		*/
	}

	//debug
	//echo "type_icone=$type_icone<br>";
	if ($type_serie == 2) {
		$icone = "icoserie.gif";
		if ($texte == "")
			$texte = $MSG_1267;
	} else
		switch ($type_icone) {
			case 'f' :
				$icone = "icoremplir.gif";
				if ($texte == "")
					$texte = $MSG_1201;
				break;
			case 'm' :
			case 'q' :
				$icone = "icoqcm.gif";
				if ($texte == "")
					$texte = $MSG_547;
				break;
			case 'o' :
			case 's' :
				$icone = "icosonde.gif";
				if ($texte == "")
					$texte = $MSG_1483;
				break;
			case 'd' :
				$icone = "icodrag.gif";
				if ($texte == "")
					$texte = "drag & drop";
				break;
		}
	$texte_alt = strip_tags($texte);

	print ("
		        <TD bgColor=$couleur>
		        <IMG class=\"icone_theme\" src=\"data/images/$icone\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
				<TD class=\"taille_titre_theme\" bgColor=$couleur>
		        <DIV class=\"texte_titre_theme\">$texte $debug</DIV></TD>
		        ");
}

function affexotlc($couleur, $texte) {
	global $MSG_776;
	if ($texte == "")
		$texte = $MSG_776;
	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/icotlc.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");
}

function afforum($couleur, $texte) {
	global $MSG_926;
	if ($texte == "")
		$texte = $MSG_926;
	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/iconeforum.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		<TD  class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");
}

function affchat($couleur, $texte) {
	global $MSG_928;
	if ($texte == "")
		$texte = $MSG_928;
	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/iconechat.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");
}

function affressources($couleur, $texte) {
	global $MSG_927;
	if ($texte == "")
		$texte = $MSG_927;
	$texte_alt = strip_tags($texte);
	print ("
		<TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/iconeressources.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		<TD class=\"taille_titre_theme\" bgColor=$couleur>
		<DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		");
}

// Liste de positionnement
function affliste($couleur, $texte, $exo) {
	global $MSG_1274;
	if ($texte == "")
		$texte = $MSG_1274;
	$texte_alt = strip_tags($texte);
	// determine l'icone en fonction du type de l'exo
	//echo "exo=$exo<br>";
	$sql = "select distinct type_test from test where id_test in (select id_test from asso_liste_test where id_liste_test=$exo)";
	$res = pg_query($sql);
	if (pg_numrows($res) > 1)
		$icone = "icoserie.gif";
	else {
		$row = pg_fetch_row($res, 0);
		//echo "row[0]=$row[0]<br>";
		switch ($row[0]) {
			case 'o' :
			case 's' :
				$icone = "icosonde.gif";
				break;
			case 'm' :
			case 'q' :
				$icone = "icoqcm.gif";
				break;
			default :
				$icone = "icoserie.gif";
				break;

		}
	}
	print ("
		    <TD bgColor=$couleur>
			<IMG  class=\"icone_theme\" src=\"data/images/$icone\" ALT=\"$texte_alt\" TITLE\"$texte_alt\" /></TD>
		    <TD class=\"taille_titre_theme\" bgColor=$couleur>
		    <DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		    ");
}

// Contenu SCORM
function affscorm($couleur, $texte) {
	if ($texte == "")
		$texte = "Scorm";
	$texte_alt = strip_tags($texte);
	print ("
		    <TD bgColor=$couleur>
		<IMG class=\"icone_theme\" src=\"data/images/scorm.gif\" ALT=\"$texte_alt\" TITLE=\"$texte_alt\" /></TD>
		    <TD class=\"taille_titre_theme\" bgColor=$couleur>
		    <DIV class=\"texte_titre_theme\">$texte</DIV></TD>
		    ");
}
//*******************************
//LIENS ET TEXTES VERS LES ETAPES

//function afflien($str,$etap,$couleur,$val_etape,$liste_avance,$p_courant,$nbetape){
function afflien($str, $etap, $couleur, $val_etape, $obligation, $p_courant, $nbetape, $indicateur = 0) {
	// test indicateur d'�tape

	$deb = "";
	$fin = "";
	$img = "";
	if ($indicateur == 1) {
		$deb = "<b>";
		$fin = "</b>";
		$img = "<img src=\"./images/petiteflech_droite.gif\">";
	}

	print ("
		<TD class=\"taille_titre_lien_etape\">
		<DIV class=\"texte_titre_lien_etape\">$img
		<a href=\"scenario/scenario.php3?numetape=$etap&val_etape=$val_etape&obligation=$obligation&parcours_courant=$p_courant&nbetape=$nbetape\">
		$deb $str $fin</a>
		</DIV></TD>
		");
}

//function afflienressource($str,$etap,$couleur,$liste_avance,$parcours){
function afflienressource($str, $etap, $couleur, $obligation, $parcours, $indicateur = 0) {
	//On teste si la personne a le droit d'acceder aux ressources
	global $s_tabDroits, $MSG_1199, $MSG_1515;
	if (!in_array("Acces Ressources", $s_tabDroits)) {
		print ("
				     	 <TD class=\"taille_titre_etape\">
				         <DIV class=\"texte_titre_etape\">$MSG_1199 <DIV class=\"texte_titre_etape_nondispo\">($MSG_1515)</DIV>
				         </DIV></TD>
				");
	} else {
		// test indicateur d'�tape

		$deb = "";
		$fin = "";
		$img = "";
		if ($indicateur == 1) {
			$deb = "<b>";
			$fin = "</b>";
			$img = "<img src=\"./images/petiteflech_droite.gif\">";
		}
		print ("
				  <TD class=\"taille_titre_lien_etape\">
				<DIV class=\"texte_titre_lien_etape\">$img
				<a href=\"ressource/index.php3?numetape=$etap&obligation=$obligation&parcours=$parcours\">$deb $str $fin</a>
				</DIV></TD>
				");
	}
}

//function afflienforum($str,$etap,$couleur,$liste_avance){
function afflienforum($str, $etap, $couleur, $obligation, $indicateur = 0) {
	//On teste si la personne a le droit d'acceder au forum

	global $s_tabDroits, $MSG_1199, $MSG_1515;

	if (!in_array("Acc�s Forum", $s_tabDroits)) {
		print ("
				      <TD class=\"taille_titre_etape\">
				<DIV class=\"texte_titre_etape\">$MSG_1199 <DIV class=\"texte_titre_etape_nondispo\">($MSG_1515)</DIV></DIV></TD>");
	} else {
		// test indicateur d'�tape

		$deb = "";
		$fin = "";
		$img = "";
		if ($indicateur == 1) {
			$deb = "<b>";
			$fin = "</b>";
			$img = "<img src=\"./images/petiteflech_droite.gif\">";
		}
		print ("
				    <TD class=\"taille_titre_lien_etape\">
				    <DIV class=\"texte_titre_lien_etape\">$img
				    <a href=\"forum/index.php?numetape=$etap&obligation=$obligation\">$deb $str $fin</a>
				    </DIV></TD>");
	}
}

//function afflienchat($str,$etap,$couleur,$liste_avance,$path){
function afflienchat($str, $etap, $couleur, $obligation, $path, $indicateur = 0) {

	global $s_tabDroits, $MSG_1046, $MSG_1199, $MSG_1515;

	if (in_array("Acc�s Chat", $s_tabDroits)) {
		// test indicateur d'�tape

		$deb = "";
		$fin = "";
		$img = "";
		if ($indicateur == 1) {
			$deb = "<b>";
			$fin = "</b>";
			$img = "<img src=\"./images/petiteflech_droite.gif\">";
		}
		print ("
				<TD class=\"taille_titre_lien_etape\">
				<DIV class=\"texte_titre_lien_etape\">$img
				<a href=# onClick=\"window.open('$path/chat/index.php3?numetape=$etap&obligation=$obligation','Chat','width=850,height=600,menubar=no,status=no,scrollbars=yes');\">
				$deb $str $fin</a>
				</DIV></TD>
				");
	} else {

		print ("
				        <TD class=\"taille_titre_etape\">
				<DIV class=\"texte_titre_etape\">$MSG_1199 <DIV class=\"texte_titre_etape_nondispo\">($MSG_1515)</DIV></DIV>
				</TD>
				");
	}
}

function afftexte($str, $couleur) {
	print ("
		<TD class=\"taille_titre_etape\">
		<DIV class=\"texte_titre_etape\">$str </DIV></TD>
		");
}

//function afflienqcm($qcm,$str,$rien,$couleur,$liste_avance){
function afflienqcm($qcm, $str, $rien, $couleur, $obligation) {
	print ("
		<TD class=\"taille_titre_lien_etape\">
		<DIV class=\"texte_titre_lien_etape\">
		<a href=\"tests/intermediaire_test.php3?num_qstaire=$qcm&obligation=$obligation\">$str</a>
		</DIV></TD>
		");
}

function affqcmtexte($str, $couleur) {
	print ("
		<TD class=\"taille_titre_etape\">
		<DIV class=\"texte_titre_etape\">$str</DIV></TD>
		");
}

//function afflienblanc($blanc,$str,$rien,$couleur,$liste_avance){
function afflienblanc($blanc, $str, $rien, $couleur, $obligation, $indicateur = 0) {
	// test indicateur d'�tape

	$deb = "";
	$fin = "";
	$img = "";
	if ($indicateur == 1) {
		$deb = "<b>";
		$fin = "</b>";
		$img = "<img src=\"./images/petiteflech_droite.gif\">";
	}
	print ("
		  <TD class=\"taille_titre_lien_etape\">
		
		<DIV class=\"texte_titre_lien_etape\">$img
		
		
		<a href=\"serie/avant_serie.php?id_serie=$blanc&obligation=$obligation\">$deb $str $fin</a>
		</DIV></TD>
		");
}
function affblanctexte($str, $couleur) {
	print ("
		   <TD class=\"taille_titre_etape\">
		<DIV class=\"texte_titre_etape\">$str</DIV></TD>
		");
}

// Type L (test de positionnement)
function afflienliste($liste, $str, $rien, $couleur, $obligation, $indicateur = 0) {
	// test indicateur d'�tape

	$deb = "";
	$fin = "";
	$img = "";
	if ($indicateur == 1) {
		$deb = "<b>";
		$fin = "</b>";
		$img = "<img src=\"./images/petiteflech_droite.gif\">";
	}
	print ("
		    <TD class=\"taille_titre_lien_etape\">
		    <DIV class=\"texte_titre_lien_etape\">$img
		    <a href=\"liste/avant_liste.php?id_liste=$liste&obligation=$obligation\">$deb $str $fin</a>
		    </DIV></TD>
		");
}
function afflistetexte($str, $couleur) {
	print ("
		    <TD class=\"taille_titre_etape\">
		    <DIV class=\"texte_titre_etape\">$str</DIV></TD>
		    ");
}
//function afflienexotlc($exo,$str,$dif,$couleur,$liste_avance,$etape){
function afflienexotlc($exo, $str, $dif, $couleur, $obligation, $etape, $indicateur = 0) {
	// test indicateur d'�tape

	$deb = "";
	$fin = "";
	$img = "";
	if ($indicateur == 1) {
		$deb = "<b>";
		$fin = "</b>";
		$img = "<img src=\"./images/petiteflech_droite.gif\">";
	}
	print ("
		<TD class=\"taille_titre_lien_etape\">
		<DIV class=\"texte_titre_lien_etape\">$img
		<a href=\"exostlc/index.php3?numexo=$exo&dif=$dif&obligation=$obligation&numetape=$etape\">$deb $str $fin</a>
		</DIV></TD>
		");
}

/*
Fonction : afflienexotlc_formateur

auteur: R�mi Cocquet

Cette fonction permet d'afficher le lien vers l'enonc� de l'exercice � telecharger pour les formateurs.
Celui - ci est diff�rent de celui des stagiaires car il doit ne permettre aucune modification --> consulation uniquement
*/
function afflienexotlc_formateur($exo, $str, $dif, $couleur, $obligation, $etape) {
	print ("
		<TD class=\"taille_titre_lien_etape\">
		<DIV class=\"texte_titre_lien_etape\">
		<a href=\"exostlc/index.php3?numexo=$exo&dif=$dif&obligation=$obligation&numetape=$etape\">$str</a>
		</DIV></TD>
		");
}

function affexotlctexte($str, $couleur) {
	print ("
		<TD class=\"taille_titre_etape\">
		<DIV class=\"texte_titre_etape\">$str</DIV></TD>
		");
}
function affiche_rien($texte, $couleur) {
	print ("
		<TD class=\"taille_titre_etape\">
		<DIV class=\"texte_titre_etape\">$texte</DIV></TD>
		");
}

// fonction qui affiche le lien pour contenu scorm
function afflienscorm($scorm, $str, $etape, $couleur, $obligation, $indicateur = 0) {
	$deb = "";
	$fin = "";
	$img = "";
	if ($indicateur == 1) {
		$deb = "<b>";
		$fin = "</b>";
		$img = "<img src=\"./images/petiteflech_droite.gif\">";
	}
	print ("
			<TD class=\"taille_titre_lien_etape\">
		    <DIV class=\"texte_titre_lien_etape\">$img
		    <a href=\"./scorm/affiche_scorm.php?num_paquet=$scorm&nompaquet=$str&obligation=$obligation&numetape=$etape\">$deb $str $fin</a>
		    </DIV></TD>
		    ");

}
//************************************
//LES DEUX DERNIERE COLONNES (Suivi + Corrige)
// NOTE : LES 3 DERNIERES ==> Suivi Dur�e Corrig�

function affnontraite($couleur, $duree, $typ = '') {
	global $MSG_1068;

	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG class=\"icone_etat\" src=\"data/images/iconontraite.gif\" ALT=\" $MSG_1068\" TITLE=\" $MSG_1068\" />
		    </TD>
		    <td nowrap>
		    <DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </td>
		    <TD>&nbsp;</TD></TR>
		    ");
}

function affvalide($couleur, $duree) {
	global $MSG_1069;

	print ("
		<TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icovalid.gif\" ALT=\"$MSG_1069\" TITLE=\"$MSG_1069\" />
		</td>
		<td nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD>&nbsp;</TD></TR>
		
		");
}

function affvalideqcm($num_qstaire, $couleur, $duree) {
	global $MSG_1069, $MSG_1100, $MSG_1199;
	global $s_numstag, $s_numcal, $s_numparc, $s_stag;
	//echo "coucou $s_numcal $s_numstag $num_qstaire<br>";
	// affichage de l'icone
	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG  class=\"icone_etat\" src=\"data/images/icovalid.gif\" ALT=\"$MSG_1069\" TITLE=\"$MSG_1069\" />
		    </td>
		    <td nowrap>
		    <fDIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </TD>
		     <TD>
		    
		    ");
	// test si le user est dans la table stockresultqcm (cas d'un qcm bloquant)
	$correction = 1;
	$blocage_parc = 0;
	$req = "select * from stockresultqcm where num_cal='$s_numcal' and num_user='$s_numstag' and num_qcm='$num_qstaire'";
	$restest = pg_exec($req);
	$nbessai = pg_numrows($restest);
	if (pg_numrows($restest) > 0) {
		// recup du dernier score
		$req = "select result_qstn from gestionqstn
				        where num_cal='$s_numcal' and gqstn_num_user='$s_numstag' and gqstn_num_qstaire='$num_qstaire'";
		$resnote = pg_exec($req);
		$rownote = pg_fetch_row($resnote, 0);
		//echo "coucou $s_numcal $s_numstag $num_qstaire<br>";
		// recup de la config du qcm bloquant
		$req = "select * from qcm_bloquant where num_cal='$s_numcal' and num_qcm='$num_qstaire'";
		$res = pg_exec($req);
		if (pg_numrows($res) > 0) {
			//echo "coucou<br>";
			$row = pg_fetch_row($res);
			$nbtentative = $row[4];
			$seuil = $row[2];
			//Comparaison de la note avec le seuil
			$rowtest = pg_fetch_row($restest, 0);
			if ($rowtest[3] < $seuil && $rownote[0] < $seuil) {
				//echo "echec<br>";
				// cas d'echec, on teste si la correction est disponible et si le parcours est bloqu�
				// blocage du parcours ?

				if ($row[6] == 't') {
					$blocage_parc = 1;
					// on decr�mente l'avancement du stagiaire pour bloqu� le parcours

					$req = "update gestionparcours set avancement='$row[3]' where
										                    gp_num_parcours='$s_numparc' and gp_num_user=$s_numstag and num_cal='$s_numcal'";
					$maj = pg_exec($req);
				}

				if ($row[5] == 'f')
					$correction = 0;
			}
		}
	}
	// Voir la correction si nbessai=nbtentative ?

	if ($correction == 1)
		print ("
				                <A href=\"suivi/precorrection_test.php3?num_qstaire=$num_qstaire\"><DIV class=\"texte_lien_correction\">$MSG_1100</DIV></A>
				                ");
	else {

		print ("
				                <DIV class=\"texte_correction\">$MSG_1199</DIV>
				                ");
	}
	if ($blocage_parc == 1)
		if ($s_stag == 1)
			print ("
						                <br/><a href=\"suivi/deblocage_parcours.php3?num_qstaire=$num_qstaire\"><DIV class=\"texte_lien_correction\">D�blocage du parcours</DIV></a>
						                ");
		else
			print ("
						                <br/><DIV class=\"texte_correction\">Parcours bloqu�</DIV>
						                ");
	print ("
		        </TD></TR>
		        ");
}

function affencoursqcm_form($num_qstaire, $couleur, $duree, $typ) {

	global $s_stag, $MSG_1083, $MSG_1082, $s_numstag;

	print ("
		<TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1070\" TITLE\"$MSG_1070\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur>
		");
	if ($s_stag == 1) {
		$page = page_stagiaire($s_numstag, $typ);
		// debug

		if ($page != "testext.php3")
			print ("<A href=\"suivi/revalide_Qcm.php3?numqstaire=$num_qstaire\"><DIV class=\"texte_lien_correction\">$MSG_1083</DIV></A>");
		else
			print ("En cours");
	} else
		print ("<A href=\"suivi/revalide_Qcm.php3?numqstaire=$num_qstaire\"><DIV class=\"texte_lien_correction\">$MSG_1082</DIV></A>");

	print ("</TD></tr>");
}

function affencoursqcm($couleur, $duree) {
	global $MSG_1083, $MSG_1084;
	print ("
		<TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083\" TITLE=\"$MSG_1083\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">$MSG_1084<DIV></TD></tr>
		");
}

function affrevalideqcm($couleur, $duree) {
	global $MSG_1082, $MSG_1083;
	print ("
		  <TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083\" TITLE=\"$MSG_1083\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">$MSG_1082</DIV>
		</TD></tr>
		");
}

function affencoursblanc($couleur, $duree) {
	global $MSG_1083, $MSG_1084;
	print ("
		<TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083\" TITLE=\"$MSG_1083\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">$MSG_1084<DIV></TD></tr>
		");
}
function affencoursblanc_form($exo, $couleur, $duree, $typ) {
	global $s_stag, $MSG_1083a, $MSG_1082, $s_numstag;

	// NOTE : Si le stagiaire est en train de faire une s�rie le formateur voit le message "r�activer la s�rie"
	// On va donc regarder si le stagiaire est en train de faire la s�rie et afficher le message appropri� ("en cours" ou "r�activer ..."
	// recup de la page o� se trouve le stagiaire
	// pour le moment on regarde si la page est dans la session
	// si oui alors le stagiaire fait la s�rie
	$page = page_stagiaire($s_numstag, $typ);

	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1070\" TITLE=\"$MSG_1070\" />
		    </td>
		    <TD nowrap>
		    <DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </TD>
		    <TD bgColor=$couleur>
			<DIV class=\"texte_lien_correction\">
		    ");
	if ($page != "do_serie_test.php")
		print ("<A href=\"parcours.php3?action=reactive&id_serie=$exo\">$MSG_1083a</A>");
	else
		print ("En cours");
	print ("</DIV></TD></tr>");

}
function affrevalideblanc($couleur, $duree) {
	global $MSG_1082a, $MSG_1083a;
	print ("
		   <TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083a\" TITLE=\"$MSG_1083a\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">$MSG_1082a</DIV>
		</TD></tr>
		");
}
function affvalideblanc($exo, $couleur, $duree) {
	global $MSG_1069, $MSG_1100, $MSG_1199;
	global $s_numstag, $s_numcal, $s_numparc, $s_stag;
	// affichage de l'icone
	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG class=\"icone_etat\" src=\"data/images/icovalid.gif\" ALT=\"$MSG_1069\" TITLE=\"$MSG_1069\" />
		    </td>
		    <TD nowrap>
		    <DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </TD>
		    <TD bgColor=$couleur>
		    ");
	// NOTE : Prendre en compte le cas d'une serie bloquante
	// test si le user est dans la table stockresultserie (cas d'une serie bloquante)
	$correction = 1;
	$blocage_parc = 0;
	$req = "select * from stockresultserie where num_cal='$s_numcal' and num_user='$s_numstag' and num_serie='$exo'";
	$restest = pg_exec($req);
	$nbessai = pg_numrows($restest);
	if (pg_numrows($restest) > 0) {
		// recup du dernier score
		$req = "select score from res_serie
				        where id_formation='$s_numcal' and id_stag='$s_numstag' and id_serie='$exo'";
		$resnote = pg_exec($req);
		$rownote = pg_fetch_row($resnote, 0);
		//echo "coucou $s_numcal $s_numstag $num_qstaire<br>";
		// recup de la config du qcm bloquant
		$req = "select * from serie_bloquante where num_cal='$s_numcal' and num_serie='$exo'";
		$res = pg_exec($req);
		if (pg_numrows($res) > 0) {
			//echo "coucou<br>";
			$row = pg_fetch_row($res);
			$nbtentative = $row[4];
			$seuil = $row[2];
			//Comparaison de la note avec le seuil
			$rowtest = pg_fetch_row($restest, 0);
			if ($rowtest[3] < $seuil && $rownote[0] < $seuil) {
				//echo "echec<br>";
				// cas d'echec, on teste si la correction est disponible et si le parcours est bloqu�
				// blocage de la serie ?
				if ($row[6] == 't') {
					$blocage_parc = 1;
					// on decr�mente l'avancement du stagiaire pour bloqu� le parcours
					$req = "update gestionparcours set avancement='$row[3]' where
										                    gp_num_parcours='$s_numparc' and gp_num_user=$s_numstag and num_cal='$s_numcal'";
					$maj = pg_exec($req);
				}
				if ($row[5] == 'f')
					$correction = 0;
			}
		}
	}
	// Voir la correction si nbessai=nbtentative ?
	if ($correction == 1)
		print ("
				        <A href=\"serie/avant_correction_serie.php?id_serie=$exo\"><DIV class=\"texte_lien_correction\">$MSG_1100</DIV></A>
				        ");
	else {
		if ($s_stag == 1)
			print ("
						                <A href=\"serie/avant_correction_serie.php?id_serie=$exo\"><DIV class=\"texte_lien_correction\">$MSG_1199</DIV></A>
						                ");
		else
			print ("
						                <DIV class=\"texte_correction\">$MSG_1199</DIV>
						                ");
	}
	if ($blocage_parc == 1)
		if ($s_stag == 1)
			print ("
						                <br/><a href=\"serie/deblocage_parcours.php?num_serie=$exo\"><DIV class=\"texte_lien_correction\">D�blocage du parcours</DIV></a>
						                ");
		else
			print ("
						                <br/><DIV class=\"texte_correction\">Parcours bloqu�</DIV>
						                ");
	print ("
		        </TD></TR>
		        ");

	/*
	print("
	<!--<a href=\"serie/corr_serie.php?id_serie=$exo\"><font face=\"Arial,Helvetica\" size=2 color=#333399>$MSG_1100</font></A><br>-->
	<a href=\"serie/avant_correction_serie.php?id_serie=$exo\"><font face=\"Arial,Helvetica\" size=2 color=#333399>$MSG_1100 </font></A></DIV></TD></TR>
	");
	*/
}
function affvalideexotlc($exo, $couleur, $duree) {
	global $MSG_1069, $MSG_1100;
	print ("
		  <TD class=\"taille_cellule_icone_etat\">
		
		<IMG class=\"icone_etat\" src=\"data/images/icovalid.gif\" ALT=\"$MSG_1069\" TITLE=\"$MSG_1069\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur>
		<A href=\"suivi/correction_exostlc.php3?numexo=$exo\"><DIV class=\"texte_lien_correction\">$MSG_1100</DIV></a></TD></TR>
		");
}

/*
 function affencoursexotlc($couleur,$texte,$duree)
modifi�e par r�mi
 http://192.168.1.54/parcours/addCorrExo.php3?parcours=1555&numexo=224&num_cal=550&numstag=166&numgrp=323&numtheme=101&nbrub=1
*/
function affencoursexotlc($couleur, $texte, $duree, $formateur = "", $parcours = "", $numexo = "", $num_cal = "", $numstag = "", $numgrp = "", $numtheme = "", $nbrub = "") {
	global $MSG_976, $MSG_335;

	print ("
		   <TD class=\"taille_cellule_icone_etat\">
		
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$texte\" TITLE=\"$texte\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur>");
	if ($formateur == "1")
		print ("<A onclick=\"window.open('parcours/fenetre_correction.php?interface=parcours&parcours=$parcours&numexo=$numexo&num_cal=$num_cal&numstag=$numstag&numgrp=$numgrp&numtheme=$rowtheme[0]&mode=$mode&nbrub=1','popup', 'toolbar=0,location=0,directories=0,menuBar=0,scrollbars=1,resizable=1,width=700,height=500');fpop.focus();\" href=\"#\">");

	if ($formateur == "1")
		echo '</A>';
	print ("</TD></tr>
		");
}

function affiche_etape_titre($message) {
	print ("
			<TR>
			<TD class=\"etape_titre\" colspan=\"7\"><DIV class=\"texte_etape_titre\">$message</DIV></td>
			</tr>
		
		");
}
// Les fonctions pour les tests de positionnement (type L ==> liste)
function affencoursliste($couleur, $duree) {
	global $MSG_1083, $MSG_1084;
	print ("
		  <TD class=\"taille_cellule_icone_etat\">
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083\" TITLE\"$MSG_1083\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">$MSG_1084<DIV></TD></tr>
		");
}
function affencoursliste_form($exo, $couleur, $duree, $typ) {
	global $s_stag, $MSG_1083a, $MSG_1082, $s_numstag;

	// NOTE : Si le stagiaire est en train de faire une s�rie le formateur voit le message "r�activer la s�rie"
	// On va donc regarder si le stagiaire est en train de faire la s�rie et afficher le message appropri� ("en cours" ou "r�activer ..."
	// recup de la page o� se trouve le stagiaire
	// pour le moment on regarde si la page est dans la session
	// si oui alors le stagiaire fait la s�rie
	$page = page_stagiaire($s_numstag, $typ);

	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1070\" TITLE=\"$MSG_1070\" />
		    </td>
		    <TD nowrap>
		    <DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </TD>
		    <TD bgColor=$couleur>
		    ");
	if ($page != "do_liste.php")
		print ("<A href=\"parcours.php3?action=reactive&id_liste=$exo\"><DIV class=\"texte_lien_correction\">R�activer la liste</DIV></A>");
	else
		print ("En cours");
	print ("</TD></tr>");

}
function affrevalideliste($couleur, $duree) {
	global $MSG_1082a, $MSG_1083a;
	print ("
		  <TD class=\"taille_cellule_icone_etat\">
		
		
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083a\" TITLE=\"$MSG_1083a\" />
		</td>
		<TD nowrap>
		<DIC class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">Liste r�activ�e</DIV>
		</TD></tr>
		");
}
function affvalideliste($exo, $couleur, $duree) {
	global $MSG_1069, $MSG_1100, $MSG_1199;
	global $s_numstag, $s_numcal, $s_numparc, $s_stag;
	// affichage de l'icone
	print ("
		    <TD class=\"taille_cellule_icone_etat\">
		    <IMG class=\"icone_etat\" src=\"data/images/icovalid.gif\" ALT=\"$MSG_1069\" TITLE=\"$MSG_1069\" />
		    <</td>
		    <TD nowrap>
		    <DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		    </TD>
		    <TD bgColor=$couleur>
		    ");
	print ("
		    <A href=\"liste/avant_correction_liste.php?id_liste=$exo\"><DIV class=\"texte_lien_correction\">$MSG_1100</DIV></A>
		    ");
	print ("
		    </TD></TR>
		    ");
}
// contenu scorm
function affencoursscorm($couleur, $duree) {
	global $MSG_1083, $MSG_1084;
	print ("
		  <TD class=\"taille_cellule_icone_etat\">
		
		<IMG class=\"icone_etat\" src=\"data/images/icoattente.gif\" ALT=\"$MSG_1083\" TITLE=\"$MSG_1083\" />
		</td>
		<TD nowrap>
		<DIV class=\"texte_temps\">&nbsp;$duree</DIV>
		</TD>
		<TD bgColor=$couleur><DIV class=\"texte_correction\">En cours</DIV></TD></tr>
		");
}

/**
 * A SUPPRIMER
 */
function parcours_en_formation($parcours, & $tabform) {
	print ("parcours_en_formation est depr�ci�e<br>");
	return get_parcours_all_formations($parcours, & $tabform);
}
/**
 	Obtenir les formations li�es � un parcours.
 	Retourne un tableau contenant les n� de formation si le parcours (ou son pere ou grandpere ..)
    est dans une ou plusieurs formations
    
 	@param integer : le numero du parcours
 	@param array: un tableau que l'on peu passer en r�f�rence pour stocker le resultat de la fonction
 	@return array: le tableau pass� en r��f�rence pour stocker le resultat de la fonction
*/
function get_parcours_alls_formations($parcours, $tabform=Array()) {
	//optenir les formations du parcours
	$res0 = get_parcours_formations($parcours);
	$cnt0 = pg_numrows($res0);
	
	$tabform_tmp= array();
	$cpt=0;
	// on stocke les n� et libell�s de formation ds la table
	for ($i = 0; $i < $cnt0; $i++) {
		$row = pg_fetch_row($res0, $i);
		if (!in_array("$row[0]", $tabform_tmp)){
			$tabform_tmp[]=$row[0];
			$tabform[$cpt][0] = $row[0];
			$tabform[$cpt][1] = $row[1];
			$cpt++;
//			echo "$parcours ajoute formation $row[0]<br>";
		}
//		else echo "$parcours rejete formation $row[0]<br>";
	}
//	echo "$cnt0 formations:<pre>";
//	print_r($tabform);
//	echo "</pre>";

	// test si le parcours est un parcours attach�
	$res1 = get_parcours_parcours_pere($parcours);
	$cnt1 = pg_numrows($res1);
	
	for ($ii = 0; $ii < $cnt1; $ii++) {
		$rowa = pg_fetch_row($res1, $ii);
		$res10=get_parcours_formations($rowa[0]);
		$cnt10 = pg_numrows($res10);
		for ($j = 0; $j < $cnt10; $j++) {
			$rowb = pg_fetch_row($res10, $j);
			if (!in_array("$rowb[0]", $tabform_tmp)){
				$tabform_tmp[]=$rowb[0];
				$tabform[$cpt][0] = $rowb[0];
				$tabform[$cpt][1] = $rowb[1];
				$cpt++;
//				echo "$parcours ajoute formation $rowb[0]<br>";
			}
//			else echo "$parcours rejete formation $rowb[0]<br>";
		}
	}
//	echo "$cnt1 formations des peres:<pre>";
//	print_r($tabform);
//	echo "</pre>";
	
	// tester si le parcours est un sousparcours d'un parcours en formation
	$res2 = get_plateforme_parcourss_orientes_souss_parcourss();
	// recup des parcours configure pour une orientation
	$res2 = get_plateforme_parcourss_orientes();
	$cnt2 = pg_numrows($res2);
	
	for ($ii = 0; $ii < $cnt2; $ii++) {
		$rowa = pg_fetch_row($res2, $ii);
		if($rowa[1]==$parcours){
			if(is_parcours_en_formation($rowa[0])){ 
			$res20=get_parcours_all_formations($rowa[0]);
			$cnt20 = pg_numrows($res20);
	//		echo ">>$cnt20<br>";
			for ($j = 0; $j < $cnt20; $j++) {
				$rowb = pg_fetch_row($res20, $j);
				if (!in_array("$rowb[0]", $tabform_tmp)){
					$tabform_tmp[]=$rowb[0];
					$tabform[$cpt][0] = $rowb[0];
					$tabform[$cpt][1] = $rowb[1];
					$cpt++;
	//				echo "$parcours ajoute formation $rowb[0]<br>";
				}
	//			else echo "$parcours rejete formation $rowb[0]<br>";
			}
			}
		}
	}
//	echo "$cnt2 formations des ssparcours:<pre>";
//	print_r($tabform);
//	echo "</pre>";

	return $tabform;
}

/**
 * Savoir si un parcours (ou son pere ou grandpere ..) est utilis� dans une formation
 * @param integer le numero de parcours
 * @return bool true si le parcours est dans une formation, false sinon.
 */
function is_parcours_en_formation($parcours) {
	$formations = get_parcours_alls_formations($parcours, $formations = Array ());
	
	
	if (count($formations) > 0)
		return true;
	else
		return false;
}

/**
 *  Fonction qui retourne la premi�re �tape intervertible d'un parcours.
 *  Elle teste si l'inversion des �tapes est possible pour un parcours.
 * 
 *  @param integer : identifiant du parcours
 *  @return integer : le numero de l'�tape � partir de laquelle on poura inverser les �tapes, null si pas d'inversion possible. 
 */
function get_parcours_etape_intervertible_old($parcours) {
		$inversion_etape = 'NULL';
	
		// test si le parcours est un parcours attach�
		if (is_parcours_etape($parcours))
			return null;

		// test si le parcours est un sousparcours de parcours dynamique
		if(is_parcours_parcours_dynamiques_sous_parcours_old($parcours)){
			return null;
		}
	
		// test si le parcours poss�de au moins une �tape de parcours dynamique
		$res = get_parcours_etapes_type($parcours, get_etape_type_new_old(10));
		if (pg_numrows($res) > 0)
			return null;


		// test si le parcours poss�de une �tape de type 'L' (liste de test d'auto-positionnement)
		//ici, cela ne marche que pour l'ancienne base, car le type 4 correspond aux types QBCL.		
		$res = get_parcours_etapes_type($parcours, get_etape_type_old_new('L'));
		if(pg_numrows($res)>0)
			return null;
			
		// test si le parcours est utilis� dans une formation
		if (is_parcours_en_formation($parcours)) {
			// recup de l'avancement max
			$inversion_etape = pg_fetch_result(get_parcours_avancement_max($parcours), 0, 0);
		}
		return ($inversion_etape+1);
}

/**
 *  Fonction qui test si l'inversion des �tapes est possible pour un parcours.
 * 
 *  @param integer : identifiant du parcours
 *  @return integer : le numero de l'�tape � partir de laquelle on poura inverser les �tapes, null si pas d'inversion possible. 
 */
function get_parcours_etape_intervertible($parcours) {

	if (VERSION_BASE > VERSION) {
		
	

	} else {
		return get_parcours_etape_intervertible_old($parcours); 
	}
}

/**
 * Test si le parcours est un sousparcours de parcours dynamique.
 * 
 * @param integer identifiant du parcours
 * @return bool  true, le parcours est dans un parcours dynamique, false sinon.
 */
function is_parcours_sous_parcours_parcourss_orientes_old($parcours) {
	$res = get_plateforme_parcours_dynamiques_sous_parcours();
	$nb = pg_numrows($res);
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$stock = array ();
		$stock = explode(",", $row[0]);
		if (in_array("$parcours", $stock))
			return true;
	}
	return false;
}

/**
 * Savoir si un parcours  est utilis� comme sous parcours d'un parcours dynamique
 * @param integer le numero de parcours
 * @return bool true si le parcours est utilis� par un parcours dynamique, false sinon.
 */
function is_parcours_sous_parcours_parcourss_orientes($parcours) {
	if (VERSION_BASE > VERSION) {
		$res = get_plateforme_parcourss_orientes_souss_parcourss();
		$nb = pg_numrows($res);
		for ($i = 0; $i < $nb; $i++) {
			$id = pg_fetch_result($res, $i, 0);
			if ($parcours == $id) {
				return true;
			}
		}
		return false;
	} else {
		return is_parcours_sous_parcours_parcourss_orientes_old($parcours);
	}
}

function is_parcours_dynamique_old($parcours){
	$sql="SELECT * FROM config_orientation WHERE num_parcours=$parcours";
	$res=pg_query($sql);
	if(pg_num_rows($res)>0){
		return true;
	}
	else{
		return false;
	}
}

function is_parcours_dynamique($parcours){
	if (VERSION_BASE > VERSION) {
		// test si le parcours poss�de au moins une �tape de parcours orient�
		$res = get_parcours_etapes_type($parcours, 10);
		if (pg_numrows($res) > 0)return true;
		else return false;
	}else{
		return is_parcours_dynamique_old($parcours);
	}
}

/**
 * Savoir si l'on peut ajouter une �tape � la fin d'un parcours.
 * C'est � dire si 
 * 
 * @param integer le numero de parcours
 * @return bool true 
 */
function is_parcours_etape_ajoutable_old($parcours){
	// test si parcours attach�
    if(is_parcours_etape($parcours))
        return false;
    
   //test si parcours dynamique
    if(is_parcours_dynamique($parcours))
        return false;

    return true;
}

/**
 * Savoir si l'on peut ajouter une �tape � la fin d'un parcours.
 * C'est � dire si 
 * 
 * @param integer le numero de parcours
 * @return bool true 
 */
function is_parcours_etape_ajoutable($parcours){
	if (VERSION_BASE > VERSION) {
		return !is_parcours_dynamique($parcours);
	}else{
		return is_parcours_etape_ajoutable_old($parcours);
	}
}

/**
 * Savoir si l'on peut inserer une �tape � la suite d'une �tape d'un parcours.(OLD)
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape
 * @return bool true ou false
 */
function is_parcours_etape_inserable_old($parcours, $etape){
	// test si parcours attach�
    if(is_parcours_etape($parcours))
        return false;
    
   //test si parcours dynamique
    if(is_parcours_dynamique($parcours))
        return false;

    return true;
}

/**
 * Savoir si l'on peut inserer une �tape avant une �tape d'un parcours.
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape
 * @return bool true ou false
 */
function is_parcours_etape_inserable($parcours, $etape){
	if (VERSION_BASE > VERSION) {
		// si le parcours est un aprcours attache ou un sous parcours pas d'insertion
		if(is_parcours_etape($parcours) || is_parcours_dynamique($parcours))
			return  false;
		return true;
	}
	else{
		return is_parcours_etape_inserable_old($parcours, $etape);
	}
}

/**
 * Savoir si l'on peut supprimer une �tape d'un parcours.(OLD)
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape
 * @return bool true ou false
 */
function is_parcours_etape_supprimable_old($parcours, $etape){
	// test si parcours attach�
    if(is_parcours_etape($parcours))
        return false;
    
   //test si parcours dynamique
    if(is_parcours_dynamique($parcours))
        return false;

    return true;
}

/**
 * Savoir si l'on peut supprimer une �tape d'un parcours.
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape
 * @return bool true ou false
 */
function is_parcours_etape_supprimable($parcours, $etape){
	if (VERSION_BASE > VERSION) {
		// test si l'etape du parcours est enregistre
		$res=get_parcours_etape_resultats($parcours,$etape);
		if(pg_num_rows($res)>0)
			return false;
		// test si le parcours est configur� en orientation
		if(is_parcours_dynamique($parcours)){
			// il faut tester si le type de l'etape est utiliser dans la configuration (A SUIVRE ....)
			// pour le moment on retourne false si l'etape est de type serie ou exotlc
			$res_etape=get_etape($etape);
			$row_etape=pg_fetch_row($res_etape,0);
			if($row_etape[2]==4 || $row_etape[2]==5)
				return false;
		}
		return true;
	}
	else{
		return is_parcours_etape_supprimable_old($parcours, $etape);
	}
}

/**
 * Savoir si l'on peut modifier une �tape d'un parcours.(OLD)
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape p�re
 * @return bool true ou false
 */
function is_parcours_etape_modifiable_old($parcours, $pere){
	// test si parcours attach�
    if(is_parcours_etape($parcours))
        return false;
    
   //test si parcours dynamique
    if(is_parcours_dynamique($parcours))
        return false;
   	if($pere<get_parcours_etape_intervertible($parcours))
   		return false;

    return true;
}

/**
 *  Savoir si l'on peut modifier une �tape d'un parcours.
 * 
 * @param integer le numero de parcours
 * @param integer le numero de l'�tape p�re
 * @return bool true ou false
 */
function is_parcours_etape_modifiable($parcours, $pere){
	
	if (VERSION_BASE > VERSION) {
		return true;
	}else{
		return is_parcours_etape_modifiable_old($parcours, $pere);
	}
}
/**
 * Fonction qui retourne le type de param�trage d'un parcours
 * @param integer num�ro du parcours
 * @return integer -1 = pas personnalis�, 1 d�taill�, 0 standard
 */
function get_parcours_type_parametrage($parcours){
    // y a t'il des noms d'etape ?
    $res=get_parcours_types_etapes_personnalises($parcours);
    if(pg_num_rows($res)==0)
        return -1;
   	// recup du nb de type #
    $res=get_parcours_types_etapes($parcours);
    $nbtype=pg_num_rows($res);
    // boucle sur les types
    for($i=0;$i<$nbtype;$i++){
        $row=pg_fetch_row($res,$i);
        // nombre d'etape par type
        
        $t=get_etape_type_formate($row[0],1);
        //echo "t=$t<br>";
        $resetape=get_parcours_type_etape_personnalise($parcours,$t);
        if(pg_num_rows($resetape)>1)
            return 1;
    }
    return 0;
}

/**
 * Obtenir la dur�e totale d'un parcours.
 * 
 * La dur�e totale d'un parcours est obtenue par la somme des dur�es configur�es de chacunes des �tapes.
 * Si il n'y a pas de dur�e configur�e pour une �tape, on utilise alors la dur�e calcul�e.
 * 
 * @param integer le num�ro de parcours.
 * 
 * @return integer : la dur�e en seconde du parcours.
 */
function get_parcours_duree_totale($parcours) {

	//initialisation duree totale
	$duree = 0;
	
	// balayage des �tapes du parcours
	$res=get_parcours_etapes($parcours);
	$nbetape = pg_numrows($res);
	for ($e = 0; $e < $nbetape; $e++) {
		
		//initialisation temps etape
		$temps_etape = 0;
		
		//recu infos etapes
		$row = pg_fetch_row($res, $e);
		
		//si le type d'�tape peu poss�der un chrono
		if (is_etape_type_chronometre("".$row[4])) {
			//on recupere la dur�e de l'�tape
			$temps_etape = get_etape_chrono_total($row[0], $row[4]);
			//chrono individuel
			if($temps_etape<0)$temps_etape=-$temps_etape;
		}
			
		//si pas de dur�e dur�e configu�e, on tiens compte de la dur�e calcul�e
		if (empty($row[8]))
			$duree += $temps_etape;
		else
			$duree += $row[8];
	}
	return $duree;
}

/**
 * Savoir si un parcours est modifiable ou supprimable.
 * 2: le parcours est supprimable
 * 1: il n'est que modifible 
 * 0: il n'est ni modifiable ni supprimable
 *  
 * @param integer idendifiant du parcours
 * @return integer: 0,1,ou 2
 */
function get_parcours_actions($parcours){
  
  //TODO insufisant, vrai que si l'�tape  est effectu�e     
    // test si le parcours est une �tape
    if(is_parcours_etape($parcours)){
        return 0; 
    }

//TODO insufisant, vrai que si l'�tape dans le parcours principal est effectu�e    
    //test si le parcours est un sous parcours de parcours dynamique
//    if(is_parcours_sous_parcours_parcourss_orientes($parcours)){
//    	echo "\$parcours=$parcours<br>";
//    }
//    	return 0;
//    }
	
	
 //TODO insufisant,le parcours  en formation n'est pas une condition valable  
    // test si le parcours est en formation  
    if(is_parcours_en_formation($parcours)){
		//echo "parc en form : $parcours<br>";
		// test si le parcours est modifiable (pas fini par un stagiaire)
		if(is_parcours_fini($parcours)){
			//echo "coucou et parcours=$parcours<br>";
			return 0;
		}
        return 1;
    }
	
	
    return 2;
}

/**
 * Obtenir le nombre d'�tape d'un parcours.
 * @param integer identifiant du parcours
 * @return integer nombre d'�tapes.
 */
function get_parcours_nb_etapes_old($parcours){
	$res = get_parcours_etapes($parcours);
	$nb=pg_num_rows($res);
	if($nb>0){
		$row0=pg_fetch_row($res, 0);
		if($row0[4]=='I'){
			$row1=pg_fetch_row($res, 1);
			if($row1[4]=='S'&&empty($row1[0])){
				$nb--;
			}
		}else{
			if($row0[4]=='S'&&empty($row0[0])){
				$nb--;
			}
		}
	}
	return $nb;
}

/**
 * Obtenir le nombre d'�tape d'un parcours.
 * @param integer identifiant du parcours
 * @return integer nombre d'�tapes.
 */
function get_parcours_nb_etapes($parcours){
	if (VERSION_BASE > VERSION) {
		return pg_numrows(get_parcours_etapes($parcours));
	}else{
		return get_parcours_nb_etapes_old($parcours);
	}
}

/**
*   Obtenir les �tapes d'un parcours sous forme d'un tableau javascript.
*	Le tableau javascript est nomm� tab_etapes_parcours.
*   @param integer : le num�ro de parcours
*   @return string : une chaine contenant la declaration javascript d'un tableau contenant tous les id des �tapes d'un parcours.
*/
function get_parcours_etapes_tableau_javascript($parcours) {
	global $MSG_2551,$MSG_727,$MSG_926,$MSG_1689,$MSG_2225,$MSG_776,$MSG_922,$MSG_927b,$MSG_928,$MSG_516,$MSG_1473,$MSG_1741,$MSG_547,$MSG_1483,$MSG_1372,$MSG_1863, $MSG_1864,$MSG_2210, $MSG_1627,$MSG_2224,$MSG_1626,$MSG_1866, $MSG_2224,$MSG_2227, $MSG_2226,$MSG_2228;
	
	$res_etapes=get_parcours_etapes($parcours);
	$tableau_javascript="\nvar tab_etapes_parcours= new Array();\n";
	$nb_etapes=pg_num_rows($res_etapes);
	for($i=0;$i<$nb_etapes;$i++){
		$row=pg_fetch_row($res_etapes,$i);
		//print_rr($row);
		$tmp_etape=get_ams_libelles($row[1]);
		$row[1]=get_ams_libelle($tmp_etape,50);
		$tmp_etape=get_ams_libelles($row[2]);
		$row[2]=get_ams_libelle($tmp_etape,50);
		$tmp_etape=get_ams_libelles($row[3]);
		$row[3]=get_ams_libelle($tmp_etape,50);
		$tableau_javascript.="tab_etapes_parcours[$i]=new Array();\n";
		$tableau_javascript.="tab_etapes_parcours[$i][0]=$row[0];\n";
		$tableau_javascript.="tab_etapes_parcours[$i][1]='".$row[1]."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][2]='".addslashes($row[2])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][3]='".addslashes($row[3])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][4]='".addslashes($row[4])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][5]='".addslashes($row[5])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][6]='".addslashes($row[6])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][7]='".addslashes($row[7])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][8]='".addslashes($row[8])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][9]='".addslashes($row[9])."';\n";
		$var='$lib_type='.$row[10].';';
		eval($var);
		$tableau_javascript.="tab_etapes_parcours[$i][10]='".addslashes($lib_type)."';\n";
		$res_theme=get_etape_themes($row[0]);
		if(pg_num_rows($res_theme)>0)$numtheme =  pg_fetch_result($res_theme, 0, 0);
		$tableau_javascript.="tab_etapes_parcours[$i][11]='".$numtheme."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][12]='".$row[11]."';\n\n";
	}
	return $tableau_javascript;
}

/**
*   Obtenir les �tapes d'un parcours sous forme d'un tableau javascript, avec leurs themes.
*	Le tableau javascript est nomm� tab_etapes_parcours.
*   @param integer : le num�ro de parcours
*   @return string : une chaine contenant la declaration javascript d'un tableau contenant tous les id des �tapes d'un parcours.
*/
function get_parcours_etapes_themes_tableau_javascript($parcours) {
	$res_etapes=get_parcours_etapes($parcours);
	$tableau_javascript="\nvar tab_etapes_parcours= new Array();\n";
	$nb_etapes=pg_num_rows($res_etapes);
	for($i=0;$i<$nb_etapes;$i++){
		$row=pg_fetch_row($res_etapes,$i);
		$tableau_javascript.="tab_etapes_parcours[$i]=new Array();\n";
		$tableau_javascript.="tab_etapes_parcours[$i][0]=$row[0];\n";
		$tableau_javascript.="tab_etapes_parcours[$i][1]='".addslashes($row[1])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][2]='".addslashes($row[2])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][3]='".addslashes($row[3])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][4]='".addslashes($row[4])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][5]='".addslashes($row[5])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][6]='".addslashes($row[6])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][7]='".addslashes($row[7])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][8]='".addslashes($row[8])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][9]='".addslashes($row[9])."';\n";
		$tableau_javascript.="tab_etapes_parcours[$i][10]='".pg_fetch_result(get_etape_themes($row[0]), 0, 0)."';\n\n";
		
	}
	return $tableau_javascript;
}

/**
 * Obtenir le type de configuration du temps des �tapes d'un parcours.
 * Retourne -1 si pas de configuration de temps pour le parcours,
 * 0 si il y a une configuration par type d'�tapes,
 * 1 si il y a une configuration propre a chaque �tapes.
 * @param integer : l'identifiant du parcours
 * @return integer: -1,0 ou 1 selon le type de configuration
 */
function get_parcours_type_duree($parcours){
	
    // y a t'il des dur�es d'�tape ?
    $res=get_parcours_etapes_durees_valuees($parcours);
    $nb=pg_num_rows($res);
	//echo "nb=$nb<br>";
    if($nb==0){
        return -1;
    }
        
    // recup du nb de type
    $res=get_parcours_types_etapes($parcours);
    while($row=pg_fetch_row($res)){
    	if($row[0]!='4_1_4')
    		$tab_types[get_etape_type_formate($row[0],2)]+=$row[2];
    }
   
     // boucle sur les types
    foreach($tab_types as $num_type => $nb_etapes_type){
        if(is_etape_type_duree($num_type)){
            // nombre de durees par type
            $resetape=get_parcours_etapes_durees_type_distincts($parcours,$num_type);
            $nb_durees=pg_num_rows($resetape);
            //echo "nb_durees=$nb_durees et nb_etapes_type=$nb_etapes_type<br>";
            if($nb_durees>1&&$nb_durees<=$nb_etapes_type){
				return 1;
            }
        }
    }
    return 0;
}



/**
	Savoir si un parcours est fini
	* @param integer le numero de parcours
	* @return bool true si le parcours est fini, false sinon.
*/
function is_parcours_fini($parcours){
	if (VERSION_BASE > VERSION) {
		// recup et boucle sur les etapes du parcours
		$res=get_parcours_etapes($parcours);
		$nb_etape=pg_num_rows($res);
		for($i=0;$i<$nb_etape;$i++){
			$row=pg_fetch_row($res,$i);
			// action sur l'etape
			$res_etape=get_parcours_etape_resultats($parcours,$row[0]);
			if(pg_num_rows($res_etape)>0)
				continue;
			else
				return false;
		
		}
		return true;
		
		
	}

}

/**
 	Obtenir les formations d'un parcours.
 	Retourne un tableau contenant les n� de formation si le parcours est principal
    
    
 	@param integer : le numero du parcours
 	@param array: un tableau que l'on peu passer en r�f�rence pour stocker le resultat de la fonction
 	@return array: le tableau pass� en r��f�rence pour stocker le resultat de la fonction
*/
function get_parcours_ses_formations($parcours, $tabform=Array()) {
	//optenir les formations du parcours
	$res=get_parcours_formations($parcours);
	$nb=pg_num_rows($res);
	for($i=0;$i<$nb;$i++){
		$row=pg_fetch_row($res,$i);
		if(!in_array($row[0],$tabform))
			$tabform[]=$row[0];
	}
	return $tabform;
}

/**
   Savoir si une etape de parcours est modifiable ou supprimable
 * 2: l'etape est supprimable
 * 1: elle n'est que modifible 
 * 0: elle n'est ni modifiable ni supprimable
 *  
 * @param integer idendifiant du parcours
 * @param integer idendifiant de l'etape parcours
 * @return integer: 0,1,ou 2
*/
function get_parcours_etape_actions($parcours,$etape){
	// si le parcours est fini aucune action permise
	if(is_parcours_fini($parcours))
		return 1;
	// test si l'etape est supprimable
	if(is_parcours_etape_supprimable($parcours,$etape))
		return 2;
	return 1;
	
}

/**
   R�cup�ration dans un tableau indic� des �tapes intervertibles
   * @param integer idendifiant du parcours
   * @return array : le tableau d'�tapes intervertibles
*/
function get_tableau_etapes_intervertibles($parcours){
	$tab=array();
	// recup des etapes
	$res=get_parcours_etapes($parcours);
	$nb=pg_num_rows($res);
	// boucle sur les etapes
	for($i=0;$i<$nb;$i++){
		$ind=$i+1;
		$row=pg_fetch_row($res,$i);
		// NOTE : pr�voir peut �tre d'autres condition (etape parcours oriente,. A Suivre ...)
		if($row[11]=='t')
			$tab[$ind]=$row[0];
	}
	return $tab;
}
?>