<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on May 16, 2006
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

/**
  LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL

  Ce fichier contient toutes les fonctions necessaires  l'interrogation des bd pour les
 parcours . Chacunes de ces fonctions  2 fonctions quivalentes: l'une prefix par
 _af_ en base, et l'autre suffux par _old dans le script.

 CONVENTION PROPOSEE:

 Le maximum des requetes SQL doivent etre ecritent sous la forme de fonctions
 en PLPGSQL en base, c'est a dire la totalit des requetes retournant  une valeur.

 Les requetes retournant plusieurs lignes ne pouvant etre traites ainsi, elles doivent
 tre ecrite sous la forme de fonctions PHP qui retournent une variable resultat (pg_exec)


 CONVENTION DE NOMAGE :
 Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
 PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
  la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
 Exemple:

 la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base
       @package parcours
*/

/**
*   obtenir le numero du parcours pour l'utilisateur et le calendrier spcifi
*
*   Retourne le numero du parcours  dont l'utilisateur et le calendrier sont passs en parametre.
*
*    @param  integer  : le numero du user
*    @param  integer  : le numero du calendrier
*
*    @return integer  : le resultat de la requete
*/
function get_numero_parcours($user, $calendrier){

    $req="select * from _af_get_numero_parcours($user, $calendrier);";
    return (pg_query($req));

}

function check_dynamique_parcours_old($cal)
{
            $req="select num_parcours from config_orientation where num_parcours in (select distinct g_num_parcours from gestionnaire where g_num_cal='$cal')";
            return(pg_query($req));
}

/**
*   Tester si une formation a un parcours dynamique
*        MAIS C'EST QUOI CETTE FONCTION NICO??????????????????
*   Retourne la liste des parcours dynamiques de la formation
*   si il y en a.
*
*    @param  integer : numro de calendrier
*
*
*/
function get_dynamique_parcours($cal)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM _af_get_dynamique_parcours($cal) AS (num_cal integer)";
                        $res = pg_query($req);
            }
            else
                        $res=check_dynamique_parcours_old($cal);
            return $res;
}
/**
*   Tester si une formation a un parcours dynamique
*
*   Retourne la liste des parcours dynamiques de la formation
*   si il y en a.
*
*    @param  integer : numro de calendrier
*
*
*/
function check_dynamique_parcours($cal)
{
            if(VERSION_BASE>"7.1.3")
            {
                        $req="select * FROM _af_get_dynamique_parcours($cal) AS (num_cal integer)";
                        $res = pg_query($req);
            }
            else
                        $res=check_dynamique_parcours_old($cal);
            return $res;
}

function get_sous_parcours_old($parcours)
{
            $ss_parc="select sousparcours from config_orientation where num_parcours='$parcours'";
            return(pg_query($ss_parc));
}

/**
*   Rcuprer les sous parcours d'un parcours donn
*
*   Retourne la liste des sous-parcours du parcours
*
*    @param  integer : numro de parcours
*
*
*/
function get_sous_parcours($parcours)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM _af_get_sous_parcours($parcours) AS (num_parc integer)";
                        $res = pg_query($req);
            }
            else
                        $res=get_sous_parcours_old($parcours);
            return $res;
}

/**
*   Obtenir les etapes libres d'un parcours(OLD).
*
*   Retourne les numros d'tape d'un parcours qui sont libres.
*
*    @param  integer : numro de parcours
*
*   @return integer :   les numros d'tape
*/
function get_etapes_libres_parcours_old($parcours)
{
            $req="  SELECT num_etape
                        FROM gestparcours
                        WHERE g_num_parcours=$parcours
                        AND obligation='l' AND type_etape<>'I' ; ";
            return(pg_query($req));
}

/**
*   Obtenir les etapes libres d'un parcours(OLD).
*
*   Retourne les numros d'tape d'un parcours qui sont libres.
*
*    @param  integer : numro de parcours
*
*   @return integer :   les numros d'tape
*/
function get_etapes_libres_parcours($parcours)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM _af_get_etapes_libres_parcours($parcours) AS (num_etape integer)";
                        $res = pg_query($req);
            }
            else
                        $res=get_etapes_libres_parcours_old($parcours);
            return $res;
}

/**
* Retourne un numro donnant le mode d'affichage du parcours : 0 = par dfaut, 1 par titre, 2 par tape fin de page
* Retourne un numro donnant le mode d'affichage du parcours : 0 = par dfaut, 1 par titre, 2 par tape fin de page.
* S'il y a des tape fin de page, ce mode prend le dessus sur le reste. Sinon on compte les tapes titre, et s'il n'y en a
* aucune alors on affiche en suivant le mode classique : une dizaine d'tapes par page.
* @param integer : numro de parcours
* @return integer : mode d'affichage : 0=classique, 1=titre & 3=fin de page
*/
function get_mode_affichage_parcours($num_parcours)
{
        return ( pg_result(pg_query("SELECT _af_get_mode_affichage_parcours($num_parcours) ; "),0,0) ) ;
}

/**
* Procdure qui inverse deux tape d'un parcours donne
* Procdure qui inverse deux tape d'un parcours donne. Cette procdure attaque les tables gestparcours et config_ressource
* @param integer : numro de parcours
* @param integer : numro de la premire tape
* @param integer : numro de la seconde tape
*/
function inverse_etapes_parcours($num_parcours, $num_etape1, $num_etape2)
{
        pg_query("SELECT _ap_inverse_etapes_parcours($num_parcours, $num_etape1, $num_etape2) ;") ;
}


/**
* Fonction qui donne les informations utiles d'un parcours (nom, rang ,theme,filiere,affichage_duree_fo) OLD
* Cette fonction est  utiliser dans le constructeur de la classe Parcours. Il faut construire l'objet Filiere
*  partir des numro rcuprer.
* @param integer : numro de parcours dans la table parcours
* @return integer : rsultat de requete : {num_parcours, nom_parcours,rang,num_theme,, num_filiere,affichage_duree_fo}
*/
function get_infos_parcours_old($id_parc)
{
    $req="select distinct
    num_parcours,nom_parcours,num_rang as rang,num_thematik as num_theme,num_c_q_e_d as num_filiere,affiche_fo as affichage_duree_fo
    from parcours,gestparcours where g_num_parcours=$id_parc and num_etape=1 and num_parcours=g_num_parcours";
    $res=pg_query($req);
    return $res;

}

function get_infos_parcours($id_parc)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM _af_get_infos_parcours($id_parc)
                        AS (num_parcours integer, nom_parcours varchar, rang integer,num_theme integer, num_filiere integer,affiche_duree_fo boolean)";
                        $res = pg_query($req);
            }
            else
                        $res=get_infos_parcours_old($id_parc);

            return $res;
}

/**
* Retourne la listes des formations d'un parcours dont l'id est pass en paramtre (OLD)
*
* @param integer : numro de parcours
* @param string : ASC ou DESC
* @param integer : si VRAI alors on ordonne par date et non pas par formation
* @return integer : liste de numro de formation, le nom, la date de dbut e la date de fin
*/
function get_formations_parcours_old($num_parcours, $classement="ASC", $par_date=0)
{
    $req="SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin
    FROM calendrier, gestionnaire, dates d1, dates d2
    WHERE g_num_parcours=$num_parcours
    AND g_num_cal=num_cal
    AND datedeb = d1.num_date
    AND datefin = d2.num_date
    ORDER by " ;
    if($par_date)
        $req .= "debut $classement";
    else
        $req .= "nom_formation $classement";

    $formations=pg_query($req);

    return $formations;
}
/**
* Retourne la listes des formations d'un parcours dont l'id est pass en paramtre
*
* @param integer : numro de parcours
* @param string : ASC ou DESC
* @param integer : si VRAI alors on ordonne par date et non pas par formation
* @return integer : liste de numro de formation, le nom, la date de dbut e la date de fin
*/
function get_formations_parcours($num_parcours, $classement="ASC", $par_date=0)
{
        if(VERSION_BASE>VERSION)
        {
                $req="SELECT * FROM  _af_get_formations_parcours($num_parcours, '$classement', $par_date)
                AS (num_formation integer, nom_formation varchar, debut date, fin date) ;" ;
                $formations=pg_query($req);
        }
        else
                $formations=get_formations_parcours_old($num_parcours, $classement, $par_date) ;

        return $formations ;
}

/**
*   Vrifie qu'un nom de parcours est unique (OLD)
*   @param sring : le nom du parcours  vrifier
*   @return integer : n si existe, 0 sinon
*/
function check_parcours_libelle_old($libelle){
    $sql="select * from parcours where nom_parcours='$libelle'";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    else{
        $row=pg_fetch_row($res,0);
        return $row[0];
    }
}
/**
*   Vrifie qu'un nom de parcours est unique
*   @param sring : le nom du parcours  vrifier
*   @return integer : 1 si existe, 0 sinon
*/
function check_parcours_libelle($libelle){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
        return true;
    }
    else
        $res=check_parcours_libelle_old($libelle);
    return ($res);
}

/**
*   Vrifie qu'un nom de parcours n'est pas utilis par un parcours ayant des tapes (OLD)
*   @param sring : le nom du parcours  vrifier
*   @return integer : 1 si existe, 0 sinon
*/
function check_parcours_libelle_utilise_old($libelle){
    $sql="select * from parcours where nom_parcours='$libelle' and num_parcours in (select g_num_parcours from gestparcours)";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    else{
        return 1;
    }
}
/**
*   Vrifie qu'un nom de parcours est unique
*   @param sring : le nom du parcours  vrifier
*   @return integer : 1 si existe, 0 sinon
*/
function check_parcours_libelle_utilise($libelle){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
        return false;
    }
    else
        $res=check_parcours_libelle_utilise_old($libelle);
    return ($res);
}

///**
//*	Obtenir les proprits d'un parcours. (OLD)
//*
//*	@param integer: le numero du parcours
//*	@return integer : l'entier resultat de la requete
//*/
//function get_parcours_old($parcours) {
//
//		$req = "select * from parcours where num_parcours=$parcours";
//		$res = pg_query($req);
//
//	return $res;
//}
//
///**
//*	Obtenir les proprits d'un parcours
//*
//*	@param integer: le numero du parcours
//*	@return integer : l'entier resultat de la requete
//*/
//function get_parcours($parcours) {
//
//	if (VERSION_BASE > VERSION) {
//
//		$req = "A IMPLEMENTER";
//		$res = pg_query($req);
//
//	} else
//		$res = get_parcours_old($parcours);
//
//	return $res;
//}

///**
//*   Mettre  jour le nom d'un parcours (OLD)
//*   @param integer : le numro de parcours
//*   @param string : le nouveau nom de parcours
//*   @return integer : 1 si OK , 0 si erreur
//*/
//function maj_parcours_libelle_old($parcours,$libelle){
//    if(!check_parcours_libelle($libelle)){
//        $sql="update parcours set nom_parcours='$libelle' where num_parcours=$parcours";
//        $maj=pg_query($sql);
//        $ok=1;
//    }
//    else
//        $ok=0;
//    return $ok;
//}
///**
//*   Mettre  jour le nom d'un parcours (OLD)
//*   @param integer : le numro de parcours
//*   @param string : le nouveau nom de parcours
//*   @return integer : 1 si OK , 0 si erreur
//*/
//function maj_parcours_libelle($parcours,$libelle){
//    if (VERSION_BASE > VERSION) {
//        $req = "A IMPLEMENTER";
//        $res = pg_query($req);
//    }
//    else
//        $res = maj_parcours_libelle_old($parcours,$libelle);
//    return $res;
//}

///**
//*   Enregistre le nom d'un parcours
//*
//*   @param string : le nom du parcours
//*   @return integer : le n du nouveau parcours
//*/
//function set_parcours_libelle_old($libelle){
//    $num_parcours=check_parcours_libelle($libelle);
//    if(!$num_parcours){
//        $sql="insert into parcours(nom_parcours) values('$libelle')";
//        $ins=pg_query($sql);
//        $oid=pg_getlastoid($ins);
//        $res=pg_query("SELECT num_parcours from parcours where oid=$oid;");
//        $num_parcours=pg_result($res, 0, 0);
//    }
//    return $num_parcours;
//}
///**
//*   Enregistre le nom d'un parcours
//*
//*   @param string : le nom du parcours
//*   @return integer : le n du nouveau parcours
//*/
//function set_parcours_libelle($libelle){
//    if (VERSION_BASE > VERSION) {
//        $req = "select af_set_parcours('$libelle',$filiere);";
//        $res = pg_query($req);
//        $num_parcours=pg_result($res, 0, 0);
//    }
//    else
//        $num_parcours = set_parcours_libelle_old($libelle);
//    return $num_parcours;
//}

/**
       Obtenir le type d'etape d'un parcours pour une serie donne (OLD)

	Les informations obtenues sont:
	type_etape

      @param integer: identifiant en base du parcours
      @param integer: identifiant en base de la serie
*/
function get_parcours_type_etape_serie_old($parcours,$serie)
{
    $req="select distinct type_etape from gestparcours where g_num_parcours=$parcours and num_c_q_e_d=$serie";
    $res=pg_query($req);
    return $res ;
}

/**
       Obtenir le type d'etape d'un parcours pour une serie donne

	Les informations obtenues sont:
	type_etape

      @param integer: identifiant en base du parcours
      @param integer: identifiant en base de la serie
*/
function get_parcours_type_etape_serie($parcours,$serie)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_parcours_type_etape_serie_old($parcours,$serie);

    return $res ;
}

/**
*   Obtenir les parcours attachs disponibles pour un parcours et un theme  (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @param integer : le numro de rang (des parcours attachs)
*   @return integer : le rsultats de la requte
*/
function get_parcours_parcours_attaches_disponibles_old($parcours,$theme,$rang){
    $sql="select num_parcours,nom_parcours from parcours where num_parcours in
            (select distinct g_num_parcours from gestparcours where num_rang=$rang and num_thematik=$theme and num_etape='1')
            and num_parcours not in (select num_parcours from config_orientation) and num_parcours not in
            (select attach_parcours from gestparcours where g_num_parcours=$parcours) order by nom_parcours";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les parcours attachs disponibles pour un parcours et un theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @param integer : le numro de rang (des parcours attachs)
*   @return integer : le rsultats de la requte
*/
function get_parcours_parcours_attaches_disponibles($parcours,$theme,$rang){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_parcours_attaches_disponibles_old($parcours,$theme,$rang);
    return $res;
}

/**
*   Obtenir les exotlc disponibles pour un parcours et un theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_exotlc_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select num_exo,titre,lower(titre) as ordre from exotlc where num_exo in
            (select gestfic_num_exo from gestfic where gestfic_num_fic in
            (select num_fic from fictlc where num_themedir=$theme)) and num_exo not in
            (select num_c_q_e_d from gestparcours where type_etape='E' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les exotlc disponibles pour un parcours et un theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_exotlc_disponibles($parcours,$theme,$valexo=0){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_exotlc_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series multi exo disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_multi_exo_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) >1) and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    // debug
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series multi exo disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_multi_exo_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_multi_exo_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series de qcm disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_qcm_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
            (select distinct id_serie from asso_exo_serie where type_exo='q') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d <>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series de qcm disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_qcm_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_qcm_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series de blanc disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_blanc_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
            (select distinct id_serie from asso_exo_serie where type_exo='f') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series de blanc disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_blanc_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_blanc_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series de sondage disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_sondage_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
            (select distinct id_serie from asso_exo_serie where type_exo='s') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series de sondage disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_sondage_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_sondage_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series de qrc disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_qrc_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
            (select distinct id_serie from asso_exo_serie where type_exo='m') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) 
			and id not in (select id_test from test) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series de qrc disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_qrc_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_qrc_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series de src disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_src_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where theme=$theme and id in
            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
            (select distinct id_serie from asso_exo_serie where type_exo='o') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) 
			and id not in (select id_test from test) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series de src disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_src_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_src_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series alatoires monotheme disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_aleatoires_monotheme_disponibles_old($parcours,$theme,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where id in
            (select distinct num_serie from serie_aleatoire where theme=$theme and mode='1') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='C' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series alatoires monotheme disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_aleatoires_monotheme_disponibles($parcours,$theme,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_aleatoires_monotheme_disponibles_old($parcours,$theme,$valexo);
    return $res;
}

/**
*   Obtenir les series alatoires multitheme disponibles pour un parcours en fonction du theme (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_aleatoires_multitheme_disponibles_old($parcours,$valexo=0){
    $sql="select id,titre,lower(titre) as ordre from serie_exo where id in
            (select distinct num_serie from serie_aleatoire where mode='2') and id not in
            (select num_c_q_e_d from gestparcours where type_etape='C' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) order by ordre;";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les series alatoires multitheme disponibles pour un parcours en fonction du theme
*
*   @param integer : le numro de parcours
*   @param integer : le numro de theme
*   @return integer : le rsultat de la requte
*/
function get_parcours_series_aleatoires_multitheme_disponibles($parcours,$valexo=0){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_series_aleatoires_multitheme_disponibles_old($parcours,$valexo);
    return $res;
}

///**
//*   Enregistre une tape de parcours (OLD)
//*   @param integer : le numro de parcours
//*   @param integer : le numro de l'tape
//*   @param char : le type d'tape
//*   @param integer : le numro de rang
//*   @param integer : le numro de filire ou d'valuation
//*   @param integer : le numro de theme
//*   @param string : le libelle de fichier
//*   @param integer : le numro de parcours attach
//*   @param bool : 1=> fin de page (affichage en front)
//*   @param bool : o => tape obligatoire et l => tape libre
//*   @param string : nom de l'tape (allias)
//*   @param integer : la dure de l'tape
//*/
//function set_parcours_etape_old($num_parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree){
//    if($finpage=="") $finpage=0;
//    $sql="insert into gestparcours
//            values('$num_parcours','$etape','$numtype','$rang','$num_c_q_e_d','$numtheme','$attach_fic','$attach_parcours',$finpage,'$obligation',$allias,$duree)";
//    echo "sql=$sql<br>";
//    $ins=pg_query($sql);
//    return $ins;
//}
///**
//*   Enregistre une tape de parcours
//*   @param integer : le numro de parcours
//*   @param integer : le numro de l'tape
//*   @param char : le type d'tape
//*   @param integer : le numro de rang
//*   @param integer : le numro de filire ou d'valuation
//*   @param integer : le numro de theme
//*   @param string : le libelle de fichier
//*   @param integer : le numro de parcours attach
//*   @param bool : 1=> fin de page (affichage en front)
//*   @param bool : o => tape obligatoire et l => tape libre
//*   @param string : nom de l'tape (allias)
//*   @param integer : la dure de l'tape
//*/
//function set_parcours_etape($num_parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree){
//    //$etape=11;
//    if(VERSION_BASE>VERSION){
//       $res="select contraintes.af_set_parcours($num_parcours,$etape,null,$obligation,$duree,$finpage)";
//    }
//    else
//        $res=set_parcours_etape_old($num_parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree);
//    return $res;
//}

///**
//*   Supprime un parcours (OLD)
//*
//*   @param integer : le numro du parcours
//*   @return integer : 1 OK, 0 erreur
//*/
//function del_parcours_old($parcours){
//    $sql="delete from parcours where num_parcours=$parcours";
//    $del=pg_query($sql);
//    $sql="delete from gestparcours where g_num_parcours=$parcours";
//    $del=pg_query($sql);
//    $sql="delete from config_orientation where num_parcours=$parcours";
//    $del=pg_query($sql);
//    return $del;
//}
///**
//*   Supprime un parcours
//*
//*   @param integer : le numro du parcours
//*   @return integer : 1 OK, 0 erreur
//*/
//function del_parcours($parcours){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=del_parcours_old($parcours);
//    return $res;
//}

///**
//*   Obtenir les tapes d'un parcours (OLD)
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultat de la requte (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
//*/
//function get_parcours_etapes_old($parcours){
//    $sql="select DISTINCT * from gestparcours where g_num_parcours=$parcours order by num_etape";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les tapes d'un parcours
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultat de la requte
//*/
//function get_parcours_etapes($parcours){
//    if(VERSION_BASE>VERSION){
//        $sql="select * from contraintes.af_get_parcours_etapes($parcours) AS (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)";
//    	$res=pg_query($sql);
//    }
//    else
//        $res=get_parcours_etapes_old($parcours);
//    return $res;
//}

//}

/**
*   Mettre  jour le numro de filiere et de rang d'un parcours copi (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le numro de cours (filiere)
*   @param integer : le numro de rang
*   @return integer : 1
*/
function maj_parcours_filiere_rang_old($parcours,$filiere,$rang){
    $sql="update gestparcours set num_c_q_e_d=$filiere,num_rang=$rang where g_num_parcours=$parcours and num_etape='1'";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le numro de filiere et de rang d'un parcours copi
*
*   @param integer : le numro de parcours
*   @param integer : le numro de cours (filiere)
*   @param integer : le numro de rang
*   @return integer : 1
*/
function maj_parcours_filiere_rang($parcours,$filiere,$rang){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_filiere_rang_old($parcours,$filiere,$rang);
    return $res;
}

/**
*   Mettre  jour l'tape numro 0 d'un parcours (OLD)
*
*   @param integer : le numro de parcours
*   @param string : le libelle de l'tape titre
*   @return integer : 1
*/
function maj_parcours_etape_zero_old($parcours,$etape_titre){
    $sql="update gestparcours set attach_fic='$etape_titre' where g_num_parcours=$parcours and num_etape=0";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour l'tape numro 0 d'un parcours
*
*   @param integer : le numro de parcours
*   @param string : le libelle de l'tape titre
*   @return integer : 1
*/
function maj_parcours_etape_zero($parcours,$etape_titre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_etape_zero_old($parcours,$etape_titre);
    return $res;
}

/**
*   Mettre  jour l'tape numro 1 d'un parcours (OLD)
*
*   @param integer : le numro du parcours
*   @param integer : le numero de theme
*   @param string : le nom du fichier (scnario)
*   @return integer : 1
*/
function maj_parcours_etape_un_old($parcours,$theme,$nom_fichier){
    $sql="update gestparcours set num_thematik='$theme',attach_fic='$nom_fichier' where g_num_parcours=$parcours and num_etape=1";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour l'tape numro 1 d'un parcours
*
*   @param integer : le numro du parcours
*   @param integer : le numero de theme
*   @param string : le nom du fichier (scnario)
*   @return integer : 1
*/
function maj_parcours_etape_un($parcours,$theme,$nom_fichier){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_etape_un_old($parcours,$theme,$nom_fichier);
    return $res;
}

/**
*   Mettre  jour l'tape d'un parcours (OLD)
*
*   @param integer : le numero du parcours
*   @param integer : le numro de l'tape
*   @param char : le type d'tape
*   @param integer : le numro de rang
*   @param integer : le numro de filiere ou d'valuation
*   @param integer : le numro de theme
*   @param string : le libelle de fichier
*   @param integer : le numro de parcours attach
*   @param bool : 1 => fin de page (affichage en front)
*   @param char : o = etape obligatoire , l = libre
*   @param string : nom de l'tape
*   @param integer : la dure de l'tape
*/
function maj_parcours_etape_old($parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree){
    $sql="update gestparcours set type_etape='$numtype',num_rang='$rang',num_c_q_e_d='$num_c_q_e_d',num_thematik='$numtheme',attach_fic='$attach_fic',
    attach_parcours='$attach_parcours',num_etape_suivante='$finpage',obligation='$obligation',nom_etape=$allias,temps_etape=$duree
    where g_num_parcours=$parcours and num_etape=$etape";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour l'tape d'un parcours
*
*   @param integer : le numero du parcours
*   @param integer : le numro de l'tape
*   @param char : le type d'tape
*   @param integer : le numro de rang
*   @param integer : le numro de filiere ou d'valuation
*   @param integer : le numro de theme
*   @param string : le libelle de fichier
*   @param integer : le numro de parcours attach
*   @param bool : 1 => fin de page (affichage en front)
*   @param char : o = etape obligatoire , l = libre
*   @param string : nom de l'tape
*   @param integer : la dure de l'tape
*/
function maj_parcours_etape($parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_etape_old($parcours,$etape,$numtype,$rang,$num_c_q_e_d,$numtheme,$attach_fic,$attach_parcours,$finpage,$obligation,$allias,$duree);
    return $res;
}

///**
//*   Supprimer une tape du parcours  (OLD)
//*
//*   @param integer : le numro du parcours
//*   @param integer : le numro de l'tape  supprimer
//*   @return integer : 1
// */
//function del_parcours_etape_old($parcours,$pere){
//    $sql="delete from gestparcours where g_num_parcours=$parcours and num_etape=$pere";
//    $del=pg_query($sql);
//    return $del;
//}
///**
//*   Supprimer une tape du parcours
//*
//*   @param integer : le numro du parcours
//*   @param integer : le numro de l'tape  supprimer
//*   @return integer : 1
// */
//function del_parcours_etape($parcours,$pere){
//     if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=del_parcours_etape_old($parcours,$pere);
//    return $res;
//}

/**
*   Mettre  jour le numro d'une tape (OLD)
*
*   @param integer : le numro du parcours
*   @param integer : le nouveau numero d'tape
*   @param integer : le numero d'tape  modifier
*   @return integer : 1
*/
function maj_parcours_num_etape_old($parcours,$nouveau_numero,$etape){
    $sql="update gestparcours set num_etape='$nouveau_numero' where g_num_parcours=$parcours and num_etape=$etape";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le numro d'une tape
*
*   @param integer : le numro du parcours
*   @param integer : le nouveau numero d'tape
*   @param integer : le numero d'tape  modifier
*   @return integer : 1
*/
function maj_parcours_num_etape($parcours,$nouveau_numero,$etape){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_num_etape_old($parcours,$nouveau_numero,$etape);
    return $res;
}

///**
//*   Obtenir le numro d'indice de la premire tape d'un parcours  (OLD)
//*	Ce numro peut-etre 0 ou 1.
//*
//*   @param integer : le numro du parcours
//*   @return integer : le numro de la premire tape
//*/
//function get_parcours_numero_premiere_etape_old($parcours){
//    $sql="select min(num_etape) from gestparcours where g_num_parcours=$parcours";
//    $res=pg_query($sql);
//    $row=pg_fetch_row($res,0);
//    return $row[0];
//}
//
///**
//*   Obtenir le numro d'indice de la premire tape d'un parcours.
//* 
//*	Cette fonction est inutile, la premire tape  pour indice NULL.
//*	Elle existe encore par soucis de compatibilit entre les 2 versions de base de donnes.
//*
//*   @param integer : le numro du parcours
//*   @return integer : 'NULL'
//*/
//function get_parcours_numero_premiere_etape($parcours){
//     if(VERSION_BASE>VERSION){
//        return 'NULL';
//    }
//    else
//        $res=get_parcours_numero_premiere_etape_old($parcours);
//    return $res;
//}

/**
*   Obtenir la configuration d'une ressource pour une tape de parcours (OLD)
*
*   @param integer : le numro du parcours
*   @param integer : le numro de l'tape
*   @return integer : le rsultat de requte
*/
function get_parcours_config_ressource_old($parcours,$etape){
    $sql="select * from config_ressource where num_parcours='$parcours' and num_etape=$etape";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir la configuration d'une ressource pour une tape de parcours
*
*   @param integer : le numro du parcours
*   @param integer : le numro de l'tape
*   @return integer : le rsultat de requte
*/
function get_parcours_config_ressource($parcours,$etape){
      if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_config_ressource_old($parcours,$etape);
    return $res;
}

/**
	Obtenir la configuration ressources des etapes d'un parcours pour une formation donne(OLD)
 *
 *	@param integer : le numro du parcours
*   @return integer : le rsultat de requte
*/
function get_parcours_config_ressources_formation_old($parcours,$formation){
	$sql="select * from config_ressource where num_cal=$formation and num_parcours=$parcours";
	//echo "sql=$sql<br>";
 	return (pg_query($sql));
}
/**
	Obtenir la configuration ressources des etapes d'un parcours pour une formation donne(OLD)
 *
 *	@param integer : le numro du parcours
*   @return integer : le rsultat de requte
*/
function get_parcours_config_ressources_formation($parcours,$formation){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_config_ressources_formation_old($parcours,$formation);
    return $res;
}

/**
*   Mettre  jour les parametres d'une tape de parcours  (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero d'tape
*   @param string : l'intitul de l'tape titre
*   @param integer : 1=finpage sinon 0
*/
function maj_parcours_etape_titre_finpage_old($parcours,$etape,$intitule,$finpage){
    $sql="update gestparcours set attach_fic='$intitule',num_etape_suivante='$finpage' where g_num_parcours=$parcours and num_etape=$etape";
    $res=pg_query($sql);
    return $res;
}
/**
*   Mettre  jour les parametres d'une tape de parcours
*
*   @param integer : le numero de parcours
*   @param integer : le numero d'tape
*   @param string : l'intitul de l'tape titre
*   @param integer : 1=finpage sinon 0
*/
function maj_parcours_etape_titre_finpage($parcours,$etape,$intitule,$finpage){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_etape_titre_finpage_old($parcours,$etape,$intitule,$finpage);
    return $res;
}

/**
*   Mettre  jour les parametres d'une tape de parcours  (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero d'tape

*   @param integer : 1=finpage sinon 0
*/
function maj_parcours_etape_finpage_old($parcours,$etape,$finpage){
    $sql="update gestparcours set num_etape_suivante='$finpage' where g_num_parcours=$parcours and num_etape=$etape";
    $res=pg_query($sql);
    return $res;
}
/**
*   Mettre  jour les parametres d'une tape de parcours
*
*   @param integer : le numero de parcours
*   @param integer : le numero d'tape

*   @param integer : 1=finpage sinon 0
*/
function maj_parcours_etape_finpage($parcours,$etape,$finpage){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_etape_finpage_old($parcours,$etape,$finpage);
    return $res;
}

/**
*   Obtenir la configuration d'une ressource pour une etape de parcours et une formation (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero de l'etape
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_parcours_config_ressource_formation_old($parcours,$etape,$formation){
    $sql="select * from config_ressource where num_parcours=$parcours and num_etape=$etape and num_cal=$formation";
    //echo $sql;
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir la configuration d'une ressource pour une etape de parcours et une formation (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero de l'etape
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_parcours_config_ressource_formation($parcours,$etape,$formation){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_config_ressource_formation_old($parcours,$etape,$formation);
    return $res;
}

/**
*   Enregistrement de la configuration d'une ressource pour une etape de parcours et une formation (OLD)
*
*   @param integer : le numero de la formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier
*   @param char : le type de ressource (t=fichier ou t=texte)
*   @param integer : le numero de parcours
*   @param integer : le numero d'etape
*/
function set_parcours_config_ressource_old($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape){
    $sql="insert into config_ressource values('$formation','$espace','$section','$num_fic','$type_numfic','$parcours','$etape')";
    $ins=pg_query($sql);
    return $ins;
}
/**
*   Enregistrement de la configuration d'une ressource pour une etape de parcours et une formation
*
*   @param integer : le numero de la formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier
*   @param char : le type de ressource (t=fichier ou t=texte)
*   @param integer : le numero de parcours
*   @param integer : le numero d'etape
*/
function set_parcours_config_ressource($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_parcours_config_ressource_old($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape);
    return $res;
}

/**
*   Mise  jour de la configuration d'une ressource pour une etape de parcours et une formation (OLD)
*
*   @param integer : le numero de la formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier
*   @param char : le type de ressource (t=fichier ou t=texte)
*   @param integer : le numero de parcours
*   @param integer : le numero d'etape
*/
function maj_parcours_config_ressource_old($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape){
    $sql="update config_ressource set num_espace='$espace',num_section=$section,num_fic='$num_fic',type='$type_numfic'
            where num_cal=$formation and num_parcours=$parcours and num_etape=$etape";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mise  jour de la configuration d'une ressource pour une etape de parcours et une formation
*
*   @param integer : le numero de la formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier
*   @param char : le type de ressource (t=fichier ou t=texte)
*   @param integer : le numero de parcours
*   @param integer : le numero d'etape
*/
function maj_parcours_config_ressource($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_config_ressource_old($formation,$espace,$section,$num_fic,$type_numfic,$parcours,$etape);
    return $res;
}

///**
//*   Obtenir la configuration d'un parcours dynamique (OLD)
//*
//*   @param integer : le numro du parcours
//*   @return integer : le resultat de la requte
//*/
//function get_parcours_config_orientation_old($parcours){
//    $sql="select * from config_orientation where num_parcours=$parcours";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir la configuration d'un parcours dynamique
//*
//*   @param integer : le numro du parcours
//*   @return integer : le resultat de la requte
//*/
//function get_parcours_config_orientation($parcours){
//     if(VERSION_BASE>VERSION){
//        $sql="select * from contraintes.af_get_parcours_oriente($parcours)";
//    	$res=pg_query($sql);
//    }
//    else
//        $res=get_parcours_config_orientation_old($parcours);
//    return $res;
//}

///**
//*   Enregistrer la configuration d'un parcours dynamique  (OLD)
//*
//*   @param integer : le numro de parcours
//*   @param string : la liste des seuils
//*   @param string : la liste des modules (sous-parcours)
//*   @return integer : 1
//*/
//function set_parcours_config_orientation_old($parcours,$liste_seuil,$liste_module){
//    $sql="insert into config_orientation values('$parcours','$liste_seuil','$liste_module')";
//    $ins=pg_query($sql);
//    return $ins;
//}
///**
//*   Enregistrer la configuration d'un parcours dynamique
//*
//*   @param integer : le numro de parcours
//*   @param string : la liste des seuils
//*   @param string : la liste des modules (sous-parcours)
//*   @return integer : 1
//*/
//function set_parcours_config_orientation($parcours,$liste_seuil,$liste_module){
//     if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=set_parcours_config_orientation_old($parcours,$liste_seuil,$liste_module);
//    return $res;
//}

/**
*   Mettre  jour la configuration d'un parcours dynamique  (OLD)
*
*   @param integer : le numro de parcours
*   @param string : la liste des seuils
*   @param string : la liste des modules (sous-parcours)
*   @return integer : 1
*/
function maj_parcours_config_orientation_old($parcours,$liste_seuil,$liste_module){
    $sql="update config_orientation set seuil='$liste_seuil',sousparcours='$liste_module' where num_parcours=$parcours";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour la configuration d'un parcours dynamique
*
*   @param integer : le numro de parcours
*   @param string : la liste des seuils
*   @param string : la liste des modules (sous-parcours)
*   @return integer : 1
*/
function maj_parcours_config_orientation($parcours,$liste_seuil,$liste_module){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_config_orientation_old($parcours,$liste_seuil,$liste_module);
    return $res;
}

///**
//*   Supprimer la configuration d'un parcours dynamique (OLD)
//*
//*   @param integer : le numero de parcours
//*   @return integer : 1
//*/
//function del_parcours_config_orientation_old($parcours){
//    $sql="delete from config_orientation where num_parcours=$parcours";
//    $del=pg_query($sql);
//    return $del;
//}
///**
//*   Supprimer la configuration d'un parcours dynamique
//*
//*   @param integer : le numero de parcours
//*   @return integer : 1
//*/
//function del_parcours_config_orientation($parcours){
//     if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=del_parcours_config_orientation_old($parcours);
//    return $res;
//}

/**
*   Mettre  jour le nom d'une tape (OLD)
*
*   @param integer : le numro de parcours
*   @param string : le nom pour l'tape
*   @param integer : le numro d'tape
*   @return intger : 1
*/
function maj_parcours_nom_etape_old($parcours,$libelle,$etape){
    $sql="update gestparcours set nom_etape='$libelle' where g_num_parcours=$parcours and num_etape=$etape";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le nom d'une tape
*
*   @param integer : le numro de parcours
*   @param string : le nom pour l'tape
*   @param integer : le numro d'tape
*   @return intger : 1
*/
function maj_parcours_nom_etape($parcours,$libelle,$etape){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_nom_etape_old($parcours,$libelle,$etape);
    return $res;
}

///**
//*   Mettre  jour le nom d'une tape par type(OLD)
//*
//*   @param integer : le numro de parcours
//* 	@param char : le type d'tape
//*   @param string : le nom pour l'tape
//*   @return intger : 1
//*/
//function maj_parcours_type_etape_personnalise_old($parcours,$type,$libelle){
//    $sql="update gestparcours set nom_etape='$libelle' where g_num_parcours=$parcours and type_etape='$type'";
//    $maj=pg_query($sql);
//    return $maj;
//}
///**
//*   Mettre  jour le nom d'une tape par type
//*
//*   @param integer : le numro de parcours
//* 	@param char : le type d'tape
//*   @param string : le nom pour l'tape
//*   @return intger : 1
//*/
//function maj_parcours_type_etape_personnalise($parcours,$type,$libelle){
//    if(VERSION_BASE>VERSION){
//        $sql="SELECT * FROM contraintes.af_maj_parcours_type_etape_personnalise($parcours,$type,'$libelle')";
//    	$maj=pg_query($sql);
//    }
//    else
//        $res=maj_parcours_nom_type_etape_old($parcours,$type,$libelle);
//    return $res;
//}

///**
//*   Mettre  jour la dure d'une tape (OLD)
//*
//*   @param integer : le numro de parcours
//*   @param integer : la dure pour l'tape
//*   @param integer : le numro d'tape
//*   @return intger : 1
//*/
//function maj_parcours_duree_etape_old($parcours,$duree,$etape){
//    $sql="update gestparcours set temps_etape='$duree' where g_num_parcours=$parcours and num_etape=$etape";
//    $maj=pg_query($sql);
//    return $maj;
//}
///**
//*   Mettre  jour la duree d'une tape
//*
//*   @param integer : le numro de parcours
//*   @param integer : la duree pour l'tape
//*   @param integer : le numro d'tape
//*   @return intger : 1
//*/
//function maj_parcours_duree_etape($parcours,$duree,$etape){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=maj_parcours_duree_etape_old($parcours,$duree,$etape);
//    return $res;
//}

///**
//*   Mettre  jour la dure d'une tape par type(OLD)
//*
//*   @param integer : le numro de parcours
//*   @param integer : la dure pour l'tape
//*   @param char : le type d'tape
//*   @return intger : 1
//*/
//function maj_parcours_duree_type_etape_old($parcours,$duree,$type){
//    $sql="update gestparcours set temps_etape='$duree' where g_num_parcours=$parcours and type_etape='$type'";
//    $maj=pg_query($sql);
//    return $maj;
//}
///**
//*   Mettre  jour la dure d'une tape par type
//*
//*   @param integer : le numro de parcours
//*   @param integer : la dure pour l'tape
//*   @param integer : le type d'tape
//*   @return intger : 1
//*/
//function maj_parcours_duree_type_etape($parcours,$duree,$type){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=maj_parcours_duree_type_etape_old($parcours,$duree,$type);
//    return $res;
//}

///**
//*   Mettre  jour l'option d'affichage des dures (OLD)
//*
//*   @param integer : le numro de parcours
//*   @param bool : t=affichage f=pas d'affichage
//*   @return integer : 1
//*/
//function maj_parcours_affichage_duree_old($parcours,$valeur){
//    $sql="update parcours set affiche_fo='$valeur' where num_parcours=$parcours";
//    $maj=pg_query($sql);
//    return $maj;
//}
///**
//*   Mettre  jour l'option d'affichage des dures
//*   @param integer : le numro de parcours
//*   @param bool : t=affichage f=pas d'affichage
//*   @return integer : 1
//*/
//function maj_parcours_affichage_duree($parcours,$valeur){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=maj_parcours_affichage_duree_old($parcours,$valeur);
//    return $res;
//}

///**
//*   Obtenir les diffrents temps d'tape pour un type (OLD)
//*
//*   @param integer : le numro de parcours
//*   @param char : le type d'tape
//*   @return integer : le resultat de la requete
//*/
//function get_parcours_duree_type_etape_old($parcours,$type){
//    $sql="select distinct temps_etape from gestparcours where g_num_parcours='$parcours' and type_etape='$type'";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les diffrents temps d'tape pour un type
//*
//*   @param integer : le numro de parcours
//*   @param char : le type d'tape
//*   @return integer : le resultat de la requete
//*/
//function get_parcours_duree_type_etape($parcours,$type){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_duree_type_etape_old($parcours,$type);
//    return $res;
//}

///**
//*   Obtenir les diffrents type d'tape d'un parcours  (OLD)
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultatde la requte
//*/
//function get_parcours_types_etape_old($parcours){
//    $sql="select distinct type_etape from gestparcours where g_num_parcours=$parcours";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les diffrents type d'tape d'un parcours
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultatde la requte
//*/
//function get_parcours_types_etape($parcours){
//     if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_types_etape_old($parcours);
//    return $res;
//}

///**
//*   Obtenir le nom d'etape de parcours pour un type donn  (OLD)
//*
//*   @param integer : le numro de parcours
//*   @param char : le type d'tape
//*   @return integer : le rsultat de la requte
//*/
//function get_parcours_noms_type_etape_old($parcours,$type){
//    $sql="select distinct nom_etape from gestparcours where g_num_parcours=$parcours and type_etape='$type'";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir le nom d'etape de parcours pour un type donn
//*
//*   @param integer : le numro de parcours
//*   @param char : le type d'tape
//*   @return integer : le rsultat de la requte
//*/
//function get_parcours_noms_type_etape($parcours,$type){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_noms_type_etape_old($parcours,$type);
//    return $res;
//}

/**
*   Obtenir les parcours attachs d'un parcours (OLD)
*
*   @param integer : le numro de parcours
*   @return integer : le resultat de la requete
*/
function get_parcours_parcours_attaches_old($parcours){
    $sql="select attach_parcours from gestparcours where g_num_parcours=$parcours and attach_parcours>0 and type_etape='T'";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les parcours attachs d'un parcours
*
*   @param integer : le numro de parcours
*   @return integer : le resultat de la requete
*/
function get_parcours_parcours_attaches($parcours){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_parcours_attaches_old($parcours);
    return $res;
}

///**
//*   Obtenir les noms d'tape d'un parcours (OLD)
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultat de la requte
//*/
//function get_parcours_noms_etape_old($parcours){
//    $sql="select nom_etape from gestparcours where g_num_parcours=$parcours and nom_etape <>'' ";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les noms d'tape d'un parcours
//*
//*   @param integer : le numro de parcours
//*   @return integer : le rsultat de la requte
//*/
//function get_parcours_noms_etape($parcours){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_noms_etape_old($parcours);
//    return $res;
//}

/**
*   Vrifie si un parcours est aussi un parcours attach (OLD)
*
*   @param integer : le numro de parcours
*   @return intefer : 1=vrai et 0=faux
*/
function check_parcours_attache_old($parcours){
    $sql="select * from gestparcours where attach_parcours='$parcours' and type_etape='T'";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return 1;
    else
        return 0;
}
/**
*   Vrifie si un parcours est aussi un parcours attach
*
*   @param integer : le numro de parcours
*   @return intefer : 1=vrai et 0=faux
*/
function check_parcours_attache($parcours){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_parcours_attache_old($parcours);
    return $res;
}

///**
//    Obtenir le type d'une tape de parcours (OLD)
//    @param integer : le numro de parcours
//    @param integer : le numro d'tape
//    @return char : le type de l'tape
//*/
//function get_parcours_type_etape_old($parcours,$etape){
//    $sql="select type_etape from gestparcours where g_num_parcours=$parcours and num_etape=$etape";
//    $res=pg_query($sql);
//    $row=pg_fetch_row($res,0);
//    return $row[0];
//}
///**
//    Obtenir le type d'une tape de parcours
//    @param integer : le numro de parcours
//    @param integer : le numro d'tape
//    @return char : le type de l'tape
//*/
//function get_parcours_type_etape($parcours,$etape){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_type_etape_old($parcours,$etape);
//    return $res;
//}

/**
    Mettre  jour le numro d'tape d'une configuration de ressource dans un parcours (OLD)

    @param integer : le numro de parcours
    @param integer : le nouveau numro d'tape
    @param integer : le numro d'tape  modifier
    @return integer : 1
*/
function maj_parcours_num_etape_config_ressource_old($parcours,$nouveau_numero,$etape){
    $sql="update config_ressource set num_etape='$nouveau_numero' where num_parcours=$parcours and num_etape=$etape";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour le numro d'tape d'une configuration de ressource dans un parcours

    @param integer : le numro de parcours
    @param integer : le nouveau numro d'tape
    @param integer : le numro d'tape  modifier
    @return integer : 1
*/
function maj_parcours_num_etape_config_ressource($parcours,$nouveau_numero,$etape){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_parcours_num_etape_config_ressource_old($parcours,$nouveau_numero,$etape);
    return $res;
}

/**
    Obtenir les infos sur la filiere d'un parcours (OLD)

    @param integer : le numero de parcours
    @return integer : le resultat de la requete
*/
function get_parcours_filiere_infos_old($parcours){
    $sql="select * from filiere where id in (select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and num_etape='1')";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos sur la filiere d'un parcours

    @param integer : le numero de parcours
    @return integer : le resultat de la requete
*/
function get_parcours_filiere_infos($parcours){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_parcours_filiere_infos_old($parcours);
    return $res;
}

/**
    Vrifie si un parcours est en formation (OLD)

    @param integer : le numero de parcours
    @return integer : 1 =oui    0=non
*/
function check_parcours_formation_old($parcours){
    $sql="select * from gestionnaire where g_num_parcours=$parcours";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    return 1;
}
/**
    Vrifie si un parcours est en formation

    @param integer : le numero de parcours
    @return integer : 1 =oui    0=non
*/
function check_parcours_formation($parcours){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_parcours_formation_old($parcours);
    return $res;
}

///**
//    Obtenir l'avancement max dans un parcours en formation (OLD)
//
//    @param integer : le numero de parcours
//    @return integer : l'avancement max
//*/
//function get_parcours_avancement_max_old($parcours){
//    $sql="select max(avancement) from gestionparcours where gp_num_parcours=$parcours";
//    $res=pg_query($sql);
//    $row=pg_fetch_row($res,0);
//    return $row[0];
//}
///**
//    Obtenir l'avancement max dans un parcours en formation
//
//    @param integer : le numero de parcours
//    @return integer : l'avancement max
//*/
//function get_parcours_avancement_max($parcours){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_parcours_avancement_max_old($parcours);
//    return $res;
//}


?>