<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
       @package parcours
       @modulegroup plpgsql
       @module plpgsql_parcours
*/
//include ("$chemin_bo/lib/parcours/plpgsql_deprecated_parcours.inc");

/**
	Obtenir les numeros de formation d'un parcours (OLD)
	
	@param string : le numero du parcours
	@return integer : le resultat de la requete (formation_pere int4, parcours_pere int4)
*/
function get_parcours_formations_old($parcours) {
	$sql = "select distinct g_num_cal,g_num_parcours from gestionnaire where g_num_parcours=$parcours";
	return pg_query($sql);

}
/**
	Obtenir les numeros de formation d'un parcours 
	
	@param string : le numero du parcours
	@return integer : le resultat de la requete (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)
*/
function get_parcours_formations($parcours,$ordre="ASC",$order_by="libelle") {
	if (VERSION_BASE > VERSION) {
		if($order_by=="libelle")$v_type="ORDER BY $order_by $ordre";
		else $v_type ="ORDER BY $order_by $ordre";
		$sql = "SELECT * FROM contraintes.af_get_parcours_formations($parcours) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool)$v_type ";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_parcours_formations_old($parcours);
	return $res;
}

/**
	Obtenir les numeros de formation lies  un parcours (OLD)
	
	@param string : le numero du parcours
	@return integer : le resultat de la requete (formation_pere int4, parcours_pere int4)
*/
function get_parcours_all_formations_old($parcours) {
	$sql = "select distinct g_num_cal,g_num_parcours from gestionnaire where g_num_parcours=$parcours";
	return pg_query($sql);

}
/**
	Obtenir les numeros de formation lies  un parcours 
	
	@param string : le numero du parcours
	@return integer : le resultat de la requete (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)
*/
function get_parcours_all_formations($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_all_formations($parcours) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_parcours_all_formations_old($parcours);
	return $res;
}

/**
	Obtenir les parcours peres d'un parcours attache (OLD)
	
	@param integer : le numero du parcours attach
	@return integer : le resultat de la requete (parcours_pere int4)
*/
function get_parcours_parcours_pere_old($parcours) {
	$sql = "select distinct g_num_parcours from gestparcours where attach_parcours=$parcours and type_etape='T'";
	return pg_query($sql);
}

/**
	Obtenir les parcours peres d'un parcours attache 
	
	@param integer : le numero du parcours attach
	@return integer : le resultat de la requete (parcours_pere int4)
*/
function get_parcours_parcours_pere($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_parcours_pere($parcours) ";
		//echo "$sql<BR>";
		return pg_query($sql);
	} else
		$res = get_parcours_parcours_pere_old($parcours);
	return $res;
}

/**
*   Vrifie si un parcours est une tape de parcours ( cad parcours attach ou sous-parcours) (OLD)
*
*   @param integer : le numro de parcours
*   @return bool : true si le parcours est une tape, false sinon
*/
function is_parcours_etape_old($parcours) {
	$sql = "select * from gestparcours where attach_parcours=$parcours and type_etape='T'";
	//echo "$sql<BR>";
	$res = pg_query($sql);
	if (pg_numrows($res) > 0)
		return true;
	else
		return false;
}

/**
*   Vrifie si un parcours est une tape de parcours ( cad parcours attach ou sous-parcours)
*
*   @param integer : le numro de parcours
*   @return bool : true si le parcours est une tape, false sinon
*/
function is_parcours_etape($parcours) {
	if (VERSION_BASE > VERSION) {
		$res = get_etape_parcourss($parcours);
		if (pg_num_rows($res) > 0)
			return true;
		else
			return false;
	} else
		return is_parcours_etape_old($parcours);
}

/**
*	Obtenir les proprits d'un parcours. (OLD)
*
*	@param integer: le numero du parcours
*	@return integer : l'entier resultat de la requete  (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_parcours_old($parcours) {

	$req = "select DISTINCT num_parcours, nom_parcours, num_c_q_e_d, affiche_fo from parcours LEFT OUTER JOIN gestparcours ON(num_parcours=g_num_parcours AND num_etape=1) where num_parcours=$parcours ";
	//echo $req."<br>";
	$res = pg_query($req);

	return $res;
}

/**
*	Obtenir les proprits d'un parcours
*
*	@param integer: le numero du parcours
*	@return integer : l'entier resultat de la requete  (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp)
*/
function get_parcours($parcours) {

	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_get_parcours($parcours) AS (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp)";
		//echo $req."<br>";
		$res = pg_query($req);

	} else
		$res = get_parcours_old($parcours);

	return $res;
}

/**
* Retourne un numro donnant le mode d'affichage du parcours.
* 0 : Affichage par dfaut, 10 tapes par page
* 1 : On affiche une page par tape titre.
* 2 : On affiche toutes les tapes jusqu' une tape fin de page, puis on change de page.
* 
* Le mode d'affichage fonctionne avec la priorit suivante: mode 2, mode 1, mode 0.
* 
* @param integer : numro de parcours
* @return integer : mode d'affichage : 0=classique, 1=titre & 3=fin de page
*/
function get_parcours_mode_affichage_old($parcours) {
	return (pg_result(pg_query("SELECT _af_get_mode_affichage_parcours($parcours) ; "), 0, 0));
}

/**
* Retourne un numro donnant le mode d'affichage du parcours.
* 0 : Affichage par dfaut, 10 tapes par page
* 1 : On affiche une page par tape titre.
* 2 : On affiche toutes les tapes jusqu' une tape fin de page, puis on change de page.
* 
* Le mode d'affichage fonctionne avec la priorit suivante: mode 2, mode 1, mode 0.
* 
* @param integer : numro de parcours
* @return integer : mode d'affichage : 0=classique, 1=titre & 3=fin de page
*/
function get_parcours_mode_affichage($parcours) {
	if (VERSION_BASE > VERSION) {
		return (pg_result(pg_query("SELECT _af_get_mode_affichage_parcours($parcours) ; "), 0, 0));
	} else
		return get_parcours_mode_affichage_old($parcours);
}

/**
*   Obtenir les tapes d'un parcours (OLD)
*
*   @param integer : le numro de parcours
*   @return integer : le rsultat de la requte (id int4, libelle_alias varchar, libelle_etape varchar, libelle_type_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
*/
function get_parcours_etapes_old($parcours) {
	global $MSG_1267, $MSG_776, $MSG_926, $MSG_516, $MSG_1834, $MSG_928, $MSG_927, $MSG_922, $MSG_282, $MSG_2035,$MSG_1503a;
	
	$sql = "SELECT DISTINCT CASE 
									WHEN type_etape='S' OR type_etape='I' THEN attach_fic
									WHEN type_etape='T' THEN CAST(attach_parcours AS varchar) 
									WHEN type_etape='F' OR type_etape='P' OR type_etape='R' THEN CAST(num_etape AS varchar)
									ELSE CAST(num_c_q_e_d AS varchar) 
								  END AS id,
								  CASE
									WHEN type_etape='R' OR type_etape='I'THEN attach_fic
									WHEN type_etape='S' THEN allias
									ELSE NULL
								  END AS libelle_allias,
								  CASE
									WHEN type_etape='B' THEN B.titre
									WHEN type_etape='C' THEN B.titre
									WHEN type_etape='E' THEN E.titre
									WHEN type_etape='F' THEN NULL
									WHEN type_etape='I' THEN attach_fic
									WHEN type_etape='L' THEN NULL
									WHEN type_etape='P' THEN NULL
									WHEN type_etape='R' THEN NULL
									WHEN type_etape='S' THEN attach_fic
									WHEN type_etape='T' THEN nom_parcours
									WHEN type_etape='Z' THEN NULL
									ELSE NULL
								   END AS libelle_etape,
								 nom_etape AS libelle_type_etape, type_etape, num_etape, g_num_parcours, 
								CASE 
									WHEN obligation='o' THEN 't'
									ELSE 'f'
								  END AS obliga ,
		
								 temps_etape, 
								CASE 
									WHEN num_etape_suivante=0 THEN 'f'
									ELSE 't'
								  END AS fin_page,
								CASE 
									WHEN type_etape='B' THEN '" . $MSG_1267 . "'
									WHEN type_etape='C' THEN '" . $MSG_1503a . "'
									WHEN type_etape='E' THEN '" . $MSG_776 . "'
									WHEN type_etape='F' THEN '" . $MSG_926 . "'
									WHEN type_etape='I' THEN '" . $MSG_516 . "'
									WHEN type_etape='L' THEN '" . $MSG_1834 . "'
									WHEN type_etape='P' THEN '" . $MSG_928 . "'
									WHEN type_etape='R' THEN '" . $MSG_927 . "'
									WHEN type_etape='S' THEN '" . $MSG_922 . "'
									WHEN type_etape='T' THEN '" . $MSG_282 . "'
									WHEN type_etape='Z' THEN '" . $MSG_2035 . "'
									ELSE ''
								END AS libelle_type_etape,
								nom_etape 
					FROM ((((gestparcours 
						LEFT OUTER JOIN allias_fichier ON (attach_fic=libelle AND num_thematik=theme))
						LEFT OUTER JOIN exotlc E ON (num_exo=num_c_q_e_d))
						LEFT OUTER JOIN serie_exo B ON (id=num_c_q_e_d))
						LEFT OUTER JOIN parcours  ON (num_parcours=attach_parcours))
					WHERE g_num_parcours=$parcours order by num_etape";
				
	 
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les tapes d'un parcours
*
*   @param integer : le numro de parcours
*   @return integer : le rsultat de la requte (id int4, libelle_alias varchar, libelle_etape varchar, libelle_type_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)
*/
function get_parcours_etapes($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_parcours_etapes($parcours) AS (id int4, libelle varchar, libelle_bis varchar, libelle_alias  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_parcours_etapes_old($parcours);
	return $res;
}

/**
*   Obtenir le numro d'indice de la premire tape d'un parcours  (OLD)
*	Ce numro peut-etre 0 ou 1.
*
*   @param integer : le numro du parcours
*   @return integer : le numro de la premire tape
*/
function get_parcours_numero_premiere_etape_old($parcours) {
	$sql = "select min(num_etape) from gestparcours where g_num_parcours=$parcours";
	$res = pg_query($sql);
	$row = pg_fetch_row($res, 0);
	return $row[0];
}

/**
*   Obtenir le numro d'indice de la premire tape d'un parcours.
* 
*	Cette fonction est inutile, la premire tape  pour indice NULL.
*	Elle existe encore par soucis de compatibilit entre les 2 versions de base de donnes.
*
*   @param integer : le numro du parcours
*   @return integer : 'NULL'
*/
function get_parcours_numero_premiere_etape($parcours) {
	if (VERSION_BASE > VERSION) {
		return 'NULL';
	} else
		$res = get_parcours_numero_premiere_etape_old($parcours);
	return $res;
}

/**
*   Obtenir les informations d'une etape de parcours  (OLD)
*
*   @param integer : le numero du parcours
*   @param integer : le numero de l'tape
*   @return integer : le rsultat de la requte (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
*/
function get_parcours_etape_fille_old($parcours, $etape_pere) {
	global $MSG_1267, $MSG_776, $MSG_926, $MSG_516, $MSG_1834, $MSG_928, $MSG_927, $MSG_922, $MSG_282, $MSG_2035;
	$sql = "SELECT DISTINCT CASE 
									WHEN type_etape='S' OR type_etape='R' THEN attach_fic
									WHEN type_etape='T' THEN CAST(attach_parcours AS varchar) 
									ELSE CAST(num_c_q_e_d AS varchar) 
								  END AS id,
								  CASE
									WHEN type_etape='R' OR type_etape='I'THEN attach_fic
									WHEN type_etape='S' THEN allias
									ELSE NULL
								  END AS libelle_allias,
								  CASE
									WHEN type_etape='B' THEN B.titre
									WHEN type_etape='C' THEN B.titre
									WHEN type_etape='E' THEN E.titre
									WHEN type_etape='F' THEN NULL
									WHEN type_etape='I' THEN attach_fic
									WHEN type_etape='L' THEN NULL
									WHEN type_etape='P' THEN NULL
									WHEN type_etape='R' THEN NULL
									WHEN type_etape='S' THEN NULL
									WHEN type_etape='T' THEN nom_parcours
									WHEN type_etape='Z' THEN NULL
									ELSE NULL
								   END AS libelle_etape,
								 nom_etape AS libelle_type_etape, type_etape, num_etape, g_num_parcours, 
								CASE 
									WHEN obligation='o' THEN 't'
									ELSE 'f'
								  END AS obliga ,
		
								 temps_etape, 
								CASE 
									WHEN num_etape_suivante=0 THEN 'f'
									ELSE 't'
								  END AS fin_page,
								CASE 
									WHEN type_etape='B' THEN '" . $MSG_1267 . "'
									WHEN type_etape='C' THEN '" . $MSG_1267 . "'
									WHEN type_etape='E' THEN '" . $MSG_776 . "'
									WHEN type_etape='F' THEN '" . $MSG_926 . "'
									WHEN type_etape='I' THEN '" . $MSG_516 . "'
									WHEN type_etape='L' THEN '" . $MSG_1834 . "'
									WHEN type_etape='P' THEN '" . $MSG_928 . "'
									WHEN type_etape='R' THEN '" . $MSG_927 . "'
									WHEN type_etape='S' THEN '" . $MSG_922 . "'
									WHEN type_etape='T' THEN '" . $MSG_282 . "'
									WHEN type_etape='Z' THEN '" . $MSG_2035 . "'
									ELSE ''
								END AS libelle_type_etape,
								nom_etape 
					FROM ((((gestparcours 
						LEFT OUTER JOIN allias_fichier ON (attach_fic=libelle AND num_thematik=theme))
						LEFT OUTER JOIN exotlc E ON (num_exo=num_c_q_e_d))
						LEFT OUTER JOIN serie_exo B ON (id=num_c_q_e_d))
						LEFT OUTER JOIN parcours  ON (num_parcours=attach_parcours))
					WHERE g_num_parcours=$parcours
					AND num_etape=$etape_pere order by num_etape";
	//echo "$sql<br>";
	echo"parcours=$parcours etape_pere=$etape_pere<br>";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les informations d'une etape de parcours
*
*   @param integer : le numero du parcours
*   @param integer : le numero de l'tape
*   @return integer : le rsultat de la requte (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape varchar, type int4, pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)
*/
function get_parcours_etape_fille($parcours, $etape_pere) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_parcours_etape_fille($parcours,$etape_pere) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape varchar, type varchar, pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_parcours_etape_fille_old($parcours, $etape_pere);
	return $res;
}

/**
	Obtenir les thmes d'un scenario pour un parcours.(OLD)
	
	@param integer : le numro du scenario
	@return integer : le resultat de la requete  (id int4, libelle varchar)
*/
function get_parcours_scenario_themes_old($parcours, $scenario) {
	$req = "SELECT DISTINCT num_thematik, nom_theme FROM gestparcours, themedir WHERE g_num_parcours=$parcours AND attach_fic LIKE '$scenario' AND type_etape='S' AND num_thematik=num_themedir";
	//echo "$req<br>";
	return pg_query($req);
}

/**
 * Obtenir les thmes d'un scenario .
 * 
 * @param integer : le numero du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_parcours_scenario_themes($parcours, $scenario) {
	if (VERSION_BASE > VERSION) {
		return get_scenario_themes($scenario);
	} else {
		return get_parcours_scenario_themes_old($parcours, $scenario);
	}
}
/**
 * Obtenir les informations d'une tape de parcours.
 * 
 * @param integer : numro du parcours
 * @param integer : numro de l'tape
 * @param integer : type de l'tape
 * @return integer : resultat de la requete (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
 */
function get_parcours_etape_old($parcours, $etape, $type) {
	global $MSG_1267, $MSG_776, $MSG_926, $MSG_516, $MSG_1834, $MSG_928, $MSG_927, $MSG_922, $MSG_282, $MSG_2035;

	$sql = "SELECT DISTINCT CASE 
									WHEN type_etape='S' OR type_etape='R' THEN attach_fic
									WHEN type_etape='T' THEN CAST(attach_parcours AS varchar) 
									ELSE CAST(num_c_q_e_d AS varchar) 
								  END AS id,
								  CASE
									WHEN type_etape='R' OR type_etape='I'THEN attach_fic
									WHEN type_etape='S' THEN allias
									ELSE NULL
								  END AS libelle_allias,
								  CASE
									WHEN type_etape='B' THEN B.titre
									WHEN type_etape='C' THEN B.titre
									WHEN type_etape='E' THEN E.titre
									WHEN type_etape='F' THEN NULL
									WHEN type_etape='I' THEN NULL
									WHEN type_etape='L' THEN NULL
									WHEN type_etape='P' THEN NULL
									WHEN type_etape='R' THEN NULL
									WHEN type_etape='S' THEN attach_fic
									WHEN type_etape='T' THEN nom_parcours
									WHEN type_etape='Z' THEN NULL
									ELSE NULL
								   END AS libelle_etape,
								 nom_etape AS libelle_type_etape, type_etape, num_etape, g_num_parcours, 
								CASE 
									WHEN obligation='o' THEN 't'
									ELSE 'f'
								  END AS obliga ,
		
								 temps_etape, 
								CASE 
									WHEN num_etape_suivante=0 THEN 'f'
									ELSE 'f'
								  END AS fin_page,
								CASE 
									WHEN type_etape='B' THEN '" . $MSG_1267 . "'
									WHEN type_etape='C' THEN '" . $MSG_1267 . "'
									WHEN type_etape='E' THEN '" . $MSG_776 . "'
									WHEN type_etape='F' THEN '" . $MSG_926 . "'
									WHEN type_etape='I' THEN '" . $MSG_516 . "'
									WHEN type_etape='L' THEN '" . $MSG_1834 . "'
									WHEN type_etape='P' THEN '" . $MSG_928 . "'
									WHEN type_etape='R' THEN '" . $MSG_927 . "'
									WHEN type_etape='S' THEN '" . $MSG_922 . "'
									WHEN type_etape='T' THEN '" . $MSG_282 . "'
									WHEN type_etape='Z' THEN '" . $MSG_2035 . "'
									ELSE ''
								END AS libelle_type_etape,
								nom_etape  
					FROM ((((gestparcours 
						LEFT OUTER JOIN allias_fichier ON (attach_fic=libelle AND num_thematik=theme))
						LEFT OUTER JOIN exotlc E ON (num_exo=num_c_q_e_d))
						LEFT OUTER JOIN serie_exo B ON (id=num_c_q_e_d))
						LEFT OUTER JOIN parcours  ON (num_parcours=attach_parcours))
					WHERE g_num_parcours=$parcours
					AND num_etape=$etape order by num_etape";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;

	//	switch ($type) {
	//		case 'S':
	//			$sql="select DISTINCT  attach_fic,attach_fic, nom_etape, type_etape, num_etape, g_num_parcours, 
	//						CASE 
	//							WHEN obligation='o' THEN 't'
	//							ELSE 'f'
	//						  END AS obliga , temps_etape, num_etape_suivante from gestparcours where g_num_parcours=$parcours 
	//							AND attach_fic='$etape' ";
	//			break;
	//		case 'T':
	//			return get_parcours($etape);
	//			break;
	//		case 'F':
	//			
	//			break;	
	//		case 'R':
	//			
	//			break;
	//		case 'P':
	//			
	//			break;
	//		case 'I':
	//			$sql="select DISTINCT  attach_fic,attach_fic, nom_etape, type_etape, num_etape, g_num_parcours, 
	//						CASE 
	//							WHEN obligation='o' THEN 't'
	//							ELSE 'f'
	//						  END AS obliga , temps_etape, num_etape_suivante from gestparcours where g_num_parcours=$parcours 
	//							AND attach_fic='$etape' ";
	//			break;
	//			break;
	//		case 'B':
	//		case 'C':
	//			
	//			break;
	//		case 'L':
	//			
	//			break;
	//		case 'Z':
	//			
	//			break;			
	//		default:
	//			break;
	//	}
	//	$res=pg_query($sql);
	//    return $res;
}

/**
 * Obtenir les informations d'une tape de parcours.
 * 
 * @param integer : numro du parcours
 * @param integer : numro de l'tape
 * @param integer : type de l'tape
 * @return integer : resultat de la requete (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)
 */
function get_parcours_etape($parcours, $etape, $type = "") {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_parcours_etape($parcours,$etape) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)";
		//echo "$sql<br>";
		return pg_query($sql);
	} else {
		return get_parcours_etape_old($parcours, $etape, $type);
	}
}

/**
    Obtenir l'avancement maximal dans un parcours en formation (OLD).
	Le resultat retourn est le nombre d'etape maximal qui ait t fait par un stagiaire dans ce parcours, quelque soit la formation ou la classe.
	
    @param integer : le numero de parcours
    @return integer : le nombre d'etape maximal qui ait t fait par un stagiaire dans ce parcours.
*/
function get_parcours_avancement_max_old($parcours) {
	$sql = "select max(avancement) from gestionparcours where gp_num_parcours=$parcours";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
    Obtenir l'avancement maximal dans un parcours en formation.
	Le resultat retourn contient les information de l'tape la plus loin du parcours
	qui a t faites par un stagiaire, quelque soit la formation ou la classe.
	
    @param integer : le numero de parcours
    @return integer : resultat de la requete (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)
*/
function get_parcours_avancement_max($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_parcours_avancement_max($parcours) AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar)";
		$res = pg_query($sql);
	} else
		$res = get_parcours_avancement_max_old($parcours);
	return $res;
}

/**
 * Obtenir les tapes d'un type donn qui sont dans un parcours.(OLD)
 * 
 * @param integer : numro du parcours
 * @param integer : type d'tape voulu
 * @return integer : resultat de la requete : (id int4, libelle_pour_parcours varchar, libelle_etape  varchar, type int4,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool)
 */
function get_parcours_etapes_type_old($parcours, $type) {
	//$type=get_etape_type_new_old($type);
	switch($type){
			 case 1 :$old_type= "T";break;
			case 2 :$old_type= "F"; break;
			case 3 :$old_type=	 "Z"; break;
			case 4 : $old_type= "B"; break;
			case 5 :$old_type=	 "E"; break;
			case 6 :$old_type=	 "S"; break;
			case 7 :$old_type=	 "R"; break;
			case 8 :$old_type=	 "P"; break;
			case 9 :$old_type=	 "I"; break;
			case 10 : $old_type= "O"; break;
		}
		
	$sql = "SELECT DISTINCT G1.num_etape, G1.num_etape,G1.nom_etape, G1.type_etape, G1.num_etape, G1.g_num_parcours, G1.obligation, G1.temps_etape, G1.num_etape_suivante FROM gestparcours G1 WHERE G1.g_num_parcours=$parcours and type_etape='$old_type'";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir les tapes d'un type donn qui sont dans un parcours.
 * 
 * @param integer : numro du parcours
 * @param integer : type d'tape voulu
 * @return integer : resultat de la requete : (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4)
 */
function get_parcours_etapes_type($parcours, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_etapes_type($parcours, '$type') AS (id int4, libelle_alias varchar, libelle varchar, libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool, libelle_type_original varchar, modifiable bool, indice int4)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else {
		$res = get_parcours_etapes_type_old($parcours, $type);
	}
	return $res;
}

/**
    Obtenir les types d'tapes d'un parcours (OLD)
    Les types d'tapes dont ordonns par leur libelle.
    
    @param integer : le numro de parcours
    @return integer: resultat de la requete : (id int4, libelle varchar)
*/
function get_parcours_types_etapes_old($parcours) {
	global $MSG_1267, $MSG_776, $MSG_926, $MSG_516, $MSG_1834, $MSG_928, $MSG_927, $MSG_922, $MSG_282, $MSG_2035;
	$sql = "SELECT DISTINCT type_etape,
					CASE 
						WHEN type_etape='B' THEN '" . $MSG_1267 . "'
						WHEN type_etape='C' THEN '" . $MSG_1267 . "'
						WHEN type_etape='E' THEN '" . $MSG_776 . "'
						WHEN type_etape='F' THEN '" . $MSG_926 . "'
						WHEN type_etape='I' THEN '" . $MSG_516 . "'
						WHEN type_etape='L' THEN '" . $MSG_1834 . "'
						WHEN type_etape='P' THEN '" . $MSG_928 . "'
						WHEN type_etape='R' THEN '" . $MSG_927 . "'
						WHEN type_etape='S' THEN '" . $MSG_922 . "'
						WHEN type_etape='T' THEN '" . $MSG_282 . "'
						WHEN type_etape='Z' THEN '" . $MSG_2035 . "'
						ELSE ''
					END AS libelle
		 		FROM gestparcours 
				WHERE g_num_parcours=$parcours 
				GROUP BY (type_etape)
				ORDER BY libelle";
	//echo "$sql<br>"; , COUNT(type_etape)
	return pg_query($sql);
}
/**
    Obtenir les types d'tapes d'un parcours 
    @param integer : le numro de parcours
    @return integer: resultat de la requete : (id int4, libelle varchar, nb int4)
*/
function get_parcours_types_etapes($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_types_etapes($parcours) AS (id varchar, libelle varchar, nb int4)";
		$res = pg_query($sql);
		return $res;
	} else
		return get_parcours_types_etapes_old($parcours);
}

/**
*  Obtenir les libells personnalis des types d'tapes d'un parcours(OLD)
*
*   @param integer : le numro de parcours
*   @return integer : le rsultat de la requte
*/
function get_parcours_types_etapes_personnalises_old($parcours) {
	$sql = "select nom_etape from gestparcours where g_num_parcours=$parcours and nom_etape <>'' ";
	$res = pg_query($sql);
	return $res;
}
/**
*    Obtenir les libells personnalis des types d'tapes d'un parcours
*
*   @param integer : le numro de parcours
*   @return integer : le rsultat de la requte
*/
function get_parcours_types_etapes_personnalises($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_types_etapes_personnalises($parcours)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_parcours_types_etapes_personnalises_old($parcours);
	return $res;
}

/**
*   Obtenir le libell personnalis d'un type d'tape d'un parcours (OLD)
*
*   @param integer : le numro de parcours
* 	@param integer : le numro de type d'tape
*   @return integer : le rsultat de la requte
*/
function get_parcours_type_etape_personnalise_old($parcours, $type) {
	$sql = "select nom_etape from gestparcours where g_num_parcours=$parcours and nom_etape <>'' AND type_etape='$type'";
	$res = pg_query($sql);
	return $res;
}
/**
*  Obtenir le libell personnalis d'un type d'tape d'un parcours
*
*   @param integer : le numro de parcours
* 	@param integer : le numro de type d'tape
* 	
*   @return varchar[] : les liblls
*/
function get_parcours_type_etape_personnalise($parcours, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_type_etape_personnalise($parcours, '$type')";
		//echo "$sql<br>";      
		$res = pg_query($sql);
	} else
		$res = get_parcours_type_etape_personnalise_old($parcours, $type);
	return $res;
}

function get_parcours_etapes_disponibles_old($parcours, $theme) {
	//$theme=2; 
	$rang = 1;
	$valexo = 0;
	$parcours = 1558;

	//	$sql_p_attach="(select num_parcours AS  id,nom_parcours AS  libelle, 'T' AS  type, lower(nom_parcours) AS  ordre from parcours where num_parcours in
	//            (select distinct g_num_parcours from gestparcours where num_rang=$rang and num_thematik=$theme and num_etape='1')
	//            and num_parcours not in (select num_parcours from config_orientation) and num_parcours not in
	//            (select attach_parcours from gestparcours where g_num_parcours=$parcours)) ";
	//            
	//   	$sql_exotlc="(select num_exo AS id,titre AS libelle, 'E' AS type,lower(titre) as ordre from exotlc where num_exo in
	//            (select gestfic_num_exo from gestfic where gestfic_num_fic in
	//            (select num_fic from fictlc where num_themedir=$theme)) and num_exo not in
	//            (select num_c_q_e_d from gestparcours where type_etape='E' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";       
	//             
	//	$sql_serie_multiexos="(select id AS id,titre AS libelle, 'B' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) >1) and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";
	//            
	//    $sql_serie_qcm="(select id AS id,titre AS libelle, 'Bq' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
	//            (select distinct id_serie from asso_exo_serie where type_exo='q') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d <>$valexo))";    
	//            
	//   	$sql_serie_blanc="(select id AS id,titre AS libelle, 'Bf' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
	//            (select distinct id_serie from asso_exo_serie where type_exo='f') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";    
	//            
	//    $sql_serie_sondage="(select id AS id,titre AS libelle, 'Bs' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
	//            (select distinct id_serie from asso_exo_serie where type_exo='s') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";
	//            
	//    $sql_serie_qrc="(select id AS id,titre AS Bm_libelle, 'Bm' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
	//            (select distinct id_serie from asso_exo_serie where type_exo='m') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) 
	//			and id not in (select id_test from test))";
	//			
	//    $sql_serie_src="(select id AS id,titre AS libelle, 'Bo' AS type,lower(titre) as ordre from serie_exo where theme=$theme and id in
	//            (select id_serie from asso_exo_serie group by id_serie having count(distinct type_exo) =1) and id in
	//            (select distinct id_serie from asso_exo_serie where type_exo='o') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='B' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) 
	//			and id not in (select id_test from test) )";
	//			
	//    $sql_serie_aleatoire_monotheme="(select id AS id,titre AS libelle, 'Cmono' AS type,lower(titre) as ordre from serie_exo where id in
	//            (select distinct num_serie from serie_aleatoire where theme=$theme and mode='1') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='C' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";	
	//            
	//    $sql_series_aleatoires_multitheme="(select id AS id, titre AS libelle, 'Cmulti' AS type,lower(titre) as ordre from serie_exo where id in
	//            (select distinct num_serie from serie_aleatoire where mode='2') and id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='C' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo) )";
	//            
	//    $sql_forum="(select NULL AS id,'$MSG_926' AS libelle, 'F' AS type, lower('$MSG_926') as ordre)";
	//    
	//	$sql_chat="(select NULL AS id,'$MSG_928' AS libelle, 'P' AS type, lower('$MSG_928') as ordre)";
	//	
	//	$sql_ressources="(select NULL AS id,'$MSG_927' AS libelle, 'R' AS type, lower('$MSG_927') as ordre)";
	//	   
	//	$sql_scorm="(select id AS id,name AS libelle, 'Z' AS type,lower(name) as ordre from scorm where num_theme=$theme and  id not in
	//            (select num_c_q_e_d from gestparcours where type_etape='Z' and g_num_parcours=$parcours and num_c_q_e_d<>$valexo))";
	//    
	//    $sql="($sql_p_attach UNION $sql_exotlc 
	//		  	UNION $sql_serie_multiexos 
	//			UNION $sql_serie_qcm 
	//			UNION $sql_serie_blanc 
	//			UNION $sql_serie_sondage 
	//			UNION $sql_serie_qrc 
	//			UNION $sql_serie_src 
	//			UNION $sql_serie_aleatoire_monotheme 
	//			UNION $sql_series_aleatoires_multitheme  
	//			UNION $sql_forum 
	//			UNION $sql_chat
	//			UNION $sql_ressources 
	//			UNION $sql_scorm) ORDER BY type, ordre";  
	//attention, le order by  la fin de la requete est requis  cause de l'impossiblit de trier en amont.	
	if(empty($parcours))$parcours='NULL';		
	$sql = "SELECT * FROM _af_get_parcours_etapes_disponibles_theme($parcours, $theme) AS (id int4, libelle varchar, type varchar , ordre text) order by type";
	//echo "$sql<br>";      
	return pg_query($sql);
}

/**
 * Obtenir les tapes que l'on peut ajouter dans un parcours.
 * Ces tapes sont celles qui ne sont pas dej dans le parcours.
 * 
 * @param integer : le numro de parcours
 * @param integer : le numro du thme
 * @return integer : le rsultat de la requte (id int4, libelle varchar, type int4)
 */
function get_parcours_etapes_disponibles_theme($parcours, $theme, $filiere="") {
	if (VERSION_BASE > VERSION) {
		if(empty($parcours)){
			$sql = "SELECT * FROM contraintes.af_get_filiere_etapes_disponibles_theme($filiere, $theme) AS (id int4, libelle varchar, type varchar, libelle_type varchar) order by type, libelle_type";	
		}else{
			$sql = "SELECT * FROM contraintes.af_get_parcours_etapes_disponibles_theme($parcours, $theme) AS (id int4, libelle varchar, type varchar, libelle_type varchar) order by type, libelle_type";
			//echo "sql=$sql<br>";
		}
		//echo "$sql<br>";
		return $res = pg_query($sql);
	} else
		return get_parcours_etapes_disponibles_old($parcours, $theme);
}

/**
*   Enregistre une tape de parcours. (OLD)
* 
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant de l'tape
*   @param integer : l'identifiant du pere de l'tape
*   @param bool : obligation de l'tape
*   @param bool : tape fin de page?
*   @param integer : le type de l'tape 
*   @param integer : l'identifiant du theme
*   @return bool : true si l'affectation a bien t ffectue.
*/
function set_parcours_etape_old($parcours, $etape = 0, $pere, $obligation, $finpage, $type, $theme) {
	if(!$etape)$etape=0;
	if ($finpage == "FALSE")
		$finpage = 0;
	else
		$finpage = 1;
	if ($obligation == "FALSE")
		$obligation = l;
	else
		$obligation = o;
	$filiere = pg_fetch_result(get_parcours($parcours), 0, 2);
	$rang_filiere = get_filiere_niveau($filiere);
	$p_attache = 'NULL';
	if ($type == get_etape_type_old_new('I')) {
		$fichier = $etape;
		$etape = 0;
	}
	if ($type == get_etape_type_old_new('T') || $type == get_etape_type_old_new('L')) {
		$p_attache = $etape;
		$etape = 0;
	}
	//echo "type=$type pere=$pere";
	if ($type == get_etape_type_old_new('S') && ($pere == 1 || $pere == 0) ) {
		$sql = "UPDATE gestparcours SET obligation='$obligation', num_etape_suivante=$finpage, num_rang=$rang_filiere , attach_fic='$etape',num_thematik=$theme
				        WHERE g_num_parcours=$parcours AND num_etape=1 AND type_etape='S'";
		$res = pg_query($sql);

	} else {
		$sql = "INSERT INTO gestparcours (g_num_parcours, num_c_q_e_d, num_etape, obligation, num_etape_suivante, type_etape, num_rang , attach_fic, attach_parcours, num_thematik)
				            VALUES($parcours,$etape,$pere,'$obligation',$finpage,'$type',$rang_filiere, '$fichier', $p_attache, $theme)";
	}
	echo "sql=$sql<br>";
	$ins = pg_query($sql);
	return $ins;
}

/**
*   Enregistre une tape de parcours.
* 
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant de l'tape
*   @param integer : l'identifiant du pere de l'tape
*   @param bool : obligation de l'tape
*   @param bool : tape fin de page?
*   @return bool : true si l'affectation a bien t ffectue.
*/
function set_parcours_etape($parcours, $etape, $pere, $obligation, $chrono, $finpage, $type = "", $theme = "") {
	if (VERSION_BASE > VERSION) {
		$sql = "select contraintes.af_set_parcours_etape($parcours,$etape,$pere,$obligation, $chrono, $finpage)";
		//echo "sql=$sql<br>";
		$res = pg_fetch_result(pg_query($sql),0,0);
	} else
		$res = set_parcours_etape_old($parcours, $etape, $pere, $obligation, $finpage, $type, $theme);
	return $res;
}

/**
* Cre un parcours.(OLD)
*
* @param string : le libelle du parcours
* @param integer : le numro de filire
* @return integer : le n du nouveau parcours
*/
function set_parcours_old($libelle, $filiere) {
	$rang_filiere = get_filiere_niveau($filiere);

	$sql = "INSERT INTO parcours(nom_parcours) VALUES('$libelle')";
	echo "sql=$sql<br>";
	$ins = pg_query($sql);
	$oid = pg_getlastoid($ins);
	$res = pg_query("SELECT num_parcours from parcours where oid=$oid;");
	$num_parcours = pg_result($res, 0, 0);

	$sql = "INSERT INTO gestparcours (g_num_parcours, num_c_q_e_d, num_etape, type_etape, num_thematik, num_rang)
		        VALUES($num_parcours,$filiere,1,'S', -1,$rang_filiere)";
	echo "sql=$sql<br>";
	$res = pg_query($sql);

	return $num_parcours;
}

/**
* Cre un parcours.
*
* @param string : le libelle du parcours
* @param integer : le numro de filire
* @return integer : le n du nouveau parcours
*/
function set_parcours($libelle, $filiere) {
	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_set_parcours('$libelle',$filiere);";
		$res = pg_query($req);
		$num_parcours = pg_result($res, 0, 0);
	} else
		$num_parcours = set_parcours_old($libelle, $filiere);
	return $num_parcours;
}

/**
*   Mettre  jour la dure des tapes d'un type donn pour un parcours. (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : le type d'tape
* 	@param integer : la dure pour l'tape
*   @return integer : true ou false selon que la mise a jour ai bien t effectue.
*/
function maj_parcours_etapes_duree_type_old($parcours, $type, $duree) {
	if ($type == 'B') {
		$req_sel = "SELECT num_c_q_e_d FROM gestparcours WHERE g_num_parcours=$parcours and type_etape='$type'";
		$sel = pg_query($req_sel);
		while ($row = pg_fetch_row($sel)) {
			$sql = "UPDATE serie_exo SET chrono=$duree WHERE id=$row[0]";
			$maj = pg_query($sql);
		}
	} else {
		$sql = "update gestparcours set temps_etape='$duree' where g_num_parcours=$parcours and type_etape='$type'";
		$maj = pg_query($sql);
	}
	if($maj)return 't';
	else return 'f';
}

/**
*   Mettre  jour la dure des tapes d'un type donn pour un parcours.
*
*   @param integer : le numro de parcours
*   @param integer : le type d'tape
* 	@param integer : la dure pour l'tape
*   @return bool : true ou false selon que la mise a jour ai bien t effectue.
*/
function maj_parcours_etapes_duree_type($parcours, $type, $duree) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_parcours_etapes_duree_type($parcours, '$type', $duree)";
		//echo "$sql<br>";
		$maj = pg_query($sql);
		return pg_fetch_result($maj,0,0);
	} else
		return maj_parcours_etapes_duree_type_old($parcours, $type, $duree);
}

/**
*   Obtenir les diffrents temps des chronos des tapes d'un type donn d'un parcours(OLD)
*
*   @param integer : le numro de parcours
*   @param char : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_chrono_type_old($parcours, $type) {
	if ($type == 'B') {
		$req_sel = "SELECT num_c_q_e_d FROM gestparcours WHERE g_num_parcours=$parcours and type_etape='$type'";
		$sel = pg_query($req_sel);
		while ($row = pg_fetch_row($sel)) {
			$tmp_chrono = get_etape_chrono_total($row[0], $type);
			if ($tmp_chrono < 0) {
				$sql = "select -1";
				//echo "$sql<br/>";
				$res = pg_query($sql);
			}
		}
	} else {
		$sql = "select distinct temps_etape from gestparcours where g_num_parcours='$parcours' and type_etape='$type'";
		//echo "$sql<br/>";
		$res = pg_query($sql);
	}
	return pg_fetch_result($res, 0, 0);
}

/**
*   Obtenir les diffrents temps des chronos des tapes d'un type donn d'un parcours.
*	Les types pris en compte sont les types de base (profondeur 1) et les types calculs de profondeur 2 (X_Y) uniquement.
*	Les types de profondeurs suprieur  1 (X_Y_Z) sont assimils  des types de profondeur 2 (X_Y). 
*
*   @param integer : le numro de parcours
*   @param string : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_chrono_type($parcours, $type) {
	if (VERSION_BASE > VERSION) {
		$duree=0;
		//on formate le $type pour les types composs
		$type=get_etape_type_formate($type,2);
		//on recup les etapes du parcours
		$res = get_parcours_etapes($parcours);
		$indiv=false;
		while($row=pg_fetch_row($res)){
				//on formate le type pour les types composs
				$row_type=get_etape_type_formate($row[4],2);
				if($row_type==$type&&is_etape_type_chronometre($type)&&$row[4]!='4_1_4'){
					$d=get_etape_chrono_total($row[0], $type);
					if($d>0){
						$duree+=$d;
					}else{
						$duree+=(-$d);
						$indiv=true;
					}
				}
		}
		if($indiv){
			return -$duree;
		}else{
			return $duree;
		}
	} else
		$res = get_parcours_etapes_chrono_type_old($parcours, $type);
	return $res;
}

/**
*  Obtenir la somme des dures des tapes d'un type donn d'un parcours.(OLD)
*
*   @param integer : le numro de parcours
*   @param char : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_duree_type_old($parcours,$type){
    $sql="select SUM(temps_etape) from gestparcours where g_num_parcours='$parcours' and type_etape='$type'";
    $res=pg_query($sql);
    return pg_fetch_result($res,0,0);
}

/**
*   Obtenir la somme des dures des tapes d'un type donn d'un parcours.
*	Les types pris en compte sont les types de base (profondeur 1) et les types calculs de profondeur 2 (X_Y) uniquement.
*	Les types de profondeurs suprieur  1 (X_Y_Z) sont assimils  des types de profondeur 2 (X_Y). 
*
*   @param integer : le numro de parcours
*   @param string : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_duree_type($parcours,$type){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_etapes_duree_type($parcours,'$type')";
    	//echo "$sql<br>";
    	$res= pg_fetch_result(pg_query($sql),0,0);
    }
    else
        $res=get_parcours_etapes_duree_type_old($parcours,$type);
    return $res;
}

/**
*   Obtenir les diffrents temps des dures des tapes d'un type donn d'un parcours.(OLD)
*
*   @param integer : le numro de parcours
*   @param char : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_type_old($parcours,$type){
    $sql="select DISTINCT temps_etape from gestparcours where g_num_parcours='$parcours' and type_etape='$type'";
    $res=pg_query($sql);
    return $res;
}

/**
*   Obtenir les diffrents temps des dures des tapes d'un type donn d'un parcours.
*	Les types pris en compte sont les types de base (profondeur 1) et les types calculs de profondeur 2 (X_Y) uniquement.
*	Les types de profondeurs suprieur  1 (X_Y_Z) sont assimils  des types de profondeur 2 (X_Y). 
*
*   @param integer : le numro de parcours
*   @param string : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_type($parcours,$type){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_etapes_durees_type($parcours,'$type')";
		//echo "$sql<br>";
    	$res=pg_query($sql);
    }
    else
        $res=get_parcours_etapes_durees_type_old($parcours,$type);
    return $res;
}

/**
*   Obtenir les diffrents temps des dures des tapes d'un type donn d'un parcours.(OLD)
*
*   @param integer : le numro de parcours
*   @param char : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_type_distincts_old($parcours,$type){
    $sql="select  temps_etape from gestparcours where g_num_parcours='$parcours' and type_etape='$type'";
    $res=pg_query($sql);
    return $res;
}

/**
*   Obtenir les diffrents temps des dures des tapes d'un type donn d'un parcours.
* 	Les temps NULL sont comtabiliss.
*	Les types pris en compte sont les types de base (profondeur 1) et les types calculs de profondeur 2 (X_Y) uniquement.
*	Les types de profondeurs suprieur  1 (X_Y_Z) sont assimils  des types de profondeur 2 (X_Y). 
*
*   @param integer : le numro de parcours
*   @param string : le type d'tape
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_type_distincts($parcours,$type){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_etapes_durees_type_distincts($parcours,'$type')";
		//echo "$sql<br>";
    	$res=pg_query($sql);
    }
    else
        $res=get_parcours_etapes_durees_type_distincts_old($parcours,$type);
    return $res;
}
/**
*   Mettre  jour l'option d'affichage des dures (OLD)
*
*   @param integer : le numro de parcours
*   @param bool : TRUE=affichage FALSE=pas d'affichage
*   @return bool : true ou false selon que la mise a jour ai bien t effectue.
*/
function maj_parcours_duree_old($parcours, $duree) {
	$sql = "update parcours set affiche_fo='$valeur' where num_parcours=$parcours";
	$maj = pg_query($sql);
	return $maj;
}

/**
*   Mettre  jour l'option d'affichage des dures en front-office.
* 
*  @param integer : le numro de parcours
*  @param bool : TRUE=affichage FALSE=pas d'affichage
*  @return bool : true ou false selon que la mise a jour ai bien t effectue.
*/
function maj_parcours_duree($parcours, $duree) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_parcours_duree($parcours,$duree)";
		//echo "$sql<br/>";
		$maj = pg_query($sql);
	} else
		$res = maj_parcours_duree_old($parcours, $duree);
	return $res;
}

/**
*   Mettre  jour la dure d'une tape (OLD)
*
*   @param integer : le numro de parcours
*   @param integer : la dure pour l'tape
*   @param integer : le numro d'tape
*   @return intger : 1
*/
function maj_parcours_etape_duree_old($parcours, $etape, $duree, $type) {
	//$sql="update gestparcours set temps_etape='$duree' where g_num_parcours=$parcours and num_etape=$etape";
	$sql = "SELECT * FROM _af_maj_parcours_etape_duree($parcours,'$type','$etape',$duree)";
	//echo "$sql<br/>";
	$maj = pg_query($sql);
	return $maj;
}

/**
*   Mettre  jour la duree d'une tape
*
*   @param integer : le numro de parcours
*   @param integer : la duree pour l'tape
*   @param integer : le numro d'tape
*   @return intger : 1
*/
function maj_parcours_etape_duree($parcours, $etape, $duree, $type = "") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_parcours_etape_duree($parcours,$etape,$duree)";
		//echo "$sql<br/>";
		$maj = pg_query($sql);
	} else
		$res = maj_parcours_etape_duree_old($parcours, $etape, $duree, $type);
	return $res;
}


/**
*   Supprimer une tape d'un parcours  (OLD)
*
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant du pere de l'tape  supprimer
*   @return bool : true ou false selon que la suppression se soit bien passe
 */
function del_parcours_etape_old($parcours, $pere) {
	$sql = "delete from gestparcours where g_num_parcours=$parcours and num_etape=$pere";
	//echo "$sql<br/>";
	$del = pg_query($sql);
	// ordonnacement des numros d'tapes
	if($pere<>0){
    	$sql="update gestparcours set num_etape=num_etape-1 where g_num_parcours=$parcours and num_etape>$pere";
    	$maj=pg_query($sql);
	}
	return $del;
}

/**
*   Supprimer une tape d'un parcours
*
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant du pere de l'tape  supprimer
*  @return bool : t ou f selon que la suppression se soit bien passe
 */
function del_parcours_etape($parcours, $etape) {
if (VERSION_BASE > VERSION) {
		$sql = "select * FROM contraintes.af_del_parcours_etape($parcours,$etape)";
		$del=pg_fetch_result(pg_query($sql),0,0);
	} else
		$del = del_parcours_etape_old($parcours, $etape);
	return $del;
}

/**
*   Supprime un parcours (OLD)
*
*   @param integer : le numro du parcours
*   @return bool : true ou false selon que la suppression se soit bien passe
*/
function del_parcours_old($parcours){
    $sql="delete from gestparcours where g_num_parcours=$parcours";
    $del=pg_query($sql);
    $sql="delete from config_orientation where num_parcours=$parcours";
    $del=pg_query($sql);
    $sql="delete from parcours where num_parcours=$parcours";
    $del=pg_query($sql);
    return $del;
}

/**
*   Supprime un parcours
*
*   @param integer : le numro du parcours
*   @return bool: true ou false selon que la suppression se soit bien passe
*/
function del_parcours($parcours){
    if(VERSION_BASE>VERSION){
        print("Erreur del_parcours($parcours) :A NE PAS implmenter utiliser delEtape...");
    }
    else
        $res=del_parcours_old($parcours);
    return $res;
}


/**
 *	Obtenir les ressources configures comme etapes d'un parcours (OLD)
 *
 *	@param integer : le numro du parcours
 *	@param integer : le numro du formation
 *	@return integer : le rsultat de requte (fichier int4, fichier int4, espace int4, section int4, etape int4, parcours int4, type char)
 */
function get_parcours_ressources_old($parcours,$formation){
	$sql="SELECT num_fic,num_fic, num_espace, num_section,num_etape, num_parcours, type 
			FROM config_ressource 
			WHERE num_cal=$formation 
			AND num_parcours=$parcours";
	//echo "sql=$sql<br>";
 	return pg_query($sql);
}

/**
 * Obtenir les ressources configures comme etapes d'un parcours 
 *
 * @param integer : le numro du parcours
 * @return integer : le rsultat de requte (id int4, fichier int4, espace int4, section int4, etape int4, parcours int4)
 */
function get_parcours_ressources($parcours,$formation=""){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_parcours_ressources($parcours) AS (id int4, fichier int4, espace int4, section int4, etape int4, parcours int4)";
    	return pg_query($sql);
    }
    else
      return get_parcours_ressources_old($parcours,$formation);
}

/**
*   Cration d'une tape ressource. (OLD)
*
*   @param integer : le numero du parcours
*   @param integer : le numero de ressource
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de formation
*   @param char : le type de ressource (t=fichier ou t=texte)
*   @param integer : le numero d'etape
* 
* 	@return integer : le numro d'etape_ressource ainsi cr.
*/
function set_parcours_ressource_old($parcours,$pere, $formation,$espace,$section,$num_fic,$type_numfic,$etape){
    $sql="insert into config_ressource values('$formation','$espace','$section','$num_fic','$type_numfic','$parcours','$etape')";
    $ins=pg_query($sql);
    return $ins;
}

/**
*   Cration d'une tape ressource.
*
*   @param integer : le numero du parcours
* 	@param integer : le numero de l'tape pere 
*   @param integer : le numero de ressource
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero d'etape
* 
* 	@return integer : le numro d'etape_ressource ainsi cr.
*/
function set_parcours_etape_ressource($parcours,$pere, $ressource, $espace, $section, $formation="", $type=""){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_parcours_config_ressource_old($parcours,$pere, $ressource, $espace, $section, $formation, $type);
    return $res;
}

function get_parcours_filieres_old($parcours, $desc=""){
	if($desc=='DESC')$ordre=" DESC";
    else $ordre="";
    
 	$sql="	select id, nom, id_pere from filiere 
			where id in (select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and num_etape='1')
			ORDER BY nom $ordre";
	//echo "$sql<br>";			
    $res=pg_query($sql);
    
    return $res;
}

function get_parcours_filieres($parcours, $desc=""){
	if(VERSION_BASE>VERSION){
       return get_etape_filieres($parcours, $desc);
    }
    else
        $res=get_parcours_filieres_old($parcours,$desc);
        
    return $res;
}

/**
*   Modifier une tape d'un parcours  partir du pere.
* 
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant de l'tape
*   @param integer : l'identifiant du pere de l'tape
*   @param bool : obligation de l'tape
*   @param bool : tape fin de page?
*   @return bool : true si l'affectation a bien t ffectue.
*/
function maj_parcours_etape_etape_pere($parcours,$pere, $etape,  $obligation, $chrono, $finpage) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_maj_parcours_etape($parcours, $pere, $etape, $obligation, $chrono, $finpage) ";
		//echo "$sql<br>";	
    	$res=pg_fetch_result(pg_query($sql),0,0);
	} else
		print ("A implmenter...");
	return $res;
}

/**
	Obtenir les etapes de types serie d'un parcours (OLD)
	@param integer : parcours
	@return integer : res req
*/
function get_parcours_etapes_serie_old($parcours){
	$sql="select distinct id,titre from serie_exo where id in 
				(select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and type_etape='B')";
	return pg_query($sql);
}
/**
	Obtenir les etapes de types serie d'un parcours
	@param integer : parcours
	@return integer : res req
*/
function get_parcours_etapes_serie($parcours){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_parcours_etapes_serie($parcours) as (id int4,libelle varchar,type int4,indice int4,obligatoire bool)";
		$res=pg_query($sql);
	}
	else
		$res=get_parcours_etapes_serie_old($parcours);
	return $res;
}

/**
 * Fonction pour la modification de l'ordre des etapes d'un parcours
 * 
 * @param integer : numero du parcours
 * @param integer: numero de l'etape qui est dplace (source)
 * @param integer: numero de l'etape qui est  la place de la source (destination)
 * @param bool: 'TRUE' si on insert avant(par dfaut) ou 'FALSE' pour inserer apres
 * @return bool: t si l'opration s'est bien passe, f sinon.
 */
function maj_parcours_etape_ordre_etape($parcours, $etape_src, $etape_dest, $insere_avant='TRUE', $type_src="", $type_dest="") {
	if (VERSION_BASE > VERSION) {
		$sql = "select * FROM contraintes.af_maj_parcours_etape_ordre($parcours, $etape_src, $etape_dest,$insere_avant)";
		//echo "$sql<br>";die();
		$res = pg_query($sql);
		return pg_fetch_result($res, 0, 0)=='t';
	} else
		return  maj_serie_evaluation_ordre_evaluation_old($parcours, $etape_src, $etape_dest, $insere_avant, $type_src, $type_dest);
}

/**
*   Mettre  jour le nom d'une tape par type(OLD)
*
*   @param integer : le numro de parcours
* 	@param char : le type d'tape
*   @param string : le nom pour l'tape
*   @return intger : 1
*/
function maj_parcours_type_etape_personnalise_old($parcours,$type,$libelle){
    $sql="update gestparcours set nom_etape='$libelle' where g_num_parcours=$parcours and type_etape='$type'";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le nom d'une tape par type
*
*   @param integer : le numro de parcours
* 	@param char : le type d'tape
*   @param string : le nom pour l'tape
*   @return intger : 1
*/
function maj_parcours_type_etape_personnalise($parcours,$type,$libelle){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_maj_parcours_type_etape_personnalise($parcours,$type,'$libelle')";
        //echo "$sql<br>";
    	$res=pg_query($sql);
    }
    else
        $res=maj_parcours_type_etape_personnalise_old($parcours,$type,$libelle);
    return $res;
}

/**
*   Mettre  jour le nom d'une tape par type(OLD)
*
*   @param integer : le numro de parcours
* 	@param char : le type d'tape
*   @param string : le nom pour l'tape
*   @return intger : 1
*/
function maj_parcours_etape_type_etape_personnalise_old($parcours,$etape,$libelle){
    $sql="update gestparcours set nom_etape='$libelle' where g_num_parcours=$parcours and num_c_q_e_d=$etape";
    $maj=pg_query($sql);
    return $maj;
}

/**
*   Mettre  jour le nom d'une tape par type
*
*   @param integer : le numro de parcours
* 	@param char : le type d'tape
*   @param string : le nom pour l'tape
*   @return intger : 1
*/
function maj_parcours_etape_type_etape_personnalise($parcours,$etape,$libelle){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_maj_parcours_etape_type_etape_personnalise($parcours,$etape,'$libelle')";
        //echo "$sql<br>";
    	$res=pg_query($sql);
    }
    else
        $res=maj_parcours_etape_type_etape_personnalise_old($parcours,$etape,$libelle);
    return $res;
}

/**
*   Obtenir les durees d'etapes qui n'ont pas de chrono (OLD)
*
*   @param integer : le numro de parcours
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_valuees_old($parcours){
     $sql="select temps_etape from gestparcours where g_num_parcours=$parcours and type_etape in ('S','F','P','R','E')";
     $res=pg_query($sql);
     return $res;
}
/**
*   Obtenir les durees d'etapes qui n'ont pas de chrono
*
*   @param integer : le numro de parcours
*   @return integer : le resultat de la requete
*/
function get_parcours_etapes_durees_valuees($parcours){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_etapes_durees_valuees($parcours)";
     	$res=pg_query($sql);
    }
    else
        $res=get_parcours_etapes_durees_valuees_old($parcours);
    return $res;
}

/**
*   Mettre  jour le nom d'un parcours (OLD)
*   @param integer : le numro de parcours
*   @param string : le nouveau nom de parcours
*   @return integer : 1 si OK , 0 si erreur
*/
function maj_parcours_libelle_old($parcours,$libelle){
    if(!check_parcours_libelle($libelle)){
        $sql="update parcours set nom_parcours='$libelle' where num_parcours=$parcours";
        $maj=pg_query($sql);
        $ok=1;
    }
    else
        $ok=0;
    return $ok;
}
/**
*   Mettre  jour le nom d'un parcours (OLD)
*   @param integer : le numro de parcours
*   @param string : le nouveau nom de parcours
*   @return integer : 1 si OK , 0 si erreur
*/
function maj_parcours_libelle($parcours,$libelle){
    if (VERSION_BASE > VERSION) {
        return maj_etape_libelle($parcours,$libelle);
    }
    else
        $res = maj_parcours_libelle_old($parcours,$libelle);
    return $res;
}


/**
 * Obtenir les sous parcours utilisables pour une tape parcours orient d'un parcours.
 * 
 * @param integer : le numro de parcours
 * @return integer : le rsultat de la requte (id int4, libelle varchar, type int4)
 */
function get_parcours_etape_parcours_oriente_parcourss_disponibles($parcours) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_etape_parcours_oriente_parcourss_disponibles($parcours) AS (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp, indice int4)";	
		//echo "$sql<br>";
		return $res = pg_query($sql);
	} else
		print("La fonction get_parcours_etape_parcours_oriente_parcourss_disponibles($parcours) n'existe pas pour la version ".VERSION);
}

/**
	Obtenir les resultats obtenus  une tape de parcours
    @param integer : le numero de parcours
	@param integer : le numero d'tape
    @return integer : le resultat de la requete(id int4, formation int4,  classe int4, stagiaire int4, parcours int4,  etape int4, date_debut timestamp, date_fin timestamp)
*/
function get_parcours_etape_resultats($parcours,$etape){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_etape_resultats($parcours,$etape) AS (id int8, formation int4, stagiaire int4, parcours int4,  etape int4, date_debut timestamp, duree interval)";
		//echo "$sql<br>";
		return pg_query($sql);
    }
    else
        print("La fonction get_parcours_etape_resulats($parcours,$etape) n'existe pas pour la version ".VERSION);
}

?>