<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoParcoursAttache.
 * Un DoParcoursAttache est l'objet servant  gerer l'avancement des
 * Etapes de type ParcoursAttache d'un parcours.
 * 
 * @package parcours_attache
 */
class DoParcoursAttache extends DoParcoursDynamique{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'Exotlc
	 * @param object DoEtapeFactory &$obj_DoEtapeFactory Fabrique  utiliser pour la cration des DoEtape du ParcoursAttache
	 */	
	function DoParcoursAttache($formation,$individu,$parcours,$etape,&$obj_DoEtapeFactory){
		messageDebug("DoParcoursAttache::DoParcoursAttache($formation,$individu,$parcours,$etape,&$obj_DoEtapeFactory)");
		parent::DoParcoursDynamique($formation,$individu);
		$this->initDoParcoursAttache($parcours,$etape,$obj_DoEtapeFactory);
	}

	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param integer &$obj_DoEtapeFactory Fabrique  utiliser pour la cration des DoEtape du ParcoursAttache
	 */	
	function initDoParcoursAttache($parcours,$etape, &$obj_DoEtapeFactory){
		messageDebug("DoParcoursAttache::initDoParcoursAttache($parcours,$etape, &$obj_DoEtapeFactory)");
		if(!empty($parcours)&&!empty($etape)&&is_object($obj_DoEtapeFactory)){
			parent::initDoParcoursDynamique($parcours,$etape, TYPE_ETAPE_PARCOURS_ATTACHE,$obj_DoEtapeFactory);
		}else{
			die("Erreur initDoParcoursAttache($parcours,$etape, $obj_DoEtapeFactory): L'objet ne peut etre initialis.<br>");
		}	
	}
	
	/**
	 * Implmentation de la mthode abstraite de la classe DoParcoursDynamique.
	 * @param object &$obj_elementEntity DoElementEntity L'objet d'avancement 
	 */
	function &perform(&$obj_elementEntity){
		messageDebug("DoParcoursAttache::perform()");
		$row_avancement=$obj_elementEntity->getAvancement();
		//recup du resultat pour l'tape
		$row_res=pg_fetch_row(get_resultat_etape($row_avancement[3],$row_avancement[4],$row_avancement[0],$row_avancement[1]));
		
		//si l'tape parcours n'est pas commenc
		if(empty($row_res[0])){
			messageDebug("DoParcoursAttache::perform() Etape parcours non commence, on la commence".$row_res[0]);
			$obj_elementEntity->obj_DoNode->beginCurrentEtape();
			//l'tape courrante du parcours devient etape courante de l'entity
			$obj_elementEntity->obj_DoNode=&$obj_elementEntity->obj_DoNode->getCurrentDoEtape();
		//si l'tape parcours EST commence
		}else{
			messageDebug("DoParcoursAttache::perform() Etape parcours commence, on la termine??".$row_res[0]);
			
			//si l'tape parcours est termine
			if(empty($row_avancement[6])){
				messageDebug("DoParcoursAttache::perform() l'Etape parcours va etre termine".$row_res[0]);
				set_resultat_fin($row_res[0]);
				return $obj_elementEntity->nextDoNode();
			}
			else{
				messageDebug("DoParcoursAttache::perform() Etape parcours  suivre".$row_avancement[6]);
			}
		}
	}
//	function &begin(){
//		//recup du resultat de l'avancement
//		$row_avancement=$this->getAvancement();
//		$row_res=pg_fetch_row(get_resultat_etape($row_avancement[3],$row_avancement[4],$row_avancement[0],$row_avancement[1]));
//		//si l'tape parcours n'est pas commenc
//		if(empty($row_res[0])){
//			print("Etape parcours non commence, on la commence".$row_res[0]."<br>");
//			$this->obj_DoNode->beginCurrentEtape();
//			//l'tape courrante du parcours devient etape courante de l'entity
//			//$this->obj_DoNode=&$this->obj_DoNode->getCurrentDoEtape();
//			return $this->obj_DoNode->getCurrentDoEtape();
//		}
//	}
//	
//	function end(){
//		$row_avancement=$this->getAvancement();
//		$row_res=pg_fetch_row(get_resultat_etape($row_avancement[3],$row_avancement[4],$row_avancement[0],$row_avancement[1]));
//		if(!empty($row_res[0])){
//			print("Etape parcours commence, on la termine??".$row_res[0]."<br>");
//			//si l'tape parcours est termine
//			if(empty($row_avancement[6])){
//				//$this->obj_DoNode->beginCurrentEtape();
//				//l'tape courrante du parcours devient etape courante de l'entity
//				//$this->obj_DoNode=&$this->obj_DoNode->getCurrentDoEtape();
//				print("Etape parcours a terminer".$row_res[0]."<br>");
//				set_resultat_fin($row_res[0]);
//				//return $this->nextDoNode();
//			}
//			else{
//				print("Etape parcours rien".$row_avancement[6]."<br>");
//			}
//		}
//	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object ParcoursAttache l'objet correspondant  l'tape
	 */		
	function getParcoursAttache(){
		return parent::getObjEtape();
	}
}
?>
