<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe ParcoursAttache.
 *	Un ParcoursAttache est un objet driv de Etape. 
 *
 *	@package parcours_attache
 */
class ParcoursAttache extends Parcours{

	/**
	 * Construit un ParcoursAttache.
	 * Le ParcoursAttache peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Etape
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */
	function ParcoursAttache($id, $libelle="Etape Parcours Attache", $date_creation="27.11.2006"){
		if(func_num_args()==1){
			$res_etape=get_parcours($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[4];
			$filiere=$row_etape[2];
			$duree=$row_etape[3];
		}else{
			
		}
		parent::Parcours($id, $libelle, $date_creation,TYPE_ETAPE_PARCOURS_ATTACHE, $filiere,$duree);
	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_parcours_attache.gif";
	}	
	
}
?>
