<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoParcoursOriente.
 * Un DoParcoursOriente est l'objet servant  gerer l'avancement des
 * Etapes de type ParcoursOriente d'un parcours.
 * 
 * @package parcours_oriente
 */
class DoParcoursOriente extends DoParcoursDynamique{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'Exotlc
	 */		
	function DoParcoursOriente($formation,$individu,$parcours,$etape,&$obj_DoEtapeFactory){
		messageDebug("DoParcoursOriente:DoParcoursOriente()");
		parent::DoParcoursDynamique($formation,$individu);
		$this->initDoParcoursOriente($parcours,$etape,&$obj_DoEtapeFactory);
	}
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 */		
	function initDoParcoursOriente($parcours,$etape,&$obj_DoEtapeFactory){
		messageDebug("DoParcoursOriente:initDoParcoursOriente()");
		parent::initDoParcoursDynamique($parcours,$etape,TYPE_ETAPE_PARCOURS_ORIENTE,&$obj_DoEtapeFactory);
	}
	
	/**
	 * Implmentation de la mthode abstraite de la classe DoParcoursDynamique.
	 * @param object &$obj_elementEntity DoElementEntity L'objet d'avancement 
	 */
	function &perform(&$obj_elementEntity){
	     messageDebug("DoParcoursOriente::perform()");
		$row_avancement=$obj_elementEntity->getAvancement();
		//recup du resultat pour l'tape
		$row_res=pg_fetch_row(get_resultat_etape($row_avancement[3],$row_avancement[4],$row_avancement[0],$row_avancement[1]));
		
		//si l'tape parcours n'est pas commenc
		if(empty($row_res[0])){
			messageDebug("DoParcoursOriente::perform() Etape parcours non commence, on la commence".$row_res[0]);
			$obj_elementEntity->obj_DoNode->beginCurrentEtape();
			//l'tape courrante du parcours devient etape courante de l'entity
			$obj_elementEntity->obj_DoNode=&$obj_elementEntity->obj_DoNode->getCurrentDoEtape();
		//si l'tape parcours EST commence
		}else{
			messageDebug("DoParcoursOriente::perform() Etape parcours commence, on la termine??".$row_res[0]);
			
			//si l'tape parcours est termine
			if(empty($row_avancement[6])){
				messageDebug("DoParcoursOriente::perform() l'Etape parcours va etre termine".$row_res[0]);
				set_resultat_fin($row_res[0]);
				return $obj_elementEntity->nextDoNode();
			}
			else{
				messageDebug("DoParcoursAttache::perform() Etape parcours  suivre".$row_avancement[6]);
			}
		}
	}
	

	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------	
	/**
	 * Obtenir l'objet ParcoursOriente associ  cet objet d'avancement.
	 * @return object ParcoursOriente L'objet Serie associ. 
	 */
	function getParcoursOriente(){
		return parent::getObjEtape();
	}
}
?>
