<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe ParcoursOriente.
 *	Un ParcoursOriente est un objet driv d'Etape.
 *
 *	@package parcours_oriente
 */
class ParcoursOriente extends Etape{

	/**
	 * Construit un ParcoursOriente.
	 * Le ParcoursOriente peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du ParcoursOriente
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */
	function ParcoursOriente($id, $libelle="Etape Parcours Oriente", $date_creation="27.11.2006"){
		if(func_num_args()==1){
			$res_etape=get_parcours_oriente($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[3];
			
		}else{
			echo "ParcoursOriente($id, $libelle, $date_creation,TYPE_ETAPE_PARCOURS_ORIENTE);<br/>";			
		}
		parent::Etape($id, $libelle, $date_creation,TYPE_ETAPE_PARCOURS_ORIENTE);
		$this->initParcoursOriente();
	}

	/**
	 * Initialise les attributs propres au ParcoursOriente.
	 */	
	function initParcoursOriente(){
		parent::initEtape();
		$res_config=get_parcours_oriente_configuration($this->id);
		$nb_lignes_configurations=pg_num_rows($res_config);

		//TODO casser le tableau configuration en variables		
		for($i=0;$i<$nb_lignes_configurations;$i++){
			$row_configuration=pg_fetch_row($res_config, $i);
			
			if((!is_array($configuration))||(!in_array($row_configuration[1], $configuration))){
				if(!empty($row_configuration[2]))$configuration[$row_configuration[1]][$row_configuration[2]]=$row_configuration[3];
				else $configuration[$row_configuration[1]]=$row_configuration[3];
			}	
		}
	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_parcours_oriente.gif";
	}
}
?>
