<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	
	@package parcours_oriente 
	@modulegroup plpgsql 
	@module plpgsql_parcours_oriente
*/
 
 
/**
*   Enregistrer la configuration d'un parcours dynamique  (OLD)
*
*   @param integer : le numro de parcours
*   @param string : la liste des seuils
*   @param string : la liste des modules (sous-parcours)
*   @return integer : 1
*/
function set_parcours_oriente_old($sous_parcours,$types,$seuils){
	$i=0;
	//TODO
	foreach($types as $type){
		$sql="to do insert into config_orientation values($sous_parcours,'$liste_seuil','$liste_module')";
		$i++;
	}
    $ins=pg_query($sql);
    return $ins;
}

/**
*   Crer un parcours orient.
*
*   @param integer : le libelle de l'etape.
* 	@param integer : la liste des sous parcours.
*   @param int4[] : la liste des types
*   @param int4[] : la liste des seuils
*   @return integer : l'identifiant de l'etape ainsi cre.
*/
function set_parcours_oriente($libelle,$sous_parcourss,$types,$nbtypes,$seuils){
	if(!(count($types)==count($seuils)&&count($seuils)>=(count($sous_parcourss)-1)))
		die("Erreur fonction set_parcours_oriente($libelle,$sous_parcours,$types,$seuils): les tableaux en parametre n'ont pas des tailles compatibles'.");
    if(VERSION_BASE>VERSION){
    	$_sous_parcourss=int_array_to_plpgsql_array($sous_parcourss);
    	$_types=int_array_to_plpgsql_array($types);
    	$_seuils=int_array_to_plpgsql_array($seuils);
        $sql="SELECT * FROM contraintes.af_set_parcours_oriente('$libelle',$_sous_parcourss,$_types,$nbtypes,$_seuils)";
   		//echo "$sql<br>";
   		$ins=pg_query($sql);
   		return pg_fetch_result($ins,0,0);
    }
    else
        $res=set_parcours_oriente_old($sous_parcourss,$types,$seuils);
    return $res;
}

/**
*   Enregistrer la configuration d'un parcours dynamique  (OLD)
*
*   @param integer : le numro de parcours
*   @param string : la liste des seuils
*   @param string : la liste des modules (sous-parcours)
*   @return integer : 1
*/
function get_parcours_oriente_configuration_old($etape){
    //$sql="SELECT * FROM contraintes.af_get_parcours_oriente($etape)";
	//echo "$sql<br>";
	$ins=pg_query($sql);
	return $ins;
}

/**
*   Obtenir une tape parcours oriente  (OLD)
*
*   @param integer : le numro de l'tape
*   @return integer : identifiant resultat de la requete ( etape int4, sous_parcours int4, type_evaluation int4, seuil int4)
*/
function get_parcours_oriente_configuration($etape){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_parcours_oriente_configuration($etape) AS ( etape int4,  sous_parcours int4, type_evaluation int4, seuil int4)";
   		//echo "$sql<br>";
   		return pg_query($sql);
    }
    else
        return get_parcours_oriente_configuration_old($etape);
}

/**
*   Enregistrer la configuration d'un parcours dynamique  (OLD)
*
*   @param integer : le numro de parcours
*   @param string : la liste des seuils
*   @param string : la liste des modules (sous-parcours)
*   @return integer : 1
*/
function maj_parcours_oriente_old($parcours,$sous_parcours,$types,$seuils){
	$i=0;
	//TODO
	foreach($types as $type){
		$sql="to do insert into config_orientation values($parcours,$sous_parcours,'$liste_seuil','$liste_module')";
		$i++;
	}
    $ins=pg_query($sql);
    return $ins;
}

/**
*   Crer un parcours orient.
*
*   @param integer : le libelle de l'etape.
* 	@param integer : la liste des sous parcours.
*   @param int4[] : la liste des types
*   @param int4[] : la liste des seuils
*   @return integer : l'identifiant de l'etape ainsi cre.
*/
function maj_parcours_oriente($etape, $libelle,$sous_parcourss,$types,$nbtypes,$seuils){
	if(!(count($types)==count($seuils)&&count($seuils)>=(count($sous_parcourss)-1)))
		die("Erreur fonction maj_parcours_oriente($etape, $libelle,$sous_parcours,$types,$seuils): les tableaux en parametre n'ont pas des tailles compatibles'.");
    if(VERSION_BASE>VERSION){
    	$_sous_parcourss=int_array_to_plpgsql_array($sous_parcourss);
    	$_types=int_array_to_plpgsql_array($types);
    	$_seuils=int_array_to_plpgsql_array($seuils);
        $sql="SELECT * FROM contraintes.af_maj_parcours_oriente($etape,'$libelle',$_sous_parcourss,$_types,$nbtypes,$_seuils)";
   		//echo "$sql<br>";
   		$ins=pg_query($sql);
   		return pg_fetch_result($ins,0,0);
    }
    else
        $res=maj_parcours_oriente_old($sous_parcourss,$types,$seuils);
    return $res;
}

/**
*   Obtenir les sous parcours d'un parcours oriente. (OLD)
*
*   @param integer : le numro de parcours oriente
*   @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4)
*/
function get_parcours_oriente_sous_parcourss_old($parcours) {
	$sql1 = "select sousparcours from config_orientation where num_parcours=$parcours";
	$res = pg_query($sql1);
	$sql2 = "select num_parcours, nom_parcours, num_c_q_e_d from parcours, gestparcours where num_parcours=g_num_parcours AND num_etape=1 AND num_parcours IN (" . pg_fetch_result($res, 0, 0) . ")";
	return pg_query($sql2);
}

/**
*   Obtenir les sous parcours d'une etape parcours oriente. 
*
*   @param integer : le numro de parcours oriente
*   @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4)
*/
function get_parcours_oriente_sous_parcourss($etape) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours_oriente_sous_parcours($etape) AS (id int4, libelle varchar, filiere int4, pere int4)";
		//echo "$sql<br>";
		return  pg_query($sql);
	} else
		$res = get_parcours_dynamique_sous_parcourss_old($etape);
	return $res;
}

/**
*   Obtenir la configuration d'un parcours dynamique (OLD)
*
*   @param integer : le numro du parcours
*   @return integer : le resultat de la requte
*/
function get_etape_parcours_oriente_configuration_old($parcours){
    $sql="select * from config_orientation where num_parcours=$parcours";
    $res=pg_query($sql);
    return $res;
}
/**
	Obtenir la configuration d'une tape parcours oriente

	@param integer : le numero d'tape
    @return integer : le resultat de la requete id int4, libelle varchar, \"type\" int4
*/
function get_etape_parcours_oriente_configuration($etape){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.contraintes.af_get_etape_parcours_oriente_configuration($etape) AS (id int4, type int4, seuil int4, sous_parcours int4)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        return get_etape_parcours_oriente_configuration_old($etape);
        
    return $res ;
}

/**
	Obtenir la configuration d'une tape parcours oriente

	@param integer : le numero d'tape
    @return integer : le resultat de la requete id int4, libelle varchar, \"type\" int4
*/
function set_etape_parcours_oriente_configuration($etape, $types, $seuils, $sous_parcourss){
	if(VERSION_BASE>VERSION){
		if(count($types)==0&&(count($sous_parcourss)!=count($seuils))){
			die("Fonction set_etape_parcours_oriente_configuration($etape, $types, $seuils, $sous_parcourss): le nombre de seuils et de sous parcours ne correspondent pas.");
		}
		if( (count($types)!=0) && (count($sous_parcourss)!=count($seuils))&&(count($seuils)!=count($types))){
			die("Fonction set_etape_parcours_oriente_configuration($etape, $types, $seuils, $sous_parcourss): le nombre de seuils, de types et de sous parcours ne correspondent pas.");
		}
		$t_types=int_array_to_plpgsql_array($types);
		$t_seuils=int_array_to_plpgsql_array($seuils);
		$t_sous_parcourss=int_array_to_plpgsql_array($sous_parcourss);
        $sql="SELECT * FROM contraintes.contraintes.af_set_etape_parcours_oriente_configuration($etape, $t_types, $t_seuils, $t_sous_parcourss) AS (id int4, type int4, seuil int4, sous_parcours int4)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("La fonction set_etape_parcours_oriente_configuration($etape,$t_types, $t_seuils, $t_sous_parcourss) n'existe pas pour la version ".VERSION);
        
    return $res ;
}

/**
*	Obtenir les proprits d'une tape parcours orient
*
*	@param integer: le numero de l'tape
*	@return integer : l'entier resultat de la requete (id int4, libelle varchar, type int4, date_creation timestamp)
*/
function get_parcours_oriente($etape) {

	if (VERSION_BASE > VERSION) {
		return get_etape($etape);

	} else
		print("La fonction get_parcours_oriente($etape) n'existe pas pour la version ".VERSION);

	return $res;
}
?>
