<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctions pour plate-forme
	@package plateforme
	@modulegroup fonctions
*/


// mise des droit en table
function droits_en_table($res){
	print("la fonction droits_en_table est a modifier");
	 if(VERSION_BASE > VERSION){
		$chaine="_int4'{";
		while($row=pg_fetch_row($res)){
			$chaine .="$row[0],";
		}
		$chaine=substr($chaine,0,-1);
		$chaine.="}'";
		return $chaine;
	 }
	 else{
		$tab=pg_super_fetch_array($reqdroit);
		return $tab;
	 }
}

/**
	Verifie si une icone est supprimable
	@param integer/string : numero ou nom du fichier
	@return boolean : true si supprimable,false sinon
*/
function is_plateforme_icone_supprimable($icone){
	if(VERSION_BASE > VERSION){
		$fichier_nom=get_fichier_name($icone);
		return !is_fichier_utilise($fichier_nom,"section");
	}
	else{
		$sql=" select distinct icone from ressource_sec where icone='$icone'";
		$res=pg_query($sql);
		if(pg_num_rows($res)>0)
			return false;
		return true;
	}
}

/**
	Rcupere les icones de la plateforme sous forme de tableau
*/
function in_array_plateforme_icones(){
	global $chemin_fo;
	$tab=array();
	if(VERSION_BASE > VERSION){
		
		$res=get_plateforme_icones();
		$nbicone=pg_num_rows($res);
		for($i=0;$i<$nbicone;$i++){
			$row=pg_fetch_row($res,$i);
			$tab[$row[0]]=$row[1];
		}
	}
	else{
		$dir = $chemin_fo ."/".UPLOAD_RESSOURCE_ICONE_DIR;
		$thisdir = dir($dir);
        $x=0;
        while($entry=$thisdir->read()) {
			if (($entry!='.') && ($entry!='..')) {
				$tab[$x] = $entry; 
				$x++;
			}
		}
	}
	return $tab;
}

function get_plateforme_object_type_libelle($type){
		
		global $MSG_17, $MSG_2324, $MSG_71, $MSG_635, $MSG_682, $MSG_1519, $MSG_727,$MSG_1290;
		
		 switch($type){
	            	case 'f' :
	                	$libelle = $MSG_17;
	                	break;

                	case 's' :
                          $libelle =$MSG_2324 ;
                          break;

               		case 'o' :
                         $libelle = $MSG_71 ;
                       	 break;

                    case 'c' :
                         $libelle = $MSG_1290;
                         break;

                    case 'g' :
                   		 $libelle = $MSG_682;
                         break;

                     case 'l' :
                    	 $libelle = $MSG_1519;
                         break;

                     case 'p' :
                        $libelle = $MSG_727;
                        break;

                default :
                        die("type d'objet inconnu : $type") ;
                        break ;
	}
	return $libelle;
}
?>