<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Ce fichier propose un ensemble de fonctions pour rcuprer les objets de la plateforme
	@author Rmi Cocquet
	@since mars 2006
	@package plateforme
	@modulegroup plpgsql_objets
*/

/**
	Rcupre les thmes de la plate forme sous forme d'objets
*/
function obj_get_plateforme_themes(){
	//la liste d'objets  retourner
	$obj_themes= array();

	//recupere les donnes en base
	$enregistrements_themes= get_plateforme_themes();
	$nb_themes= pg_numrows($enregistrements_themes);
	
	//creation des objets et stockage dans un tableau
	for($i=0; $i<$nb_themes;$i++){
		$cur_theme= pg_fetch_object($enregistrements_themes);
		$obj_themes[$i]= new Theme($cur_theme->id, $cur_theme->libelle,$cur_theme->individu);
	}
	
	return $obj_themes;
}
function obj_get_plateforme_all_themes(){
	//la liste d'objets  retourner
	$obj_themes= array();

	//recupere les donnes en base
	$enregistrements_themes= get_plateforme_all_themes();
	$nb_themes= pg_numrows($enregistrements_themes);
	
	//creation des objets et stockage dans un tableau
	for($i=0; $i<$nb_themes;$i++){
		$cur_theme= pg_fetch_object($enregistrements_themes);
		$obj_themes[$i]= new Theme($cur_theme->id, $cur_theme->libelle);
	}
	
	return $obj_themes;
}



/**
	Rcupre toutes les catgories de la plate forme sous forme d'objets
*/
function obj_get_plateforme_categories(){
	//la liste d'objets  retourner
	$obj_categories= array();

	//recupere les donnees en base
	$enregistrements_categories= get_plateforme_categories();
	$nb_categories= pg_numrows($enregistrements_categories);
	//creation des objets et stockage dans un tableau
	for($i=0; $i<$nb_categories; $i++){
		$cur_categorie= pg_fetch_object($enregistrements_categories);
		$obj_categories[$i]= new Categorie($cur_categorie->id, $cur_categorie->libelle, $cur_categorie->table_cible, $cur_categorie->gestionnaire_contenus, $cur_categorie->table_etape);
	}
	return $obj_categories;
}

/**
	Rcupere, selon qu'elles apparaissent ou non dans le gestionnaire de contenus, les categories
	de la plate forme.
	@param bool: valeur de "gestionnaire_contenus", qui indique si la categories est pour des fichiers ou des elements de plate-forme
	@return array un tableau d'objets Categorie indx par les identifiants des catgories.
*/
function obj_get_plateforme_categories_gestionnaire_contenus($gestionnaire_contenus){
	//la liste d'objets a retourner
	$obj_categories= array();

	//recupere les donnees en base
	$enregistrements_categories= get_plateforme_categories_gestionnaire_contenus($gestionnaire_contenus);
	$nb_categories= pg_numrows($enregistrements_categories);
	//creation des objets et stockage dans un tableau
	for($i=0; $i<$nb_categories; $i++){
		$cur_categorie= pg_fetch_object($enregistrements_categories);
//		echo "<pre>";
//		print_r($cur_categorie);
//		echo "</pre>";
		$obj_categories[$cur_categorie->id]= new Categorie($cur_categorie->id, $cur_categorie->libelle, $cur_categorie->table_cible, $cur_categorie->gestionnaire_contenus, $cur_categorie->table_etape);
	}
	return $obj_categories;
}
?>