<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
	Fonctions pour obtenir les entit�s de la plate-forme.
	
       @package plateforme
       @modulegroup plpgsql
       @module plpgsql_plateforme
*/
/*
 * NOTE : Prise en compte des themes de l'individu 
 * af_get_categorie_themes($categorie) devient af_get_categorie_themes($categorie,$individu)
 * 
 */
//include ("$chemin_bo/lib/plateforme/plpgsql_deprecated_plateforme.inc");

/**
*   Obtenir tous les individus de la plateforme
*
*   Retourne la totalit� des informations de tous les individus de la plateforme
*
*   @return integer : tous les champs de la table utilisateur
*/
function get_plateforme_individus_old($type, $ordre, $exclusif) {
	/*
	$req="SELECT * FROM utilisateurs order by nom;";
	$individus=pg_query($req);
	
	// retourne 0 (false) ou 1 (true)
	return $individus;
	*/
	$req = "select num_user, nom, prenom,num_org FROM utilisateurs";
	if ($type != 0)
		$req .= " where ";
	// On veut les formateurs
	if ($type == 1||$type==3) {
		// Les 'f' seulement
		if ($exclusif == 'true')
			$req .= " categorie LIKE 'f' ";
		// Les 'f' et les 'fu'
		else
			$req .= "  categorie LIKE '%f%' ";
	} else {
		// On veut les stagiaires
		if ($type == 2) {
			// les 'u' seulement
			if ($exclusif == 'true')
				$req .= "  categorie LIKE 'u' ";
			// Les 'u' et les 'fu'
			else
				$req .= " A categorie LIKE '%u%' ";
		}
	}
	$req .= " ORDER BY nom $ordre;";
	//echo "$req<br>";
	$individus = pg_query($req);
	return $individus;
}

/**
*   Obtenir toutes les individus de la plateforme
*
*   Retourne la totalit� des informations de tous les individus de la plateforme
* 
*	@param integer type d'individus voulus : 0=>tous, 1=>formateurs, 2=>utilisateurs)
*	@param varchar ordre du tris sur le nom (ASC ou DESC)
*	@param bool selection excusive? true ou false.
*
*    @return integer : resultat de la requete (id integer, nom varchar, prenom varchar,organisme int4)
*/
function get_plateforme_individus($type, $ordre, $exclusif) {

	if (VERSION_BASE > VERSION) {

		$req = "SELECT * FROM  contraintes.af_get_individus($type,'$ordre',$exclusif)
		        AS (id integer, nom varchar, prenom varchar,organisme int4)";
		//echo "req=$req<br>";
		$individus = pg_query($req);
	} else // Fonction de substitution
		$individus = get_plateforme_individus_old($type, $ordre, $exclusif);

	// retourne 0 (false) ou 1 (true)
	return $individus;
}


/**
*   Obtenir toutes les individus de la plateforme qui ne sont pas de certains types
*
*   Retourne l'identifiant, nom ,prenom et l'organisme de tous les individus de la plateforme
* 	n'tant pas des types d'individus dfinis.
* 
*	@param integer[] types d'individus voulus non voulus, NULL pour tous
*	@param varchar ordre du tris sur le nom (ASC ou DESC)
*	@param bool selection excusive? true ou false.
*
*    @return integer : resultat de la requete (id integer, nom varchar, prenom varchar,organisme int4)
*/
function get_plateforme_individus_except_individus_types($except_types, $ordre, $exclusif) {

	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.fw_get_individus_except_individus_types($except_types, '$ordre', $exclusif) AS (id integer, nom varchar, prenom varchar, organisme integer)";
		//echo "req=$req<br>";
		$individus = pg_query($req);
	}
	return $individus;
}

/**
*   Obtenir toutes les individus de la plateforme
*
*   Retourne la totalit� des informations de tous les individus de la plateforme
* 
*	@param integer type d'individus voulus : 0=>tous, 1=>formateurs, 2=>utilisateurs)
*	@param varchar ordre du tris sur le nom (ASC ou DESC)
*	@param bool selection excusive? true ou false.
*
*    @return integer : resultat de la requete (id integer, nom varchar, prenom varchar,organisme int4)
*/
function get_plateforme_inscriptions() {

	if (VERSION_BASE > VERSION) {

		$req = "SELECT * FROM  contraintes.af_get_inscriptions()
		        AS (id integer,identifiant_md5 varchar,login varchar,password varchar,nom varchar, prenom varchar,
				adresse varchar,code varchar,ville varchar,email varchar,tel_fix varchar,tel_port varchar,
				lang int4,organisme int4,photo int4)";
		//echo "req=$req<br>";
		$individus = pg_query($req);
	} else // Fonction de substitution
		//$individus = get_plateforme_individus_old($type, $ordre, $exclusif);
		print("n'existe pas");
	// retourne 0 (false) ou 1 (true)
	return $individus;
}

/**
*  obtenir la liste des formations qui ont des �valuations corrig�es   (OLD)
* 	Note: cette fonction a ete enomee, son ancien non est get_formation()
*  Retourne les num�ros de formation ainsi que le nom
*
*    @param  integer : le type de classement
*    @param  string : param�tre de date
*    @return integer : la liste des num�ros de formation et leur nom
*/
function get_formations_evaluations_finies_old($date_form, $classement) {
	$date_courante = date("Y-m-d");
	// on s�lectionne les formations termin�es (date de fin d�pass�e!)
	if ($date_form == "old") {
		$signe = "<";
		if ($classement == 1)
			$order = "order by nom_cal asc";
		else
			$order = "";
	}
	elseif ($date_form == "current") {
		$signe = ">=";
		if ($classement == 1)
			$order = "order by nom_cal asc";
		else
			$order = "";
	}

	$req = "select distinct id_formation, nom_cal
	            from res_serie, calendrier, dates
	            where score >=0
	            and jour $signe '$date_courante'
	            and id_formation=num_cal
	            and datefin=num_date
	            union
	            select distinct rs.num_cal, nom_cal
	            from resexouser rs, calendrier c, dates
	            where rs.num_cal <>0
	            and jour $signe '$date_courante'
	            and rs.num_cal=c.num_cal
	            and datefin=num_date
	            $order";
	$res = pg_query($req);
	return ($res);
}

/**
*  obtenir la liste des formations qui ont des �valuations corrig�es
* 	Note: cette fonction a ete enomee, son ancien non est get_formation()
*  Retourne les num�ros de formation ainsi que le nom
*
*    @param  integer : le type de classement
*    @param  string : param�tre de date
*    @return integer : la liste des num�ros de formation et leur nom
*/
function get_formations_evaluations_finies($date_form, $classement) {
	if (VERSION_BASE > VERSION) {

	} else
		$res = get_formations_evaluations_finies_old($date_form, $classement);
	return ($res);
}

/**
	Obtenir toutes les formations.
	
	Resultat:
	 num_cal | nom_cal | datedeb | datefin | langue | lower(nom_cal) as minus
	@deprecated utiliser get_plateforme_formations() 
	 @return integer le resultat de la requete
*/
function get_formations_old() {
	$sql = "select distinct num_cal, nom_cal, datedeb, datefin, langue, lower(nom_cal) as minus
			from  CALENDRIER , GESTIONNAIRE 
			WHERE g_num_cal=num_cal
			order by minus;";

	return pg_query($sql);
}

/**
	Obtenir toutes les formations.
	
	Resultat:
	 num_cal | nom_cal | datedeb | datefin | langue | lower(nom_cal) as minus
	 @deprecated utiliser get_plateforme_formations() 
	 @return integer le resultat de la requete
*/
function get_formations() {

	if (VERSION_BASE > VERSION) {

	} else
		$res = get_formations_old();

	return ($res);
}

/**
 * Obtenir toutes les formations de la plate-forme. (OLD)
 * 
 * Les parametres de la fonction permettent un classement et/ou un tris sur les formations.
 * Sans parametre, cette fonction retourne toutes les formations class�es par libell� croissant.
 *  
 * @param varchar : ordre de classement ('asc' ou 'desc')
 * @param varchar :'libelle' ou 'date_debut' (order by)
 * @param integer : p�riode (1 : pass�es, 2 : pr�sentes, 3 : futures, 0 toutes)
 * @return integer le resultat de la requete: (id int4,libelle varchar,dat_deb timestamp,dat_fin timestamp,langue int4)
 */
function get_plateforme_formations_old($classement, $ordre, $periode) {

	if ($periode != "0") {
		if ($periode != "1" && $periode != "2" && $periode != "3") {
			$cond_d = " AND (";
			$cond_m = "";
			$cond_m_val = " OR ";
			$cond_f = " ) ";
		} else {
			$cond_d = " AND ";
			$cond_m = "";
			$cond_m_val = " AND ";
			$cond_f = "";
		}

		if ($periode == 1) {
			$condition .= "  D2.jour < current_date ";
			$cond_m = $cond_m_val;
		}

		if ($periode == 2) {
			$condition .= "$cond_m  NOT (D1.jour > current_date OR D2.jour < current_date) ";
			$cond_m = $cond_m_val;
		}

		if ($periode == 3)
			$condition .= "$cond_m  D1.jour > current_date ";
	}

	$sql = "select distinct num_cal, nom_cal, D1.jour as debut, D2.jour as fin, langue, lower(nom_cal) as minus
			from  CALENDRIER , GESTIONNAIRE, dates D1, dates D2 
			WHERE g_num_cal=num_cal
			AND D1.num_date=datedeb
	        AND D2.num_date=datefin
			$cond_d  $condition $cond_f
			order by minus;";

	//echo $sql . "<BR>";
	return pg_query($sql);
}

/**
 * Obtenir toutes les formations de la plate-forme.
 * 
 * Les parametres de la fonction permettent un classement et/ou un tris sur les formations.
 * Sans parametre, cette fonction retourne toutes les formations class�es par libell� croissant.
 *  
 * @param varchar : ordre de classement ('asc' ou 'desc')
 * @param varchar :'libelle' ou 'date_debut' (order by)
 * @param integer : p�riode (1 : pass�es, 2 : pr�sentes, 3 : futures, 0 toutes)
 * @return integer le resultat de la requete: (id int4,libelle varchar,dat_deb timestamp,dat_fin timestamp,langue int4)
 */
function get_plateforme_formations($classement = "ASC", $ordre = "libelle", $periode = 0) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_formations('$classement','$ordre',$periode) as 
						(id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees bool)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formations_old($classement, $ordre, $periode);
	return ($res);
}

/**
*	Obtenir les informations des groupes qui ont des exostlc de corriges. (OLD)
*   
*    @return integer : liste des numeros de groupe, leur nom et le numero de leur pere
*/
function get_groupes_exostlc_corriges_old() {
	$req = "select * from classe where id in (select distinct gu_num_gest_gr from GESTIONUTIL) order by nom;";

	return (pg_query($req));

}

/**
*	Obtenir les informations des groupes qui ont des exostlc de corriges.
*    
*    @return integer : liste des num�ros de groupe, leur nom et le numero de leur pere
*/
function get_groupes_exostlc_corriges() {
	if (VERSION_BASE > VERSION) {

	} else
		$res = get_groupes_exostlc_corriges_old();
	return ($res);
}

/**
*   obtenir la liste des groupes qui ont des �valuations corrig�es (OLD)
*
*   Retourne les num�ros de groupes ainsi que le nom
*
*    @param  integer : le type de classement
*    @return integer : liste des num�ros de groupe et leur nom
*
*/
function get_groupes_evaluation_finie_old($classement) {
	if ($classement == 1)
		$order = "order by nom asc";
	else
		$order = "";

	$req = "select distinct gu_num_gest_gr,nom
	                        from gestionutil, classe
	                        where gu_num_gest_gr=id
	                        and gu_num_user in ( select distinct id_stag
	                                                            from res_serie
	                                                            where score >=0
	                                                            union
	                                                            select distinct num_user
	                                                            from resexouser
	                                                            where num_cal <>0)
	                        and gu_num_user in ( select num_user
	                                                            from utilisateurs
	                                                            where categorie like '%u%')
	                        $order";

	return (pg_query($req));

}

/**
*   obtenir la liste des groupes qui ont des �valuations corrig�es
*
*   Retourne les num�ros de groupes ainsi que le nom
*
*    @param  integer : le type de classement
*    @return integer : liste des num�ros de groupe et leur nom
*
*/
function get_groupes_evaluation_finie($classement) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from _af_get_groupes_evaluation_finie($classement) AS (num_grp integer, nom_groupe varchar)";
		$res = pg_query($req);
	} else
		$res = get_groupes_evaluation_finie_old($classement);
	return ($res);
}

/**
*   Obtenir la liste des stagiaires ayant des evaluations valid�es (OLD)
*
*   Retourne la liste des stagiaires
*
*    @param  integer : type de classement
*     @return integer : liste des num�ros de stagiaires et leur nom
*
*/
function get_stagiaires_evaluation_finie_old($classement) {
	if ($classement == 1)
		$order = "order by nom asc";
	else
		$order = "";

	$req = "select id_stag, nom
	            from res_serie, utilisateurs
	            where id_formation in (select distinct g_num_cal from gestionnaire)
	            and num_user=id_stag
	            and score >=0
	            union
	            select ru.num_user, nom
	            from resexouser ru, utilisateurs u
	            where num_cal in (select distinct g_num_cal from gestionnaire)
	            and u.num_user=ru.num_user
	            and num_cal <>0
	            $order";
	return (pg_query($req));
}

/**
*   Obtenir la liste des stagiaires ayant des evaluations valid�es
*
*   Retourne la liste des stagiaires
*
*    @param  integer : type de classement
*
*
*/
function get_stagiaires_evaluation_finie($classement) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_stagiaires_evaluation_finie($classement) AS (id_stag integer,nom_stag varchar)";
		$res = pg_query($req);
	} else
		$res = get_stagiaires_evaluation_finie_old($classement);

	return $res;
}

/**
	Obtenir l'identifiant et le nom prenom des stagiaires 
	ayant eut des exercices a telecharger corriges
	
	format du resultat:
	num_user | nom prenom
	
	note: le nom et le prenom sont concatenes dans une meme
	colonne de resultat, separes par un espace.
	
	@return integer  l'entier resultat de la requete.
*/
function get_stagiaires_exotlcs_corriges_old() {
	$sql = "	select DISTINCT num_user, textcat(textcat(nom,text ' '), prenom) AS nomprenom 
						from UTILISATEURS, GESTIONUTIL 
						where categorie LIKE '%u%' 
						and gu_num_user=num_user 
						and num_user in (
							select distinct gesttlc_user 
							from gestexotlc
						) 
						order by nomprenom;";
	//echo $sql;
	return pg_query($sql);
}

/**
	Obtenir l'identifiant et le nom prenom des stagiaires 
	ayant eut des exercices a telecharger corriges
	
	format du resultat:
	num_user | nom prenom
	
	note: le nom et le prenom sont concatenes dans une meme
	colonne de resultat, separes par un espace.
	
	@return integer  l'entier resultat de la requete.
*/
function get_stagiaires_exotlcs_corriges() {

	if (VERSION_BASE > VERSION) {

	} else
		$res = get_stagiaires_exotlcs_corriges_old();

	return $res;
}
/**
* Obtenir la liste des formations qui ont des sondages valid�s
*
* Retourne la liste des sondages
*
* @param string : date
* @param string : classement
*
*/
function get_formations_sondage_fini_old($classement, $date) {
	$liste_sondage = "('s','o')";
	if ($classement == "old")
		$signe = "<";
	else
		$signe = ">=";

	$req = "select id_formation,nom_cal, lower(nom_cal) as minus
	            from res_serie_exo, calendrier, dates
	            where type_exo in $liste_sondage
	            and jour $signe '$date'
	            and id_formation=num_cal
	            and datefin=num_date
	            group by id_formation,nom_cal
	            order by minus asc";

	return (pg_query($req));
}

/**
* Obtenir la liste des formations qui ont des sondages valid�s
*
* Retourne la liste des sondages
*
* @param string : date
* @param string : classement
* @return integer : liste des num�ros de stagiaires et leur nom
*/
function get_formations_sondage_fini($classement, $date) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_formations_sondage_fini('$classement','$date') AS (id_formation smallint, nom varchar,minus text)";
		$res = pg_query($req);
	} else
		$res = get_formations_sondage_fini_old($classement, $date);

	return $res;
}

/**
* Obtenir la liste des droits par default (OLD).
*
* Obtenir la liste des droits par default pour la categorie d'utilisateur sp�cifi�e.
*
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_droits_defaut_old($categorie) {

	if ($categorie == 0) {
		$selection = " type_droit='u' or type_droit='f' ";
	} else {
		if ($categorie == 1) {

			$selection = " type_droit='f' ";
		} else {

			if ($categorie == 2) {
				$selection = " type_droit='u' ";
			} else {
				echo "Erreur: la categorie selectionnee est invalide.";
			}

		}

	}

	$req = "select * from droit where defaut=1 and $selection ;";
     echo "req=$req<br>";
	$res = pg_query($req);

	return ($res);
}

/**
* Obtenir la liste des droits par default.
*
* Obtenir la liste des droits par default pour la categorie d'utilisateur sp�cifi�e.
*
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_droits_defaut($categorie) {
	if (VERSION_BASE > VERSION) {
		/*
		$req="select * 
		FROM _af_get_droits_defaut($categorie) 
		AS (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer) ;";
		*/
		$req = "select * from contraintes.af_get_droits_defaut($categorie) as (id int4,libelle varchar,type int4)";
		$res = pg_query($req);
	} else
		$res = get_droits_defaut_old($categorie);
	return $res;
}

/**
*   Obtenir toutes les tests de la plateforme (OLD)
*
*   Retourne la totalit� des informations de tous les tests de la plateforme
*
*   @return integer : tous les champs 
*/
function get_plateforme_tests_old() {
	$req = "SELECT id_liste_test, nom_liste_test, dynamique, continue, media_liste_test, longueur_media, largeur_media FROM liste_test";
	$tests = pg_query($req);

	return $tests;
}

/**
*   Obtenir toutes les tests de la plateforme
*
*   Retourne la totalit� des informations de tous les tests de la plateforme
*
*   @return integer : tous les champs 
*/
function get_plateforme_tests() {
	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_get_tests() AS (id int4, libelle varchar, dynamique bool, continu bool, media int4, longueur_media int4, largeur_media int4, date_creation timestamp)";
		$tests = pg_query($req);
	} else // Fonction de substitution
		$tests = get_plateforme_tests_old();
	return $tests;
}

/**
*   R\�cup�rer les diff�rents organismes de la plate forme (OLD)
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_organismes_old() {
	$sql = "select * from organisme order by libelle_org;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents organismes de la plate forme
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_organismes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_plateforme_organismes() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_organismes_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents th�mes des formations de la plate forme (OLD)
*  @deprecated : utiliser get_plateforme_themes_formation()
*   Retourne les  th�mes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les th�mes des formations de la plateforme
*
*/
function get_themes_formations_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in
	            (select num_thematik from gestparcours where g_num_parcours in
	            (select distinct g_num_parcours from gestionnaire) and num_etape=1) order by nom_theme;";

	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents th�mes des formations  de la plate forme
*   @deprecated : utiliser get_plateforme_themes_formation()
*   Retourne les  th�mes ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les th�mes des formations de la plateforme
*
*/
function get_themes_formations() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_themes_formations_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents groupes des formations de la plate forme (OLD)
*   @deprecated : utiliser get_plateforme_classes_formation()
*   Retourne les  groupes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les groupes des formations de la plateforme
*
*/
function get_groupes_formations_old() {
	$sql = "select id,nom from classe where id in
	            (select distinct g_num_gest_g from gestionnaire) order by nom";

	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents groupes formations  de la plate forme
*  @deprecated : utiliser get_plateforme_classes_formation()
*   Retourne les  groupes ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les groupes des formations de la plateforme
*
*/
function get_groupes_formations() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_groupes_formations_old();
	return $res;
}

/**
*   Recuperer les diff\erents formateurs formations  de la plate forme (OLD)
*
*   Retourne les  formateurs ordonne alphabetiquement pas leur nom
*	@deprecated utiliser get_plateforme_formateurs()
*    @return  integer : les formateurs des formations de la plateforme
*
*/
function get_formateurs_formations_old() {
	$sql = "select num_user,nom,prenom from utilisateurs where categorie like '%f%' and num_user in
	            (select distinct g_num_user from gestionnaire) order by nom";

	return (pg_query($sql));
}

/**
*   Recuperer les diff\erents formateurs formations  de la plate forme
*
*   Retourne les  formateurs ordonne alphabetiquement pas leur nom
*    @deprecated utiliser get_plateforme_formateurs()
*    @return  integer : les formateurs des formations de la plateforme
*
*/
function get_formateurs_formations() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_formateurs_formations_old();
	return $res;
}

/**
*   Recuperer tous les formateurs  de la plate forme (OLD)
*
*   Retourne les  formateurs ordonne alphabetiquement pas leur nom
*
*    @return  integer : les formateurs des formations de la plateforme
*
*/
function get_plateforme_formateurs_old() {
	$sql = "	select num_user,  textcat(textcat(nom,text ' '), prenom) AS nomprenom, lower(nom) AS ordre
	    			from utilisateurs 
	    			where categorie like '%f%' 
	    			and num_user in
	            		(select distinct g_num_user from gestionnaire) 
	            	order by ordre";

	return (pg_query($sql));
}

/**
*   Recuperer tous les formateurs  de la plate forme
*
*   Retourne les  formateurs ordonne alphabetiquement pas leur nom
*
*    @return  integer : les formateurs des formations de la plateforme
*
*/
function get_plateforme_formateurs() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_formateurs($user_id) as (formateur int4,nom_prenom text)";
		//echo "$sql";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formateurs_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents stagiaires des formations de la plate forme (OLD)
*
*   Retourne les  stagiaires ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les stagiaires des formations de la plateforme
*
*/
function get_stagiaires_formations_old() {
	$sql = "select num_user,nom,prenom from utilisateurs where num_user in
	            (select distinct gp_num_user from gestionparcours) and categorie='u' or categorie='fu' order by nom";

	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents stagiaires formations  de la plate forme
*
*   Retourne les  stagiaires ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les stagiaires des formations de la plateforme
*
*/
function get_stagiaires_formations() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_stagiaires_formations_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rentes salles de la plate forme (OLD)
*
*   Retourne les  salles ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les salles de la plateforme
*
*/
function get_salles_old() {
	$sql = "select * from salle order by nom_salle;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rentes salles de la plate forme
*
*   Retourne les  salles ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les salles de la plateforme
*
*/
function get_salles() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_salles() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_salles_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rentes salles de la plate forme (OLD)
*
*   Retourne les  salles ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les salles de la plateforme
*
*/
function get_plateforme_salles_old() {
	$sql = "select * from salle order by nom_salle;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rentes salles de la plate forme
*
*   Retourne les  salles ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les salles de la plateforme
*
*/
function get_plateforme_salles() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_salles() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_salles_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rentes interventions de la plate forme (OLD)
*
*   Retourne les  interventions ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les interventions de la plateforme
*
*/
function get_interventions_old() {
	$sql = "select * from intervention order by nom;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rentes interventions de la plate forme
*
*   Retourne les  interventions ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les interventions de la plateforme
*
*/
function get_interventions() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_interventions_old();
	return $res;
}

/**
*   R�cuperer les diff�rentes fili�res de la plate-forme (OLD)
*
*   Retourne les fili�res ordonn�es alphab�tiquement par leur nom
*
*   @return integer : les fili�res de la plate-forme

*/
function get_filieres_old($parent) {
	$sql = "select * from filiere where id_pere='$parent' order by nom;";
	return (pg_query($sql));
}
/**
*   R�cuperer les diff�rentes fili�res de la plate-forme
*
*   Retourne les fili�res ordonn�es alphab�tiquement par leur nom
*
*   @return integer : les fili�res de la plate-forme

*/
function get_filieres($parent=null) {
	if (VERSION_BASE > VERSION) {
		if(empty($parent))$sql = "select * from contraintes.af_get_filieres() as (id int4, libelle varchar,pere int4, indice int4)";
		else $sql="A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_filieres_old($parent);
	return $res;
}

/**
*   R\�cup�rer les diff�rentes sections de la plate forme (OLD)
*
*   Retourne les  sections ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les sections de la plateforme
*
*/
function get_sections_old() {
	$sql = "select num_section,titre ,icone,lower(titre) as ordre from ressource_sec order by ordre;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rentes sections de la plate forme
*
*   Retourne les  sections ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les sections de la plateforme
*
*/
function get_sections() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_sections() as (id int4, libelle varchar,icone int4)";
		$res = pg_query($sql);
	} else
		$res = get_sections_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents espaces de la plate forme (OLD)
*
*   Retourne les  espaces ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les espaces de la plateforme
*
*/
function get_espaces_old() {
	$sql = "select num_espace,titre,lower(titre) as ordre from ressource_esp order by ordre;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents espaces de la plate forme
*
*   Retourne les  espaces ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les espaces de la plateforme
*
*/
function get_espaces() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_espaces() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_espaces_old();
	return $res;
}

/**
*   R�cup�rer les diff�rents themes des ressources de la plate forme (OLD)
*
*   Retourne les  themes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les themes des ressources de la plateforme
*
*/
function get_plateforme_themes_ressource_old() {
	$sql = "(select t.num_themedir,t.nom_theme,lower(t.nom_theme) as ordre from themedir t where t.num_themedir in
	        (select distinct f.num_themedir from ressource_fic f where f.num_fic in
	        (select distinct g.num_fic from ressource_gest g where type='f'))
	         )
	         union
	         (select t.num_themedir,t.nom_theme ,lower(t.nom_theme) as ordre from themedir t where t.num_themedir in
	        (select distinct x.num_themedir from ressource_txt x where x.num_text in
	        (select distinct g.num_fic from ressource_gest g where type='t'))
	         )  order by ordre";
	return (pg_query($sql));
}
/**
*   R�cup�rer les diff�rents themes des tapes ressources de la plate forme
*
*   Retourne les  th�mes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les themes des ressources de la plateforme
*
*/
function get_plateforme_themes_etape_ressource() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(39,$user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_themes_ressource_old();
	return $res;
}

/**
	Obtenir les themes des fichiers ressources fichier de la plateforme 
	@return integer : res req
*/
function get_plateforme_themes_ressource_fichier(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql = "select * from contraintes.af_get_categorie_themes(7,$user_id) as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
	Obtenir les themes des fichiers ressources texte de la plateforme 
	@return integer : res req
*/
function get_plateforme_themes_ressource_texte(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql = "select * from contraintes.af_get_categorie_themes(26,$user_id) as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
	Obtenir les themes des fichiers ressources scenario de la plateforme 
	@return integer : res req
*/
function get_plateforme_themes_ressource_scenario(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql = "select * from contraintes.af_get_categorie_themes(1,$user_id) as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
	Obtenir les themes des fichiers ressources scenario_dynamique de la plateforme 
	@return integer : res req
*/
function get_plateforme_themes_ressource_scenario_dynamique(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql = "select * from contraintes.af_get_categorie_themes(59,$user_id) as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
	Obtenir les themes des fichiers ressource (fichier + texte + scenario + scenario_dynamique)
	@return integer : res req
*/
function get_plateforme_themes_ressource_fichier_texte(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql="select * from contraintes.af_get_themes_ressource_fichier_texte($user_id) as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
 * Obtenir les themes des fichiers glossaire
 * @return integer : res req
 * 
 */
 function get_plateforme_themes_ressource_glossaire(){
 	global $auth;
 	$user_id=$auth->getUserId();
 	$sql="select * from contraintes.af_get_categorie_themes(66,$user_id) as (id int4,libelle varchar)";
 	return pg_query($sql);
 }

/**
*   R�cup�rer les diff�rents parcours de la plate forme (OLD)
*
*   Retourne les  parcours ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les parcours de la plateforme
*
*/
function get_plateforme_parcours_old() {
	$sql = "select num_parcours,nom_parcours,lower(nom_parcours) as ordre from parcours order by ordre;";
	return (pg_query($sql));
}
/**
*   R�cup�rer les diff�rents parcours de la plate forme
*
*   Retourne les  parcours ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les parcours de la plateforme
*/
function get_plateforme_parcours() {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_parcours()AS (id integer, libelle varchar, filiere int4 , duree bool, date_creation timestamp) order by libelle";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_parcours_old();
	return $res;
}

/**
*   R�cup�rer les diff�rents th�mes de la plate forme (OLD)
*   Retourne les  themes ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les th�mes de la plateforme :(id int4, libelle varchar, repertoire text)
*
*/
function get_plateforme_themes_old() {
	$themes = "select * from THEMEDIR order by nom_theme;";
	return (pg_query($themes));
}

/**
*   R�cup�rer les diff�rents themes de la plate forme
*   Retourne les  themes ordonne alphabetiquement pas leur nom
*
*    @return  integer : les th�mes de la plateforme :(id int4, libelle varchar, repertoire text)
*
*/
function get_plateforme_themes() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$req = "select * from contraintes.af_get_themes(".$auth->getUserId().") AS (id int4, libelle varchar, repertoire text, individu integer) order by libelle";
		$themes = pg_query($req);
	} else
		$themes = get_plateforme_themes_old();
	return $themes;
}
function get_plateforme_all_themes() {
	if (VERSION_BASE > VERSION) {
		
		$req = "select * from contraintes.af_get_all_themes() AS (id int4, libelle varchar, repertoire text)";
		$themes = pg_query($req);
	} else
		$themes = get_plateforme_themes_old();
	return $themes;
}

/**
*   Obtenir les parcours attach�s de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_attaches_old() {
	$sql = "select distinct attach_parcours from gestparcours";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les parcours attach�s de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_attaches() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_parcours_attaches_old();
	return $res;
}

/**
*   Obtenir les parcours en formation de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_formation_old() {
	$sql = "select distinct g_num_parcours from gestionnaire";
	$res = pg_query($sql);
	return $res;
}
/**
*   Obtenir les parcours en formation de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_formation() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_parcours_formation_old();
	return $res;
}

/**
*   Obtenir les sous-parcours des parcours dynamiques de la plateforme (OLD)
*
*   @return integer : le resultat de la requete  (id int4, libelle varchar, filiere int4)
*/
function get_plateforme_parcourss_orientes_souss_parcourss_old() {
	$sql = "select sousparcours from config_orientation";
	$res = pg_query($sql);
	$ss_parcours = pg_fetch_result($res, 0, 0);

	$req = "	SELECT num_parcours, nom_parcours, num_c_q_e_d 
			  	FROM parcours, gestparcours
				WHERE num_parcours=g_num_parcours AND type_etape='S'
				AND num_parcours IN ($ss_parcours)";
	return pg_query($req);
}
/**
*   Obtenir les sous-parcours des parcours dynamiques de la plateforme
*
*   @return integer : le resultat de la requete  (id int4, libelle varchar, filiere int4)
*/
function get_plateforme_parcourss_orientes_souss_parcourss() {
	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_get_parcours_orientes_sous_parcours() AS (id int4, libelle varchar, filiere int4) "; 
		//echo "$req<br>";
		$res = pg_query($req);
	} else
		$res = gget_plateforme_parcourss_orientes_souss_parcourss_old();
	return $res;
}

/**
*   Obtenir les parcours non attach� de la plateforme pour un niveau donn� (OLD)
*
*   @param integer : le niveau
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_non_attaches_old($rang) {
	$sql = "select * from parcours where num_parcours in
	                (select distinct g_num_parcours from gestparcours where num_rang='$rang') and num_parcours not in
	                (select g_num_parcours from gestparcours where attach_parcours>0 and type_etape='T') order by nom_parcours;";
	$res = pg_query($sql);
	return $res;
}
/**
*   Obtenir les parcours non attach� de la plateforme pour un niveau donn�
*
*   @param integer : le niveau
*   @return integer : le resultat de la requete
*/
function get_plateforme_parcours_non_attaches($rang) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_parcours_non_attaches_old($rang);
	return $res;
}

/**
*   Obtenir les liste de test d'auto-positionnement de la plate forme (OLD);
*
*   @return integer : le resultat de la plateforme
*/
function get_plateforme_liste_test_old() {
	$sql = "select * from liste_test where id_liste_test in (select id_liste_test from asso_liste_test) order by nom_liste_test";
	$res = pg_query($sql);
	return $res;
}
/**
*   Obtenir les liste de test d'auto-positionnement de la plate forme
*
*   @return integer : le resultat de la plateforme
*/
function get_plateforme_liste_test() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_liste_test_old();
	return $res;
}



function get_plateforme_themes_positionnement_old() {
	$sql = "select distinct num_themedir,nom_theme,lower(nom_theme) as ordre from themedir T,serie_exo S, test E where T.num_themedir=S.theme AND S.id=E.id_test order by ordre";
	//echo "$sql<br>";
	$res = pg_query($sql);

	return $res;
}

function get_plateforme_themes_positionnement() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes_type_evaluation(22,1) as (id int4, libelle varchar)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_themes_positionnement_old();
	return $res;
}

/**
    Obtenir les baremes de la plateforme (OLD)

    @return integer :  le resultat de la requete
*/
function get_plateforme_baremes_old() {
	$sql = "SELECT * FROM bareme ORDER BY libelle_bareme";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les baremes de la plateforme

    @return integer :  le resultat de la requete
*/
function get_plateforme_baremes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_baremes() as (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4) ";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_baremes_old();
	return $res;
}

/**
    Obtenir les diff�rents themes des qcm de la plateforme (OLD)

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_qcm_old() {
	$sql = "select distinct num_themedir, nom_theme, lower(nom_theme) AS ordre from themedir T, question Q where num_themedir=theme order by ordre ;";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les diff�rents themes des qcm de la plateforme

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_qcm() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_themes_qcm_old();
	return $res;
}

/**
    Obtenir les interventions de la plateforme (OLD)

*   @return integer : le resultat de la requete
*/
function get_plateforme_interventions_old() {
	$sql = "select id,nom,code_couleur from intervention order by nom";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les interventions de la plateforme

*   @return integer : le resultat de la requete
*/
function get_plateforme_interventions() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_interventions() as (id int4,libelle varchar,couleur varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_interventions_old();
	return $res;
}

/**
    Obtenir les infos d'une modalite (OLD)
*
*   @param integer : le numero de modalite
*   @return integer : le resultat de la requete
*/
function get_plateforme_modalite_infos_old($modalite) {
	$sql = "select * from typeform where num_typeform=$modalite";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les infos d'une modalite
*
*   @param integer : le numero de modalite
*   @return integer : le resultat de la requete
*/
function get_plateforme_modalite_infos($modalite) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_modalite_infos_old($modalite);
	return $res;
}

/**
    Obtenir les calendriers de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_calendriers_old() {
	$sql = "select distinct g_num_cal from gestionnaire;";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les calendriers de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_calendriers() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_calendriers_old();
	return $res;
}

/**
    Supprime les calendriers inutilis�s (OLD)
*
*   @return integer : le resultat de la requete
*/
function del_plateforme_calendriers_old() {
	$sql = "delete from calendrier where num_cal not in (select g_num_cal from gestionnaire);";
	$del = pg_query($sql);
	return $del;
}
/**
    Supprime les calendriers inutilis�s (OLD)
*
*   @return integer : le resultat de la requete
*/
function del_plateforme_calendriers() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = del_plateforme_calendriers_old();
	return $res;
}

/**
*   Obtenir les infos du formateur par defaut.  (OLD)
*	    
*	Le login et le mot de passe de l'utilisateur par d�faut sont d�finis dans le fichier dbpostgres_fonction.php.
*   @param varchar : le login
*   @param varchar : le mot de passe
*   @return integer : le resultat de la requete  (id int4 , md5 varchar,login  varchar, password varchar, nom  varchar, prenom varchar , adresse varchar , code  varchar, ville  varchar,email  varchar, tel_fixe  varchar, tel_port  varchar, langue int4 , organisme int4, photo int4)
*/
function get_plateforme_formateur_defaut_old($login, $password) {
	$sql = "select num_user , id_user ,login , password, nom , prenom , adresse , code , ville ,email , telfixe , telport , langue , num_org ,  fic_photo  from utilisateurs where login like '$login' and password like '$password';";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les infos du formateur par defaut
*	@deprecated version - Dec 11, 2008 La notion de formateur par defaut a ete supprimee
*   @param varchar : le login
*   @param varchar : le mot de passe
*   @return integer : le resultat de la requete (id int4 , md5 varchar,login  varchar, password varchar, nom  varchar, prenom varchar , adresse varchar , code  varchar, ville  varchar,email  varchar, tel_fixe  varchar, tel_port  varchar, langue int4 , organisme int4, photo int4)
*/
function get_plateforme_formateur_defaut($login, $password) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_individu('$login','$password') AS (id int4 , md5 varchar,login  varchar, password varchar, nom  varchar, prenom varchar , adresse varchar , code  varchar, ville  varchar,email  varchar, tel_fixe  varchar, tel_port  varchar, langue int4 , organisme int4, photo int4)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formateur_defaut_old($login, $password);
	return $res;
}

/**
    Obtenir les formateurs utilisateurs de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_formateurs_utilisateurs_old() {
	$sql = "select * from utilisateurs where categorie='f' or categorie='fu' order by nom;";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les formateurs utilisateurs de la plateforme
*
*   @return integer : le resultat de la requete 
*/
function get_plateforme_formateurs_utilisateurs() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_formateurs_utilisateurs_old();
	return $res;
}

/**
    Obtenir les filieres ayant des parcours (OLD)
*
*   @return integer : le resultat de la requete (id int4, libelle varchar, pere int4)
*/
function get_plateforme_filieres_parcours_old() {
	$sql = "select distinct num_c_q_e_d, nom, id_pere from gestparcours, filiere where num_etape=1 AND id=num_c_q_e_d;";
	$res = pg_query($sql);
	return $res;
}
/**
*    Obtenir les filieres ayant des parcours
*
*   @return integer : le resultat de la requete: (id int4, libelle varchar, pere int4)
*/
function get_plateforme_filieres_parcours() {
	if (VERSION_BASE > VERSION) {
//		  $sql="select * from contraintes.af_get_classe_peres_fils() as (id int4,nom varchar,id_pere int4,min int4,max int4) order by id";
		$sql = "SELECT * FROM contraintes.af_get_filieres_parcours(NULL) AS (id int4, libelle varchar, pere int4)";
		//echo "$sql";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_filieres_parcours_old();
	return $res;
}

/**
    Obtenir les themes pour les exercices "remplir les blancs" (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_themes_blanc_old() {
	$sql = "SELECT num_themedir, nom_theme, lower(nom_theme) AS ordre FROM themedir where num_themedir in
	                (select theme from gest_ftb) ORDER BY ordre";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les themes pour les exercices "remplir les blancs"
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_themes_blanc() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_themes_blanc_old();
	return $res;
}

/**
    Obtenir les exotlc de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_exotlcs_old() {
	$sql = "select * from exotlc";
	return (pg_query($sql));
}
/**
    Obtenir les exotlc de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_exotlcs() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_exotlcs() as (id int4,commentaire text,texte text,enonce text,remarque text,type int4)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_exotlcs_old();
	return $res;
}

/**
    Obtenir les theme des exotlc (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_exotlc_themes_old() {
	$sql = "select distinct themedir.num_themedir, themedir.nom_theme ,lower(themedir.nom_theme) as minus from exotlc, themedir ,
	                fictlc, gestfic where fictlc.num_themedir=themedir.num_themedir and fictlc.num_fic=gestfic.gestfic_num_fic and
	                gestfic.gestfic_num_exo=exotlc.num_exo order by minus;";
	return (pg_query($sql));
}
/**
    Obtenir les theme des exotlc 
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_exotlc_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(33,$user_id) as (id int4,libelle varchar)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_exotlc_themes_old();
	return $res;
}

/**
    Obtenir tous les formateurs strict de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_formateurs_strict_old() {
	$sql = "select num_user,nom,prenom from utilisateurs where categorie like '%f%' order by nom";
	return (pg_query($sql));
}
/**
    Obtenir tous les formateurs strict de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_formateurs_strict() {
	if (VERSION_BASE > VERSION) {
		//$res=get
	} else
		$res = get_plateforme_formateurs_strict_old();
	return $res;
}

/**
    Obtenir les formations qui ont des fichiers rendu (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_formations_fichier_rendu_old() {
	$sql = "select * from calendrier where num_cal in (select distinct num_cal from reception_exostlc)";
	return (pg_query($sql));
}
/**
    Obtenir les formations qui ont des fichiers rendu (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_formations_fichier_rendu() {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_formations_fichier_rendu() as (id int4,libelle varchar)";
		$res=pg_query($sql);
	} 
	else
		$res = get_plateforme_formations_fichier_rendu_old();
	return $res;
}

/**
    Obtenir les criteres de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_criteres_old() {
	$sql = "select * from rubrique order by libelle_rub";
	return (pg_query($sql));
}
/**
    Obtenir les criteres de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_criteres() {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_plateforme_criteres_old();
	return $res;
}

/**
    Obtenir les alertes non li�es � une formation (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes_non_liees_old() {
	$sql = "select num_alert,intitule,texte from alert where num_cal=0";
	return (pg_query($sql));
}
/**
    Obtenir les infos des alertes non li�es � une formation
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes_non_liees() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_alertes_non_liees() as (id int4,libelle varchar,formation int4,date date,jours int4,texte text)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_alertes_non_liees_old();
	return $res;
}

/**
    Obtenir les infos des alertes attachees � une formation (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes_liees_old() {
	$sql = "select num_alert,intitule,A.num_cal,D.jour,periode,texte from alert A,calendrier C,dates D
	                where A.num_cal!='0' and C.num_cal=A.num_cal and A.num_date=D.num_date order by jour";
	return (pg_query($sql));
}
/**
    Obtenir les infos des alertes attachees � une formation
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes_liees() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_alertes_liees($user_id) as  (id int4,libelle varchar,formation int4,date date,jours int4,texte text) order by date";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_alertes_liees_old();
	return $res;
}

/**
    Obtenir les alertes de la plateforme (OLD)
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes_old() {
	$sql = "select A.num_alert,A.intitule,A.num_cal,D.jour,A.periode,A.texte  from 
				alert A,dates D where A.num_date=D.num_date";
	
	return (pg_query($sql));
}
/**
    Obtenir les alertes de la plateforme
*
*   @return integer : le resultat de la requete
*/
function get_plateforme_alertes() {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_alertes() as (id int4,libelle varchar,formation int4,date date,jours int4,texte text)";
		$res=pg_query($sql);
	} else
		$res = get_plateforme_alertes_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents organismes des individu de la plate forme (OLD)
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_plateforme_organismes_individu_old() {
	$sql = "select * from organisme where num_org in (select num_org from utilisateurs where
	                categorie='fu' or categorie='f' or categorie='u') order by libelle_org;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents organismes de la plate forme
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_plateforme_organismes_individu() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_organismes_non_vide() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_organismes_individu_old();
	return $res;
}

/**
    Verifier si un login est deja utilise (OLD)
*   @param string : le libelle du login
    @return bool : true = existe sinon false
*/
function check_plateforme_login_utilise_old($libelle) {
	$sql = "select * from utilisateurs where login='$libelle'";
	$res = pg_query($sql);
	if (pg_num_rows($res) > 0)
		return true;
	return false;
}
/**
    Verifier si un login est deja utilise
*   @param string : le libelle du login
    @return bool : true = existe sinon false
*/
function check_plateforme_login_utilise($libelle) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_is_login_ok('$libelle')";
		$res = pg_query($sql);
		return 't'!=pg_fetch_result($res, 0, 0);
	} else
		$res = check_plateforme_login_utilise_old($libelle);
	//return $res;
}

/**
    Verifier si un login est deja utilise dans la table inscription
*   @param string : le libelle du login
    @return bool : true = existe sinon false
*/
function check_plateforme_login_inscription_utilise($libelle) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_is_login_inscription_ok('$libelle')";
		echo "sql=$sql<br>";
		$res = pg_query($sql);
		return 't'!=pg_fetch_result($res, 0, 0);
	} else
		$res = check_plateforme_login_utilise_old($libelle);
	//return $res;
}

/**
    Remplace un formateur de la plateforme (OLD)
*
*   @param integer : le numero du formateur � remplacer
*   @param integer : le nouveau formateur
*   @return integer : le resultat de la requete
*/
function maj_plateforme_formateur_old($formateur, $nouveau_formateur) {
	$sql = "update gestionnaire set g_num_user=$nouveau_formateur where g_num_user=$formateur";
	$maj = pg_query($sql);
	$sql = "update exotlc set formateur=$nouveau_formateur where formateur=$formateur";
	$maj = pg_query($sql);
	return $maj;
}
/**
    Remplace un formateur de la plateforme
*
*   @param integer : le numero du formateur � remplacer
*   @param integer : le nouveau formateur
*   @return integer : le resultat de la requete
*/
function maj_plateforme_formateur($formateur, $nouveau_formateur) {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = maj_plateforme_formateur_old($formateur, $nouveau_formateur);
	return $res;
}

/**
    Supprime toutes les occurences d'un individu de la plateforme (OLD)
*
*   @param integer : le numero de l'individu
*   @return integer : le resultat de la requete
*/
function del_plateforme_individu_old($individu) {
	$sql = "delete from asso_exo_serie_aleatoire where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from comment_presentiel where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from commentairepage where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from commentuserrub where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from config_grille where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from connexion where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from gestexotlc where gesttlc_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from gestionparcours where gp_num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from notation where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from reception_exostlc where num_stag=$individu";
	$del = pg_query($sql);
	$sql = "delete from res_liste where id_stag=$individu";
	$del = pg_query($sql);
	$sql = "delete from res_liste_test where id_stag=$individu";
	$del = pg_query($sql);
	$sql = "delete from res_serie  where id_stag=$individu";
	$del = pg_query($sql);
	$sql = "delete from res_serie_exo where id_stag=$individu";
	$del = pg_query($sql);
	$sql = "delete from resexouser where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from scorm_sco_users where userid=$individu";
	$del = pg_query($sql);
	$sql = "delete from session where num_user=$individu";
	$del = pg_query($sql);
	$sql = "delete from stockresultserie where num_user=$individu";
	$del = pg_query($sql);
	return $del;
}
/**
    Supprime toutes les occurences d'un individu de la plateforme
*
*   @param integer : le numero de l'individu
*   @return integer : le resultat de la requete
*/
function del_plateforme_individu($individu) {
	if (VERSION_BASE > VERSION) {
		//$sql="A IMPLEMENTER";
		//$res=pg_query($sql);
		$res = 1;
	} else
		$res = del_plateforme_individu_old($individu);
	return $res;
}

/**
* Obtenir la liste des droits par default (OLD).
*
* Obtenir la liste des droits par default pour la categorie d'utilisateur sp�cifi�e.
*
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_plateforme_droits_defaut_old($categorie) {
	if ($categorie == 0) {
		$selection = " type_droit='u' or type_droit='f' ";
	} else {
		if ($categorie == 1) {
			$selection = " type_droit='f' ";
		} else {
			if ($categorie == 2) {
				$selection = " type_droit='u' ";
			} else {
				echo "Erreur: la categorie selectionnee est invalide.";
			}
		}
	}
	$req = "select * from droit where defaut=1 and $selection ;";
	$res = pg_query($req);
	return ($res);
}
/**
* Obtenir la liste des droits par default.
*
* Obtenir la liste des droits par default pour la categorie d'utilisateur sp�cifi�e.
*
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_plateforme_droits_defaut($categorie) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_droits_defaut($categorie) AS (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer) ;";
		$res = pg_query($req);
	} else
		$res = get_plateforme_droits_defaut_old($categorie);
	return $res;
}

/**
*   R�cup�rer les diff�rents groupes des formations de la plate forme (OLD)
*
*   Retourne les  groupes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les groupes des formations de la plateforme
*
*/
function get_plateforme_groupes_formations_old() {
	$sql = "select id,nom from classe where id in
	            (select distinct g_num_gest_g from gestionnaire) order by nom";
	return (pg_query($sql));
}
/**
*   R�cup�rer les diff�rents groupes formations  de la plate forme
*
*   Retourne les  groupes ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les groupes des formations de la plateforme
*
*/
function get_plateforme_groupes_formations() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_groupes_formations_old();
	return $res;
}

/**
	Obtenir les cat�gories disponibles pour la plateforme.
	@return integer : le resultat de la requete (id integer, libelle varchar, table_cible varchar, gestionnaire_contenus boolean, table_etape varchar)
*/
function get_plateforme_categories() {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM contraintes.af_get_categories() AS (id integer, libelle varchar, table_cible varchar, gestionnaire_contenus boolean, table_etape varchar) ;";
		$res = pg_query($req);
	} else
		print ("La fonction get_plateforme_categories() n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**
	Obtenir les cat�gories disponibles pour la plateforme.
*/
function get_plateforme_categories_gestionnaire_contenus($gestionnaire_contenus) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM contraintes.af_get_categories($gestionnaire_contenus) AS (id integer, libelle varchar, table_cible varchar, gestionnaire_contenus boolean, table_etape varchar) ;";
		//echo $req."<BR>";
		$res = pg_query($req);
	} else
		print ("La fonction get_plateforme_categories() n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**
	Obtenir les noms des individus qui se sont connect�s (OLD)
 *
 *	@return integer : le resultat de la requete
*/
function get_plateforme_nom_individus_connexion_old() {
	$sql = "select nom from utilisateurs where num_user in (select distinct num_user from connexion) order by nom  asc";
	return (pg_query($sql));
}
/**
	Obtenir les noms des individus qui se sont connect�s
 *
 *	@return integer : le resultat de la requete
*/
function get_plateforme_nom_individus_connexion() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_nom_individus_connexion_old();
	return $res;
}

/**
	Obtenir les numeros,noms et prenoms des individus dont les noms commencent par l'initiale donn�e (OLD)
 *
 *	@param string : l'initiale
 *	@return integer : le resultat de la requete
*/
function get_plateforme_individus_initiale_old($initiale, $type = "") {
	$sql = "select num_user,nom,prenom from utilisateurs where nom like '$initiale%' ";
	if (!empty ($type))
		$sql .= "and categorie like '%$type%' ";
	$sql .= "order by nom asc";
	return (pg_query($sql));
}
/**
	Obtenir les numeros,noms et prenoms des individus dont les noms commencent par l'initiale donn�e
 *
 *	@param string : l'initiale
 *	@return integer : le resultat de la requete
*/
function get_plateforme_individus_initiale($initiale,$type,$classement,$exclusif) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_individus_initiale('$initiale',$type,'$classement','$exclusif') as (id int4,nom varchar,prenom varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_individus_initiale_old($initiale);
	return $res;
}

/**
	Obtenir les individus de la plateforme (OLD)
*	@param string : le type (u,f,fu)
*	@return integer : le resultat de la requete
*/
/*
function get_plateforme_individus_old($type){
	$sql="select num_user,nom,prenom from utilisateurs where categorie like '%$type%' order by nom asc";
	return (pg_query($sql));
}
*/
/**
	Obtenir les individus de la plateforme
*	@param string : le type (u,f,fu)
*	@return integer : le resultat de la requete
*/
/*
function get_plateforme_individus($type){
	if (VERSION_BASE > VERSION) {
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
		
    }
    else
        $res=get_plateforme_individus_old($type);
    return $res;
}
*/
/**
	Obtenir les dates de connexion des individus (OLD)
 *
 *	@return integer : le resultat de la requete
*/
function get_plateforme_individus_connexions_old() {
	$sql = "select num_user,max(date_connexion) as maxdate,ip from connexion group by num_user,ip order by maxdate";
	return (pg_query($sql));
}
/**
	Obtenir les dates de connexion des individus
 *
 *	@return integer : le resultat de la requete
*/
function get_plateforme_individus_connexions() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_individus_connexions_old();
	return $res;
}

/**
	Obtenir le infos individus actuellement connect�s (OLD)
 *
 * 	@return integer : le resultat de la requete
*/
function get_plateforme_individus_connectes_old() {
	$sql = "select u.nom,u.prenom,u.categorie,s.num_cal from utilisateurs u,session s where u.num_user=s.num_user";
	return (pg_query($sql));
}
/**
	Obtenir le infos individus actuellement connect�s
 *
 * 	@return integer : le resultat de la requete
*/
function get_plateforme_individus_connectes() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_individus_connectes_old();
	return $res;
}

/**
	Obtenir les formations poss�dant au moins une liste de tests d'auto-positionnement (OLD)
*
* 	@return integer : le resultat de la requete
*/
function get_plateforme_formations_auto_positionnement_old() {
	$sql = "select num_cal,nom_cal from calendrier where num_cal in (select distinct id_formation from res_liste) order by nom_cal";
	return (pg_query($sql));
}
/**
	Obtenir les formations poss�dant au moins une liste de tests d'auto-positionnement
*
* 	@return integer : le resultat de la requete
*/
function get_plateforme_formations_auto_positionnement() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formations_auto_positionnement_old();
	return $res;
}

/**
	Obtenir les themes qui ont des sondages (OLD)
 *
 *	@return integer : le resultat de la requete
*/
function get_plateforme_themes_sondage_old() {
	$sql = "select distinct num_themedir,nom_theme,lower(nom_theme) as ordre from themedir,question_sondage
				where num_themedir=theme order by ordre";
	return (pg_query($sql));
}
/**
	Obtenir les themes qui ont des sondages
 *
 *	@return integer : le resultat de la requete
*/
/*
function get_plateforme_themes_sondage() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_themes_sondage_old();
	return $res;
}
*/

/**
	Obtenir les formateurs qui ont des formations avec du presentiel not� (OLD)

 	@return integer : le reultat de la requete
*/
function get_plateforme_formateurs_formation_presentiel_note_old() {
	$sql = "select num_user,nom,prenom from utilisateurs where categorie like '%f%' and num_user in
				(select g_num_user from gestionnaire where g_num_cal in
				(select distinct num_cal from notation))";
	return (pg_query($sql));
}
/**
	Obtenir les formateurs qui ont des formations avec du presentiel not�

 	@return integer : le reultat de la requete
*/
function get_plateforme_formateurs_formation_presentiel_note() {
	if (VERSION_BASE > VERSION) {
		$sql = "A IMPLEMENTER";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formateurs_formation_presentiel_note_old();
	return $res;
}

/**
	Obtenir les formations presentes qui ont des cours presentiels (OLD)

 	@return integer : le resultat de la requete
*/
function get_plateforme_formations_presentielles_presentes_old() {
	$sql = "select num_cal,nom_cal from calendrier,dates as A,dates as B 
				where A.num_date=datedeb and B.num_date=datefin and current_date between A.jour and B.jour and  num_cal in
				(select distinct g_num_cal from gestionnaire where g_num_cal in
				(select distinct gnum_cal from gest_cal where numtype=3))";

	return (pg_query($sql));
}
/**
	Obtenir les formations presentes qui ont des cours presentiels

 	@return integer : le resultat de la requete
*/
function get_plateforme_formations_presentielles_presentes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_formations_presentielles() as (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)"; 
		$res = pg_query($sql);
	} else
		$res = get_plateforme_formations_presentielles_presentes_old();
	return $res;
}

/**
	Obtenir les themes de la plateforme pour les blancs (OLD)
	@return integer : resultat de la requete
*/
function get_plateforme_ftb_themes_old() {
	$sql = "select * from themedir where num_themedir in (select theme from gest_ftb) order by nom_theme";
	return pg_query($sql);
}
/**
	Obtenir les themes de la plateforme pour les blancs
	@return integer : resultat de la requete
*/
function get_plateforme_ftb_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(14,$user_id) as (id int4, libelle varchar) order by lower(libelle)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_ftb_themes_old();
	return $res;
}

/**
	Obtenir les themes de la plateforme pour les sondages (old)
	@return integer : resultat requete
*/
function get_plateforme_sondage_themes_old() {
	$sql = " select * from themedir where num_themedir in (select theme from question_sondage)";
	return pg_query($sql);
}
/**
	Obtenir les themes de la plateforme pour les sondages
	@return integer : resultat requete
*/
function get_plateforme_sondage_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes_type_evaluation(27,2,$user_id) as (id int4, libelle varchar)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_sondage_themes_old();
	return $res;
}

/**
	Obtenir les themes de la plateforme pour les qcm (old)
	@return integer : resultat requete
*/
function get_plateforme_qcm_themes_old() {
	$sql = " select * from themedir where num_themedir in (select theme from question)";
	return pg_query($sql);
}
/**
	Obtenir les themes de la plateforme pour les qcm
	@return integer : resultat requete
*/
function get_plateforme_qcm_themes() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_categorie_themes_type_evaluation(27,1,$user_id) as (id int4, libelle varchar)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_qcm_themes_old();
	return $res;
}

///**
//	Obtenir les themes de la plateforme pour les series (OLD)
//	@return integer : resultat requete
//*/
//function get_plateforme_serie_themes_old() {
//	$sql = "SELECT num_themedir, nom_theme, lower(nom_theme) AS ordre
//	                FROM themedir WHERE num_themedir IN
//	                        (SELECT theme FROM serie_exo
//	                        WHERE id NOT IN
//	                                (SELECT num_serie FROM serie_aleatoire)
//	                        AND id IN
//	                                (SELECT id_serie FROM asso_exo_serie))
//	                ORDER BY ordre";
//	return pg_query($sql);
//}
///**
//	Obtenir les themes de la plateforme pour les series 
//	@return integer : resultat requete
//*/
//function get_plateforme_serie_themes() {
//	if (VERSION_BASE > VERSION) {
//		$sql = "select * from contraintes.af_get_categorie_themes(19) as (id int4,libelle varchar)";
//		echo $sql."<br>";
//		$res = pg_query($sql);
//	} else
//		$res = get_plateforme_serie_themes_old();
//	return $res;
//}
/**
    R�cup�rer les diff�rents themes des series de la plateforme (OLD)

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_serie_old() {
	$sql = "select distinct num_themedir,nom_theme,lower(nom_theme) as ordre from themedir T,serie_exo S where T.num_themedir=S.theme order by ordre";
	$res = pg_query($sql);
	return $res;
}
/**
    R�cup�rer les diff�rents themes des series de la plateforme

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_serie() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		//$sql = "select * from contraintes.af_get_categorie_themes_type_evaluation(27,1) as (id int4, libelle varchar)";
		$sql = "select * from contraintes.af_get_categorie_themes(19,$user_id) as (id int4,libelle varchar)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_themes_serie_old();
	return $res;
}

/**
    R�cup�rer les diff�rents themes des series de la plateforme (OLD)

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_qsrc_old() {
	$sql = "select distinct num_themedir,nom_theme,lower(nom_theme) as ordre from themedir T,serie_exo S where T.num_themedir=S.theme order by ordre";
	$res = pg_query($sql);
	return $res;
}
/**
    R�cup�rer les diff�rents themes des series de la plateforme

    @return integer : le resultat de la requete
*/
function get_plateforme_themes_qsrc() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(23,$user_id) as (id int4,libelle varchar)";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_themes_qsrc_old();
	return $res;
}

/**
	Obtenir les series aleatoires de la plateforme pour un type  (OLD)
	@param integer : le mode
	@return integer : resultat requete
*/
function get_plateforme_series_aleatoires_old($type) {
	$sql = "SELECT DISTINCT num_serie, titre, lower(titre) AS ordreAff
	                FROM serie_aleatoire, serie_exo
	                WHERE id=num_serie
	                AND mode=$type
	                ORDER BY ordreAff";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les series aleatoires de la plateforme pour un type
	@param integer : le mode (ex : 2=monotheme,3=multitheme)
	@return integer : resultat requete
*/
function get_plateforme_series_aleatoires($type) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_series_aleatoires_type($type) as (id int4,libelle varchar)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_series_aleatoires_old($type);
	return $res;
}

/**
	Obtenir les themes de la plateforme pour les series aleatoires monothemes (OLD)
	@return integer : resultat requete
*/
function get_plateforme_serie_aleatoire_multiserie_themes_old() {
	$sql = "SELECT DISTINCT num_themedir, nom_theme, lower(nom_theme) AS ordre FROM themedir T, Serie_exo S, serie_aleatoire SA
	                WHERE T.num_themedir=S.theme
	                AND S.id=SA.num_serie
	                ORDER BY ordre";
	//echo "sql=$sql<br>";
	return pg_query($sql);

}
/**
	Obtenir les themes de la plateforme pour les series aleatoires monothemes 
	@return integer : resultat requete
*/
function get_plateforme_serie_aleatoire_multiserie_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_aleatoire_multiserie_themes($user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_serie_aleatoire_multiserie_themes_old();
	return $res;
}

/**
	Obtenir les themes de la plateforme pour les series aleatoire configur�es (OLD)
	@return integer : resultat requete
*/
function get_plateforme_serie_aleatoire_configuree_themes_old() {
	$sql = "SELECT DISTINCT num_themedir, nom_theme, lower(nom_theme) AS ordre FROM themedir T, Serie_exo S, gestserie G
	                WHERE T.num_themedir=S.theme
	                AND S.id=G.num_serie
	                ORDER BY ordre";
	return pg_query($sql);
}
/**
	Obtenir les themes de la plateforme pour les series aleatoire configur�es 
	@return integer : resultat requete
*/
function get_plateforme_serie_aleatoire_configuree_themes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_aleatoire_configuree_themes() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_serie_aleatoire_configuree_themes_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rents organismes de la plate forme (OLD)
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_plateforme_organismes_old() {
	$sql = "select * from organisme order by libelle_org;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents organismes de la plate forme
*
*   Retourne les  organisme ordonn� alphab�tiquement pas leur nom
*
*    @return  integer : les organismes de la plateforme
*
*/
function get_plateforme_organismes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_organismes() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_organismes_old();
	return $res;
}

/**
	Obtenir les classes de la plateforme (OLD)
	@return integer : resultat requete
*/
function get_plateforme_classes_old() {
	$sql = "select id,nom,id_pere,minplace,maxplace from classe,placegroupe where id=num_gest_groupe order by nom";
	return pg_query($sql);
}
/**
	Obtenir les classes de la plateforme 
	@return integer : resultat requete :(id int4,libelle varchar,pere int4,min int4, max int4)
*/
function get_plateforme_classes() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_classes() as (id int4,libelle varchar,pere int4,min int4, max int4)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_classes_old();
	return $res;
}

/**
	Obtenir les themes des fichiers exotlc (OLD)
	@return integer : resultat requete
*/
function get_plateforme_fichier_exotlc_themes_old() {
	$sql = " select * from THEMEDIR where num_themedir in (select num_themedir from FICTLC) order by nom_theme;";
	return pg_query($sql);
}
/**
	Obtenir les themes des fichiers exotlc 
	@return integer : resultat requete
*/
function get_plateforme_fichier_exotlc_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(5,$user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_fichier_exotlc_themes_old();
	return $res;
}

/**
	Obtenir les themes des capacites (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_capacite_themes_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from capacite) order by nom_theme";
	return pg_query($sql);
}
/**
	Obtenir les themes des capacites 
	@return integer  : resultat requete
*/
function get_plateforme_capacite_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(10,$user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_capacite_themes_old();
	return $res;
}

/**
	Obtenir les themes des titre de capacites (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_titrecapacite_themes_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from titrecapacite) order by nom_theme";
	return pg_query($sql);
}
/**
	Obtenir les themes des capacites 
	@return integer  : resultat requete
*/
function get_plateforme_titrecapacite_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(11,$user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_titrecapacite_themes_old();
	return $res;
}

/**
	Obtenir les themes des grille (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_grille_themes_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from grille) order by nom_theme";
	return pg_query($sql);
}
/**
	Obtenir les themes des grilles
	@return integer  : resultat requete
*/
function get_plateforme_grille_themes() {
	global $auth;
	$user_id=$auth->getUserId();
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(15,$user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_grille_themes_old();
	return $res;
}

/**
	Obtenir les theme des couples titrecapacite / capacite (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_titrecapacite_capacites_themes_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from titrecapacite where num_titrecapacite in 
				(select tr_num_titrecapacite from titrecapa))";
	return pg_query($sql);
}
/**
	Obtenir les theme des couples titrecapacite / capacite 
	@return integer  : resultat requete
*/
function get_plateforme_titrecapacite_capacites_themes() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_capacite_titre_capacite_themes($user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_titrecapacite_capacites_themes_old();
	return $res;
}

/**
	Obtenir les theme des couples grille / titrecapacite (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_grille_titrecapacites_themes_old() {
	$sql = "select num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from grille where num_grille in 
				(select gt_num_grille from grilletitrecapa))";
	return pg_query($sql);
}
/**
	Obtenir les theme des couples titrecapacite / capacite 
	@return integer  : resultat requete
*/
function get_plateforme_grille_titrecapacites_themes() {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_grille_capacite_titre_themes($user_id) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_grille_titrecapacites_themes_old();
	return $res;
}

/**
	Obtenir les classes (avec individu) de la plateformes (OLD)
	@return integer  : resultat requete
*/
function get_plateforme_classes_individu_old() {
	$sql = "select * from classe where id in (select distinct gu_num_gest_gr from GESTIONUTIL) order by nom";
	return pg_query($sql);
}
/**
	Obtenir les classes (avec individu) de la plateformes
	@return integer  : resultat requete
*/
function get_plateforme_classes_individu() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_classes_individu() as (id int4,libelle varchar,pere int4,max int4,min int4)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_classes_individu_old();
	return $res;
}

/**
* Obtenir la liste des droits  (OLD).
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_plateforme_droits_old($categorie) {
	if ($categorie == 0) {
		$selection = " type_droit='u' or type_droit='f' ";
	} else {
		if ($categorie == 1) {
			$selection = " type_droit='f' ";
		} else {
			if ($categorie == 2) {
				$selection = " type_droit='u' ";
			} else {
				echo "Erreur: la categorie selectionnee est invalide.";
			}
		}
	}
	$req = "select num_droit,libelle_droit,type_droit,defaut  from droit where  $selection ;";

	$res = pg_query($req);

	return ($res);
}

/**
* Obtenir la liste des droits .
* @param integer : 0 tous, 1, formateurs, 2 utilisateurs
* @return integer : les droits  (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer)
*
*/
function get_plateforme_droits($categorie) {
	if (VERSION_BASE > VERSION) {
		/*
		$req="select * 
		FROM _af_get_droits_defaut($categorie) 
		AS (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer) ;";
		*/
		$req = "select * from contraintes.af_get_droits($categorie) as (id int4,libelle varchar,type int4,defaut bool)";
		$res = pg_query($req);
	} else
		$res = get_plateforme_droits_old($categorie);
	return $res;
}

/**
 * Obtenir les langues de la plate-forme.(OLD)
 * 
 * Retourne un tableau contenant les chemins vers les langues.
 * 
 * @return array() un tableau contenant les chemins vers les langues
 */
function get_plateforme_langues_old() {
	global $chemin_bo;
	global $serverback;

	$langues = array ();
	$badRep = array (
		".",
		".."
	);
	$lang_bo = $chemin_bo . "/lang/";

	if ($dirLang = opendir($lang_bo)) {
		$i = 0;
		while ($repLang = readdir($dirLang)) {
			$cheminRepLang = $lang_bo . $repLang;
			if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)) {
				$langues[$i] = $repLang;
				$i++;
			}
		}
	} else
		print die("Impossible de lire le r&eacute;pertoire des langues");

	return ($langues);
}

/**
 * Obtenir les langues de la plate-forme.
 * 
 * Retourne un tableau contenant les chemins vers les langues.
 * 
 * @return array() un tableau contenant les chemins vers les langues
 */
function get_plateforme_langues() {
	global $chemin_bo;
	global $serverback;

	if (VERSION_BASE > VERSION) {
		$langues = array ();
		$lang_bo = $chemin_bo . "/lang/";

		$sql = "select * from contraintes.af_get_langues() as (id int4,libelle varchar, code varchar, locale varchar)";
		$res = pg_query($sql);

		while ($row = pg_fetch_row($res)) {
			$langues[] = $lang_bo . $row[0];
		}

		return $langues;
	} else {
		return get_plateforme_langues_old();
	}
}

/**
 * Obtenir les langues de la plate-forme.
 * @return integer :res req
 */
function get_plateforme_langues2() {
	$sql = "select * from contraintes.af_get_langues() as (id int4,libelle varchar, code varchar, locale varchar)";
	return  pg_query($sql);

		
}

/**
 * Obtenir les langues disponibles de la plate-forme.(OLD)
 * 
 * Retourne un tableau contenant les chemins vers les langues disponibles.
 * Toutes les langues sont disponibles si la plate-forme n'est pas une plate-forme h�berg�e (pas une PGR).
 * Si la plate-forme est herg�e (donc une PGR), les langues disponibles sont celles qui sont
 * pr�sentes dans le fichier config_site.php. 
 * 
 *  @return array() un tableau contenant les chemins vers les langues disponibles [0]contient le code de la langue,[1] son lib�ll� et [2] le code.
 */
function get_plateforme_langues_disponibles_old() {
	global $chemin_bo;
	global $serverback;
	global $site_heberge;
	global $MSG_1594, $MSG_1595, $MSG_1596, $MSG_1597, $MSG_1598, $MSG_2175, $MSG_2176;
	$lang_dispo = array ();
	$badRep = array (
		".",
		".."
	);
	//$lang_bo = $chemin_bo . "/lang/";
	// NOUVEAU SYSTEME DE LANGUE
	$lang_bo = $chemin_bo . "/langues/";
	if ($dirLang = opendir($lang_bo)) {
		$i = 0;
		while ($repLang = readdir($dirLang)) {
			$cheminRepLang = $lang_bo . $repLang;
			if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)) {
				switch ($repLang) {
					case 'french' : case 1 :
						$langue_option = $MSG_1594;
						if (L_French == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'english' : case 2 :
						$langue_option = $MSG_1595;
						if (L_English == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'chinese' : case 3 :
						$langue_option = $MSG_1596;
						if (L_Chinese == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'japanese' : case 4 :
						$langue_option = $MSG_1597;
						if (L_Japanese == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'korean' : case 5 :
						$langue_option = $MSG_1598;
						if (L_Korean == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'russian' : case 6 :
						$langue_option = $MSG_2175;
						if (L_Russian == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'sudan' : case 7 :
						$langue_option = $MSG_2176;
						if (L_Sudan == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
				}

				//si la plate-forme est une pgr, on affiche toutes les langues
				if ($site_heberge != 1) {
					$affiche_langue = true;
				}
				if ($affiche_langue) {
					$lang_dispo[$i][0] = $repLang;
					$lang_dispo[$i][1] = $langue_option;
					$lang_dispo[$i][2] = $repLang;
					$i++;
				}
			}
		}
	} else
		print die("Impossible de lire le r&eacute;pertoire des langues");

	return $lang_dispo;
}

/**
 * Obtenir les langues disponibles de la plate-forme.
 * 
 * Retourne un tableau contenant les chemins vers les langues disponibles.
 * Toutes les langues sont disponibles si la plate-forme n'est pas une plate-forme h�berg�e (pas une PGR).
 * Si la plate-forme est herg�e (donc une PGR), les langues disponibles sont celles qui sont
 * pr�sentes dans le fichier config_site.php. 
 * 
 * @return array() un tableau contenant les chemins vers les langues disponibles [0]contient le code de la langue,[1] son lib�ll� et [2] le code.
 */
function get_plateforme_langues_disponibles() {
	global $chemin_bo;
	global $serverback;
	global $site_heberge;

	if (VERSION_BASE > VERSION) {
		$lang_dispo = array ();
		$lang_bo = $chemin_bo . "/lang/";

		$sql = "select * from contraintes.fw_get_langues() as (id int4,libelle varchar, code varchar, locale varchar)";
		$res = pg_query($sql);
		$nb_langues = pg_num_rows($res);

		for ($i = 0; $i < $nb_langues; $i++) {
			$row = pg_fetch_row($res, $i);
			//site heberg�?
			/*
			if ($site_heberge == 1) {
				//langue autoris�e?
				//eval ("$exp=($row[2]==1);");
				//if ($exp) {
					$lang_dispo[] = $row[1];
				//}
			} else {
			*/
				$lang_dispo[$i][0] = $row[0];
				$lang_dispo[$i][1] = $row[1];
				$lang_dispo[$i][2] = $row[2];
			//}
		}
		return $lang_dispo;
	} else {
		return get_plateforme_langues_disponibles_old();
	}
}

/**
	Obtenir les filieres des formations de la plateforme (OLD)
	@return integer : resultat requete (id,libelle,pere)
*/
function get_plateforme_filieres_formation_old(){
	$sql="select distinct f.id,f.nom,f.id_pere from filiere f,gestparcours gp,gestionnaire g
				where gp.num_etape=1 and gp.num_c_q_e_d=f.id and gp.g_num_parcours=g.g_num_parcours";
	return pg_query($sql);  
}
/**
	Obtenir les filieres des formations de la plateforme 
	@return integer : resultat requete (id,libelle,pere)
*/
function get_plateforme_filieres_formation(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_filieres_formation() as (id int4,libelle varchar,pere int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_filieres_formation_old();
	return $res;
}

/**
	Obtenir les groupes des formation de la plateforme (OLD)
	@return integer : resultat requete (id,libelle,pere)
*/
function get_plateforme_classes_formation_old(){
	$sql="select distinct c.id,c.nom,c.id_pere from classe c,gestionnaire g
				where c.id=g.g_num_gest_g";
	return pg_query($sql);
}
/**
	Obtenir les groupes des formation de la plateforme 
	@return integer : resultat requete (id,libelle,pere)
*/
function get_plateforme_classes_formation(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_classes_formation() as  (id int4,libelle varchar,pere int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_classes_formation_old();
	return $res;
}

/**
	Obtenir les stagiaires des formations de la plateforme (OLD)
	@return integer : resultat requete (id,nom,prenom)
*/
function get_plateforme_stagiaires_formation_old(){
	$sql="select distinct num_user,nom,prenom from utilisateurs u,gestionutil gu,gestionnaire g
				where u.num_user=gu.gu_num_user and gu.gu_num_gest_gr=g.g_num_gest_g";
	return pg_query($sql);
}
/**
	Obtenir les stagiaires des formations de la plateforme 
	@return integer : resultat requete (id,nom,prenom)
*/
function get_plateforme_stagiaires_formation(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_stagiaires_formation() as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_stagiaires_formation_old();
	return $res;
}

/**
	Obtenir les modalites de la plateforme  (OLD)
	@return integer :resultat requete (id,libelle,code) 
*/
function get_plateforme_modalites_old(){
	$sql="select * from typeform";
	return pg_query($sql);
}
 /**
	Obtenir les modalites de la plateforme  
	@return integer :resultat requete (id,libelle,code) 
*/
function get_plateforme_modalites(){
	 if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_modalites() as (id int4,libelle varchar,code varchar)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_plateforme_modalites_old();
	 return $res;
}

/**
	Obtenir les intervenants de la plateforme  (OLD)
	
	@return integer : resultat requete ( )
*/
function get_plateforme_intervenants_old(){

}
/**
	Obtenir les intervenants de la plateforme  
	
	@return integer : resultat requete ( )
*/
function get_plateforme_intervenants(){
	 if (VERSION_BASE > VERSION) {
	 	global $auth;
		$user_id=$auth->getUserId();
		$sql="select * from contraintes.af_get_intervenants($user_id) as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_plateforme_intervenants_old();
	 return $res;
}

/**
	Obtenir les intervenants presentiels qui ont des grilles not�es (OLD)
	@return integer : res req
*/
function get_plateforme_intervenants_presentiel_grille_old(){
	$sql="select distinct num_user,nom,prenom from utilisateurs where num_user in
				(select num_intervenant from gest_cal where gnum_cal in 
				(select distinct num_cal from notation))";
	return pg_query($sql);
}
/**
	Obtenir les intervenants presentiels qui ont des grilles not�es 
	@return integer : res req
*/
function get_plateforme_intervenants_presentiel_grille(){
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
		$sql="select * from contraintes.af_get_intervenants_presentiel_grille($user_id) as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);
	}
	else
		return get_plateforme_intervenants_presentiel_grille_old();
	return $res;
}

/**
	Obtenir les infos d'un individu � partir de son login et passeword (OLD)
	@param string : login
	@param string : pass
	@return integer : res req
*/
function get_plateforme_individu_log_pass_old($login,$password){
	$sql = "select num_user , id_user ,login , password, nom , prenom , adresse , code , ville ,email , telfixe , telport , langue , num_org ,  fic_photo  from utilisateurs where login like '$login' and password like '$password';";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}
/**
	Obtenir les infos d'un individu � partir de son login et passeword 
	@param string : login
	@param string : pass
	@return integer : res req
*/
function get_plateforme_individu_log_pass($login,$password){
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_individu('$login','$password') AS (id int4 , md5 varchar,login  varchar, password varchar, nom  varchar, prenom varchar , adresse varchar , code  varchar, ville  varchar,email  varchar, tel_fixe  varchar, tel_port  varchar, langue int4 , organisme int4, photo int4)";
		$res = pg_query($sql);
	}
	else
		$res=get_plateforme_individu_log_pass_old($login,$password);
	return $res;
}

/**
*   R\�cup�rer les diff�rents espaces de la plate forme (OLD)
*
*   Retourne les  espaces ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les espaces de la plateforme
*
*/
function get_plateforme_espaces_old() {
	$sql = "select num_espace,titre,lower(titre) as ordre from ressource_esp order by ordre;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rents espaces de la plate forme
*
*   Retourne les  espaces ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les espaces de la plateforme
*
*/
function get_plateforme_espaces() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_espaces() as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_espaces_old();
	return $res;
}

/**
*   R\�cup�rer les diff�rentes sections de la plate forme (OLD)
*
*   Retourne les  sections ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les sections de la plateforme
*
*/
function get_plateforme_sections_old() {
	$sql = "select num_section,titre ,icone,lower(titre) as ordre from ressource_sec order by ordre;";
	return (pg_query($sql));
}
/**
*   R\�cup�rer les diff�rentes sections de la plate forme
*
*   Retourne les  sections ordonn�es alphab�tiquement pas leur nom
*
*    @return  integer : les sections de la plateforme
*
*/
function get_plateforme_sections() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_sections() as (id int4, libelle varchar,icone int4)";
		$res = pg_query($sql);
	} else
		$res = get_plateforme_sections_old();
	return $res;
}

/**
	Obtenir les types de page de la plateforme (old)
	@return  integer : les types de page  de la plateforme
*/
function get_plateforme_pages_types_old(){
	$sql="select * from categoriepage order by libelle_categorie";
	return pg_query($sql);
}
/**
	Obtenir les types de page de la plateforme 
	@return  integer : les types de page  de la plateforme
*/
function get_plateforme_pages_types(){
	if (VERSION_BASE > VERSION) {
	    $sql="select * from contraintes.af_get_pages_types() as (id int4,libelle varchar,code varchar) order by libelle";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_pages_types_old();
	return $res;
}

/**
	Obtenir les infos individus de la plateforme (old)
	@return integer : (id,identifiant,login,password,nom,prenom,adresse,code,ville,email,telfix,telport,langue,organisme,photo)
*/
function get_plateforme_individus_infos_old($selection,$ordre,$exclusif){

}
/**
	Obtenir les infos individus de la plateforme (old)
	@return integer : (id,identifiant,login,password,nom,prenom,adresse,code,ville,email,telfix,telport,langue,organisme,photo)
*/
function get_plateforme_individus_infos($selection,$ordre,$exclusif){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_individus_infos($selection,'$ordre','$exclusif') 
				as (id int4,identifiant varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,
				email varchar,tel_fixe varchar,tel_port varchar,langue int4,organisme int4,photo int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_individus_infos_old($selection,$ordre,$exclusif);
	return $res;
}

/**
	Obtenir les configurations pour les forums
	@return integer :
*/
function get_plateforme_forum_environnements(){
	$sql="select * from contraintes.af_get_forum_environnements() 
		as (id int4,libelle varchar,chemin varchar,db_type varchar,db_serveur varchar,db_name varchar,db_user varchar,db_pwd varchar,
		admin varchar,admin_pwd varchar,email_valide bool,email_verification bool,interpretation_html bool,citation bool,noms_longs bool,
		taille_pj int4,lignes int4,block_ip bool,compte_vus bool,fils_fermes bool,affiche_fils bool,encodage varchar)";
	return pg_query($sql);
}

/**
	Obtenir les forums de la plateforme
	@return integer :
*/
function get_plateforme_forums(){
	$sql="select * from contraintes.af_get_forums() 
		 as (id int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar)";
	return pg_query($sql);
}

/**
	Obtenir les etapes forum de la plateforme
	@return integer :
*/
function get_plateforme_etapes_forum(){
	$sql="select * from contraintes.af_get_etapes_forum() as 
	(id int4,libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)";
	return pg_query($sql);
}

/**
	Obtenir les associations formation/forum de la plateforme
	@return integer :
*/
function get_plateforme_formations_forums(){
	global $auth;
	$user_id=$auth->getUserId();
	$sql="select * from contraintes.af_get_formations_forums($user_id) as (formation int4,libelle_formation varchar,forum int4,libelle_forum varchar)";
	return pg_query($sql);
}

/**
	Obtenir les etapes chat de la plateformes
	@return integer :
*/
function get_plateforme_etapes_chats(){
	$sql="select * from contraintes.af_get_etapes_chats() as (id int4,libelle_etape varchar,type int4,date_creation timestamp)";
	return pg_query($sql);
}

/**
	Obtenir les individus qui ont des exotlc corriges (OLD)
	@return integer :
*/
function get_plateforme_individus_exotlcs_corriges_old(){
	$sql = "	select DISTINCT num_user, textcat(textcat(nom,text ' '), prenom) AS nomprenom 
						from UTILISATEURS, GESTIONUTIL 
						where categorie LIKE '%u%' 
						and gu_num_user=num_user 
						and num_user in (
							select distinct gesttlc_user 
							from gestexotlc
						) 
						order by nomprenom;";
	//echo $sql;
	return pg_query($sql);
}
/**
	Obtenir les individus qui ont des exotlcs corriges
	@return integer :
*/
function get_plateforme_individus_exotlcs_corriges(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_individus_exotlcs_corriges() as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_individus_exotlcs_corriges_old();
	return $res;
}

/**
	Obtenir les classes qui ont des exotlcs corriges (old)
	@return integer : res req
*/
function get_plateforme_classes_exotlcs_corriges_old(){
	$sql = "select * from classe where id in (select distinct gu_num_gest_gr from GESTIONUTIL) order by nom;";
	return pg_query($sql);
}
/**
	Obtenir les classes qui ont des exotlcs corriges 
	@return integer : res req
*/
function get_plateforme_classes_exotlcs_corriges(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_classes_exotlcs_corriges() as (id int4,libelle varchar)";
		$res=pg_query($sql);
	}
	else
		$res=get_plateforme_classes_exotlcs_corriges_old();
	return $res;
}

/**
	Obtenir les formations qui ont des exotlcs corriges (old)
	@return integer : res req
*/
function get_plateforme_formations_exotlcs_corriges_old(){

}
/**
	Obtenir les formations qui ont des exotlcs corriges 
	@return integer : res req
*/
function get_plateforme_formations_exotlcs_corriges(){
	if (VERSION_BASE > VERSION) {
		 $sql="select * from contraintes.af_get_formations_exotlcs_corriges() as (id int4,libelle varchar)";
		 $res=pg_query($sql);
	}
	else
		$res=get_plateforme_formations_old();
	return $res;
}

/**
	Obtenir les icones de la plateforme
	@return integer : res req
*/
function get_plateforme_icones(){
	$sql="select * from contraintes.af_get_icones() as (id int4,libelle varchar)";
	return pg_query($sql);
}

/**
	Obtenir les parcours orientes de la plateforme
	@return integer : res req
*/
function get_plateforme_parcourss_orientes(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_parcourss_orientes() as (parcours int4,sous_parcours int4)";
		$res=pg_query($sql);
	}
	else
		$res=  get_plateforme_parcourss_orientes_old();
	return $res;
}

/**
 * Retourne les dates bornes des formations de la plate-forme. (OLD)
 * Il s'agit de la plus petite date de d�but de formation et de la plus grande(r�cente) date de fin de formation.
 * 
 * @return integer  Le resultat de la requete : (premier date, dernier date)
 */
function get_plateforme_formations_dates_bornes_old(){
	
	$sql="SELECT MIN(D1.jour) AS premier, MAX(D2.jour) AS dernier
                                        FROM dates D1, dates D2, calendrier C1, calendrier C2
                                        WHERE D1.num_date=C1.datedeb
                                        AND D2.num_date=C2.datefin";
	$res=pg_query($sql);
	return $res;
}

/**
 * Retourne les dates bornes des formations de la plate-forme.
 * Il s'agit de la plus petite date de d�but de formation et de la plus grande(r�cente) date de fin de formation.
 * 
 * @return integer  Le resultat de la requete : (premier date, dernier date)
 */
function get_plateforme_formations_dates_bornes(){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_formations_dates_bornes() AS (premier date, dernier date)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=  get_plateforme_formations_dates_bornes_old();
	return $res;
}

/**
 * A partir de la langue de reference 'french',insere le texte 'a completer' pour les libelles manquants
 * 
 */
function set_plateforme_langues_messages_incomplets(){
	$sql="select * from contraintes.af_set_langues_messages_incomplets()";
	return pg_query($sql);	
}

/**
 * Obtenir les types de message langue
 * @return : res req
 */
 function get_plateforme_langue_types(){
 	$sql="select * from contraintes.af_get_langue_types() as (id integer,libelle varchar,code varchar)";
 	return pg_query($sql);
 }


///**
// * Retourne tous les types d'individus
// * 
// * @return varchar Le r�sultat de la requete (id integer, libelle varchar, code varchar)
// */
//function get_plateforme_individus_types(){
//	$sql="select * from contraintes.fw_get_individus_types() AS (id integer, libelle varchar, code varchar)";
////	echo $sql;
//	$res = pg_query($sql);
//	return $res;
//}
//
///**
// * Retourne tous les types d'utilisateur
// * 
// * @return integer  Le type
// * @return varchar Le r�sultat de la requete (id integer, libelle varchar, code varchar)
// *
// */
// //TODO a supprimer
//function get_plateforme_individu_types(){
////	echo "Fonction get_plateforme_individu_types() d�pr�ci�e: utiliser get_plateforme_individus_types()<br>";
//	$sql="select * from contraintes.fw_get_individu_types() AS (id integer, libelle varchar, code varchar)";
//	$res = pg_query($sql);
//	return $res;
//}

/**
 * Obtenir les formations en fonction des dates de debut et fin
 * 1 - les formations commenant et finiissant dans l'intervalle [debut - fin]
 * 2 - les formation commenant dans l'intervalle [debut - fin]
 * 3 - les formation finissant dans l'intervalle [debut - fin]
 * @param date : date debut
 * @param date : date fin
 * @param bool : comprise dans l'intervalle [debut - fin]
 * @param bool : commenant dans l'intervalle [debut - fin]
 * @param bool : finissant dans l'intervalle [debut - fin]
 * @return integer : res req
 */
 function get_plateforme_formations_dates($debut,$fin,$comprise,$commencant,$finissant){
 	$comprise=bool2Sql($comprise);
 	$commencant=bool2Sql($commencant);
 	$finissant=bool2Sql($finissant);
 	$sql="select * from contraintes.af_get_formations_dates('$debut','$fin',$comprise,$commencant,$finissant) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool )";
 	//echo "sql=$sql<br>";
 	return pg_query($sql);
 }
 
 /**
*   Rcuprer les diff�rents themes des tapes forum de la plate forme
*
*   Retourne les  th�mes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les themes des forums de la plateforme
*
*/
function get_plateforme_themes_etape_forum() {
		global $auth;
		$user_id=$auth->getUserId();
		$sql = "select * from contraintes.af_get_categorie_themes(61,$user_id) as (id int4,libelle varchar)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	
	return $res;
}

/**
 * Rcupre les modles de correction de la plateforme
 * 
 * @return integer : les modles de correction de la plateforme
 */
 function get_plateforme_modeles_correction(){
 	$sql="select * from contraintes.af_get_modeles_correction() as (id int4,libelle varchar)";
 	//echo "sql=$sql<br>";
 	return pg_query($sql);
 }
		
?>