<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Cette classe dcrit un test de positionnement.
* Builder.
* @since 07/07/2004
* @package positionnement
*/
class Positionnement extends Element{
//serie de qsrc == test de positionnements non dynamiques?
	/**
	* @var integer nombre de secondes du chronomtre ou -1 si pas de chrono ou 0 si chrono individuel
	*/
	var $chrono;

	/**
	* @var Object Qsrc  Le Qsrc qui compose le Positionnement
	*/
	var $obj_qsrc;

	/**
	* @var Object SerieGeneree  La SerieGeneree qui compose le Positionnement
	*/
	var $obj_serie_generee;
	
	var $obj_media;
	
	/**
	* Constructeur de la classe Positionnement
	* 
	* @param integer $id identifiant en base de donnes dans la table positionnement 
	* @param integer $type Type du positionnement (s = sondage, q = qcm, ...)
	* @param string $titre Titre du positionnement
	* @param integer $theme identifiant en base de donnes du thme
	* @param integer $le_bareme identifiant en base de donnes du barme 
	* @param integer $le_chrono chronomtre en secondes
	* @param object Media $media l'objet mdia de type Media_exo
	* @param bool $type_choix 'TRUE' pour afficher un radio, 'FALSE' pour afficher une checkbox;
	*/
	function Positionnement($id = 0, $type = 0, $libelle = "", $chrono = 0, $chrono_genere = 0, $bareme=0, $is_radio=false,$obj_media = null, $date_creation="") { 
		if (func_num_args() == 0) {
			
		}
		elseif (func_num_args() == 1) {
			//( id int4, libelle varchar, type  int4, chrono  int4, serie_generee int4, bareme int4, chrono_gen int4, radio bool, qsrc int4 )
			$result = get_positionnement($id);
			$row = pg_fetch_array($result);

			$this->id = $row[0];
			$this->libelle = $row[1];
			$this->chrono =$row[3];
			$this->obj_qsrc = QsrcFactory::createQsrc($row[1], $row[8], $row[2], $row[9],$row[7],$row[1]);
			$this->obj_serie_generee = new SerieGeneree($row[4],0,0,0,$row[1], $row[9],$row[5],$row[6]);	
			
		}else{
			$this->id = $id;
			$this->libelle = $libelle;
			$this->chrono = $chrono;
			$this->obj_media=$obj_media;
			$this->obj_qsrc = QsrcFactory::createQsrc($type,$id, $libelle, $date_creation,$is_radio,$libelle);
			$this->obj_serie_generee = new SerieGeneree(0,0,0,0,$libelle, $date_creation,$bareme, $chrono_genere);			
		}
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initalise les attributs de type Objets.
	 */
	function loadObjects(){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->loadObjects();
		}else{
			return null;
		}
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * L'attribut 'radio' doit tre un boolen SQL, le nombre de questions
	 * suprieur  1 strictement et le nombre de rponses suprieur  2 strictement.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;
		if(!is_int($this->chrono)){
			$message.="[chrono]";
			$attributs_ok=false;
		}
		if(!is_object($this->obj_qsrc)){
			$message.="[obj_qsrc]";
			$attributs_ok=false;
		}
		if(!is_object($this->obj_serie_generee)){
			$message.="[obj_serie_generee]";
			$attributs_ok=false;
		}
		
		return $attributs_ok;
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$res_parent=parent::verifyInsert(&$message);
		$verif=Positionnement::verify(&$message);
		//$verif_qsrc=Qsrc::verifyInsert(&$message);
		//$verif_serie_generee=SerieGeneree::verifyInsert(&$message);
		return $verif && $res_parent && true;//&& $verif_qsrc && $verif_serie_generee 
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		$res_parent=parent::verifyUpdate(&$message);
		$verif=Positionnement::verify(&$message);
		//$verif_qsrc=Qsrc::verifyUpdate(&$message);
		//$verif_serie_generee=SerieGeneree::verifyUpdate(&$message);
		return $res_parent &&  true;//$verif && $verif_qsrc && $verif_serie_generee &&
	}
	
	/**
	* Fonction qui insre un enregistrement du positionnement en base.
	* On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne false
	* @return integer  identifiant de l'enregistrement cr ou false
	*/
	function insertToDB($theme,&$message) {

		if(Positionnement::verifyInsert(&$message)){
			$id_qsrc=$this->obj_qsrc->insertToDB($theme,&$message);
			if(!$id_qsrc){
				die("Positionnement::insertToDB($theme,&$message)  Erreur lors de l'enregistrement du qsrc.<br>");
			}
			$id_serie_generee=$this->obj_serie_generee->insertToDB($theme,&$message);
			if(!$id_serie_generee){
				die("Positionnement::insertToDB($theme,&$message)  Erreur lors de l'enregistrement de la serie generee.<br>");
			}
			
			//association des qest rep
//			$tab_justes=Array();
//		$questions=Array();
//		$reponses=Array();
//		foreach($this->obj_questions as $keyQ => $obj_question){
//			
//			//transforme $this->obj_questions vers le format attendu ( tableau contenant les identifiants des questions)
//			if(!in_array($obj_question->getId(),$questions))$questions[]=$obj_question->getId();
//			
//			foreach($this->obj_reponses as $keyR => $obj_reponse){
//				
//				//transforme $this->obj_reponses vers le format attendu ( tableau contenant les identifiants des reponses)
//				if(!in_array($obj_reponse->getId(),$reponses))$reponses[]=$obj_reponse->getId();				
//				
//				//transforme $this->justes vers le format attendu ( tableau contenant tous les couples rponse/boolen)
//				if(is_array($this->justes[$obj_question->getId()])&&in_array($obj_reponse->getId(),$this->justes[$obj_question->getId()] )){
//					$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(), 1 );
//				}
//				else{
//					$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(),  0 );
//				}
//			}
//		}
//	
//		//vrification donnes et insertion
//		if($no_verify||Qrc::verifyInsert(&$message)){
//			$this->id=set_qrc(addslashes($this->libelle), $this->type,  addslashes($this->question_commune),$questions, $reponses,bool2Sql((bool)$this->radio),$tab_justes,$theme);
//			return $this->id;
//		}
//		else{
//			return false;
//		}
			$this->id=set_positionnement(addslashes($this->libelle), int2Sql($this->chrono), $id_qsrc, $id_serie_generee, $theme);
			return $this->id;
			
		}else{
			return false;
		} 
		
		// Le test doit avoir un type
//
//			//formatage des donnes
//			if ($this->media == null) {
//				$id_media = 'NULL';
//				$longueur_media = 'NULL';
//				$largeur_media = 'NULL';
//			} else {
//				if ($this->media->getId() == null)
//					$id_media = 'NULL';
//				else
//					$id_media = $this->media->getId();
//				if ($this->media->getLongueur() == null)
//					$longueur_media = 'NULL';
//				else
//					$longueur_media = $this->media->getLongueur();
//				if ($this->media->getLargeur() == null)
//					$largeur_media = 'NULL';
//				else
//					$largeur_media = $this->media->getLargeur();
//			}
//			
//			if ($this->chrono == null)
//				$v_chrono = 'NULL';
//			else
//				$v_chrono = $this->chrono;
//			if ($this->chrono_gen == null)
//				$v_chrono_gen = 'NULL';
//			else
//				$v_chrono_gen = $this->chrono_gen;
//			if ($this->bareme == null)
//				$v_bareme = 'NULL';
//			else
//				$v_bareme = $this->bareme;
//				
//			//insertion
//			$res = set_positionnement(addslashes($this->libelle), get_evaluation_type_old_new($this->type), $theme, $id_media, $longueur_media, $largeur_media, int2Sql($chrono), int2Sql($chrono_gen), int2Sql($bareme), $this->type_choix);
//			$this->id = $res;
//			
//				return ($this->id);
	}

	/**
	* Fonction qui met  jour l'enregistrement du positionnement
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @return boolean true si la mise  jour  t effectue, false sinon.
	*/
	function updateToDB(&$message) {
		
		if(Positionnement::verifyUpdate(&$message)){
			return maj_positionnement($this->id, addslashes($this->libelle), $media, $hauteur, $largeur, $v_chrono, $v_chrono_gen, $v_bareme);
		}else{
			return false;
		} 
//			//formatage des donnes
//			if (empty ($this->media->id_media))
//				$media = 'NULL';
//			else
//				$media = $this->media->getId();
//
//			if (empty ($this->media->longueur))
//				$hauteur = 'NULL';
//			else
//				$hauteur = $this->media->getLongueur();
//
//			if (empty ($this->media->largeur))
//				$largeur = 'NULL';
//			else
//				$largeur = $this->media->getLargeur();
//
//			if ($this->chrono_gen == null)
//				$v_chrono_gen = 'NULL';
//			else
//				$v_chrono_gen = $this->chrono_gen;
//
//			if ($this->chrono == null)
//				$v_chrono = 'NULL';
//			else
//				$v_chrono = $this->chrono;
//				
//			if ($this->bareme == null)
//				$v_bareme = 'NULL';
//			else
//				$v_bareme = $this->bareme;
//
//			//mise a jour
			return maj_positionnement($this->id, addslashes($this->libelle), $media, $hauteur, $largeur, $v_chrono, $v_chrono_gen, $v_bareme);
	}


	/**
	 * Savoir si le positionnement est dynamique ou non.
	 * Un positionnement est dynamique si le nombre d'evaluations  gnrer est fix
	 * ou si un chrono  t fix pour les evaluations  gnrer.
	 * @return boolean  true si dynamique, false sinon
	 */
	function isDynamique() {

		$nbrows = get_positionnement_count_evaluations_a_associer($this->id);
		$nb_assoc = pg_num_rows(get_positionnement_evaluations_a_generer($this->id));
		if ($nbrows > 0)
			return true;
		else {

			//le positionnement est dynamique si un chrono pour les evaluations a generer  t fix.
			if ($this->chrono_gen != -1 && $this->chrono_gen != 0)
				return true;
			return false;
		}
	}

	/**
	 * Savoir si un positionnement est fini.
	 * Un positionnement est fini s'il a au moins une question
	 * et s'il est dymanique, que le nombre d'evaluations associes correspond au nombre voulu.
	 *@return boolean true si fini, false sinon
	 */
	function isFini() {
		$nb_quest = $this->getNbConfiguredObjQuestions();
		$nbrows = get_positionnement_count_evaluations_a_associer($this->id);
		$nb_assoc = pg_num_rows(get_positionnement_evaluations_a_generer($this->id));
		//le test est dynamique si le total des nombres d'evaluation demand est gal au nombre
		//d'evaluations associes, sinon il n'est pas fini 
		//echo "nb_quest=$nb_quest  nbrows=$nbrows == (nb_assoc=$nb_assoc / nb_quest=$nb_quest )";
		if ($nb_quest <= 0)
			return false;
		
		if($this->isDynamique()){
			return ($nbrows == ($nb_assoc / $nb_quest));
		}
		else return true;
	}
	
	/**
	*	Obtenir un tableau contenant les numeros des evaluations affiables
	*	Si le type n'est pas prcis retourne tous les types.
	*	
	*	@param integer $type le type des evaluations voulus
	*	@return integer []: le tableau resultat( id )
	*/
	function getEvaluationsAffiliables($type = 0) {

		$res = get_positionnement_evaluations_affiliables_theme_type($this->id, $this->theme, $type);
		$tab = array ();
		//on met dans un tableau
		for ($i = 0; $i < pg_numrows($res); $i++) {
			$row = pg_fetch_row($res, $i);
			$tab[$i] = $row[0];
		}
		return ($tab);
	}

	/**
	* Fonction qui retourne les tests contenant le positionnement.
	* L'indice ici est arbitraire vu que les tests d'un positionnement n'ont pas d'ordre.
	* @param integer $indice indice de la liste. Si on ne met rien, on retourne le tableau entier
	* Enfin, si l'indice est incohrent on retourne faux 
	* @return object Test[] : test  l'indice $indice ou l'ensemble des tests.
	*/
	function getTests($indice = 0) {
		// Rcupration des tests qui contiennent le positionnement
		$tests = array ();
		$res = get_positionnement_tests($this->id);

		for ($i = 0; $i < pg_num_rows($res); $i++) {
			$num_test = pg_fetch_result($res, $i, 0);
			$tests[$i] = & new Test($num_test);
		}
		// Si $indice n'est pas valu alors on retourne le tableau entier
		if (func_num_args() == 0) {
			return $tests;
		}
		// Sinon on analyse la valeur $indice
		else {
			// Est-ce que $indice est cohrent ?
			if ($indice >= 0 && $indice < count($this->sesListes))
				return ($tests[$indice]);
			else
				return false;
		}
	}

	/**
	* Procdure qui retire une question du Positionnement.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @param integer $id indice de la Question
	*/
	function retireQuestion($id) {
		if (!empty($this->id) && !empty($id)) {
			del_positionnement_question_positionnement($this->id, $id);
		} else
			echo "Erreur paramtre retireQuestion($id)<br>";
	}
	
	/**
	* Procdure qui retire un choix du Positionnement.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @param integer $id indice du choix a supprimer
	*/
	function retireChoix($id) {
		if (!empty($this->id) && !empty($id)) {
			del_positionnement_choix($this->id, $id);
		} else
			echo "Erreur paramtre retireChoix()<br>";
	}
	
//	/**
//	 * Obtenir le nombre de questions associes au Positionnement.
//	 * @return integer le nombre de questions.
//	 */
//	function getNbQuestions() {
//		if (!is_array($this->sesExercices))
//			print ("Erreur: les questions n'ont pas t initialises.");
//		return count($this->sesExercices);
//	}

	/**
	* Fonction qui retourne une question du Positionnement.
	* @param integer $indice indice de la question. Si on ne met rien, on retourne le tableau de Questions en entier.
	* Enfin, si l'indice est incohrent on retourne faux .
	* @return Question : Question au rang $indice ou toutes les Questions.
	*/
	function getQuestion($indice = 0) {
		if (!is_array($this->sesExercices))
			print ("Erreur: les questions n'ont pas t initialises.");

		// Si $indice n'est pas valu alors on retourne le tableau entier
		if (func_num_args()==0) {
			return $this->sesExercices;
		}
		// Sinon on analyse la valeur $indice
		else {
			// Est-ce que $indice est cohrent ?
			if ($indice >= 0 && $indice < count($this->sesExercices))
				return ($this->sesExercices[$indice]);
			else
				return false;
		}
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	
	/**
	 * Obtenir le type du Positionnement
	 * @return integer Le type du Positionnement
	 */		
	function getType() {
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->getType();
		}
		else{
			return null;
		}
	}
		
	/**
	 * Obtenir le chrono pour la Srie gnre par le Positionnement
	 * @return integer le chrono en secondes
	 */	
	function getChronoSerieGenere() {
		if(is_object($this->obj_serie_generee)){
			return $this->obj_serie_generee->getChrono();
		}
		else{
			return null;
		}
	}


	/**
	 * Obtenir le bareme
	 * @return integer L'indentifiant du Bareme
	 */	
	function getBareme() {
		if(is_object($this->obj_serie_generee)){
			return $this->obj_serie_generee->getBareme();
		}
		else{
			return null;
		}
	}
	
	/**
	 * Obtenir le nombre de Questions configures pour ce Positionnement.
	 * @return integer Nombre de Questions 
	 */	
	function getNbConfiguredObjQuestions(){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->getNbConfiguredObjQuestions();
		}
		else{
			return null;
		}
	}
	
	/**
	 * Obtenir le nombre de Reponses configures pour ce QuestionReponse.
	 * @return integer Nombre de Reponses 
	 */	
	function getNbConfiguredObjReponses(){	
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->getNbConfiguredObjReponses();
		}
		else{
			return null;
		}
	}
	
	/**
	 * Obtenir l'objet Mdia associ  un lment du Positionnement.
	 * 
	 * @param integer $element Identifiant d'une question ou d'une rponse du Positionnement.
	 * @return object Media L'objet Media initialis selon le Positionnement et l'lment spcifi.
	 */	
	function &getObjElementMedia($element){
		return $this->obj_qsrc->getObjElementMedia($element);
	}
	

	/**
	 * Obtenir les objets questions associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Question.
	 * @return mixed Identifiant rsultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool) ou Array, la ligne rsultat si indice.
	 */
	function &getObjQuestions($indice=0){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->getObjQuestions($indice);
		}
		else{
			return null;
		}
	}
	
	/**
	 * Ajouter un Objet de rponse au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la rponse tait dj prsente.
	 */
	function &setObjReponse(&$obj_reponse){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->setObjReponse($obj_reponse);
		}
		else{
			return null;
		}
	}
	
	/**
	 * Ajouter un Objet de question au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la question tait dj prsente.
	 */
	function &setObjQuestion($obj_question, $indice=0){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->setObjQuestion($obj_question, $indice);
		}
		else{
			return null;
		}
	}
		
	/**
	 * Obtenir les objets reponses associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Rponse.
	 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) ou Array, la ligne rsultat si indice.
	 */	
	function &getObjReponses($indice=0){
		if(is_object($this->obj_qsrc)){
			return $this->obj_qsrc->getObjReponses($indice);
		}
		else{
			return null;
		}
	}

	
	/**
	 * Affecter une Question au positionnement.
	 * Il n'y a aucune contrainte particuliere sur l'indice. Celui-ci peut correspondre  un lment du tableau ou non.
	 * @param integer $indice l'indice auquel on ajoute la Question.
	 * @param object Question &$exercice l'objet Question.
	 */
	function setQuestion($indice, &$exercice) {
		if (!is_array($this->sesExercices))
			$this->initQuestions() ;

		$this->sesExercices[$indice] = $exercice;

	}
	
	/**
	 * Obtenir la valeur du chrono du Positionnement.
	 * @return integer le nombre de secondes durant lequel le Positionnement doit durer.
	 */
	function getChrono() {
		return $this->chrono;
	}

	/**
	 * Obtenir l'objet Media du Positionnement
	 * @return object Media Identifiant du Positionnement
	 */	
	function getMedia() {
		return $this->obj_media;
	}
	
	/**
	 * Affecter un objet Media au Positionnement
	 * @param object Media $obj_media Le Media
	 */	
	function setMedia($obj_media) {
		$this->media=$obj_media;
	}
	
	/**
	 * Obtenir le type d'affichage  utiliser
	 * @return boolean true si radio, false si checkbox
	 */		
	function getTypeChoix(){
		return $this->type_choix;
	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_positionnement.png";
	}
	
//--------------------------------------------
// 			METHODES DEPRECIEES	
//--------------------------------------------

//	/**
//	 * Initialisation des questions du positionnement.
//	 * Cette mthode initialise l'attribut contenant les objets QuestionPositionnement du Positionnement.
//	 */
//	function initQuestions() {
//
//		if (!empty ($this->id)) {
//			// Construction du tableau des questions: sesExercices	
//			$this->sesExercices = array ();	
//		
//			$result = get_positionnement_questions($this->id, get_evaluation_type_new_old($this->type));
//			//echo "recup donnes initQuestions fait en :".((calcul_execution()-$st)/1000000)."sec <BR>";
//			while ($row1 = pg_fetch_array($result)) {
//				if($row1[2]=='t'||$row1[2]=='TRUE')$inter='TRUE';
//       			else $inter='FALSE';
//				$this->sesExercices[] = new QuestionPositionnement($row1[0], $this->id, get_evaluation_type_old_new($this->type), $row1[1], $this->theme, null, $inter);
//			}
//		}else
//			echo "Erreur paramtres initQuestions()<br>";
//	}
//
//	/**
//	 * Initialisation des choix du positionnement.
//	 * Cette mthode initialise l'attribut contenant les objets Choix du Positionnement.
//	 */
//	function initChoix() {
//		if (!empty ($this->id)) {
//			
//			// Construction du tableau sesChoix
//			$this->sesChoix = array ();
//			//recupere les infos des choix (dans l'odre)
//			$res1 = get_positionnement_choixx_infos($this->id);
//
//			//recupere les evaluations a generer des choix (dans l'ordre des choix)
//			$res2 = get_positionnement_nb_evaluations_a_generer($this->id);
//
//			//on cree les choix et on leurs affecte leurs proprits
//			$i = 0;
//			while ($res1 && ($row3 = pg_fetch_array($res1))) {
//
//				// Objet 
//				$rep = new Choix($row3[1], $this->type);
//
//				// Attributs en plus dpendant de l'association Positionnement/choix
//				$rep->bareme = $row3[2];
//				$rep->media_reponse = new Media($row3[4], $row3[5], $row3[6]);
//
//				$this->sesChoix[$i] = $rep;
//				$i++;
//			}
//
//			//on leurs affecte les evaluations a gnrer
//			$i = -1;
//			$cur_rep = null;
//			while ($res2 && ($row2 = pg_fetch_array($res2))) {
//				//incrementation de l'indice du choix
//				if ($cur_rep != $row2[1]) {
//					$i++;
//					$cur_rep = $row2[1];
//				}
//
//				if ($row2[2] == get_evaluation_type_old_new("q")) {
//					$this->sesChoix[$i]->nbQcms = $row2[3];
//					$this->sesChoix[$i]->chapQcms = $row2[4];
//				} else {
//					if ($row2[2] == get_evaluation_type_old_new("f")) {
//						$this->sesChoix[$i]->nbBlancs = $row2[3];
//						$this->sesChoix[$i]->chapBlancs = $row2[4];
//					}
//				}
//			}
//		}else
//			echo "Erreur paramtres initChoix()<br>";
//	}

//	/**
//	* Fonction qui retourne les choix  du positionnement ou un choix en particulier.
//	* @param integer $indice indice du choix dans le tableau sesChoix (de 0  nbChoix -1). 
//	* Si on ne met rien, on retourne le tableau entier
//	* Enfin, si l'indice est incohrent on retourne faux 
//	* @return Choix  Choix  l'indice $indice ou l'ensemble des Choix du positionnement
//	*/
/*
	function getChoix($indice = 0) {
		if (!is_array($this->sesChoix))
			print ("Erreur: les choix n'ont pas t initialises.");
		// Si $indice n'est pas valu alors on retourne le tableau entier
		if (func_num_args()==0) {

			return $this->sesChoix;
		}
		// Sinon on analyse la valeur $indice
		else {

			// Est-ce que $indice est cohrent ?
			if ($indice >= 0 && $indice < count($this->sesChoix))
				return ($this->sesChoix[$indice]);
			else
				return false;
		}
	}
*/

//	/**
//	* Donne le nombre de Choix associs au positionnement
//	* @return integer : le nombre de Choix
//	*/
//	function getNbChoix() {
//		if (!is_array($this->sesChoix))
//			print ("Erreur: les choix n'ont pas t initialises.");
//		return count($this->sesChoix);
//	}

	/**
	* Ajouter un Choix au Positionnement.
	*
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	*
	* @param integer $choix Numro du choix  ajouter
	* @param integer $numBareme Numro du barme
	* @param array $tabExosGen tableau contenant le nombre d'evaluations  gnrer pour un type donn : ["q"], ["f"], etc.
	* @param object Media $media Media  associer  la rponse (il doit tre construit avant l'appel)
	*/
	function ajoutChoix($choix,  $numBareme, $tabExosGen, $media) {
		if (!empty ($this->id) && !empty ($choix)) {

			// On determine l'ordre du nouveau choix
			$ordre = get_positionnement_last_choix($this->id);
			
			//formatage des donnes
			if (empty ($ordre)) {
				$ordre = 'NULL';
			}
			
			if(!empty($media)){
				$idmedia = $media->getId();
				if (empty ($idmedia))
					$idmedia = 'NULL';
					
				$hauteur = $media->getHauteur();
				if (empty ($hauteur))
					$hauteur = 'NULL';
					
				$largeur = $media->getLargeur();
				if (empty ($largeur))
					$largeur = 'NULL';
			}else{
				$idmedia = 'NULL';
				$hauteur = 'NULL';
				$largeur = 'NULL';
			}
			if (empty ($numBareme))
				$numBareme = 'NULL';
				
			//insertion du choix
			$res = set_positionnement_choix($this->id, $choix, $ordre, $numBareme, $idmedia, $hauteur, $largeur);
			if ($res!='t')
				echo "Erreur lors de l'association du positionnement et de la reponse<br>";

			//insertion du nombre d'evaluations  gnrer pour ce choix.
			if($tabExosGen){
				while ($tab = each($tabExosGen)) {
					//on passe un nombre negatif car on ne peut mettre NULL dans un tableau
					$nb1 = $tab[1][1];
					if (empty ($nb1))
						$nb1 = 0;
					$nb2 = $tab[1][2];
					if (empty ($nb2))
						$nb2 = 'NULL';
					set_positionnement_nb_evaluations_a_generer($this->id, $choix, get_evaluation_type_old_new($tab[0]), $nb1, $nb2);
				}
			}
		} else
			echo "Erreur paramtres ajoutChoix()<br>";
	}

	/**
	* Modification d'un choix.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @param integer $choix Numro de la rponse
	* @param integer $new_num_reponse rang de la rponse
	* @param integer $bareme Numro du barme
	* @param array $tabExosGen tableau contenant le nombre d'exo  gnrer pour un type donn : ["q"], ["f"], etc.
	* @param object Media $media un objet media pour le choix
	*/
	function modifChoix($choix, $new_num_reponse, $bareme, $tabExosGen, $media) {

		if ($this->id && $new_num_reponse) {
			
			if (empty($media)||$media->getId() == null)
				$id_media = 'NULL';
			else
				$id_media = $media->getId();
			if (empty($media)||$media->getHauteur() == null)
				$longueur_media = 'NULL';
			else
				$longueur_media = $media->getHauteur();
			if (empty($media)||$media->getLargeur() == null)
				$largeur_media = 'NULL';
			else
				$largeur_media = $media->getLargeur();
				
			if (empty ($bareme))
				$bareme = 'NULL';

			maj_positionnement_choix($this->id, $choix, $new_num_reponse, $bareme, $id_media, $longueur_media, $largeur_media);

			if (!empty ($tabExosGen)) {

				//mise a jour des nombres d'evaluation a generer.
				maj_positionnement_nb_evaluations_a_generer($this->id, $choix, $tabExosGen);
			}
		} else
			echo "Erreur paramtres modifChoix()<br>";
	}

	function ajoutQuestion($question, $pere){
		//TODO
	}
	
	/**
	* Obtenir les evaluations  gnrer
	*
	* Retourne un tableau contenant les evaluations a gnrer du positionnement
	*
	* @param integer $id_quest numero de question
	* @param integer $id_choix  numero de choix
	* @param integer $type type d'evaluation  retourner (facultatif)
	* @return object[] Evaluation : les evaluations
	*/
	function getEvaluationsAGenerer($id_quest, $id_choix, $type = 0) {
		
		if ($this->id && $id_quest && $id_choix) {

			if (!empty ($type)) {
				$res = get_positionnement_evaluations_a_generer_question_choix_type($this->id, $id_quest, $id_choix, get_evaluation_type_old_new($type));

			} else {
				$res = get_positionnement_evaluations_a_generer_question_choix($this->id, $id_quest, $id_choix);
			}
			$i = 0;
			$mes_exos = array ();

			while ($obj = pg_fetch_object($res)) {
				$mes_exos[$i] = $obj;
				$i++;
			}

			return $mes_exos;
		}
		echo "Erreur paramtres getEvaluationsAGenerer()<br>";
		return false;
	}

	/**
	* Associer une evaluation a generer avec une question et un choix.
	* 
	* @param integer $evaluation numero de l'exercice a generer
	* @param integer $type type de l'exercice
	* @param integer $id_quest numero de question
	* @param integer $id_choix  numero de rponse
	*  @param integer $ordre  Identifiant du pre
	*/
	function setEvaluationAGenerer($evaluation, $type, $id_quest, $id_choix, $ordre) {
		if (!empty ($evaluation) && !empty ($type) && !empty ($id_quest) && !empty ($id_choix)) {

			//on ne test que le type, le reste doit etre ok 
			if ($type == get_evaluation_type_old_new('f') || $type == get_evaluation_type_old_new('q')) {

				$res = set_positionnement_evaluation_a_generer($this->id, $id_quest, $id_choix, $evaluation, get_evaluation_type_old_new($type));
				if (!$res)
					print ("Erreur lors de l'association de l'exercice $evaluation avec la question $id_quest et la reponse $id_choix.<br>\n");

			} else {
				print ("Erreur: le type d'exercice '$type' n'est pas pris en compte.<br>\n");
				exit ();
			}
		} else
			echo "Erreur paramtres setEvaluationAGenerer()<br>";
	}

	/**
	* Fonction qui retourne une chane de caractre contenant des informations sur l'objet
	* @return string  On retourne la chane de caractres 
	*/
	function toString() {
		return $this->libelle;
	}

	/**
	* Affiche un apercu du test (c'est  dire les principales informations le concernant
	*/
	function apercu() {
		global $MSG_590, $MSG_1839, $MSG_297, $MSG_1456, $MSG_1840, $MSG_559b, $MSG_1841, $MSG_292c, $MSG_1842;
		// Initialisation
		if (!is_array($this->sesChoix))
			print ("Erreur: les choix n'ont pas t initialises.");

		if (!is_array($this->sesExercices))
			print ("Erreur: les questions n'ont pas t initialises.");
		// Type du test
		switch ($this->type) {

			case 'q' :
			case 1 : //print(" QCM ($type_reponse)");
				$titre = "QCM";
				$type_reponse = "checkbox";
				break;
			case 's' :
			case 2 : //print(" Sondage ");
				$titre = "Sondage";
				$type_reponse = "radio";
				break;
			case 'm' :
			case 4 : //print("QRC ($type_reponse)");
				$titre = "QRC";
				$type_reponse = "checkbox";
				break;
			case 'o' :
			case 5 : //print("SRC ($type_reponse)");
				$titre = "SRC";
				$type_reponse = "radio";
				break;
			default :
				print ("Type de test non reconnu");
		}
		if($this->type_choix=='t')$type_reponse = "radio";
		else $type_reponse = "checkbox";
		print ("
											<table class=\"tableau_espace\">
											<tr class=\"couleur1\">
											<td>
											<b>$MSG_590 :</b> " . $this->toString() . "&nbsp;&nbsp;
											<br><b>$MSG_1839 :</b> $titre ($type_reponse)&nbsp;&nbsp;
																															            ");
		if ($this->isDynamique())
			print ("<img src=\"../images/dyn.gif\" border=\"0\">&nbsp;&nbsp;");
		if ($this->media != null && $this->media != "NULL") {
			print ("<b>$MSG_297 :</b> " . $this->media->toString() . "&nbsp;(" . $this->media->getLongueur() . " px *   " . $this->media->getLargeur() . " px )<br>");
		} else {
			print ("<i>$MSG_1456</i>");
		}
		print ("</td>
													</tr>
										            <tr class=\"couleur2\">
													  <td>");
		print ("$MSG_1840 " . count($this->sesChoix) . " $MSG_559b $MSG_1841 " . count($this->sesExercices) . " $MSG_292c");
		if ($this->getQuestion_commune() != "")
			print ("<br><b>$MSG_1842 : </b><br>" .
			nl2br($this->getQuestion_commune()) . " ");

		print ("	</td>
														</tr>
													</table>");
	}

	/**
	* Affiche le dtail d'un test > ses questions et ses rponses dans un tableau
	*/
	function details() {
		global $MSG_292b, $MSG_303, $MSG_1833b, $MSG_1843;
		if (!is_array($this->sesChoix))
			print ("Erreur: les reponses n'ont pas t initialises.");

		if (!is_array($this->sesExercices))
			print ("Erreur: les questions n'ont pas t initialises.");
		if (count($this->sesExercices) > 0) {
			print ("<table class=\"tableau_espace\">\n\n");
			//les lignes (exercices)
			for ($i = -1; $i < count($this->sesExercices); $i++) {
				print ("<tr>");
				if (count($this->sesChoix) > 0) {
					//les colonnes (rponses)
					for ($j = -1; $j < count($this->sesChoix); $j++) {
						//premiere ligne (libelles )
						if ($i == -1) {
							//1ere colonne 1ere ligne
							if ($j == -1) {
								//$str_question = $this->getQuestion_commune();
								//if ($str_question == "")
								$str_question = $MSG_292b;
								print ("<td class=\"couleur1\"><b>$MSG_292b</b></td>");
							} else {
								print ("<td class=\"couleur1\">");

								if (!empty ($this->sesChoix[$j])) {
									//print_r($this->sesChoix[$j]);									
									$libelle_choix = $this->sesChoix[$j]->getLibelle();
									print "<b>" . ($j +1) . "-</b> " . $libelle_choix;
								} else
									print ("$MSG_303 " .
									 ($j));
								print ("</td>");
							}
						}
						//les autres lignes (questions)
						else {
							if ($j == -1) {
								//1ere colonne (libelle exercice)
								print ("<td class=\"couleur1\">");
								if (!empty ($this->sesExercices[$i]))
									print "<b>" . ($i +1) . "-</b> " . $this->sesExercices[$i]->toString();
								else
									print ("exo " .
									 ($i +1));
								print ("</td>");
							} else {
								// Pour les reponses justes et fausses
								if ($this->type == get_evaluation_type_old_new('q')) {
									$obj_reponse = & $this->getChoix($j);
									$id_reponse = $obj_reponse->getId();
									$id_question = $this->sesExercices[$i]->getId();
									$resjuste = get_positionnement_question_positionnement_reponse_solution($this->id, $id_question, $id_reponse);
									$rowjuste = pg_fetch_row($resjuste, 0);
									if ($rowjuste[3] == 't')
										$image = "icovalid.gif";
									else
										$image = "iconontraite.gif";
									print ("<td class=\"couleur2\"><div align=center><img src=\"../images/$image\" border=0></div></td>");
								} else
									print ("<td class=\"couleur2\">&nbsp;</td>");
							}
						}
					}
				} else {
					print ("<td>$MSG_1843</td>");
				}
				print ("</tr>\n\n");
			}
			print ("</table>");
		} else
			print ("$MSG_1833b");
	}


//
//	/**
//	 * Obtenir la question commune
//	 * @return string La question commune
//	 */		
//	function getQuestion_commune() {
//		return $this->question_commune;
//	}
}
?>