<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package positionnement
 * @modulegroup fonctions
 */

/**
 * Fonction qui rparti des positionnements provenant d'un resulat de requete dans 2 tableaux.
 * Un tableau contenant les positionnement de type sondage, un autre ceux de types qcm.
 * @param integer: un resultat de requete dont la premiere colonne est un identifiant de positionnement.
 * @param integer : le nombre de tuples de l'entier resultat
 * @param array: IN/OUT le tableau des positionnements de type sondage
 * @param array: IN/OUT le tableau des positionnements de type qcm
 */ 
function dispatch_positionnements($res, $nb,$tabSondage, $tabQCM)
{
            reset($tabSondage);
            reset($tabQCM);
            // Parcours des test
            for($i=0;$i<$nb;$i++)
            {
                        // Rcupration du numro de srie
                        $num_test=pg_result($res,$i,0);

                        $current_test= new Positionnement($num_test);
                        $type_test=$current_test->getType();
                        if($type_test == get_evaluation_type_old_new("s")) $tabSondage[]=$current_test;
                        if($type_test == get_evaluation_type_old_new("q")) $tabQCM[]=$current_test;
                        unset($current_test);


            }

}


/**
 * Fonction qui retourne les actions permises sur un positionnement
 * @param integer : le numero du positionnement
 * @return integer : 0:suppression possible, 1 suppression impossible, 2 autre.
 */
function get_positionnement_actions($num){
    // Valeur de retour
    $action_test=0;
    // test si le positionnement est dans une liste
    $res=get_positionnement_tests($num);
    //si test dans une liste, on efface pas
    if($res)$nb_list=pg_numrows($res);
    else $nb_list=0;
    if($nb_list>0) {
        $action_test=1;
        for($i=0;$i<$nb_list;$i++)
            {
                $row=pg_fetch_row($res,$i);
                $num_list=$row[0];
                // on recherche les parcours associs  ce positionnnement
                $res2=get_test_parcours($num_list);
                $nb_parc=pg_numrows($res2);

                for($j=0;$j<$nb_parc;$j++)
                {
                    $row=pg_fetch_row($res2,$j);
                     $tabform=array();
                     get_parcours_all_formations($row[0],$tabform);
                    $sz=sizeof($tabform);
                    if($sz>0)
                    {
                        $action_test=2;
                        break 2;
                    }
                }
            }
    }
    return $action_test;
}
?>
