<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions pour les positionnements.
 * 
 * @package positionnement
 * @modulegroup plpgsql	
 * @module plpgsql_positionnement
 */

//include ("$chemin_bo/lib/test/plpgsql_deprecated_positionnement.inc");

/**
 * Obtenir le media d'un positionnement. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete: id int4, longueur int4, largeur int4, positionnement int4
 */
function get_positionnement_media_old($positionnement) {
	$sql = "SELECT  media_test, longueur_media, largeur_media, id_test FROM test WHERE id_test=$positionnement";
//	echo $sql . "<br>";
	return pg_query($sql);
}

/**
 * Obtenir le media d'un positionnement.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete: id int4, longueur int4, largeur int4, positionnement int4
 */
function get_positionnement_media($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_media($positionnement) AS ( id int4, longueur int4, largeur int4, positionnement int4 )";
		//echo $sql . "<br>";
		return pg_query($sql);
	}
	else return get_positionnement_media_old($positionnement);
}

/**
 * Obtenir les informations d'un positionnement.(OLD)
 * 
 * @param integer $positionnement le numero du positionnement
 * @return integer resultat de la requete: ( id int4, libelle varchar, type  int4, chrono  int4, serie_generee int4, bareme int4, chrono_gen int4, radio bool, qsrc int4 , date_creation timestamp ) 
 */
function get_positionnement_old($positionnement) {
	$sql = "SELECT T.id_test, S.titre, T.type_test, S.chrono, NULL, S.bareme, T.chrono , CASE WHEN type_reponse='r' THEN 't' ELSE 'f' END, T.id_test, NULL FROM test T, serie_exo S WHERE S.id=T.id_test AND id_test=$positionnement";
	//echo $sql . "<br>";
	return pg_query($sql);
}

/**
 * Obtenir les informations d'un positionnement.
 * 
 * @param integer $positionnement le numero du positionnement
 * @return integer resultat de la requete: ( id int4, libelle varchar, type  int4, chrono  int4, serie_generee int4, bareme int4, chrono_gen int4, radio bool, qsrc int4, date_creation timestamp )
 */
function get_positionnement($positionnement) {
	if (VERSION_BASE > VERSION) {
		//$sql = "SELECT * FROM contraintes.af_get_positionnement($positionnement) AS ( id int4, libelle varchar, type_question  int4, chrono  int4, serie_aleatoire int4, bareme int4, chrono_gen int4, radio bool )";
		$sql = "SELECT * FROM contraintes.af_get_positionnement($positionnement) AS ( id int4, libelle varchar, type  int4, chrono  int4, serie_generee int4, bareme int4, chrono_gen int4, radio bool, qsrc int4, date_creation timestamp )";
		//echo $sql . "<br>";
		return pg_query($sql);
	} else
		$res = get_positionnement_old($positionnement);
	return $res;

}

/**
 * Obtenir sur les choix possibles  un positionnement. (OLD)
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete: (id int4, choix int4,  bareme int4, media int4, longueur int4, largeur int4)
 */
function get_positionnement_choix_infos_old($positionnement) {
	$requete = "SELECT A.id_test, A.id_reponse,  num_bareme, ordre, media_reponse,longueur_media, largeur_media
				            FROM asso_test_reponse A
				            WHERE A.id_test=$positionnement
				            ORDER BY ordre";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir les choix possibles pour un positionnement.
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, choix int4, bareme int4, pere int4, media int4, longueur int4, largeur int4)
 */
function get_positionnement_choixx_infos($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_choix_infos($positionnement) AS (id int4, libelle varchar, interpretationHTML bool, positionnement int4, bareme int4, pere int4, media int4, longueur int4, largeur int4)";
//		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = get_positionnement_choix_infos_old($positionnement);
	return $result;

}

/**
 * Obtenir un choix d'un positionnement.
 * 
 * @param integer : le numero du positionnement
 *  @param integer : le numero du choix
 * @return integer resultat de la requete:(id int4, libelle varchar, interpretationHTML bool, positionnement int4, bareme int4, pere int4, media int4, longueur int4, largeur int4)
 */
function get_positionnement_choix_infos($positionnement, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_choix_infos($positionnement, $choix) AS (id int4, libelle varchar, interpretationHTML bool, positionnement int4, bareme int4, pere int4, media int4, longueur int4, largeur int4)";
//		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		print("get_positionnement_choix_infos($positionnement, $choix)  a implementer");
	return $result;

}

/**
 * Obtenir sur les choix possibles  un positionnement. (OLD)
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete: (id int4, choix int4,  bareme int4, media int4, longueur int4, largeur int4)
 */
function get_positionnement_choix_old($positionnement, $type) {
	
	switch ($type) {
		case 'm':
		case TYPE_EVALUATION_QRC:
		case 'q':
		case TYPE_EVALUATION_QCM:
			$requete = "SELECT A.id_reponse, libelle_rep, inter_html, FALSE
            FROM asso_test_reponse A,
			reponse R
            WHERE A.id_test=$positionnement
			AND R.num_rep=A.id_reponse
            ORDER BY ordre";
			break;
		case 's':
		case TYPE_EVALUATION_SONDAGE:
		case 'o':
		case TYPE_EVALUATION_SRC:
			$requete = "SELECT num_prop, libelle_prop, inter_html, FALSE
            FROM asso_test_reponse A,
			proposition P
            WHERE A.id_test=$positionnement
			AND R.num_prop=A.id_reponse
            ORDER BY ordre";	
			break;
	
		default:
			die(" get_positionnement_choix_old($positionnement, $type)  : Type inconnu.<br>");
			break;
	}
	
	echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir les choix possibles pour un positionnement.
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, libelle varchar, interpretationHTML bool, question bool)
 */
function get_positionnement_choix($positionnement, $type=0) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_choix($positionnement) AS (id int4, libelle varchar, interpretationHTML bool, question bool)";
//		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result=get_positionnement_choix_old($positionnement, $type);
		
	return $result;
}


/**
 * Obtenir les nombre d'evaluation  gnrer pour un positionnement. (OLD)
 * L'entier resultat contient un tuple par choix et par type d'evaluation.
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, choix int4, type int4, nb_a_generer int4, taille_chapeau int4)
 */
function get_positionnement_nb_evaluations_a_generer_old($positionnement) {
	$requete = "SELECT DISTINCT R.id_test, R.id_reponse, R.type_exercice, R.nb_a_generer, R.taille_chapeau
				            FROM  test_rep_nbexogen R 
				            WHERE R.id_test=$positionnement
				";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir les nombre d'evaluation  gnrer pour un positionnement.
 * L'entier resultat contient un tuple par choix et par type d'evaluation.
 * Les choix sont ordonnes.
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, choix int4, type int4, nb_a_generer int4, taille_chapeau int4)
 */
function get_positionnement_nb_evaluations_a_generer($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_nb_evaluations_a_generer($positionnement) AS (id int4, choix int4, type int4, nb_a_generer int4, taille_chapeau int4)";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = get_positionnement_nb_evaluations_a_generer_old($positionnement);
	return $result;
}

/**
 * Obtenir les valuations  gnrer pour un positionnement (OLD)
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, libelle varchar, type int4, question int4, choix int4, ordre int4)
 */
function get_positionnement_evaluations_a_generer_old($positionnement) {
	$requete = "(SELECT id_exercice, libelle_question ,'q' , id_question, id_reponse, ordre
			            FROM  test_quest_rep, question
			            WHERE id_test=$positionnement
						AND id_exercice= num_question)
					UNION
					(SELECT id_exercice, substr(text,20) ,'f' , id_question, id_reponse, ordre
			            FROM  test_quest_rep, gest_ftb
			            WHERE id_test=$positionnement
						AND id_exercice= id)
			       ORDER BY ordre";
	//echo $sql . "<br>";
	$result = pg_query($requete);
	return $result;
}

/**
 * Obtenir les valuations  gnrer pour un positionnement
 * 
 * @param integer : le numero du positionnement
 * @return integer resultat de la requete:(id int4, libelle varchar, type int4, question int4, choix int4, pere int4)
 */
function get_positionnement_evaluations_a_generer($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_evaluations_a_generer($positionnement) AS (id int4, libelle varchar, type int4, question int4, choix int4, pere int4)";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = get_positionnement_evaluations_a_generer_old($positionnement);
	return $result;
}

/**
 * Obtenir le nombre d'evaluations qu'il faut associer pour un positionnement pour que celui ci soit complet. (OLD)
 * @param integer : le numero du positionnement
 * @return integer :le nombre d'evaluations qu'il faut associer
 */
function get_positionnement_count_evaluations_a_associer_old($positionnement) {
	$sql = "SELECT * FROM test_rep_nbexogen where id_test=$positionnement";
	$result = pg_query($sql);
	$nb = 0;
	while ($row = pg_fetch_row($result)) {
		if (empty ($row[4]) || $row[4] == 0) {
			$nb += $row[3];
		} else {
			$nb += $row[4];
		}
	}
	return $nb;
}

/**
 * Obtenir le nombre d'evaluations qu'il faut associer pour un positionnement pour que celui ci  soit complet.
 * @param integer : le numero du positionnement
 * @return integer :le nombre d'evaluations qu'il faut associer
 */
function get_positionnement_count_evaluations_a_associer($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_count_evaluations_a_associer($positionnement) ";
		echo $sql . "<br>";
		$result = pg_query($sql);
		return pg_fetch_result($result, 0, 0);
	} else
		$result = get_positionnement_count_evaluations_a_associer_old($positionnement);
	return $result;
}

/**
 * Obtenir les evaluations  gnrer pour un positionnement en fonction d'une question, d'un choix et d'un type. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @param integer : le numero du type d'evaluation
 * @return integer resultat de la requete:(id int4, libelle varchar, type int4, ordre)
 */
function get_positionnement_evaluations_a_generer_question_choix_type_old($positionnement, $question_positionnement, $choix, $type) {
	$requete = "SELECT * FROM 	(		
							SELECT num_question AS id, libelle_question AS libelle, 'q' AS type, E.ordre AS o
				            FROM  test_quest_rep E, question Q
				            WHERE E.id_test=$positionnement
							AND  E.type_exercice='q'
							AND E.id_question=$question_positionnement
							AND E.id_reponse=$choix
							AND E.id_exercice= Q.num_question
							AND E.type_exercice='q'
					UNION
							SELECT F.id AS id, substr(text,0,60) AS libelle, 'f' AS type, E.ordre AS o 
				            FROM  test_quest_rep E, gest_ftb F
				            WHERE E.id_test=$positionnement
							AND  E.type_exercice='f'
							AND E.id_question=$question_positionnement
							AND E.id_reponse=$choix
							AND E.id_exercice= F.id
							AND E.type_exercice='f'
									) G
					WHERE 
							type='$type'
				            ORDER BY o";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Obtenir les evaluations  gnrer pour un positionnement en fonction d'une question, d'un choix et d'un type.
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @param integer : le numero du type d'evaluation
 * @return integer resultat de la requete: (id int4, libelle varchar, type int4, pere int4)
 */
function get_positionnement_evaluations_a_generer_question_choix_type($positionnement, $question_positionnement, $choix, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_evaluations_a_generer($positionnement, $question_positionnement, $choix, $type) AS (id int4, libelle varchar, type int4, pere int4)";
		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = get_positionnement_evaluations_a_generer_question_choix_type_old($positionnement, $question_positionnement, $choix, $type);
	return $result;
}

/**
 * Affecter une nouvelle evaluation  gnrer pour un choixet une question d'un positionnement. (OLD)
 * L'evaluation est associe en tant que derniere evaluation de l'association.
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @param integer : le numero d'evaluation 
 * @param varchar : le type d'evaluation 
 * @return bool : TRUE ou FALSE selon que l'association ce soit bien pass ou non
 */
function set_positionnement_evaluation_a_generer_old($positionnement, $question_positionnement, $choix, $evaluation, $type_evaluation) {
	$pre_requete = "SELECT MAX(ordre) FROM test_quest_rep WHERE id_test=$positionnement AND id_question=$question_positionnement AND id_reponse=$choix";
	$res_pre_requete = pg_query($pre_requete);
	$ordre = pg_fetch_result($res_pre_requete,0,0) + 1;

	$requete = "INSERT INTO test_quest_rep  (id_test, id_question, id_reponse, type_exercice, id_exercice, ordre) 
					VALUES ($positionnement, $question_positionnement, $choix,'$type_evaluation', $evaluation, $ordre)";
	//echo $requete . "<br>";
	return pg_query($requete);
}

/**
 * Affecter une nouvelle evaluation  gnrer pour un choix et une question d'un positionnement. 
 * L'evaluation est associe en tant que derniere evaluation de l'association.
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @param integer : le numero d'evaluation 
 * @param varchar : le type d'evaluation pour la fonction old 
 * @return bool : TRUE ou FALSE selon que l'association ce soit bien pass ou non
 */
function set_positionnement_evaluation_a_generer($positionnement, $question_positionnement, $choix, $evaluation, $type_evaluation = "") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_positionnement_evaluation_a_generer($positionnement, $question_positionnement, $choix, $evaluation)";
		//echo $sql . "<br>";
		$result = pg_fetch_result(pg_query($sql), 0, 0);
	} else
		$result = set_positionnement_evaluation_a_generer_old($positionnement, $question_positionnement, $choix, $evaluation, $type_evaluation);
	return $result;
}

/**
 * Supprimer les evaluations  gnrer pour une question et un choix d'un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_evaluations_a_generer_old($positionnement, $question_positionnement, $choix) {
	$sql = "DELETE FROM test_quest_rep WHERE id_test=$positionnement AND id_question=$question_positionnement AND id_reponse=$choix ";
	//echo $sql . "<br>";
	return pg_query($sql);
}

/**
 * Supprimer les evaluations  gnrer pour une question et un choix d'un positionnement
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @param integer : le numero du choix
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_evaluations_a_generer($positionnement, $question_positionnement, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_positionnement_evaluations_a_generer($positionnement, $question_positionnement, $choix) ";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = del_positionnement_evaluations_a_generer_old($positionnement, $question_positionnement, $choix);
	return $result;
}

/**
 * Supprime un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_old($positionnement) {
	$sql = "DELETE  FROM test WHERE id_test=$positionnement ";
	//echo $sql . "<br>";
	$result1 = pg_query($sql);

	$sql = "DELETE  FROM asso_test_reponse WHERE id_test=$positionnement ";
	//echo $sql . "<br>";
	$result2 = pg_query($sql);

	$sql = "DELETE  FROM test_quest_rep WHERE id_test=$positionnement ";
	//echo $sql . "<br>";
	$result3 = pg_query($sql);

	$sql = "DELETE  FROM test_rep_nbexogen WHERE id_test=$positionnement ";
	//echo $sql . "<br>";
	$result4 = pg_query($sql);
	return $result1 || $result2 || $result3 || $result4;
}

/**
 * Supprime un positionnement
 * @param integer : le numero du positionnement
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_positionnement($positionnement) ";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = del_positionnement_old($positionnement);
	return $result;
}

/**
 * Supprime une question d'un positionnement (OLD)
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_question_positionnement_old($positionnement, $question) {

	$sql = "DELETE * FROM test_quest_rep WHERE id_test=$positionnement AND id_question=$question";
	//echo $sql . "<br>";
	$result = pg_query($sql);

	return $result;
}

/**
 * Supprime une question d'un positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero de la question
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_question_positionnement($positionnement, $question) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_positionnement_question($positionnement, $question) ";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = del_positionnement_question_positionnement_old($positionnement, $question);
	return $result;
}

/**
 * Supprime un choix d'un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_choix_old($positionnement, $choix) {

	$sql1 = "DELETE * FROM test_quest_rep WHERE id_test=$positionnement AND id_reponse=$choix ";
	//echo $sql1 . "<br>";
	$result1 = pg_query($sql1);

	$sql2 = "DELETE * FROM asso_test_reponse WHERE id_test=$positionnement AND id_reponse=$choix ";
	//echo $sql2 . "<br>";
	$result2 = pg_query($sql2);
	
	return $result2||$result1;
}

/**
 * Supprime un choix d'un positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_positionnement_choix($positionnement, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_positionnement_choix($positionnement, $choix) ";
//		echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = del_positionnement_choix_old($positionnement, $choix);
	return $result;
}

/**
 * Cre un positionnement. (OLD)
 * 
 * @param varchar : le libell du positionnement
 * @param integer : le type de positionnement (radio ou checkboxes )
 * @param integer : le theme du positionnement
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes)
 * @param integer : le type de d'evaluations 
 * @param integer : le chrono des evaluations gnres (secondes)
 * @param integer : le bareme des evaluations gnres
 * @return integer le numero du nouveau positionnement
 */
function set_positionnement_old($libelle, $type, $theme, $media, $hauteur, $largeur, $chrono, $chrono_genere, $bareme) {
	if($chrono=="NULL")$chrono=-1;
	if($chrono_genere=="NULL")$chrono_genere=-1;
	if($bareme=="NULL")$bareme=-1;
	ob_start();
	pg_query("begin");
	
	$insert = "INSERT INTO serie_exo
			( titre, theme, bareme,chrono)
			VALUES ( '$libelle', $theme,$bareme,$chrono) ;";
	//echo $insert . "<br>";
	$res = pg_query($insert);
	$oid=pg_last_oid($res);
	$req="SELECT id FROM serie_exo WHERE oid=$oid";
	$res = pg_query($req);
	$id = pg_fetch_result($res, 0, 0);

	$insert = "INSERT INTO test 
			(id_test, type_test, media_test, longueur_media, largeur_media,chrono,type_reponse)
			VALUES ($id, '$type', $media,$hauteur,$largeur,$chrono_genere,'$type') ;";
	//echo $insert . "<br>";
	$res = pg_query($insert);

	$message_erreur = ob_get_contents();
	ob_end_clean();
	// On annule toutes les requtes s'il y a eu un problme
	if ($message_erreur) {
		echo $message_erreur;
		pg_query("rollback");
	} else {
		pg_query("commit");

	}
	return $id;
}

/**
 * Cre un positionnement.
 * 
 * @param varchar $libelle le libell du positionnement
 * @param integer $chrono le chrono (secondes)
 * @param integer $qsrc le numero du qsrc
 * @param integer $serie le numero de la serie gnre
 * @param integer $media le numero du media
 * @param integer $hauteur la hauteur du media
 * @param integer $largeur la largeur du media
 * @param integer $theme le theme du positionnement
 * @return integer le numero du nouveau positionnement
 */
function set_positionnement($libelle, $chrono, $qsrc, $serie, $theme,$media=0, $hauteur=0, $largeur=0, $type="",$chrono_genere="",$bareme="") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_positionnement('$libelle', $chrono, $qsrc, $serie)";
//		echo $sql . "<br>";
		$result = pg_query($sql);
		$res = pg_fetch_result($result, 0, 0);
		// enregistre dans theme_categories
		set_categorie_element_theme(22, $theme, $res);
		return $res;

	} else
		return set_positionnement_old($libelle, $type, $theme, $media, $hauteur, $largeur, $chrono,  $chrono_genere, $bareme);
}

/**
 * Mettre a jour un positionnement. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @param varchar : le libell du positionnement
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @param integer : le chrono (secondes):  NULL-> pas de chrono (-1 en base)  -1->valeur interdite (-2 en base)
 * @param integer : le chrono des evaluations gnres (secondes)
 * @param integer : le bareme
 * @return bool: TRUE ou FALSE selon que la mise a jour se soit bien pass ou non
 */
function maj_positionnement_old($id, $libelle, $media, $hauteur, $largeur, $chrono, $chrono_genere, $bareme) {
	if($bareme=="NULL")$bareme=-1;
	if($chrono==-1)$chrono=-2; //on enregistre pas de chrono individuel d'1 sec car -1 correspond  chrono individuel, on force donc  -2
	if($chrono=="NULL")$chrono=-1;
	if($chrono_genere=="NULL")$chrono_genere=-1;	

	ob_start();
	pg_query("begin");

	$update1 = "UPDATE serie_exo SET titre='$libelle', bareme=$bareme,chrono=$chrono WHERE id=$id";
//	echo $update1 . "<br>";
	$res1 = pg_query($update1);

	$update2 = "UPDATE test SET chrono=$chrono_genere ,media_test=$media,longueur_media=$hauteur,largeur_media=$largeur WHERE id_test =$id";
//	echo $update2 . "<br>";
	$res2 = pg_query($update2);

	$message_erreur = ob_get_contents();
	ob_end_clean();
	// On annule toutes les requtes s'il y a eu un problme
	if ($message_erreur) {
		echo $message_erreur;
		pg_query("rollback");
	} else {
		pg_query("commit");

	}
	return $res1 && $res2;
}

/**
 * Mettre a jour un positionnement. 
 * 
 * @param integer $id le numero du positionnement
 * @param varchar $libelle le libell du positionnement
 * @param integer $media le numero du media
 * @param integer $hauteur la hauteur du media
 * @param integer $largeur la largeur du media
 * @param integer $chrono le chrono (secondes)
 * @param integer $chrono_genere le chrono des evaluations gnres (secondes)
 * @param integer $bareme le bareme
 * @return boolean  TRUE ou FALSE selon que la mise a jour se soit bien pass ou non
 */
function maj_positionnement($id, $libelle, $media, $hauteur, $largeur, $chrono, $chrono_genere, $bareme) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_positionnement($id, '$libelle',  $media, $hauteur, $largeur, $chrono,$chrono_genere, $bareme ) ";
		echo $sql."<br>";
		$result = pg_fetch_result(pg_query($sql),0,0)=='t';
	} else
		$res = maj_positionnement_old($id, $libelle, $media, $hauteur, $largeur, $chrono, $chrono_genere, $bareme);
	return $res;
}

/**
 * Obtenir le numero d'odre du prochain choix  associer  un positionnement. (OLD)
 * @param integer $positionnement le numero du positionnement
 * @return integer  le numero d'ordre pour le prochain choix de l'association
 */
function get_positionnement_last_choix_old($positionnement) {
	$result = pg_query("SELECT MAX(ordre) FROM asso_test_reponse WHERE id_test=$positionnement");
	return pg_result($result, 0, 0) + 1;
}

/**
 * Obtenir le numero du pere pour le prochain choix  associer  un positionnement.
 * @param integer $positionnement le numero du positionnement
 * @return integer  le numero du dernier choix de l'association
 */
function get_positionnement_last_choix($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_gen_get_last_element('contraintes.choix', 'id',' AND positionnement=$positionnement') ";
		//echo $sql."<br>";
		$res = pg_query($sql);
		if (pg_num_rows($res) == 1) {
			return pg_fetch_result($res, 0, 0);
		} else {
			return 'NULL';
		}
	} else
		return get_positionnement_last_choix_old($positionnement);
}

/**
 * Obtenir le numero d'odre de la prochaine question  associer  un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @return integer : le numero d'ordre pour la prochaine question  de l'association
 */
function get_positionnement_last_question_old($positionnement) {
	$sql = "SELECT MAX(ordre) FROM asso_exo_serie WHERE id_serie=$positionnement";
	$result = pg_query($sql);
	return pg_result($result, 0, 0) + 1;
}

/**
 * Obtenir le numero du pere pour la prochaine question  associer  un positionnement.
 * @param integer : le numero du positionnement
 * @return integer : le numero de la derniere question de l'association
 */
function get_positionnement_last_question($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_positionnement_last_question($positionnement) ";
		//echo $sql."<br>";
		$res = pg_query($sql);
		if (pg_num_rows($res) == 1) {
			return pg_fetch_result($res, 0, 0);
		} else {
			return null;
		}
	} else
		return get_positionnement_last_question_old($positionnement);
}

/**
 * Obtenir les questions d'un positionnement (OLD)
 * @param integer : le numero du positionnement
 * @param char :  le type de questions 
 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) 
 */
function get_positionnement_questions_old($positionnement, $type) {
		echo "\$type=$type<br>";
		switch($type){
			case 'q':
			case TYPE_EVALUATION_QCM:
					$sql = "SELECT DISTINCT num_question, libelle_question , inter_html, 't' ,QR.ordre FROM asso_exo_serie QR, question Q
					WHERE QR.id_exo=Q.num_question
					AND id_serie=$positionnement 
					AND type_exo='q' ORDER BY QR.ordre;";			
				break;
			case 's':
			case TYPE_EVALUATION_SONDAGE:
					$sql = "SELECT DISTINCT num_sondage, question , inter_html, 't' ,QR.ordre FROM asso_exo_serie QR, question_sondage Q
					WHERE QR.id_exo=Q.num_sondage
					AND id_serie=$positionnement 
					AND type_exo='s' ORDER BY QR.ordre;";			
				break;
			case 'm':
			case TYPE_EVALUATION_QRC:
					$sql = "SELECT DISTINCT num_question, libelle_question , inter_html, 't' ,QR.ordre FROM asso_exo_serie QR, question Q
					WHERE QR.id_exo=Q.num_question
					AND id_serie=$positionnement 
					AND type_exo='m' ORDER BY QR.ordre;";				
				break;
			case 'o':
			case TYPE_EVALUATION_SRC:
					$sql = "SELECT DISTINCT num_sondage, question , inter_html, 't' ,QR.ordre FROM asso_exo_serie QR, question_sondage Q
					WHERE QR.id_exo=Q.num_sondage
					AND id_serie=$positionnement 
					AND type_exo='o' ORDER BY QR.ordre;";			
				break;
			default:
					$sql = "SELECT DISTINCT num_sondage, question , inter_html, 't' ,QR.ordre FROM asso_exo_serie QR, question_sondage Q
					WHERE QR.id_exo=Q.num_sondage
					AND id_serie=$positionnement 
					AND (type_exo='o' or type_exo='m') ORDER BY QR.ordre;";		
				break;																
		}
		echo $sql."<br>";
		return pg_query($sql);
}

/**
 * Obtenir les questions d'un positionnement.
 * @param integer : le numero du positionnement
 * @param char : (facultatif) le type de questions (pour la fonction old)
 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) 
 */
function get_positionnement_questions($positionnement, $type=0) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_positionnement_questions($positionnement) AS (id int4, libelle varchar, interpretationHTML bool, question bool, indice integer) ";
//		echo $sql."<br>";
		return pg_query($sql);
	} else
		return get_positionnement_questions_old($positionnement, $type); 
}

/** 
 * Associer un nouveau choix  un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param integer : le numero d'ordre du choix
 * @param integer : le numero du bareme
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que l'association se soit bien passe ou non 
 */
function set_positionnement_choix_old($positionnement, $choix, $ordre, $bareme, $media, $hauteur, $largeur) {
	if($bareme== 'NULL')$bareme=0;
	$insert = "INSERT INTO asso_test_reponse (id_test, id_reponse,  ordre, num_bareme, media_reponse, longueur_media, largeur_media)
			           VALUES ($positionnement,  $choix, $ordre, $bareme, $media, $hauteur, $largeur)";
	//echo $insert."<br>";	
	$res=pg_query($insert);	
	if($res)return 't';
	else return 'f';    
}

/**
 * Associer un nouveau choix  un positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param integer : le numero d'ordre du choix
 * @param integer : le numero du bareme
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que l'association se soit bien passe ou non 
 */
function set_positionnement_choix($positionnement, $choix, $ordre, $bareme, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_positionnement_choix($positionnement,  $choix,  $ordre, $bareme, $media, $hauteur, $largeur)";
//		echo $sql."<br>";
		return pg_fetch_result(pg_query($sql),0,0)=='t';
	} else
		return set_positionnement_choix_old($positionnement, $choix, $ordre, $bareme, $media, $hauteur, $largeur);
}

/**
 * Mettre a jour l'association d'un choix  d'un positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix a modifier
 * @param integer : le numero du nouveau choix
 * @param integer : le numero du bareme
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que la modification se soit bien passe ou non 
 */
function maj_positionnement_choix_old($positionnement, $choix, $new_choix, $bareme, $media, $hauteur, $largeur) {
	if($bareme=='NULL')$bareme=0;
	$update = "	UPDATE asso_test_reponse SET media_reponse = $media,id_reponse= $new_choix, longueur_media = $hauteur, largeur_media = $largeur, num_bareme=$bareme
		          		WHERE id_test=$positionnement AND id_reponse= $choix";
	//echo $update."<br>";
	return pg_query($update);
}

/**
 * Mettre a jour l'association d'un choix  d'un positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix a modifier
 * @param integer : le numero du nouveau choix
 * @param integer : le numero du bareme
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que la modification se soit bien passe ou non 
 */
function maj_positionnement_choix($positionnement, $choix, $new_choix, $bareme, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_positionnement_choix($positionnement, $choix,  $new_choix, $bareme, $media, $hauteur, $largeur)";
		//echo $sql."<br>";
		return pg_query($sql);
	} else
		return maj_positionnement_choix_old($positionnement, $choix, $new_choix, $bareme, $media, $hauteur, $largeur);
}

///**
// * Associer une nouvelle question a un positionnement.
// * @param integer : le numero du positionnement
// * @param integer : le numero de la question
// * @param integer : l'odre de la question
// * @return bool : TRUE ou FALSE selon que l'association se soit bien passe ou non
// */
//function set_positionnement_question_old($positionnement, $question, $ordre) {
//	return set_serie_evaluation_old($question, $positionnement, $ordre, "", 0, 0, 0, "");
//}
//
///**
// * Associer une nouvelle question a un positionnement.
// * @param integer : le numero du positionnement
// * @param integer : le numero de la question
// * @param integer : le numero  de la question pere
// * @return bool : TRUE ou FALSE selon que l'association se soit bien passe ou non
// */
//function set_positionnement_question($positionnement, $question, $pere) {
//	if (VERSION_BASE > VERSION) {
//		$sql = "SELECT * FROM contraintes.af_set_positionnement_question($positionnement, $question, $pere::int4)";
//		echo $sql."<br>";
//		return pg_query($sql);
//	} else
//		return set_positionnement_question_old($positionnement, $question, $pere);
//}

/**
 * Definir les nombres d'evaluations  gnrer pour un choix d'un positionnement. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param integer : le type d'evaluation  gnrer
 * @param integer : le nombre d'evaluations  gnrer
 * @param integer : le nombre d'evaluations parmis lesquelles on choisi le nombre  gnrer
 * @return bool : TRUE ou FALSE selon que l'insertion se soit bien passe ou non
 */
function set_positionnement_nb_evaluations_a_generer_old($positionnement, $choix, $type, $nb_a_generer, $taille_chapeau) {
	$insert = "INSERT INTO test_rep_nbexogen (id_test, id_reponse, type_exercice, nb_a_generer, taille_chapeau)
					   VALUES ($positionnement, $choix, '$type', $nb_a_generer, $taille_chapeau)";
	//echo $insert."<br>";
	return pg_query($insert);
}

/**
 * Definir les nombres d'evaluations  gnrer pour un choix d'un positionnement.
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param integer : le type d'evaluation  gnrer
 * @param integer : le nombre d'evaluations  gnrer
 * @param integer : le nombre d'evaluations parmis lesquelles on choisi le nombre  gnrer
 * @return bool : TRUE ou FALSE selon que l'insertion se soit bien passe ou non
 */
function set_positionnement_nb_evaluations_a_generer($positionnement, $choix, $type, $nb_a_generer, $taille_chapeau) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_positionnement_nb_evaluations_a_generer($positionnement, $choix, $type, $nb_a_generer, $taille_chapeau)";
		//echo $sql."<br>";
		$result = pg_query($sql);
	} else
		return set_positionnement_nb_evaluations_a_generer_old($positionnement, $choix, $type, $nb_a_generer, $taille_chapeau);
}

/**
 * Mettre a jour les nombres d'evaluations  gnrer pour un choix d'un positionnement. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param array : tableau dont chacune des lignes contient 3 colonnes: le type d'evaluation  gnrer (0), le nombre d'evaluations  gnrer(1) et le nombre d'evaluations parmis lesquelles on choisi le nombre  gnrer(2)
 * @return bool : TRUE ou FALSE selon que l'insertion se soit bien passe ou non
 */
function maj_positionnement_nb_evaluations_a_generer_old($positionnement, $choix, $tabEvaluationsGenerees) {
	while ($tab = each($tabEvaluationsGenerees)) {
		$insert = "UPDATE test_rep_nbexogen SET nb_a_generer=" . $tab[1][1] . ", taille_chapeau=" . $tab[1][2] . "
						           WHERE id_test=$positionnement AND id_reponse=$choix AND type_exercice='".$tab[0][0]."'";
		$res=pg_query($insert);
	}
	//on supprime les associations existantes
	$delete="DELETE FROM test_quest_rep WHERE id_test=$positionnement AND id_reponse=$choix";
	$res=$res=pg_query($delete);
		
	return 't';
}

/**
 * Mettre a jour les nombres d'evaluations  gnrer pour un choix d'un positionnement. (OLD)
 * 
 * @param integer : le numero du positionnement
 * @param integer : le numero du choix
 * @param array : tableau dont chacune des lignes contient 3 colonnes: le type d'evaluation  gnrer (0), le nombre d'evaluations  gnrer(1) et le nombre d'evaluations parmis lesquelles on choisi le nombre  gnrer(2)
 * @return bool : TRUE ou FALSE selon que l'insertion se soit bien passe ou non
 */
function maj_positionnement_nb_evaluations_a_generer($positionnement, $choix, $tabEvaluationsGenerees) {
	if (VERSION_BASE > VERSION) {

		if (is_array($tabEvaluationsGenerees)) {
			$chaine = "'{";
			$i = 0;
			$nb_i = count($tabEvaluationsGenerees);
			while ($tab = each($tabEvaluationsGenerees)) {

				//on passe un nombre negatif car on ne peut mettre NULL dans un tableau
				$nb1 = $tab[1][1];
				if (empty ($nb1) || $nb1 == 'NULL')
					$nb1 = -1;
				$nb2 = $tab[1][2];
				if (empty ($nb2) || $nb2 == 'NULL')
					$nb2 = -1;
				$chaine .= "{" . get_evaluation_type_old_new($tab[0]) . ",$nb1,$nb2}";
				if ($i < $nb_i -1)
					$chaine .= ",";
				$i++;
			}
			$chaine .= "}'";
		} else {
			$chaine = 'NULL';
		}
		//echo $chaine;
		$sql = "SELECT * FROM contraintes.af_maj_positionnement_nb_evaluations_a_generer($positionnement, $choix, $chaine)";
		//echo $sql."<br>";
		$result = pg_query($sql);
	} else
		return maj_positionnement_nb_evaluations_a_generer_old($positionnement, $choix, $tabEvaluationsGenerees);
}

/**
 * Obtenir les themes d'un positionnement.(OLD)
 * @param integer : le numero du positionnement
 * @return integer : l'entier resultat : (id int4, libelle varchar)
 */
function get_positionnement_themes_old($positionnement) {
	$sql = "select theme, 'P' from serie_exo where id=$positionnement";
	//echo "$sql<br>";
	return (pg_query($sql));
}

/**
 * Obtenir les themes d'un positionnement.
 * @param integer : le numero du positionnement
 * @return integer : l'entier resultat  (id int4, libelle varchar)
 */
function get_positionnement_themes($positionnement) {
	if (VERSION_BASE > VERSION) {
		return get_categorie_element_themes(22, $positionnement);
	} else
		return get_positionnement_themes_old($positionnement);
}

/**
 * Obtenir les evaluations d'un type et d'un theme affiliables  un positionnement.
 * Ces valuations sont l'ensembles des valations d'un theme du type donn qui ne sont pas deja dans le positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero d'un theme
 * @param integer : le type d'evaluation (q ou f)
 * @return integer : l'entier resultat : (id int4, libelle varchar, type int4)
 */
function get_positionnement_evaluations_affiliables_theme_type_old($positionnement, $theme, $type) {
	$exos = "	SELECT id_exercice 
							FROM test_quest_rep 
							WHERE id_test=$positionnement
							AND type_exercice='$type'";
	switch ($type) {
		case 'f' :
		case 3 :
		
			$exos_aff = "	SELECT id, SUBSTR(text,0, 60) as libelle, 'f' FROM gest_ftb 
														WHERE theme=$theme
						    							AND id NOT IN ($exos);";
			break;
		case 'q' :
		case 1 :
			$exos_aff = "	SELECT DISTINCT num_question AS id , libelle_question as libelle, 'q' FROM question, quest_rep 
														WHERE theme=$theme
														AND num_question=qr_num_question
														AND num_question NOT IN ($exos);";
			break;
		default :
			print ("Erreur fonction get_positionnement_evaluations_affiliables_theme_type_old(...) :<br>Le type $type n'existe pas.");
			break;
	}
	//echo "$exos_aff<br>";
	return pg_query($exos_aff);

}

/**
 * Obtenir les evaluations d'un type et d'un theme affiliables  un positionnement.
 * Ces valuations sont l'ensembles des valations d'un theme du type donn qui ne sont pas deja dans le positionnement.
 * @param integer : le numero du positionnement
 * @param integer : le numero d'un theme
 * @param integer : le numero du type d'evaluation
 * @return integer : l'entier resultat : (id int4, libelle varchar, type int4)
 */
function get_positionnement_evaluations_affiliables_theme_type($positionnement, $theme, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_evaluations_affiliables_type($positionnement,$theme, $type) AS (id int4, libelle varchar, type int4)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else
		return get_positionnement_evaluations_affiliables_theme_type_old($positionnement, $theme, $type);
}

/**
 * Obtenir les tests qui utilisent un positionnement. (OLD)
 * @param integer : le numero du positionnement
 * @return integer : l'entier resultat : (id int4, libelle varchar,  dynamique bool, continu bool, media int4, hauteur int4, largeur int4)
 */
function get_positionnement_tests_old($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT DISTINCT L.id_liste_test, L.nom_lise_test, L.dynamique, L.continu, L.media_liste_test, L.longueur_media, L.largeur_media FROM asso_liste_test P, liste_test L WHERE P.id_test=$positionnement AND L.id_liste_test= P.id_liste_test ";
		return (pg_query($sql));
	}
}

/**
 * Obtenir les tests qui utilisent un positionnement. 
 * @param integer : le numero du positionnement
 * @return integer : l'entier resultat : (id int4, libelle varchar,  dynamique bool, continu bool, media int4, hauteur int4, largeur int4, date_creation timestamp)
 */
function get_positionnement_tests($positionnement) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_tests($positionnement) AS (id int4, libelle varchar,  dynamique bool, continu bool, media int4, hauteur int4, largeur int4, date_creation timestamp)";
		//echo "$sql<br>";
		return (pg_query($sql));
	} else
		return get_positionnement_tests_old($positionnement);
}

/**
    Mettre  jour une question de positionnement  (OLD)

    @param integer : le numero de question
    @param string  : le libelle de la question
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param bool : interpretation HTML
    @param char: le type de question de positionnement (q ou s)
    @return bool : TRUE ou FALSE selon que la mise a jour se soit bien passe ou non
*/
function maj_positionnement_question_positionnement_old($positionnement,$question, $libelle, $media, $largeur, $hauteur, $inter_html, $type) {
	if($inter_html=='NULL')$inter_html='f';
	
	if($type=='q'||$type==1||$type=='m'||$type==4){
		$req1=maj_question_qcm($question, $libelle,$inter_html);
		$req2=maj_question_qcm_media($question,$media, $largeur, $hauteur );
	}else{
		if($type=='s'||$type==2||$type=='p'||$type==5){
			$req1=maj_question_sondage_question_sondage($question, $libelle,$inter_html);
			$req2=maj_question_sondage_question_sondage_media($question,$media, $largeur, $hauteur );
		}else{
			print ("Erreur fonction maj_positionnement_question_positionnement_old(...) :<br>Le type $type n'existe pas.");
		}
	}
	return $req1 || $req2;
}

/**
    Mettre  jour une question de positionnement  

    @param integer : le numero de question
    @param string  : le libelle de la question
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param bool : interpretation HTML
    @param char: (facultatif) pour la fonction old, le type de question de positionnement (q ou s)
    @return bool : TRUE ou FALSE selon que la mise a jour se soit bien passe ou non
*/
function maj_positionnement_question_positionnement($positionnement, $question, $libelle, $media, $largeur, $hauteur, $inter_html, $type="") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_question_positionnement($positionnement,$question,'$libelle',$media,$largeur,$hauteur, '$inter_html')";
//		echo "$sql<br>";
		return pg_fetch_result(pg_query($sql),0,0);
	} else
		$res = maj_positionnement_question_positionnement_old($positionnement, $question, $libelle, $media, $largeur, $hauteur, $inter_html,$type);
	return $res;
}

/**
    Creer une question de positionnement  (OLD)

    @param integer : le numero de positionnement
    @param string  : le libelle de la question
    @param integer : le theme de la question
   	@param bool : interpretation HTML
   	@param integer : le type de question (qcm ou sondage)
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param integer : le numero d'ordre
    @return integer : le numero de la question ainsi cre
*/
function set_positionnement_question_positionnement_old($positionnement, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $ordre) {

	if ($type == 'q'||$type == 'm') {
		$res = set_question_qcm($libelle, $inter_html, $theme);
		$res1 = set_question_qcm_media($res,$media, $largeur, $hauteur);
	} else {
		if ($type == 's'||$type == 'o') {
			$res = set_question_sondage($libelle, $theme, $media, $largeur, $hauteur, 'r', $inter_html);
		} else {
			print ("Erreur set_positionnement_question_positionnement_old(...):<br> le type '$type' n'est pas support par la fonction.<br>");
			return false;
		}
	}
	$sql = "INSERT INTO asso_exo_serie (id_exo, type_exo, id_serie, ordre) VALUES ($res, '$type', $positionnement,$ordre )";
	//echo "$sql<br>";
	$ins = pg_query($sql);
	return $res;
}

/**
    Creer une question de positionnement  

    @param integer : le numero de positionnement
    @param string  : le libelle de la question
    @param integer : le theme de la question
   	@param bool : interpretation HTML
   	@param integer : le type de question (qcm ou sondage)
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param integer : le numero de la question pere
    @return integer : le numero de la question ainsi cre
*/
function set_positionnement_question_positionnement($positionnement, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $pere) {

	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_question_positionnement($positionnement,  '$libelle',  '$inter_html', $media, $largeur, $hauteur ,$pere)";
//		echo "$sql<br>";
		$ins = pg_fetch_result(pg_query($sql), 0, 0);
		set_categorie_element_theme(17,$theme,$ins);
		return $ins;
	} else
		$res = set_positionnement_question_positionnement_old($positionnement, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $pere);
	return $res;
}

/**
 * Obtenir la solution qu'une question et d'un choix d'un positionnement. (OLD)
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param integer : le numero du choix
 * @return integer : l'entier resultat :(question_reponse int4, question int4, reponse int4, juste bool)
 */
function get_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $choix) {
	$sql = "SELECT qr_num_question, qr_num_question, qr_num_rep, juste from quest_rep where qr_num_question=$question and qr_num_rep=$choix ";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir la solution qu'une question et d'un choix d'un positionnement.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param integer : le numero du choix
 * @return integer : l'entier resultat :(question_reponse int4, question int4, reponse int4, juste bool)
 */
function get_positionnement_question_positionnement_reponse_solution($positionnnement, $question, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_positionnement_question_positionnement_solution($positionnnement,$question,$choix) AS (question_reponse int4, question int4, reponse int4, juste bool)";
//		echo "$sql<br>";
		return pg_query($sql);
	} else
		return get_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $choix);
}

/**
 * Affecter la solution qu'une question et de plusieurs choix d'un positionnement. (OLD)
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * La question et le choix doivent avoir t prcedement associe au positionnement.
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function set_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $tab_solutions) {
	$i = 0;
	$nb_i = count($tab_solutions);
	while ($tab = each($tab_solutions)) {
		$juste=$tab[1][1];
		if($juste=="1")$juste='TRUE';
		else $juste='FALSE';
		$sql="INSERT INTO quest_rep (qr_num_question,qr_num_rep,juste  ) VALUES (".$question .",". $tab[1][0].",".$juste.")";
		//echo $sql."<br>";
		$res=pg_query($sql);
		if($res)$i++;
	}
	if($i==$nb_i)return 't';
	else return 'f';
}

/**
 * Affecter la solution qu'une question et de plusieurs choix d'un positionnement.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * La question et le choix doivent avoir t prcedement associe au positionnement.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function set_positionnement_question_positionnement_reponse_solution($positionnnement, $question, $tab_solutions) {
	if (VERSION_BASE > VERSION) {

		$chaine = "'{";
		$i = 0;
		$nb_i = count($tab_solutions);
		while ($tab = each($tab_solutions)) {
			$chaine .= "{" . $tab[1][0] . "," . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$chaine .= ",";
			$i++;
		}
		$chaine .= "}'";
		$sql = "SELECT * FROM contraintes.af_set_positionnement_question_positionnement_solution($positionnnement,$question,$chaine) ";
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		return set_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $tab_solutions);
}

/**
 * Mettre a jour la solution d'une question et de plusieurs choix d'un positionnement.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * La question et le choix doivent avoir t prcedement associe au positionnement.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function maj_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $tab_solutions) {
	$i = 0;
	$nb_i = count($tab_solutions);
	while ($tab = each($tab_solutions)) {
		$juste=$tab[1][1];
		if($juste=="1")$juste='TRUE';
		else $juste='FALSE';
		$sql="UPDATE quest_rep SET juste=".$juste." WHERE qr_num_question =$question AND qr_num_rep=".$tab[1][0];
		//echo $sql."<br>";
		$res=pg_query($sql);
		if(pg_affected_rows($res)>0){
			$i++;	
		}
		
	}
	if($i==$nb_i){
		return true;
	}
	else{
		return set_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $tab_solutions);
		
	}
}

/**
 * Mettre a jour la solution d'une question et de plusieurs choix d'un positionnement.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM ou QRC.
 * La question et le choix doivent avoir t prcedement associe au positionnement.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function maj_positionnement_question_positionnement_reponse_solution($positionnnement, $question, $tab_solutions) {
	if (VERSION_BASE > VERSION) {

		$chaine = "'{";
		$i = 0;
		$nb_i = count($tab_solutions);
		while ($tab = each($tab_solutions)) {
			$chaine .= " {" . $tab[1][0] . ", " . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$chaine .= ",";
			$i++;
		}
		$chaine .= "}'";
		$sql = "SELECT * FROM contraintes.af_maj_positionnement_question_positionnement_solution($positionnnement,$question,$chaine) ";
		//echo "$sql<br>";
		return pg_fetch_result(pg_query($sql), 0, 0);
	} else
		return maj_positionnement_question_positionnement_reponse_solution_old($positionnnement, $question, $tab_solutions);
}

/**
 * Obtenir le numero d'un positionnement correspondant  serie pour un test et un parcours.
 * @param integer : le numero de la serie
 * @param integer : le numero du test
 * @param integer : le numero du parcours
 * @return integer : le numero du positionnement
 */
function get_positionnement_serie_numero_positionnement_parcours_old($serie, $test, $parcours) {
	// les numero de serie dans un tableau
	$sql = "select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and attach_parcours=$test order by num_etape";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_serie = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_serie[] = $row[0];
	}
	// les n de positionnement dans un tableau
	$sql = "select id_test from asso_liste_test where id_liste_test=$test order by ordre";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_test = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_test[] = $row[0];
	}
	// debug
	// recup index de la serie
	reset($tab_serie);
	while (list ($cle, $val) = each($tab_serie)) {
		// debug
		//echo "cle=$cle et val=$val et serie=$serie<br>";
		if ($val == $serie)
			break;
	}
	return $tab_test[$cle];

}

/**
 * Obtenir le numero d'une serie correspondant  un positionnement pour un test et un parcours.
 * @param integer : le numero du positionnement
 * @param integer : le numero du test
 * @param integer : le numero du parcours
 * @return integer : le numero de la serie
 */
function get_positionnement_numero_serie_parcours_old($positionnnement, $test, $parcours) {
	// les numero de serie dans un tableau
	//echo "liste=$liste et parc=$parcours<br>";
	$sql = "select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and attach_parcours=$test order by num_etape";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_serie = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_serie[] = $row[0];
	}
	// les n de positionnement dans un tableau
	$sql = "select id_test from asso_liste_test where id_liste_test=$test order by ordre";
	$res = pg_query($sql);
	$nb = pg_numrows($res);
	$tab_test = array ();
	for ($i = 0; $i < $nb; $i++) {
		$row = pg_fetch_row($res, $i);
		$tab_test[] = $row[0];
	}
	// debug
	// recup index du positionnement
	reset($tab_test);
	while (list ($cle, $val) = each($tab_test)) {
		// debug
		//echo "cle=$cle et val=$val et serie=$serie<br>";
		if ($val == $test)
			break;
	}
	return $tab_serie[$cle];

}
?>