<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
 
/**
	Fichier de fonction php pourpresentiel
	@package presentiel
	@modulegroup fonctions
*/   
/**
	Stockage des cartons presentiel pour un individu
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param integer : nb evenement
	@return array : tableau de carton
*/
function get_presentiel_carton_individu_tableau($formation,$stagiaire,$grille,$titrecapacite,$capacite,$nb){
	$tabnote=array();
	$res=get_presentiel_carton_individu($formation,$stagiaire,$grille,$titrecapacite,$capacite);
	$nb_note=pg_num_rows($res);
	if($nb_note==0)
		for($e=0;$e<$nb;$e++)
			$tabnote[]=0;
	else{
		if (VERSION_BASE > VERSION){
			for($n=0;$n<$nb_note;$n++){
				$row=pg_fetch_row($res,$n);
				$tabnote[]=$row[8];
			}
		}
		else{
			$row=pg_fetch_row($res,0);
			$tabnote=explode(",",$row[0]);
		}
	}
	return $tabnote;
}

/**
	Teste  si capacite note pour une date
	 @param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param integer : timestamp
	@param integer : indice date
	@return bool : true si note, false sinon
*/
/*
function get_presentiel_note_individu_date($formation,$stagiaire,$grille,$titrecapacite,$capacite,$date,$ind){
	if (VERSION_BASE > VERSION){
		//get_presentiel_
	}
	else{
	
	}
}
*/


                    


?>