<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  	LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
    @package presentiel
    @modulegroup plpgsql
    @module plpgsql_presentiel
*/

/**
	Obtenir les cartons presentielles d'un individu  (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function get_presentiel_carton_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="select notation from notation where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Obtenir lescartons presentielles d'un individu pour une formation

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function get_presentiel_carton_individu($formation,$individu,$grille,$titrecapacite,$capacite){
 	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_carton_individu($formation,$individu,$grille,$titrecapacite,$capacite)
					as (formation int4,stagiaire int4,grille int4,capacite_titre int4,capacite int4,commentaire text,note int4,note_max int4,carton int4,date timestamp)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res = get_presentiel_carton_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Obtenir les infos note presentiellle d'un individu pour une date (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
function get_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	$sql="select comment,note,notesur from comment_presentiel where num_cal=$formation  and num_user=$individu and
			num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
   return (pg_query($sql));
}
/**
	Obtenir les infos note presentiellle d'un individu pour une date

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param date : le numero de date
 	@return integer :  le resultat de la requete
*/
function get_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,$date){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,'$date')
					as (commentaire text,note int4,note_max int4)";
		$res=pg_query($sql);
    }
    else
        $res = get_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date);
    return $res;
}

/**
	Mettre  jour les  note presentiellle d'un individu pour  une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function maj_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	$sql="update comment_presentiel set comment='$commentaire',note=$note,notesur=$notesur where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
   return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pourune date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function maj_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,$date,$commentaire,$note,$notesur){
	if (VERSION_BASE > VERSION) {
		$sql="select * from 
		contraintes.af_maj_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,'$date','$commentaire',$note,$notesur)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res = maj_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur);
    return $res;
}

/**
	Enregistrer les infos note presentiellle d'un individu pour une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function set_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	$sql="insert into comment_presentiel
			values($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,'$commentaire',$note,$notesur)";
   return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pour une date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function set_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur);
    return $res;
}

/**
	Supprimer les notations presentielles d'un individu  (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function del_presentiel_notation_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="delete from notation where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Obtenir les notations presentielles d'un individu

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function del_presentiel_notation_individu($formation,$individu,$grille,$titrecapacite,$capacite){
 	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_presentiel_notation_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Mettre  jour les notations presentielles d'un individu  (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@param string : les notations
 	@return integer :  le resultat de la requete
 */
function maj_presentiel_notation_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$notation){
	$sql="update notation set notation='$notation' where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Mettre  jour les notations presentielles d'un individu

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@param string : les notations
 	@return integer :  le resultat de la requete
 */
function maj_presentiel_notation_individu($formation,$individu,$grille,$titrecapacite,$capacite,$notation){
 	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_presentiel_notation_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$notation);
    return $res;
}

/**
	Supprimer les infos note presentiellle d'un individu pour une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
/*
function del_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	$sql="delete from  comment_presentiel  where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
  	return (pg_query($sql));
}
*/
/**
	Mettre  jour les infos note presentiellle d'un individu pour  une date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
/*
function del_presentiel_note_individu_date($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_presentiel_note_individu_date_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date);
    return $res;
}
*/
/**
	Supprimer les infos note presentiellle d'un individu  (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite

 	@return integer :  le resultat de la requete
*/
function del_presentiel_notes_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="delete from  comment_presentiel  where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite";
  	return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu
 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite

 	@return integer :  le resultat de la requete
*/
function del_presentiel_notes_individu($formation,$individu,$grille,$titrecapacite,$capacite){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_presentiel_notes_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Obtenir les notes presentielles d'un individu pour une grille (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
*/
function get_presentiel_notes_individu_grille_old($formation,$individu,$grille){
	$sql="select note,notesur from comment_presentiel where num_cal=$formation and num_user=$individu and num_grille=$grille and notesur<>0";
 	return (pg_query($sql));
}
/**
	Obtenir les notes presentielles d'un individu pour une grille

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
*/
function get_presentiel_notes_individu_grille($formation,$individu,$grille){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_notes_individu_grille($formation,$individu,$grille) 
				as (formation int4,stagiaire int4,grille int4,libelle_grille varchar,capacite_titre int4,libelle_capacite_titre varchar,capacite int4,
				libelle_capacite varchar,commentaire text,note int4,note_max int4,carton int4,date timestamp)";
		
    }
    else
        $res = get_presentiel_notes_individu_grille_old($formation,$individu,$grille);
    return $res;
}

/**
	Obtenir les notes presentielles d'un individu pour un titre de capacite(OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
*/
function get_presentiel_notes_individu_titrecapacite_old($formation,$individu,$grille,$titrecapacite){
	$sql="select note,notesur from comment_presentiel where num_cal=$formation and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and notesur<>0";
 	return (pg_query($sql));
}
/**
	Obtenir les notes presentielles d'un individu pour un titre de capacite

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
*/
function get_presentiel_notes_individu_titrecapacite($formation,$individu,$grille,$titrecapacite){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_presentiel_notes_individu_titrecapacite_old($formation,$individu,$grille,$titrecapacite);
    return $res;
}

/**
	Obtenir les notes presentielles d'un individu pour une capacite(OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
*/
function get_presentiel_notes_individu_capacite_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="select note,notesur from comment_presentiel where num_cal=$formation and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite
			and num_capacite=$capacite and notesur<>0";
 	return (pg_query($sql));
}
/**
	Obtenir les notes presentielles d'un individu pour une grille

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
*/
function get_presentiel_notes_individu_capacite($formation,$individu,$grille,$titrecapacite,$capacite){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_presentiel_notes_individu_capacite_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Obtenir les individus notes en presentiel pour une grille et une formation (OLD)

	@param integer : le numero de formation
 	@param integer : le numero de grille
*/
function get_presentiel_individus_infos_notes_old($grille,$formation){
 	$sql="select num_user,nom,prenom from utilisateurs where num_user in
			(select distinct num_user from notation where num_grille=$grille and num_cal=$formation)";
   return (pg_query($sql));
}
/**
	Obtenir les individus notes en presentiel pour une grille et une formation

	@param integer : le numero de formation
 	@param integer : le numero de grille
*/
function get_presentiel_individus_infos_notes($grille,$formation){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_presentiel_individus_infos_notes_old($grille,$formation);
    return $res;
}

/**
    Obtenir la cofiguration-grille pour un individu (OLD)

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
*/
function get_presentiel_grille_individu_old($formation,$grille,$individu){
    $sql="select * from config_grille where num_cal=$formation and num_grille=$grille and num_user=$individu";
    return (pg_query($sql));
}
/**
    Obtenir la configuration-grille pour un individu

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
*/
function get_presentiel_grille_individu($formation,$grille,$individu){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_presentiel_grille_individu_old($formation,$grille,$individu);
    return $res;
}

/**
    Mettre  jour la configuration-grille pour un utilisateur  (OLD)

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
    @param bool : voir la grille
*/
function maj_presentiel_grille_individu_old($formation,$grille,$individu,$voir){
    $sql="update config_grille set voir='$voir' where num_cal=$formation and num_user=$individu and num_grille=$grille";
    return (pg_query($sql));
}
/**
    Mettre  jour la configuration-grille pour un utilisateur

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
    @param bool : voir la grille
*/
function maj_presentiel_grille_individu($formation,$grille,$individu,$voir){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_presentiel_grille_individu_old($formation,$grille,$individu,$voir);
    return $res;
}

/**
    Enregistrer la configuration-grille pour un utilisateur  (OLD)

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
    @param bool : voir la grille
*/
function set_presentiel_grille_individu_old($formation,$grille,$individu,$voir){
    $sql="insert into config_grille values($formation,$grille,$individu,'$voir')";
    return (pg_query($sql));
}
/**
    Enregistrer la configuration-grille pour un utilisateur

    @param integer : le numero de formation
    @param integer : le numero de grille
    @param integer : le numero d'individu
    @param bool : voir la grille
*/
function set_presentiel_grille_individu($formation,$grille,$individu,$voir){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_presentiel_grille_individu_old($formation,$grille,$individu,$voir);
    return $res;
}

/**
	Obtenir le carton pour une capacite  une date (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	
	@return integer : resultat req
*/
function get_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){

}
/**
	Obtenir le carton pour une capacite  une date 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	
	@return integer : resultat req
*/
function get_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,'$date') 
					as (carton int4)";
		//echo "sql=$sql<br>";	
		$res=pg_query($sql);			
	}
	else
		return get_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date);
	return $res;
}

/**
	Met  jour le carton pour une capacite  une date (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@param integer : carton
*/
function maj_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton){

}
/**
	Met  jour le carton pour une capacite  une date 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@param integer : carton
*/
function maj_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton){
	 if (VERSION_BASE > VERSION) {
		$sql="select * from 
		contraintes.af_maj_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,'$date',$carton)";
		$res=pg_query($sql);
	 }
	 else
		return maj_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton);
	 return $res;
}

/**
	Enregistre le carton pour une capacite  une date (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@param integer : carton
*/
function set_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton){

}
/**
	Enregistre le carton pour une capacite  une date 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@param integer : carton
*/
function set_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton){
	 if (VERSION_BASE > VERSION) {
		$sql="select * from 
		contraintes.af_set_presentiel_carton_capacite_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,'$date',$carton)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		return set_presentiel_carton_capacite_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date,$carton);
	 return $res;
}

/**
	Supprime un carton pour une capacite  une date (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@return integer : res req
*/
function del_presentiel_note_individu_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){

}
/**
	Supprime un carton pour une capacite  une date 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@return integer : res req
*/
function del_presentiel_note_individu_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_del_presentiel_note_individu_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,'$date')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		return del_presentiel_note_individu_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date);
	return $res;
}

/**
	Obtenir les resultats presentielles d'un individu pour une grille (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
*/
function get_presentiel_resultats_individu_grille_old($formation,$individu,$grille){
	$sql="select note,notesur from comment_presentiel where num_cal=$formation and num_user=$individu and num_grille=$grille and notesur<>0";
 	return (pg_query($sql));
}
/**
	Obtenir les notes presentielles d'un individu pour une grille

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
*/
function get_presentiel_resultats_individu_grille($formation,$individu,$grille){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_resultats_individu_grille($formation,$individu,$grille) 
				as (formation int4,stagiaire int4,grille int4,libelle_grille varchar,capacite_titre int4,libelle_capacite_titre varchar,capacite int4,
				libelle_capacite varchar,commentaire text,note int4,note_max int4,carton int4,date timestamp)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		
    }
    else
        $res = get_presentiel_resultats_individu_grille_old($formation,$individu,$grille);
    return $res;
}

/**
	Obtenir le resultat presentiel d'un individu pour une date (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@return integer : res req
*/
function get_presentiel_resultat_individu_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){

}
/**
	Obtenir le resultat presentiel d'un individu pour une date
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@param date : timestamp
	@return integer : res req
*/
function get_presentiel_resultat_individu_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_resultat_individu_date($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,'$date')
					as (formation int4,stagiaire int4,grille int4, capacite_titre int4,capacite int4,commentaire text,note int4,note_max int4,carton int4, date timestamp)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		return get_presentiel_resultat_individu_date_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite,$date);
	return $res;
}

/**
	Obtenir les resultats presentiels d'un individu pour une capacite (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@return integer : res req
*/
function get_presentiel_resultats_individu_capacite_old( $calendrier,$stagiaire,$grille,$titrecapacite,$capacite){

}
 /**
	Obtenir les resultats presentiels d'un individu pour une capacite 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	@param integer : titrecapacite
	@param integer : capacite
	@return integer : res req
*/
function get_presentiel_resultats_individu_capacite($calendrier,$stagiaire,$grille,$titrecapacite,$capacite){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_resultats_individu_capacite($calendrier,$stagiaire,$grille,$titrecapacite,$capacite)
					as (formation int4,stagiaire int4,grille int4, capacite_titre int4,capacite int4,commentaire text,note int4,note_max int4,carton int4, date timestamp)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		return get_presentiel_resultats_individu_capacite_old($calendrier,$stagiaire,$grille,$titrecapacite,$capacite);
	return $res;
}

/**
	Mettre  jour la table stagiaire_grille (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	
	@param bool : visible(true),false sinon
	@return bool : res req
*/
function maj_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille,$visible){
	$sql="update config_grille set voir='$visible' where num_cal=$formation and num_user=$stagiaire and num_grille=$grille";
	return pg_query($sql);
}
/**
	Mettre  jour la table stagiaire_grille 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	
	@param bool : visible(true),false sinon
	@return bool : res req
*/
function maj_presentiel_stagiaire_grille($formation,$stagiaire,$grille,$visible){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_maj_presentiel_stagiaire_grille($formation,$stagiaire,$grille,'$visible')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		return maj_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille,$visible);
	return $res;
}

/**
	Obtenir les infos de la table stagiaire_grille (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
*/
function get_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille){
	$sql="select * from config_grille where num_cal=$formation and num_grille=$grille and num_user=$stagiaire";
	return pg_query($sql);
}
/**
	Obtenir les infos de la table stagiaire_grille 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
*/
function get_presentiel_stagiaire_grille($formation,$stagiaire,$grille){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_presentiel_stagiaire_grille($formation,$stagiaire,$grille) 
					as (formation int4,stagiaire int4,grille int4,visible bool)";
		$res=pg_query($sql); 
	}
	else
		return get_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille);
	return $res;
}
?>