<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la classe Proposition
Cette classe dcrit une Proposition de rponse  un sondage
La connexion  la base de donnes doit tre $db

@author CHABOISSIER Jonathan <jc@afide.fr>
@since 07/07/2004

@package proposition
*/
class Proposition extends Reponse
{

        /**
        * Constructeur de la classe Proposition
        *
        * On peut construire de deux faons. Soit on utilise le paramtre identifiant l'enregistrement en base de donnes, soit on passe
        * toutes les informations ncssaires.
        * @param integer : identifiant de la srie s'il elle existe en base de donnes (doit tre le seul argument valu si on veut construire un objet  partir
        * de l'enregistrement en BD
        * @param string : Libell
        * @param integer : identifiant du thme en base de donnes
        *
        */

        function Proposition($id="", $lib="", $theme="", $media="")
        {
                // Si l'identifiant est inconnu
                if($id=="")
                {
                        // On appel le constructeur de la classe mre
                        parent::reponse($id, $lib, $theme, $media) ;
                }
                // Si on connait l'identifiant
                else
                {
                        // On rcupre les informations en base de donnes
                        //$result = pg_query("SELECT * FROM proposition WHERE num_prop=$id");
						$result=get_proposition_sondage($id);
                        $row=pg_fetch_array($result) ;
                        $media =  new Media_exo() ;
                        // On appel le constructeur de la classe mre avec un bons paramtres
                        parent::reponse($row[0],$row[1],pg_fetch_result(get_proposition_sondage_theme($id),0,0), $media);
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Proposition()

        /**
        * Fonction qui insre un enregistrement en table
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cr (ou rcupr)
        */
        function insertToDB()
        {
                if($this->libelle_reponse && $this->num_theme)
                {
						$lib=addslashes($this->libelle_reponse);
                        // Avant d'effectuer une insertion, on vrifie que qu'il n'y a pas dj une rponse du mme libell
						/*
                        $result = pg_query("SELECT num_prop FROM proposition WHERE libelle_prop = '".addslashes($this->libelle_reponse)."' AND theme=$this->num_theme") ;
                        if(pg_num_rows($result))
						*/
						//if(check_proposition($this->num_theme,$lib))
                        //        return pg_result($result,0,0);
                        //else
                        //{
								/*
                                $insert = "INSERT INTO proposition (libelle_prop, theme) VALUES ('".addslashes($this->libelle_reponse)."', $this->num_theme)" ;
                                $result = pg_query($insert) ;
                                $oid = pg_last_oid($result) ;
                                return pg_result(pg_query("SELECT num_prop FROM proposition WHERE oid=$oid"),0,0) ;
								*/
								$html='FALSE';
								$insertion=set_proposition_sondage($lib,$html,$this->num_theme);
								if($insertion)
									return $insertion ;
								else
									return -1;
                        //}
                }
                else
                {
                        echo "Insertion Proposition impossible : mauvais attributs d'objet : $this->id_reponse && $this->libelle_reponse && $this->num_theme<br>" ;
                        return false ;
                }

        }

        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        */
        function updateToDB()
        {
                  if($this->id_reponse && $this->libelle_reponse)
                {
						/*
                        $update = "UPDATE proposition SET libelle_prop='".addslashes($this->libelle_reponse)."', theme=$this->num_theme WHERE num_prop=$this->id_reponse" ;
                        $result = pg_query($update) ;
						 if(!$result)
                                die("UPDATE proposition echec : $update<br>");
						*/
						//$lib=addslashes($this->libelle_reponse);
						$update=maj_proposition($this->id_reponse,$this->libelle_reponse);
						if($update)
							return true;
						else
							return -1;
                        
                }
                else
                {
                        echo "Update Proposition impossible : mauvais attributs d'objet $this->id_reponse et $this->libelle_reponse et $this->num_theme<br>" ;
                }
        }

        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

}
?>