<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier cr le 25 avr. 2006
	
	@author S. Ladjani
	@modulegroup plpgsql
	@package proposition
*/



/**
    Enregistre une nouvelle proposition

    @param string : le libelle de la proposition
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle proposition
*/
function set_proposition($libelle,$html, $theme){
    if(VERSION_BASE>VERSION){
        $sql="select contraintes.af_set_question_reponse_element('$libelle', $html, 'TRUE')";
        echo $sql;
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        return $row[0];
    }
    else
        $res=set_proposition_old($libelle,$html ,$theme);
    return $res;
}


/**
    Vrifie qu'une proposition est unique pour un thme donn (OLD)

    @param integer : le numro du thme
    @param string : le libelle de la proposition
    @return integer : 1 existe, 0 sinon
*/
function check_proposition_old($theme,$libelle){
    $sql="select * from proposition where theme=$theme and libelle_prop='$libelle'";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    return 1;
}
/**
    Vrifie qu'une rponse est unique pour un thme donn

    @param integer : le numro du thme
    @param string : le libelle de la rponse
    @return integer : 1 existe, 0 sinon
*/
function check_proposition($theme,$libelle){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_proposition_old($theme,$libelle);
    return $res;
}

/**
    Obtenir les infos d'une rponse (OLD)
	@deprecated utiliser get_proposition($proposition)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_proposition_infos_old($proposition){
    $sql="select * from proposition where num_prop=$proposition";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'une rponse
	@deprecated utiliser get_proposition($proposition)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_proposition_infos($proposition){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_proposition_infos_old($proposition);
    return $res;
}

/**
    Obtenir les infos d'une rponse (OLD)

    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4)
*/
function get_proposition_old($proposition){
    $sql="select * from proposition where num_prop=$proposition";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos d'une proposition

    @param integer : le numero de la proposition
    @return integer : le resultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4)
*/
function get_proposition($proposition){
    if(VERSION_BASE>VERSION){
        //$sql="select * from contraintes.af_get_proposition($proposition) as (id int4,libelle varchar,interpretation_html bool,type int4)";
        // NOTE : af_get_reponse($proposition) peut tre utilise
        $sql="select * from contraintes.af_get_reponse($proposition) as (id int4,libelle varchar,interpretation_html bool,type int4)";
        //echo "sql=$sql<br>";
   		 $res=pg_query($sql);
    }
    else
        $res=get_proposition_infos_old($proposition);
    return $res;
}

/**
    Obtenir le numero d'une rponse (OLD)

    @param string : le libelle de la proposition
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
function get_proposition_numero_old($libelle,$theme){
    $sql="select num_prop from proposition where theme='$theme' and libelle_prop='$libelle'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero d'une rponse

    @param string : le libelle de la proposition
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
function get_proposition_numero($libelle,$theme){
    if(VERSION_BASE>VERSION){
        //$sql="select * from contraintes.af_get_proposition_numero($libelle,$theme) as (id_proposition int4)";
        //$res=pg_query($sql);
    }
    else
        $res=get_proposition_numero_old($libelle,$theme);
    return $res;
}

/**
    Mettre  jour le libelle d'une proposition (OLD)

    @param integer : le numero de la proposition
    @param string : le libelle
    @return integer : 1
*/
function maj_proposition_old($proposition,$libelle){
    $sql="update proposition set libelle_prop='$libelle' where num_prop=$proposition";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour le libelle d'une proposition

    @param integer : le numero de la proposition
    @param string : le libelle
    @return integer : 1
*/
function maj_proposition($proposition,$libelle){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_proposition_old($proposition,$libelle);
    return $res;
}

?>