<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

@package proposition
@modulegroup plpgsql
@module plpgsql_proposition
*/

/**
    Obtenir les qcm pour une proposition donne (OLD)

    @param integer : le numero de la proposition
    @return integer : le resultat de la requete
*/
/*
function get_proposition_sondage_old($proposition){
    $sql="select num_prop,libelle_prop,inter_html,'s','TRUE' from proposition where num_prop=$proposition";
    $res=pg_query($sql);
    return $res;
}
*/
/**
    Obtenir les sondages pour une proposition donne

    @param integer : le numero de la proposition
    @return integer : le resultat de la requete
*/
/*
function get_proposition_sondage($proposition){
    if(VERSION_BASE>VERSION){
        return get_question_reponse_element($proposition);
    }
    else
        $res=get_proposition_sondages_old($proposition);
    return $res;
}
*/
/**
    Obtenir le pre pour l'ajout d'une proposition de qcm

    @param varchar: le nom de la table
    @param varchar : le nom du champ
    @param text : la cnodition
    @return integer : le nouveau pre
*/
function get_proposition_sondage_pere($table,$champ,$condition){
    $sql="select  * from contraintes.af_gen_last_element($table,$champ,$condition) as (id_pere int4)";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}

/**
	Obtenir les info d'une proposition (OLD)
	
	@param integer : le numero de la proposition
	@return integer :  le resultat de la requete
*/
function get_proposition_sondage_old($proposition){
	$sql="select num_prop,libelle_prop,inter_html,'s','TRUE' from proposition where num_prop=$proposition";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les info d'une proposition 
	
	@param integer : le numero de la proposition
	@return integer :  le resultat de la requete
*/
function get_proposition_sondage($proposition){
	if(VERSION_BASE>VERSION){
	return get_question_reponse_element($proposition);
	}
	else
		return get_proposition_sondage_old($proposition);
}

/**
	Enregistre une nouvelle proposition de sondage (OLD)
	
	@param string : le libelle de la proposition
	@param bool : interpretation html ?
	@param integer : le numero du theme
	@return integer : le numero de la nouvelle proposition
*/
function set_proposition_sondage_old($libelle,$html,$theme){
 
        $sql="insert into proposition (libelle_prop,theme,inter_html) values('$libelle','$theme','$html');";
//        echo $sql;
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $sql="select num_prop from proposition where oid=$oid";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        return $row[0];
}
 /**
	Enregistre une nouvelle proposition de sondage
	
	@param string : le libelle de la proposition
	@param bool : interpretation html ?
	@param integer : le numero du theme
	@return integer : le numero de la nouvelle proposition
*/
function set_proposition_sondage($libelle,$html,$theme){
	if(VERSION_BASE>VERSION){
		$num=set_question_reponse_element($libelle,$html,2,'TRUE');
		$sql="select contraintes.af_set_categorie_element_theme(17,$theme,$num)";
		$res=pg_query($sql);
		return $num;
	
	}
	else
		return set_proposition_sondage_old($libelle,$html,$theme);
}

/**
	Mettre  jour le media d'une proposition de sondage
	@param integer : le numero de la question
	@param integer : le numero de proposition
	@param integer : le numero de media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@param integer : le numero d'ordre
	@return bool : t si ok,f sinon
*/
function set_proposition_sondage_media_old($question,$proposition,$media,$largeur,$hauteur,$ordre){
	// 1er cas : il y a deja un enregistrement pour ce couple question / proposition
	$sql1="update proposition_sondage set pmedia=$media,plargeur=$largeur,phauteur=$hauteur
				where num_sondage=$question and num_proposition=$proposition";
	$res=pg_query($sql1);
	if(!$res){
		// 2ieme cas : il n'y a pas d'enregistrement pour ce couple question / proposition
		$sql2="insert into proposition_sondage (num_sondage,num_proposition,pmedia,plargeur,phauteur,ordre) 
					values($question,$proposition,$media,$largeur,$hauteur,$ordre)";
		$res=pg_query($sql);
			
	}
	return $res;
}
/**
	Mettre  jour le media d'une proposition de sondage
	@param integer : le numero de la question
	@param integer : le numero de proposition
	@param integer : le numero de media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@param integer : le numero d'ordre
	@return bool : t si ok,f sinon
*/
function set_proposition_sondage_media($question,$proposition,$media,$largeur,$hauteur,$ordre){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// ontest si une association question / sondage est unique
		//  l'avenir ,une question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return set_question_reponse_element_media($evaluation,$proposition,$media,$largeur,$hauteur);
	}
	else
		return set_proposition_sondage_media_old($question,$proposition,$media,$largeur,$hauteur,$ordre);
}

/**
	Supprimer le media d'une proposition de sondage (OLD)
	@param integer : le numero de la question
	@param integer : le numero de reponse
	@return bool : t si ok ,f sinon
*/
function del_proposition_sondage_media_old($question,$proposition){
	$sql="update proposition_sondage set pmedia=NULL,plargeur=NULL,phauteur=NULL 
				where num_sondage=$question and num_proposition=$proposition";
	$res=pg_query($sql);
	return $res;
}
/**
	Supprimer le media d'une proposition de sondage 
	@param integer : le numero de la question
	@param integer : le numero de reponse
	@return bool : t si ok ,f sinon
*/
function del_proposition_sondage_media($question,$proposition){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// ontest si une association question / sondage est unique
		//  l'avenir ,une question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return del_question_reponse_element_media($evaluation,$proposition);
	}
	else
		return del_proposition_sondage_media($question,$proposition);
}

/**
	Mettre  jour le media d'une proposition de sondage (OLD)
	@param integer : numero de questio
	@param integer : numero de reponse
	@param integer : nemero de media
	@param integer : largeur en pixel du media
	@param integer : hauteur en pixel du media
	@return bool :  t si ok, f sinon
*/
function maj_proposition_sondage_media_old($question,$proposition,$media,$largeur,$hauteur){
	$sql="update proposition_sondage set pmedia=$media,plargeur=$largeur,phauteur=$hauteur 
			where num_sondage=$question and num_proposition=$proposition";
	return pg_query($sql);
}
 /**
	Mettre  jour le media d'une proposition de sondage 
	@param integer : numero de questio
	@param integer : numero de reponse
	@param integer : nemero de media
	@param integer : largeur en pixel du media
	@param integer : hauteur en pixel du media
	@return bool :  t si ok, f sinon
*/
function maj_proposition_sondage_media($question,$proposition,$media,$largeur,$hauteur){
	 if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// ontest si une association question / sondage est unique
		//  l'avenir ,une question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return maj_question_reponse_element_media($evaluation,$proposition,$media,$largeur,$hauteur);
	 }
	 else
		$res=maj_proposition_sondage_media_old($question,$proposition,$media,$largeur,$hauteur);
	 return $res;
}

/**
	Obtenir les evaluations utilisant une proposition de sondage donne (OLD)
	@Note : ici on retourne un numero et un type
	@param integer : numero de proposition
	@return integer : resultat de la requete
*/
function get_proposition_sondage_evaluations_old($proposition){
	$sql="select distinct num_sondage,'s' from proposition_sondage where num_proposition=$proposition 
	union select distinct id_test,'o' from test_quest_rep where id_reponse=$proposition";
	$res=pg_query($sql);
	return $res;
															
}
/**
	Obtenir les evaluations utilisant une proposition de sondage donne 
	@Note : ici on retourne un numero et un type
	@param integer : numero de proposition
	@return integer : resultat de la requete
*/
function get_proposition_sondage_evaluations($proposition){
	 if(VERSION_BASE>VERSION){
		$res=get_question_reponse_element_evaluations($proposition);
	 }
	 else
		$res=get_proposition_sondage_evaluations_old($proposition);
	 return $res;
}

/**
	Obtenit le media d'une proposition de sondage (OLD)
	@param integer : numero de question
	@param integer : numero de proposition
	@return integer : resultat de la requete (question_reponse int4,question_reponse_element int4,media int4,largeur int4,hauteur int4)
*/
function get_proposition_sondage_media_old($question,$proposition){
	$sql="select num_sondage,num_proposition,pmedia,NULL,phauteur,plargeur from proposition_sondage 
				where num_sondage=$question and num_proposition=$proposition";
	$res=pg_query($sql);
	return $res;
}
/**
	Obtenir le media d'une proposition de sondage
	@param integer : numero de question
	@param integer : numero de proposition
	@return integer : resultat de la requete (question_reponse int4,question_reponse_element int4,media int4,largeur int4,hauteur int4)
*/
function get_proposition_sondage_media($question,$proposition){
	 if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// ontest si une association question / sondage est unique
		//  l'avenir ,une question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return get_question_reponse_element_media($evaluation,$proposition);
	 }
	 else
		$res=get_proposition_sondage_media_old($question,$proposition);
	 return $res;
}

/**
	Mettre  jour une proposition (OLD)
	@param integer : numero de proposition
	@param string : libelle proposition
	@param bool : interpretation html ?
	@return bool : t si ok, f sinon
*/
function maj_proposition_sondage_old($proposition,$libelle,$inter_html){
	$sql="update proposition set libelle_prop='$libelle',inter_html='$inter_html' where num_prop=$proposition";
	$maj=pg_query($sql);
	return $maj;
}
/**
	Mettre  jour une proposition 
	@param integer : numero de proposition
	@param string : libelle proposition
	@param bool : interpretation html ?
	@return bool : t si ok, f sinon
*/
function maj_proposition_sondage($proposition,$libelle,$inter_html){
	if(VERSION_BASE>VERSION){
		 return maj_question_reponse_element($proposition,$libelle,$inter_html);
	}
	else
		$res=maj_proposition_sondage_old($proposition,$libelle,$inter_html);
	return $res;
}

/**
	Obtenir les info d'une proposition (OLD)
	
	@param integer : le numero de la proposition
	@return integer :  le resultat de la requete
*/
function get_proposition_sondage_theme_old($proposition){
	$sql="select T.num_themedir, T.nom_theme from proposition P, themedir T where num_prop=$proposition AND T.num_themedir= P.num_themedir";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les info d'une proposition 
	
	@param integer : le numero de la proposition
	@return integer :  le resultat de la requete (id int4, libelle varchar)
*/
function get_proposition_sondage_theme($proposition){
	if(VERSION_BASE>VERSION){
	return get_categorie_element_themes(17,$proposition);
	}
	else
		return get_proposition_sondage_old($proposition);
}
?>