<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Qcm.
 *	Un Qcm est un objet driv de QuestionReponse. 
 *	Il correspond  l'association d'une question et de plusieurs rponses.
 *
 *	@package qcm
 */
class Qcm extends QuestionReponse{
	

	/**
	 * @var array Identifiants des rponses justes. 
	 */		
	var $justes;

	
	/**
	 * Construit un Qcm.
	 * Le Qcm peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Qcm
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio indique si le Qcm doit tre affich sous forme de radio(true) ou de checkbox(false)
	 */	
	function Qcm($id, $libelle="QCM", $date_creation="",$radio=false){
		messageDebug("Qcm::Qcm($id, $libelle, $date_creation,$radio)");
		if(func_num_args()==1){
			$res_evaluation = get_qcm($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[3];
			$radio=sql2Bool($row_evaluation[4]);
		}else{
//			echo "QCM nb param:".func_num_args()."<br>";
		}
		$this->justes=Array();
		parent::QuestionReponse($id, $libelle, TYPE_EVALUATION_QCM, $date_creation,$radio);
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=Qcm::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=Qcm::verify($message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Le nombre de questions doit tre gal  1 , le nombre de rponses justes
	 * suprieur  0 strictement, le champ radio doit tre  'f' et le type  TYPE_EVALUATION_QCM.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		
		$attributs_ok=true;		
		if(count($this->questions)!=1){
			$message.="[questions]";
			$attributs_ok=false;
		}
		if(count($this->justes)<0){
			$message.="[justes]";
			$attributs_ok=false;
		}
		if($this->radio){
			$message.="[radio]";
			$attributs_ok=false;
		}
		if($this->type!=TYPE_EVALUATION_QCM){
			$message.="[type]";
			$attributs_ok=false;
		}
		return $attributs_ok;
	}

	/**
	* Fonction qui insre le Qcm en base.
	* Affecte l'identifiant du Qcm.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Qcm
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Qcm cr ou false
	*/
	function insertToDB($theme, &$message) {
		
		//vrifie la prsence du theme
		if(empty($theme)){
			die("Erreur Qcm::insertToDB($theme, &$message=\"\"): Le thme est manquant.");
		}
	
		//transforme $this->justes vers le format attendu ( tableau contenant tous les couples rponse/boolen)
		$tab_justes=Array();
		foreach($this->reponses as $key => $id_reponse){
			if(in_array($id_reponse,$this->justes )){
				$tab_justes[]=Array($id_reponse, 1 );
			}
			else{
				$tab_justes[]=Array($id_reponse, 0 );
			}
		}
	
		//vrification donnes et insertion
		if(Qcm::verifyInsert(&$message)){
			$this->id=set_qcm(set_ams_libelle($this->libelle), $this->questions, $this->reponses, $tab_justes, $theme);
			return $this->id;
		}
		else{
			return false;
		}
	}
	
	/**
	* Fonction qui met a jour le qsrc en base.
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return boolean true si la mise  jour  t effectue, false sinon
	*/
	function updateToDB(&$message) {
		if(Qcm::verifyUpdate(&$message)){
			return maj_question_reponse($this->id, set_ams($this->libelle), $this->type, bool2Sql($this->radio), $this->questions, $this->reponses, $this->justes, $theme);
		}else{
			return false;
		}
	}
	
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_qcm", "theme_qcm"); 
		
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "juste_reponse":
				return Array(true, false);
			default:
				return null;
		}
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	/**
	 * Obtenir l'icone associe aux Qcm.
	 * @return string URL de l'icone.
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type Qcm.
	 * @return string URL de l'icone.
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	/**
	 * Ajouter un identifiant de rponse aux rponses justes.
	 * L'identifiant de rponse doit avoir t prcdement ajout dans le tableau $reponses
	 * et doit tre unique parmis les rponses justes.
	 * @return boolean true si l'ajout  t ffectu, false si la rponse tait dj "juste".
	 */
	function setJuste($reponse){
		if(!in_array($reponse, $this->justes)&&in_array($reponse, $this->reponses)){
			$this->justes[]=$reponse;
			return true;	
		}else{
			return false;
		}
	}

	/**
	 * Affecter l'ensemble des identifiants de rponses spcifis comme rponses justes.
	 * @return boolean true si l'affectation  t ffectu, false si des rponses "justes" taient dj affectes.
	 */	
	function setJustes($reponses){
		if(!is_array($this->justes)&&is_array($reponses)){
			$this->justes=$reponses;
			return true;	
		}else{
			return false;
		}
	}
	
	function isNotable(){
		return true;
	}
}
?>