<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package qcm
 */
class QcmCorrectionAleatoire extends QuestionReponseCorrectionAleatoire{
	
	var $correction;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param object DoQcm $obj_DoQcm 
	 */
	function QcmCorrectionAleatoire($obj_EtapeCorrection, $obj_Qcm){
		messageDebug("QcmCorrection::QcmCorrection($obj_EtapeCorrection, $obj_Qcm)");
		parent::QuestionReponseCorrectionAleatoire($obj_EtapeCorrection, $obj_Qcm);
		$this->nb_questions=1;
		$this->nb_reponses=0;
		$this->initQcmCorrectionAleatoire();
	}
	
	function initQcmCorrectionAleatoire(){
		$res_resultat_stagiaire=get_resultat_serie_aleatoire_question_reponse($this->resultat, $this->obj_Evaluation->getId());
		$nb_resultat_stagiaire=pg_num_rows($res_resultat_stagiaire);
		for($i=0;$i<$nb_resultat_stagiaire; $i++){
			$row=pg_fetch_row($res_resultat_stagiaire);
			$this->correction[$row[2]][$row[3]]["date_creation"]=$row[4];
			$this->correction[$row[2]][$row[3]]["coche"]=$row[5];
			$this->correction[$row[2]][$row[3]]["juste"]=$row[6];
			if($row[2]!=$quest_prec){
				$quest_prec=$row[2];
				$this->nb_reponses=0;
			}
			if($row[3]!=$rep_prec){
				$rep_prec=$row[2];
				$this->nb_reponses++;
			}
		}
	}
	
	function getCorrectionElement($question, $reponse){
		if(!is_array($this->correction[$question][$reponse])){
			die("QcmCorrection::getCorrectionElement($question, $reponse) : Erreur: Param�tres incorrects, il n'y a pas d'�l�ment de correction associ�s.");
		}
		return $this->correction[$question][$reponse];
	}
}
?>
