<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Contient les fonctions spcifiques aux QCM.
	Un QCM est un sous type de question_rponse.
	Il est spcifique dans le fait qu'il assoccie  une question
	et une rponse une proprit qui dit si elle est juste ou non (il y a une solution).
	Les fonctions
    
    @package qcm
    @modulegroup plpgsql
    @module plpgsql_qcm
 */

//include("$chemin_bo/lib/qcm/plpgsql_deprecated_qcm.inc");

/**
    Enregistre une question/reponse de qcm (OLD)
    @deprecated
	@param string : le libelle du qcm
    @param integer : le numro de question
    @param integer : le numro de rponse
    @param bool : true ou false, selon que la reponse soit juste ou fausse
    @param integer : le numero de media question
    @param integer : le numero de mdia rponse
    @param integer : largeur media question
    @param integer : hauteur media question
    @param integer : largeur media rponse
    @param integer : hauteur media rponse
    @param integer : ordre (pour la rponse)
    @return integer : le numero du nouveau qcm 
*/
function set_qcm_deprecated_old($question, $reponse, $val, $qmedia, $rmedia, $qlargeur, $qhauteur, $rlargeur, $rhauteur, $ordre) {
	$sql = "insert into quest_rep (qr_num_question,qr_num_rep,juste,qmedia,rmedia,largeur_qmedia,hauteur_qmedia,largeur_rmedia,hauteur_rmedia,ordre)
			            values($question,$reponse,$val,$qmedia,$rmedia,$qlargeur,$qhauteur,$rlargeur,$rhauteur,$ordre)";
	//echo "sql=$sql<br>";
	
	$ins = pg_query($sql);
	return $ins;
}

/**
    Enregistre une question/reponse de qcm
    et l'enregistre dans la categorie associe
    @deprecated
	@param string : le libelle du qcm
    @param integer : le numro de question
    @param integer : le numro de rponse
    @param bool : true ou false, selon que la reponse soit juste ou fausse
    @param integer : le numero de media question
    @param integer : le numero de mdia rponse
    @param integer : largeur media question
    @param integer : hauteur media question
    @param integer : largeur media rponse
    @param integer : hauteur media rponse
    @param integer : ordre (pour la rponse)
    @return integer : le numero du nouveau qcm 
*/
function set_qcm_deprecated($libelle, $question, $reponse, $val, $qmedia, $rmedia, $qlargeur, $qhauteur, $rlargeur, $rhauteur, $ordre, $theme) {
	global $id_categorie_qcm;
	
	if (VERSION_BASE > VERSION) {
		//creation du qcm
		if ($ordre == 'NULL') {

			$id_qcm = set_evaluation($libelle, 1);
			$res1 = set_question_reponse_deprecated($id_qcm, 1, 'FALSE');
			// enregistre dans theme_categories
			set_categorie_element_theme($id_categorie_qcm, $theme, $id_qcm);
		} 
		else {
			// determine l'existence du qcm avec le numero de question (couple evaluation / question ==> UNIQUE)
			$qcms = get_question_reponse_element_evaluations($question);
			$id_qcm = pg_fetch_result($qcms, 0, 0);
		}

		//enregistre l'association
		$res1b = set_question_reponse_association_element($id_qcm, $question, $reponse, $ordre);

		//enregistre la reponse  la question
		$res2 = set_qcm_solution($id_qcm, $question, $reponse, $val);

		//creation du media pour la question (on ne le fait que pour la premiere reponse)
		if ($qmedia != 'NULL' && $ordre == 'NULL') {
			$res3 = set_question_reponse_element_media($id_qcm, $question, $qmedia, $qhauteur, $qlargeur);
		}
		//creation du media pour la reponse
		if ($rmedia != 'NULL') {
			$res3 = set_question_reponse_element_media($id_qcm, $reponse, $rmedia, $rhauteur, $rlargeur);
		}

		return $id_qcm;
	} else
		$res = set_qcm_deprecated_old($question, $reponse, $val, $qmedia, $rmedia, $qlargeur, $qhauteur, $rlargeur, $rhauteur, $ordre);
	return $res;
}

/**
    Enregistre un qcm.  (OLD)
	@param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @return integer Le numero du nouveau qcm 
*/
function set_qcm_old($questions, $reponses, $justes) {
	 //print_rr($justes);
	// boucle sur le nombre de reponses
	$i=0;
	while(list($cle,$rep)=each($justes)){
		$cle++;
		if(count($justes[$i])==3 && $questions[0]==$justes[$i][0])
			// cas du qrc
			$res=set_qcm_deprecated_old($questions[0],$justes[$i][1],bool2Sql((bool)($justes[$i][2])),'NULL', 'NULL', 'NULL', 'NULL', 'NULL', 'NULL', $cle);
		if(count($justes[$i])==2)
			//cas du qcm
			$res=set_qcm_deprecated_old($questions[0],$justes[$i][0],bool2Sql((bool)($justes[$i][1])),'NULL', 'NULL', 'NULL', 'NULL', 'NULL', 'NULL', $cle);
		//echo "quest[0]=$questions[0] et juste=".$justes[$i][0]."<br>";
		
		$i++;
	}
	return $questions[0];

}


/**
    Enregistre un qcm.
	@param string $libelle Le libelle du qcm
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param array $justes Les identifiants de question
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qcm 
*/
function set_qcm($libelle, $questions, $reponses, $justes, $theme) {
//	echo "set_qcm($libelle, $questions, $reponses, $justes, $theme) <br>";
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql_justes = "'{";
		$i = 0;
		$nb_i = count($justes);
		while ($tab = each($justes)) {
			$sql_justes .= "{" . $tab[1][0] . "," . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$sql_justes .= ",";
			$i++;
		}
		$sql_justes .= "}'";
		$sql = "select * from contraintes.af_set_qcm('$libelle', ".TYPE_EVALUATION_QCM.", 'FALSE', $sql_questions, $sql_reponses, $sql_justes) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
		$num=pg_fetch_result($res,0,0);
		$res2 = set_categorie_element_theme(27,$theme,$num);
		return $num;
	} 
	else{
		//print ("La fonction set_qcm($libelle, $questions, $reponses, $justes, $theme) n'existe pas pour la version " .VERSION);
		$res=set_qcm_old($questions, $reponses, $justes);
		return $questions[0];
		
		}
}

/**
    Supprimer un qcm (OLD)

    @param integer : le numero de question de qcm
    @return bool : t si la suppression a t correctement effectu, f sinon.
*/
function del_qcm_old($question) {
	$sql = "delete from quest_rep where qr_num_question=$question";
	$del = pg_query($sql);
	return $del;
}

/**
    Supprimer un qcm

    @param integer : le numero de question de qcm
    @return bool : t si la suppression a t correctement effectu, f sinon.
*/
function del_qcm($question) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
		$res = del_evaluation($evaluation);
	} else
		$res = del_qcm_old($question);
	return $res;
}

/**
    Supprimer une reponse de qcm d'un qcm. (OLD)
    Ne supprime pas la rponse de la base.

    @param integer : le numero de question de qcm
    @param integer : le numero de la reponse
    @return integer : t si la suppression s'est bien pass, f sinon
*/
function del_qcm_reponse_old($question, $reponse) {
	$sql = "delete from quest_rep where qr_num_rep=$reponse and qr_num_question=$question";
	$del = pg_query($sql);
	if($del)return 't';
	else return 'f';
}

/**
    Supprimer une reponse de qcm d'un qcm.
    Ne supprime pas la rponse de la base.

    @param integer : le numero de question de qcm
    @param integer : le numero de la reponse
    @return integer : t si la suppression s'est bien pass, f sinon
*/
function del_qcm_reponse($question, $reponse) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
		return del_question_reponse_association_element($evaluation, $reponse);
	} else
		$res = del_qcm_reponse_old($question, $reponse);
	return $res;
}

/**
 * Obtenir le numero de la derniere rponses d'un qcm
 * La fonction get_question_reponse_last_element($question_reponse, $reponse) n'existe pas
 * pour l'ancienne version de la base.
 * @see get_question_qcm_last_reponse_old($question).
 * @param integer : le numero de qcm
 * @return integer : le numero du question_reponse_element qui est la derniere reponse
 */
function get_qcm_last_reponse($question_reponse) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_last_reponse($question_reponse);
	} else
		print ("La fonction get_question_reponse_last_element($question_reponse, $reponse) n'existe pas pour la version " .
		VERSION . "<br>Voir: get_question_qcm_last_reponse_old($question).<br>");
}

/**
 * Associe une rponse et sa valeur (juste ou fausse)  une question pour un QCM. (OLD)
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return bool: t si l'action  s'est bien effectue, f sinon
 */
function set_qcm_solution_old($question, $reponse, $juste) {
	//1er cas: il y a deja un enregistrement pour ce couple question/reponse
	$sql1 = "UPDATE quest_rep SET juste='$juste' WHERE qr_num_question=$question AND qr_num_rep=$reponse";
	//echo "sql=$sql1<br>";
	$res = pg_query($sql1);
	if (!$res) {
		//2eme cas: il n'y a pas d'enregistrement pour ce couple question/reponse
		$sql2 = "INSERT INTO quest_rep (qr_num_question, qr_num_rep, juste) VALUES ($question, $reponse, '$juste')";
		//echo "sql=$sql2<br>";
		$res = pg_query($sql2);
	}

	return $res;
}

/**
 * Associe une rponse et sa valeur (juste ou fausse)  une question pour un QCM.
 * @param integer: le numero de qcm
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return bool: t si l'action  s'est bien effectue, f sinon
 */
function set_qcm_solution($qcm, $question, $reponse, $juste) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_set_question_reponse_solution($qcm, $question, $reponse, $juste) ";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return $res;
	} else {
		$res = set_qcm_solution_old($question, $reponse, $juste);
	}
	return pg_fetch_result($res, 0, 0);
}

/**
 * Obtenir les rponses d'un QCM et savoir si elles sont justes ou fausses
 * La fonction get_qcm_solutions($qcm) n'existe pas
 * pour l'ancienne version de la base.
 * @see get_question_qcm_solution($question, $reponse).
 * @param integer: le numero de qcm
 * @return integer :(question_reponse int4, question int4,reponse int4 ,juste bool )
 */
function get_qcm_solutions($qcm) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse_solutions($qcm) AS (question_reponse int4, question int4,reponse int4 ,juste bool ) ";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return $res;
	} else
		print ("La fonction get_qcm_solutions($qcm) n'existe pas pour la version " .
		VERSION . "<br>Voir: get_question_qcm_solution($question, $reponse) .<br>");
}

/**
 * obtenir les rponses  un qcm.
 * @param integer: numero de qcm
 * @return integer: question_reponse int4, question int4, reponse int4, pere int4
 */
function get_qcm_reponses_old($qcm) {
	echo "get_qcm_reponses_old  imlmenter";
}

/**
 * obtenir les rponses  un qcm.
 * @param integer: numero de qcm
 * @return integer: question_reponse int4, question int4, reponse int4, pere int4
 */
function get_qcm_reponses($qcm) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_association_elements($qcm);
	} else {
		return get_qcm_reponses_old($qcm);
	}
}
/**
 * Obtenir une rponse   un QCM et savoir si elle est juste ou fausse
 * La fonction get_qcm_solution($qcm, $reponse)  n'existe pas
 * pour l'ancienne version de la base.
 * @see get_question_qcm_solution($question, $reponse).
 * @param integer: le numero de qcm
 * @param integer: le numero de reponse
 * @return integer :(question_reponse int4, question int4,reponse int4 ,juste bool )
 */
function get_qcm_solution($qcm, $reponse) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse_solution($qcm, $reponse) AS (question_reponse int4, question int4,reponse int4 ,juste bool ) ";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return $res;
	} else
		print ("La fonction get_qcm_solution($qcm, $reponse)  n'existe pas pour la version " .
		VERSION . "<br>Voir: get_question_qcm_solution($question, $reponse) .<br>");
}

/**
 * Mettre a jour une rponse   un QCM et dire si elle est juste ou fausse (OLD)
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return bool: t si la mise a jour  s'est bien effectue, f sinon
 */
function maj_qcm_solution_old($question, $reponse, $juste) {
	$sql = "UPDATE quest_rep SET juste='$juste' WHERE qr_num_question=$question AND qr_num_rep=$reponse; ";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
 * Mettre a jour une rponse   un QCM et dire si elle est juste ou fausse
 * @param integer: le numero de qcm
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return bool: t si la mise a jour  s'est bien effectue, f sinon
 */
function maj_qcm_solution($qcm, $question, $reponse, $juste) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_maj_question_reponse_solution($qcm, $question, $reponse, '$juste') ";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return $res;
	} else {
		$res = maj_qcm_solution_old($question, $reponse, $juste);
	}

	return pg_fetch_result($res, 0, 0);
}

/**
    Obtenir les infos d'une question de qcm

    @param integer : le numro du qcm
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_qcm_question($qcm) {
	if (VERSION_BASE > VERSION) {
		$questions = get_question_reponse_questions($qcm);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($questions) > 1)
			print ("Erreur: Un qcm utilise plusieurs questions, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$question = pg_fetch_result($questions, 0, 0);
		$res = get_question_qcm($question);
	} else
		$res = get_question_qcm($qcm);
	return $res;
}


/**
    obtenir les infos des rponses  un qcm.

    @param integer : le numro du qcm
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_qcm_reponses_infos($qcm) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_elements_infos($qcm, 1, 'TRUE');
	} else{
		//ce n'est pas un numero de qcm mais un numero de question, on 
		//appelle donc cette fonction pour la old:
		return get_question_qcm_reponses_infos_old($qcm);
	}
		
}

/**
* Obtenir le mdia d'une question de QCM
* @param integer: un numro de qcm
* @return integer: le resultat de la requete :(question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
*/
function get_qcm_question_media($qcm) {
	if (VERSION_BASE > VERSION) {
		$questions = get_question_reponse_questions($qcm);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($questions) > 1)
			print ("Erreur: Un qcm utilise plusieurs questions, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$question = pg_fetch_result($questions, 0, 0);
		return get_question_qcm_media($question);
	} else
		print ("La fonction  get_qcm_question_media($qcm)   n'existe pas pour la version " .
		VERSION);
}

/**  
 * Obtenir les informations d'un QCM
 * @param integer: un numro de qcm
 * @return integer: le resultat de la requete :(id int4, libelle varchar, type int4, date_creation timestamp, radio bool)
 */
function get_qcm($qcm){
	if (VERSION_BASE > VERSION) {
		return get_question_reponse($qcm);
	} else {
		print ("La fonction  get_qcm($qcm)   n'existe pas pour la version " .
		VERSION);
	}
}
?>