<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Qrc.
 *	Un Qrc est un objet driv de Qsrc. 
 *	Il correspond  l'association de plusieurs Questions et de plusieurs Choix.
 *
 *	@package qrc
 */
class Qrc extends Qsrc{

	/**
	* @var array Identifiants des rponses justes. 
	*/		
	var $justes;		

	/**
	 * Construit un Qrc.
	 * Le Qrc peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Qrc
	 * @param string $libelle Libell
	 * @param integer $type_qsrc Type de Qsrc
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio true, affiche le Qrc sous forme de radio, false sous la forme de checkbox
	 * @param string $question_commune indique si le Qrc doit tre affich sous forme de radio(true) ou de checkbox(false)
	 * @param integer $bareme identifiant du Bareme
	 * @param integer $chrono Chrono, en secondes
	 * @param integer $media identifiant du Mdia
	 * @param integer $chrono_gen Chrono total, en secondes
	 */		
	function Qrc($id=null, $libelle="QRC", $type_qsrc=0, $date_creation=null, $radio=false, $question_commune="", $bareme = 0, $chrono = 0, $media = 0, $chrono_gen = 0){
		messageDebug("Qrc::Qrc($id, $libelle, $type_qsrc,$date_creation, $radio, $question_commune, $bareme , $chrono , $media, $chrono_gen)");
	
		if($id==0){
			parent::Qsrc(0, $libelle, TYPE_EVALUATION_QRC, $date_creation);
			$this->radio=(bool)$radio;
			$this->question_commune=$question_commune;
			return;
		}elseif(func_num_args()==1){
			
			$res_evaluation = get_qrc($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[4];
			$question_commune=$row_evaluation[2];
			$radio=sql2Bool($row_evaluation[5]);
			
		}else{
			$res_evaluation = get_qrc($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
//			echo "QCM nb param:".func_num_args()."<br>";
			
		}
		parent::Qsrc($id, $libelle, TYPE_EVALUATION_QRC, $date_creation,$radio);
		$this->initQrc($question_commune);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initialise les attributs propres au Qrc.
	 * @param string $question_commune Question commune
	 */		
	function initQrc($question_commune){
		return parent::initQsrc($question_commune);
	}

	/**
	 * Initalise les attributs de type Objets.
	 */
	function loadObjects(){
		parent::loadObjects();
		$res=get_question_reponse_solutions($this->id);
		while($row=pg_fetch_row($res)){
			if(sql2Bool($row[3]))$this->justes[$row[1]][]=$row[2];
		}
	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=$this->verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Le champ radio doit tre  'f' et le type  TYPE_EVALUATION_QRC.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;			
		if($this->type!=TYPE_EVALUATION_QRC){
			$message.="[type]";
			$attributs_ok=false;
		}
		return $attributs_ok;
	}
	
//	/**
//	* Fonction qui insre le Qrc en base.
//	* Affecte l'identifiant du Qrc.
//	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Qrc
//	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
//	* @return integer Identifiant du qrc cr ou false
//	*/
//	function insertToDB($theme,&$message,$no_verify=false) {
//		
//		//vrifie la prsence du theme
//		if(empty($theme)){
//			die("Erreur Qrc::insertToDB($theme, &$message=\"\"): Le thme est manquant.");
//		}
//	
//		//transforme $this->justes vers le format attendu ( tableau contenant tous les couples rponse/boolen)
//		$tab_justes=Array();
//		foreach($this->questions as $keyQ => $id_question){
//		foreach($this->reponses as $keyR => $id_reponse){
//			if(in_array($id_reponse,$this->justes[$id_question] )){
//				$tab_justes[]=Array($id_question,$id_reponse, 1 );
//			}
//			else{
//				$tab_justes[]=Array($id_question,$id_reponse, 0 );
//			}
//		}
//		}
//	
//		//vrification donnes et insertion
//		if($no_verify||Qrc::verifyInsert(&$message)){
//			$this->id=set_qrc(addslashes($this->libelle), $this->type,  addslashes($this->question_commune),$this->questions, $this->reponses,bool2Sql((bool)$this->radio),$tab_justes,$theme);
//			return $this->id;
//		}
//		else{
//			return false;
//		}
//	}	
	
	/**
	* Fonction qui insre le Qrc en base.
	* Affecte l'identifiant du Qrc.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Qrc
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du qrc cr ou false
	*/
	function insertToDB($theme,&$message,$no_verify=false) {
		//vrifie la prsence du theme
		if(empty($theme)){
			die("Erreur Qrc::insertToDB($theme, &$message=\"\"): Le thme est manquant.");
		}
		$tab_justes=Array();
		$questions=Array();
		$reponses=Array();
		foreach($this->obj_questions as $keyQ => $obj_question){
			
			//transforme $this->obj_questions vers le format attendu ( tableau contenant les identifiants des questions)
			if(!in_array($obj_question->getId(),$questions))$questions[]=$obj_question->getId();
			
			foreach($this->obj_reponses as $keyR => $obj_reponse){
				
				//transforme $this->obj_reponses vers le format attendu ( tableau contenant les identifiants des reponses)
				if(!in_array($obj_reponse->getId(),$reponses))$reponses[]=$obj_reponse->getId();				
				
				//transforme $this->justes vers le format attendu ( tableau contenant tous les couples rponse/boolen)
				if(is_array($this->justes[$obj_question->getId()])&&in_array($obj_reponse->getId(),$this->justes[$obj_question->getId()] )){
					$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(), 1 );
				}
				else{
					$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(),  0 );
				}
			}
		}
	
		//vrification donnes et insertion
		if($no_verify||Qrc::verifyInsert(&$message)){
			$this->id=set_qrc(set_ams_libelle($this->libelle), $this->type,  set_ams_libelle(nl2br2($this->question_commune)),$questions, $reponses,bool2Sql((bool)$this->radio),$tab_justes,$theme);
			return $this->id;
		}
		else{
			return false;
		}
	}		
	/**
	* Fonction qui insre le Qrc en base.
	* Affecte l'identifiant du Qrc.
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Qrc cr ou false
	*/
	function updateToDB(&$message,$no_verify=false) {
		
		//vrification donnes et insertion
		if($no_verify||Qrc::verifyUpdate(&$message)){
			
			$tab_justes=Array();
			$questions=Array();
			$reponses=Array();
			foreach($this->obj_questions as $keyQ => $obj_question){
				//transforme $this->obj_questions vers le format attendu ( tableau contenant les identifiants des questions)
				if(!in_array($obj_question->getId(),$questions))$questions[]=$obj_question->getId();
				
				foreach($this->obj_reponses as $keyR => $obj_reponse){
					
					//transforme $this->obj_reponses vers le format attendu ( tableau contenant les identifiants des reponses)
					if(!in_array($obj_reponse->getId(),$reponses))$reponses[]=$obj_reponse->getId();				
					
					//transforme $this->justes vers le format attendu ( tableau contenant tous les couples rponse/boolen)
					if(is_array($this->justes[$obj_question->getId()])&&in_array($obj_reponse->getId(),$this->justes[$obj_question->getId()] )){
						$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(), 1 );
					}
					else{
						$tab_justes[]=Array($obj_question->getId(),$obj_reponse->getId(),  0 );
					}
				}
			}
//			print_rr($questions);
//			print_rr($reponses);
//			print_rr($tab_justes);
		
			$ok=maj_qrc($this->id,set_ams_libelle($this->libelle), set_ams_libelle(nl2br2($this->question_commune)),$questions, $reponses,$tab_justes,bool2Sql((bool)$this->radio));
			return $ok;
		}
		else{
			return false;
		}
	}
	
	/**
	 * Ajouter un identifiant de rponse aux rponses justes.
	 * L'identifiant de rponse doit avoir t prcdement ajout dans le tableau $reponses
	 * et doit tre unique parmis les rponses justes.
	 * @return boolean true si l'ajout  t ffectu, false si la rponse tait dj "juste".
	 */
	function &setJuste($question,$reponse){
		$trouve=false;
		//if(in_array($reponse, $this->reponses)&&in_array($question,$this->questions)){
			if(is_array($this->justes[$question])){
				foreach($this->justes[$question] as $indice =>$id_reponse){
					if($id_reponse==$reponse){
						$trouve=true;
					}
				}
			}
			if(!$trouve){
				$this->justes[$question][]=$reponse;
				return true;
			}
			else{
				echo "trouve $question,$reponse <br>";			
				 return false;
			}
					
//		}else{
//			return false;
//		}
	}
	
	function isJuste($question,$reponse){
		
		if(is_array($this->justes[$question])&&in_array($reponse,$this->justes[$question]))return true;
		else return false; 
	}
	
	function setNotJuste($question,$reponse){
		if(is_array($this->justes[$question])&&in_array($reponse,$this->justes[$question])){
			$ind=array_keys($this->justes[$question],$reponse);			
			unset($this->justes[$question][$ind[0]]);
			return true;	
		}
		else return false; 
	}
	
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_qrc", "theme_qrc","libelle_question_commune", "radio"); 
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "radio":
				return Array(true, false);
//			case "interpretationHTML_question":
//				return Array(true, false);	
//			case "interpretationHTML_reponse":
//				return Array(true, false);	
			default:
				return null;
		}
	}	
		
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	/**
	 * Obtenir l'icone associe aux Qcm.
	 * @return string URL de l'icone.
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type Qcm.
	 * @return string URL de l'icone.
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	function isNotable(){
		return true;
	}
	
	
}
?>