<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Feb 19, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

class QrcCorrection extends QsrcCorrection{
	
	var $correction;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param object DoQrc $obj_DoQrc 
	 */
	function QrcCorrection($obj_EtapeCorrection, $obj_DoQrc){
		messageDebug("QrcCorrection::QrcCorrection($obj_EtapeCorrection, $obj_DoQrc)");
		parent::QsrcCorrection($obj_EtapeCorrection, $obj_DoQrc);
		$this->nb_questions=0;
		$this->nb_reponses=0;
		if(!empty($this->resultat))$this->initQrcCorrection();
	}
	
	function initQrcCorrection(){
		$res_resultat_stagiaire=get_resultat_serie_question_reponse($this->resultat, $this->obj_Evaluation->getId());
		if($res_resultat_stagiaire)$nb_resultat_stagiaire=pg_num_rows($res_resultat_stagiaire);
		for($i=0;$i<$nb_resultat_stagiaire; $i++){
			$row=pg_fetch_row($res_resultat_stagiaire);
			$this->correction[$row[2]][$row[3]]["date_creation"]=$row[4];
			$this->correction[$row[2]][$row[3]]["coche"]=$row[5];
			$this->correction[$row[2]][$row[3]]["juste"]=$row[6];
			if($row[2]!=$quest_prec){
				$quest_prec=$row[2];
				$this->nb_questions++;
				$this->nb_reponses=0;
			}
			if($row[3]!=$rep_prec){
				$rep_prec=$row[2];
				$this->nb_reponses++;
			}
		}
		//print_rr($this->correction);
		
	}
	
	function getCorrectionElement( $question,$reponse){
		//echo "getCorrectionElement($reponse, $question)<br>";
		//print_rr($this->correction);
		
		if(!is_array($this->correction[$question][$reponse])){
			//die("QrcCorrection::getCorrectionElement($question, $reponse) : Erreur: Paramtres incorrects, il n'y a pas d'lment de correction associs.");
		}
		
		return $this->correction[$question][$reponse];

	}


}
?>
