<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * 
 * @package qrc
 * @modulegroup plpgsql
 * @module plpgsql_qrc
 */

/**
 * Obtenir les informations concernant un qrc.
 * 
 * @param integer le numro du qrc
 * @return integer le resultat de la requete : (id int4, libelle varchar,  question_commune varchar, type int4, date_creation timestamp, is_radio bool)
 */
function get_qrc_old($qrc){
	$sql = "select id, titre, question_commune,type_test, NULL,CASE WHEN type_reponse LIKE 'r' THEN TRUE ELSE FALSE END from serie_exo,test where id=id_test and id=$qrc and type_test='m'";
	//echo "$sql<br>";
	return pg_query($sql);
}
 
/**
 * Obtenir les informations concernant un qrc.
 * 
 * @param integer le numro du qrc
 * @return integer le resultat de la requete : (id int4, libelle varchar,  question_commune varchar, type int4, date_creation timestamp, is_radio bool)
 */
function get_qrc($qrc){
	if (VERSION_BASE > VERSION) {
		return get_qsrc($qrc);
	} else {
		return get_qrc_old($qrc);
	}	
}

/**
 * Affecter la solution qu'une question et de plusieurs choix d'un QRC.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * La question et le choix doivent avoir t prcedement associe au positionnement.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function set_qrc_question_solution($qrc, $question, $tab_solutions) {
	if (VERSION_BASE > VERSION) {

		$chaine = "'{";
		$i = 0;
		$nb_i = count($tab_solutions);
		while ($tab = each($tab_solutions)) {
			$chaine .= "{" . $tab[1][0] . "," . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$chaine .= ",";
			$i++;
		}
		$chaine .= "}'";
		$sql = "SELECT * FROM contraintes.af_set_qrc_question_solution($qrc,$question,$chaine) ";
		return pg_query($sql);
	} else
		return set_qsrc_question_solution_old($qrc, $question, $tab_solutions);
}


/**
 * Obtenir la solution qu'une question et d'un choix d'un positionnement. (OLD)
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * Valable uniquement pour des questions de positionnement de type QCM.
 * 
 * @param integer : le numero de positionnement
 * @param integer : le numero de question
 * @param integer : le numero du choix
 * @return integer : l'entier resultat :(question_reponse int4, question int4, reponse int4, juste bool)
 */
function get_qrc_question_solution_old($positionnnement, $question, $choix) {
	$sql = "SELECT qr_num_question, qr_num_question, qr_num_rep, juste from quest_rep where qr_num_question=$question and qr_num_rep=$choix ";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir la solution qu'une question et d'un choix d'un qrc.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * 
 * @param integer : le numero de qrc
 * @param integer : le numero de question
 * @param integer : le numero du choix
 * @return integer : l'entier resultat :(qrc int4, question int4, reponse int4, juste bool)
 */
function get_qrc_question_solution($qrc, $question, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_qrc_question_solution($qrc,$question,$choix) AS (qrc int4, question int4, reponse int4, juste bool)";
//		echo "$sql<br>";
		return pg_query($sql);
	} else
		return get_qrc_question_solution($qrc, $question, $choix);
}

/**
 * Mettre a jour la solution d'une question et de plusieurs choix d'un qrc. (OLD)
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * La question et le choix doivent avoir t prcedement associe au qrc.
 * 
 * @param integer : le numero de qrc
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function maj_qrc_question_solution_old($qrc, $question, $tab_solutions) {
	$i = 0;
	$nb_i = count($tab_solutions);
	while ($tab = each($tab_solutions)) {
		$juste=$tab[1][1];
		if($juste=="1")$juste='TRUE';
		else $juste='FALSE';
		$sql="UPDATE quest_rep SET juste=".$juste." WHERE qr_num_question =$question AND qr_num_rep=".$tab[1][0];
		//echo $sql."<br>";
		$res=pg_query($sql);
		if(pg_affected_rows($res)>0){
			$i++;	
		}
		
	}
	if($i==$nb_i){
		return true;
	}
}
/**
 * Mettre a jour la solution d'une question et de plusieurs choix d'un qrc.
 * La solution indique si le choix pour la rponse donne lieu  un rsultat juste ou faux.
 * La question et le choix doivent avoir t prcedement associe au qrc.
 * 
 * @param integer : le numero de qrc
 * @param integer : le numero de question
 * @param array : tableau contenant le numero du choix et 1 ou 0 selon que la solution soit juste ou fausse
 * @return bool : TRUE ou FALSE selon que l'affectation se soit bien passe ou non
 */
function maj_qrc_question_solution($qrc, $question, $tab_solutions) {
	if (VERSION_BASE > VERSION) {
		$chaine = "'{";
		$i = 0;
		$nb_i = count($tab_solutions);
		while ($tab = each($tab_solutions)) {
			$chaine .= " {" . $tab[1][0] . ", " . $tab[1][1] . "}";
			if ($i < $nb_i -1)
				$chaine .= ",";
			$i++;
		}
		$chaine .= "}'";
		$sql = "SELECT * FROM contraintes.af_maj_qrc_question_solution($qrc,$question,$chaine) ";
		//echo "$sql<br>";
		return pg_fetch_result(pg_query($sql), 0, 0);
	} else
		$res = maj_qrc_question_solution_old($qrc, $question, $tab_solutions);
	return $res;
}

/**
    Enregistre un qrc. (OLD)
	@param string $libelle Le libelle du qrc
	@param integer $type
	@param string $question_commune
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
	@param bool radio ou checkbox
    @param array $justes 
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qrc 
*/
function set_qrc_old($libelle, $type,$question_commune,$questions, $reponses, $radio,$justes, $theme) {
	// insertion dans serie_exo
	$id_qrc=set_serie_old($libelle,$theme,'NULL',-1,0);
	// insertion dans test
	if($radio)
		$type_reponse='r';
	else
		$type_reponse='c';
	$sql="insert into test (id_test, type_test, media_test, longueur_media, largeur_media,chrono,type_reponse,question_commune)
			VALUES ($id_qrc,'".get_evaluation_type_new_old_r($type)."',NULL,NULL,NULL, -1,'$type_reponse','$question_commune')";
//	echo "sql=$sql<br>";
	$ins = pg_query($sql) ;
	// association qrc reponses  et insertion ds test_rep_nbexogen
	while(list($cle,$rep)=each($reponses)){
		$cle++;
		$sql="insert into asso_test_reponse (id_test, id_reponse, niveau, ordre, num_bareme, media_reponse, longueur_media, largeur_media)
				VALUES ($id_qrc,$rep,0,$cle,0,NULL,NULL,NULL)" ;
		$ins=pg_query($sql) ;
		$sql="insert into test_rep_nbexogen(id_test,id_reponse,type_exercice,nb_a_generer,taille_chapeau)
				values($id_qrc,$rep,'q',0,0)";
		$ins=pg_query($sql);
		$sql="insert into test_rep_nbexogen(id_test,id_reponse,type_exercice,nb_a_generer,taille_chapeau)
		values($id_qrc,$rep,'f',0,0)";
		$ins=pg_query($sql);
	}
	// insertion dans quest_rep et asso_exo_serie
	while(list($cle,$quest)=each($questions)){
		$tab_question[0]=$quest;
		$res=set_qcm_old($tab_question,$reponses,$justes);
		$ordre=$cle + 1;
		$sql="insert into asso_exo_serie (id_serie, id_exo, type_exo, ordre, point, bareme, chrono, commentaire)
				VALUES ($id_qrc, $quest, '".get_evaluation_type_new_old_r($type)."', $ordre, 1, 0,0,'')" ;
		pg_query($sql) ;				
	}
	return $id_qrc;
	

}

/**
    Enregistre un qrc.
	@param string $libelle Le libelle du qrc
	@param integer $type
	@param string $question_commune
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
	@param bool radio ou checkbox
    @param array $justes 
    @param integer $theme Identifiant du theme
    @return integer Le numero du nouveau qrc 
*/
function set_qrc($libelle, $type,$question_commune,$questions, $reponses, $radio,$justes, $theme) {
//	echo "set_qrc($libelle, $type,$question_commune,$questions, $reponses, $radio,$justes, $theme) <br>";
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql_justes = "'{";
		$i = 0;
		$nb_i = count($justes);
		while ($tab = each($justes)) {
			$sql_justes .= "{". $tab[1][0] . ","  . $tab[1][1] . "," . $tab[1][2] . "}";
			if ($i < $nb_i -1)
				$sql_justes .= ",";
			$i++;
		}
		$sql_justes .= "}'";
		$sql = "select * from contraintes.af_set_qrc('$libelle', ".TYPE_EVALUATION_QRC.", '$question_commune', $sql_questions, $sql_reponses, $radio,$sql_justes) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
		
		$num=pg_fetch_result($res,0,0);
		if($num){
			$res2 = set_categorie_element_theme(23,$theme,$num);
			return $num;
		}
		else
			return null;
	} 
	else {
			/*
		print ("La fonction set_qrc($libelle, $type,$question_commune,$questions, $reponses, $radio,$justes, $theme) n'existe pas pour la version " .
		VERSION);
			*/
		return set_qrc_old($libelle, $type,$question_commune,$questions, $reponses, $radio,$justes, $theme); 
		}
}
/**
    Mise  jour d'un qrc.
    
    @param integer $src Identifiant du qrc
	@param string $libelle Le libelle du qrc
	@param string $libelle Question commune du qrc
    @param array $questions Les identifiants de question
    @param array $reponses Les identifiants de question
    @param boolean $radio Radio ou checkbox
    @return boolean Le rsultat de la fonction
*/
function maj_qrc($qrc,$libelle,  $question_commune, $questions, $reponses,$justes,$radio) {
	
	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql_justes = "'{";
		$i = 0;
		$nb_i = count($justes);
		while ($tab = each($justes)) {
			$sql_justes .= "{". $tab[1][0] . ","  . $tab[1][1] . "," . $tab[1][2] . "}";
			if ($i < $nb_i -1)
				$sql_justes .= ",";
			$i++;
		}
		$sql_justes .= "}'";		
		$sql = "select * from contraintes.af_maj_qrc($qrc,'$libelle', '$question_commune', $radio, $sql_questions, $sql_reponses ,$sql_justes) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res,0,0)=='t';
	} else
		print ("La fonctionmaj_qrc($qrc,$libelle,  $question_commune, $questions, $reponses,$justes,$radio) n'existe pas pour la version " .
		VERSION);
}
?>
