<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoQsrc.
 * Un DoQsrc est l'objet servant  gerer l'avancement des
 * Qsrc, type d'Evaluation incluant les SRC et QRC.
 * 
 * @package qsrc
 */
class DoQsrc extends DoEvaluation{

	/**
	 * Constucteur.
	 * Affecte les attributs de la classe  
	 * partir des paramtres.
	 * 
	 * @param integer $resultat Identifiant du rsultat d'avancement.
	 * @param integer $evaluation Identifiant de l'Evaluation concerne par l'avancement.
	 * @param integer $type Identifiant du type de de l'Evaluation concerne par l'avancement.
	 * @param integer $indice Indice de l'valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory La fabrique d'objet Evaluation.
	 */
	function DoQsrc($resultat,$evaluation,$type,$indice,&$obj_EvaluationFactory){
		parent::DoEvaluation($resultat,$evaluation,$type,$indice,$obj_EvaluationFactory);
	}
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	/**
	 * Termine le Qsrc
	 * Enregistre la date de fin de l'valuation et detruit les attributs de l'objet inutiles.
	 * @param object ResultatQsrc $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean true ou false suivant le succs ou non de la mthode.
	 */		
	function end($obj_resultat){
		messageDebug("DoQsrc::end($obj_resultat)");
		$fin_parent=parent::end($obj_resultat);
		$fin=set_resultat_serie_qsrc($this->getResultat(), $this->node,$obj_resultat->questions,$obj_resultat->reponses,$obj_resultat->valeurs);
		if(!$fin){
			die("Erreur DoQsrc::end(): L'valuation n'a pas t termine. ()<br>");
			return false;
		}
		return $fin &&$fin_parent;
	}
	
	/**
	 * Obtenir le Qsrc associ  l'objet d'avancement
	 * @return object Qsrc  Le Qsrc
	 */	
	function &getQsrc(){
		return parent::getObjEvaluation();
	}
	
	/**
	 * Traitement des donnes du formulaire soumis par le Stagiaire.
	 * @param array $valeurs_soumises Le $HTTP_POST_VARS du fomulaire
	 */
	function validerFormulaire($valeurs_soumises){
		$cle_nom="choixreponse";
		$src_nom="reponse";
		
		$choix_valides=array();
		while(list($cle,$val)=each($valeurs_soumises)){
			//enregistre une rponse saisie
	        if(substr($cle, 0, strlen($cle_nom))==$cle_nom){
				$v=substr($cle, strlen($cle_nom)+1, strlen($cle));
//				echo "pour question= $v-> rponse=$val coche<br>";
				$this->obj_resultat->init($v,$val, 1);
				$choix_valides[]=$v."_".$val;
	        }
	        //enregistre une rponse non saisie
	        else{
	        	$v=substr($cle, strlen($src_nom)+1, strlen($cle));
				$v_tmp=explode("_",$v);
				$v=$v_tmp[1];
		        if((substr($cle, 0, strlen($src_nom))==$src_nom) && !in_array($val."_".$v,$choix_valides)){
//		        	echo "pour question= $v-> rponse=$val pas coche<br>";
					$this->obj_resultat->init($val,$v, 0);
					$choix_valides[]=$val."_".$v;
		        }
	        }
	    }
	}
}
?>
