<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Qsrc.
 *	Un Qsrc est un objet driv de Evaluation. 
 *	Il correspond  l'association de plusieurs Questions et de plusieurs Choix.
 *
 *	@package src
 */
class Qsrc extends QuestionReponse{
	

	/**
	 * @var string La question commune
	 */	
	var $question_commune;
	
	/**
	 * Construit un Qsrc.
	 * Le Qsrc peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Qsrc
	 * @param string $libelle Libell du Qsrc
	 * @param integer $type Identifiant du type de Qsrc
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio true, affiche le Qrc sous forme de radio, false sous la forme de checkbox
	 * @param string $question_commune indique si le Qrc doit tre affich sous forme de radio(true) ou de checkbox(false)
	 */		
	function Qsrc($id=0, $libelle="QSRC", $type=0, $date_creation="", $radio=false, $question_commune=""){
		if(func_num_args()==1){
			$res_evaluation = get_qsrc($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[4];
			$type=$row_evaluation[3];
		}else{
		}
		parent::QuestionReponse($id, $libelle, $type, $date_creation,$radio);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initialise les attributs propres au Qsrc.
	 * @param string $question_commune Question commune
	 */		
	function initQsrc($question_commune){
		messageDebug("Qsrc::initQsrc($question_commune)");
		if(!empty($question_commune)){
			$this->question_commune=$question_commune;
		}else{
			die("Erreur initQsrc($positionnement,$question_commune): L'objet ne peut etre initialis.");
		}	
	}

	/**
	 * Enregistre en base de donnes les mdias du Qsrc.
	 * Le Qsrc doit lui mme avoir t insr en base auparavant.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return bool Boolen indiquant si une erreur c'est produite(false) ou non(true). 
	 */
	function insertMediaToDb(&$message){
		$ok=true;
		if(empty($this->id)){
			die("Qsrc::insertMediaToDb(&$message): Insertion du mdia en base impossible, le Qsrc ne possde pas d'identifiant.");
		}
		//cration des mdias des questions et des rponses
		foreach($this->obj_questions as $i => $question){
			$media=$question->getMedia();
			if(is_object($media)){
				$media->setQuestionReponse($this->id);
				$tr_media=$media->insertToDB($message);	
				if(!$tr_media)$ok=false;
			}
		}
		foreach($this->obj_reponses as $i => $reponse){
			$media=$reponse->getMedia();
			if(is_object($media)){
				$media->setQuestionReponse($this->id);
				$tr_media=$media->insertToDB($message);	
				if(!$tr_media)$ok=false;
			}
		}
		return $ok;
	}
	
	/**
	 * Met  jour en base de donnes les mdias du Qsrc.
	 * Le Qsrc doit lui mme avoir t mis  jour et/ou insr en base auparavant.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return bool Boolen indiquant si une erreur c'est produite(false) ou non(true). 
	 */
	function updateMediaToDB(&$message){
		$ok=true;
		if(empty($this->id)){
			die("Qsrc::updateMediaToDB(&$message): Mise  jour du mdia en base impossible, le Qsrc ne possde pas d'identifiant.");
		}
		//mise  jour des mdias des questions et des rponses
		foreach($this->obj_questions as $i => $question){
			$media=$question->getMedia();
			if(is_object($media)){
				$media->setQuestionReponse($this->id);
				$tr_media=$media->updateToDB($message);	
				if(!$tr_media)$ok=false;
			}else{
				//il faut supprimer l'ventuel mdia prcdent.				
				del_question_reponse_element_media($this->id,$question->getId());
			}
		}
		foreach($this->obj_reponses as $i => $reponse){
			$media=$reponse->getMedia();
			if(is_object($media)){
				$media->setQuestionReponse($this->id);
				$tr_media=$media->updateToDB($message);	
				if(!$tr_media)$ok=false;
			}else{
				//il faut supprimer l'ventuel mdia prcdent.				
				del_question_reponse_element_media($this->id,$reponse->getId());
			}
		}
		return $ok;
	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert(&$message);
		$verif=Qsrc::verify(&$message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * De plus, vrifie que l'attribut question_reponse est bien valu.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		$res_parent=parent::verifyUpdate(&$message);
		$verif=Qsrc::verify(&$message);
		
		return $res_parent && $verif ;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * La question commune doit tre non vide.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;	
		if(empty($this->question_commune)){
			$message.="[question_commune]";
			$attributs_ok=false;
		}
		
		return $attributs_ok;
	}


	/**
	* Fonction qui insre le qsrc en base.
	* Affecte l'identifiant du Qsrc
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Qsrc
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du qsrc cr ou false
	*/
	function insertToDB($theme,&$message,$no_verify=false) {
		die("QSrc::insertToDB($theme,&$message,$no_verify=false) Erreur: La mthode doit tre surcharge.");
	}
	
	/**
	* Fonction qui met a jour le qsrc en base.
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return boolean true si la mise  jour  t effectue, false sinon
	*/
	function updateToDB(&$message,$no_verify=false) {
		die("QSrc::updateToDB(&$message,$no_verify) Erreur: La mthode doit tre surcharge.");
//		if($no_verify||Qsrc::verifyUpdate(&$message)){
//			return maj_qsrc($this->id,addslashes($this->libelle), addslashes($this->question_commune), bool2Sql($this->radio))
//				&& $this->updateMediaToDB($message);
//		}
//		else{
//			return false;
//		}
	}
	
//	/**
//	 * Modifier un Choix
//	 * @param integer $id_choix Identifiant du Choix  remplacer.
//	 * @param integer $new_id_choix Identifiant du nouveau Choix.
//	 * @param integer $bareme Identifiant du nouveau Bareme.
//	 * @param object Media $media Nouveau Media pour le Choix.
//	 * @return boolean true si la mise  jour  t effectue, false sinon
//	 */
//	function modifChoix($id_choix, $new_id_choix, $bareme, $media){
//	
//		if ($this->id && $new_id_choix) {
//			
//			if (empty($media)||$media->getId() == null)
//				$id_media = 'NULL';
//			else
//				$id_media = $media->getId();
//			if (empty($media)||$media->getHauteur() == null)
//				$longueur_media = 'NULL';
//			else
//				$longueur_media = $media->getHauteur();
//			if (empty($media)||$media->getLargeur() == null)
//				$largeur_media = 'NULL';
//			else
//				$largeur_media = $media->getLargeur();
//				
//			if (empty ($bareme))
//				$bareme = 'NULL';
//
//			$res=maj_question_reponse_choix($this->id, $id_choix, $new_id_choix, $bareme, $id_media, $longueur_media, $largeur_media);
//			if (!empty ($tabExosGen)) {
//
//				//mise a jour des nombres d'evaluation a generer.
//				maj_question_reponse_nb_evaluations_a_generer($this->id, $id_choix, $tabExosGen);
//			}
//			return true;
//		} else{
//			echo "Erreur paramtres modifChoix()<br>";
//			return false;
//		}
//			
//	}
//
//	/**
//	 * Ajouter un Choix
//	 * @param integer $choix Identifiant du Choix  ajouter.
//	 * @param integer $bareme Identifiant du nouveau Bareme.
//	 * @param array $tabExosGen Evaluations  gnrer
//	 * @param object Media $media Nouveau Media pour le Choix.
//	 * @return boolean true si la mise  jour  t effectue, false sinon
//	 */
//	function ajoutChoix($choix,  $bareme, $tabExosGen, $media){
//		messageDebug("Qsrc::ajoutChoix($choix,  $bareme, $tabExosGen, $media)");
//		//return $this->obj_positionnement->ajoutChoix($id_rep, $bareme, $nbExos, $mon_media);
//		if (!empty ($this->id) && !empty ($choix)) {
//
//			// On determine l'ordre du nouveau choix
//			$ordre = get_qsrc_last_reponse($this->id);
//			
//			//formatage des donnes
//			if (empty ($ordre)) {
//				$ordre = 'NULL';
//			}
//			
//			if(!empty($media)){
//				$idmedia = $media->getId();
//				if (empty ($idmedia))
//					$idmedia = 'NULL';
//					
//				$hauteur = $media->getHauteur();
//				if (empty ($hauteur))
//					$hauteur = 'NULL';
//					
//				$largeur = $media->getLargeur();
//				if (empty ($largeur))
//					$largeur = 'NULL';
//			}else{
//				$idmedia = 'NULL';
//				$hauteur = 'NULL';
//				$largeur = 'NULL';
//			}
//			if (empty ($bareme))
//				$bareme = 'NULL';
//				
//			//insertion du choix
//			$res = set_question_reponse_choix($this->id, $choix, $ordre, $bareme, $idmedia, $hauteur, $largeur);
//			if ($res!='t')
//				echo "Erreur lors de l'association du positionnement et de la reponse<br>";
//
//			//insertion du nombre d'evaluations  gnrer pour ce choix.
//			if($tabExosGen){
//				while ($tab = each($tabExosGen)) {
//					//on passe un nombre negatif car on ne peut mettre NULL dans un tableau
//					$nb1 = $tab[1][1];
//					if (empty ($nb1))
//						$nb1 = 0;
//					$nb2 = $tab[1][2];
//					if (empty ($nb2))
//						$nb2 = 'NULL';
//					set_positionnement_nb_evaluations_a_generer($this->id, $choix, get_evaluation_type_old_new($tab[0]), $nb1, $nb2);
//				}
//			}
//		} else
//			die("Qsrc::ajoutChoix($choix,  $bareme, $tabExosGen, $media)<br>");
//	}
//	
//	
//	/**
//	* Procdure qui retire un choix du Positionnement.
//	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
//	* @param integer $choix Identifiant du Choix  supprimer
//	* @return boolean true ou false selon que la suppression se soit bien pass ou non
//	*/
//	function retireChoix($choix) {
//		if (!empty($this->id) && !empty($choix)) {
//			return del_question_reponse_choix($this->id, $choix);
//		} else{
//			echo "Erreur paramtre retireChoix($choix)<br>";
//			return false;
//		}
//	}
	
	/**
	* Procdure qui retire une question du Positionnement.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @param integer : indice de la Question  supprimer
	* @return boolean true ou false selon que la suppression se soit bien pass ou non
	*/
	function retireQuestion($question) {
		if (!empty($this->id) && !empty($question)) {
			return del_qsrc_question($this->id, $question);
		} else{
			echo "Erreur paramtre retireQuestion($question)<br>";
			return false;
		}
	}	
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
//	/**
//	 * Savoir si le Qsrc doit etre affich sous la forme de radio ou de checkbox
//	 * @return boolean true indique que le Qsrc doit etre affich sous la forme , false sous forme de checkbox 
//	 */
//	function isRadio(){
//		return pg_fetch_result(get_question_reponse($this->id),0,4)=='t';
//	}
	
//
//	/**
//	 * Savoir si le QSRC doit etre affich sous la forme de radio ou de checkbox
//	 * @return boolean true indique que le QuestionReponse doit etre affich sous la forme , false sous forme de checkbox 
//	 */
//	function isRadio(){
//		if (VERSION_BASE > VERSION) {
//			return parent::isRadio();
//		}else{
//			return pg_fetch_result(get_positionnement($this->id),0,7)=='t';
//		}
//	}
		
	/**
	 * Obtenir la question commune
	 * @return string La question commune
	 */
	function getQuestionCommune(){
		return $this->question_commune;
	}

	/**
	 * @param string La question commune
	 */
	function setQuestionCommune($question_commune){
		$this->question_commune=$question_commune;
	}
	/**
	 * Obtenir l'icone associe aux Qcm.
	 * @return string URL de l'icone.
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type Qcm.
	 * @return string URL de l'icone.
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}

	/**
	 * Obtenir les informations sur le Media du Qsrc.
	 * @return integer le resultat de la requete :(question_reponse integer, id int4, re_id int4, hauteur integer,largeur integer)
	 */
	function getMedia(){
		return get_question_&&reponse_media($this->id);
	}

	/**
	 * Obtenir l'objet Media du Qsrc.
	 * @return object Media l'objet Media initialis aux valeurs spcifies le Qsrc.
	 */		
	function &getObjMedia(){
		$res_media=get_question_reponse_media($this->id);
		if(pg_num_rows($res_media)>0){
			$row=pg_fetch_row($res_media);
			if(!empty($row[0]))return new Media($row[1],$row[2],$row[3],$row[4]);
		}
		else{
			return null;
		}
	}
	
}
?>