<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets Qsrc.
 * 
 * Cet objet permet d'obtenir, par la mthode createQsrc(), un objet Qsrc correspondant  un objet particulier.
 * 
 * @package evaluation
 */
class QsrcFactory{
	
	/**
	 * Cre un objet Qsrc.
	 * @param integer $type Type du Qsrc
	 * @param integer $qsrc Identifiant du Qsrc  crer.
	 * @return object Qsrc l'objet Qsrc souhait.
	 */	
	function createQsrc($type,$qsrc, $libelle="", $date_creation="",$radio=false,$question_commune=""){
//		echo "\$type=$type<br>";
		if(func_num_args()==2){
			switch($type){
				case TYPE_EVALUATION_QRC;
					return new Qrc($qsrc);
				case TYPE_EVALUATION_SRC;
					return new Src($qsrc);
				default:
					die("QsrcFactory::createQsrc($type,$qsrc): Le type '$type' est inconnu.<br>");																				
			}						
		}else{
			switch($type){
				case TYPE_EVALUATION_QRC;
					return new Qrc($qsrc,$libelle, $type, $date_creation,$radio,$question_commune);
				case TYPE_EVALUATION_SRC;
					return new Src($qsrc,$libelle, $type, $date_creation,$radio,$question_commune);
				default:
					die("QsrcFactory::createQsrc($type,$qsrc,$libelle, $date_creation,$radio,$question_commune): Le type '$type' est inconnu.<br>");																				
			}			
		}
	}
}
?>
